/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus32bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.awt.Component;
import java.awt.Dimension;

public class VideoInterface
implements Hardware,
Clockable,
Bus32bit,
Configurable {
    private int FRAMES_PER_SECOND = 60;
    private int SKIP_TICKS = 1000 / this.FRAMES_PER_SECOND;
    private static final int VI_STATUS_REG = 0;
    private static final int VI_ORIGIN_REG = 1;
    private static final int VI_WIDTH_REG = 2;
    private static final int VI_INTR_REG = 3;
    private static final int VI_CURRENT_REG = 4;
    private static final int VI_BURST_REG = 5;
    private static final int VI_V_SYNC_REG = 6;
    private static final int VI_H_SYNC_REG = 7;
    private static final int VI_LEAP_REG = 8;
    private static final int VI_H_START_REG = 9;
    private static final int VI_V_START_REG = 10;
    private static final int VI_V_BURST_REG = 11;
    private static final int VI_X_SCALE_REG = 12;
    private static final int VI_Y_SCALE_REG = 13;
    private static final int MI_INTR_REG = 70254600;
    private static final int DAC_WIDTH_BUF_REG = 4;
    private static final int DAC_FPS_REG = 5;
    private static final int MI_INTR_CLR_VI = 64;
    private static final int MI_INTR_SET_VI = 128;
    private static final int NUM_FRAMES = 7;
    private Component drawSurface;
    private boolean useFrameBuffer;
    private int fbLenBytes;
    private int[] regVI = new int[14];
    private long lastFrame;
    private long[] frames = new long[7];
    private int currentFrame = 0;
    private long frequency = 1000L;
    private int oldViVsyncReg = 0;
    private int viIntrTime = 500000;
    private int viFieldNumber = 0;
    private long currentTime;
    private long next_game_tick;
    private long sleep_time;
    private boolean frameLimit = true;
    private Bus32bit mi;
    private Bus32bit dac;
    private Bus32bit timer;

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                break;
            }
            case 1: {
                this.mi = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.dac = (Bus32bit)bus;
                if (this.dac == null || this.drawSurface == null) break;
                ((Configurable)this.dac).writeConfig("screen", (Object)this.drawSurface);
                break;
            }
            case 3: {
                this.timer = (Bus32bit)bus;
                if (this.timer == null) break;
                this.timer.write32bit(3, 5000);
            }
        }
    }

    public void reset() {
        this.frequency = 1000L;
        this.currentFrame = 0;
        this.viFieldNumber = 0;
    }

    public void clock(long ticks) {
        this.mi.write32bit(70254600, 128);
        this.timer.write32bit(3, this.refreshScreen());
    }

    public int read32bit(int reg) {
        switch (reg - 0x4400000 >> 2) {
            case 0: {
                return this.regVI[0];
            }
            case 1: {
                return this.regVI[1];
            }
            case 2: {
                return this.regVI[2];
            }
            case 3: {
                return this.regVI[3];
            }
            case 4: {
                return this.regVI[4];
            }
            case 5: {
                return this.regVI[5];
            }
            case 6: {
                return this.regVI[6];
            }
            case 7: {
                return this.regVI[7];
            }
            case 8: {
                return this.regVI[8];
            }
            case 9: {
                return this.regVI[9];
            }
            case 10: {
                return this.regVI[10];
            }
            case 11: {
                return this.regVI[11];
            }
            case 12: {
                return this.regVI[12];
            }
            case 13: {
                return this.regVI[13];
            }
            case 16: {
                return this.frameLimit ? 1 : 0;
            }
            case 17: {
                return this.useFrameBuffer ? 1 : 0;
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg - 0x4400000 >> 2) {
            case 0: {
                if (this.regVI[0] == value) break;
                this.regVI[0] = value;
                break;
            }
            case 1: {
                this.regVI[1] = value & 0xFFFFFF;
                break;
            }
            case 2: {
                if (this.regVI[2] == value) break;
                this.regVI[2] = value;
                this.dac.write32bit(4, value);
                this.drawSurface.setPreferredSize(new Dimension(this.regVI[2], (this.regVI[2] >> 2) * 3));
                this.fbLenBytes = 3 * this.regVI[2] * this.regVI[2] >> 1;
                break;
            }
            case 3: {
                this.regVI[3] = value;
                break;
            }
            case 4: {
                this.mi.write32bit(70254600, 64);
                break;
            }
            case 5: {
                this.regVI[5] = value;
                break;
            }
            case 6: {
                this.regVI[6] = value;
                break;
            }
            case 7: {
                this.regVI[7] = value;
                break;
            }
            case 8: {
                this.regVI[8] = value;
                break;
            }
            case 9: {
                this.regVI[9] = value;
                break;
            }
            case 10: {
                this.regVI[10] = value;
                break;
            }
            case 11: {
                this.regVI[11] = value;
                break;
            }
            case 12: {
                this.regVI[12] = value;
                break;
            }
            case 13: {
                this.regVI[13] = value;
                break;
            }
            case 14: {
                break;
            }
            case 16: {
                this.frameLimit = value != 0;
                break;
            }
            case 17: {
                this.useFrameBuffer = value != 0;
            }
        }
    }

    public Object readConfig(String key) {
        if (key.equals("framelimit")) {
            return this.frameLimit;
        }
        if (key.equals("framebuffer")) {
            return this.useFrameBuffer;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("framelimit")) {
            this.frameLimit = (Boolean)value;
        } else if (key.equals("framebuffer")) {
            this.useFrameBuffer = (Boolean)value;
        } else if (key.equals("screen")) {
            this.drawSurface = (Component)value;
            if (this.dac != null) {
                ((Configurable)this.dac).writeConfig("screen", value);
            }
        }
    }

    private int refreshScreen() {
        if (this.oldViVsyncReg != this.regVI[6]) {
            if (this.regVI[6] == 0) {
                this.viIntrTime = 500000;
            } else {
                this.viIntrTime = (this.regVI[6] + 1) * 1500;
                if (this.regVI[6] % 1 != 0) {
                    this.viIntrTime -= 38;
                }
            }
        }
        this.viFieldNumber = (this.regVI[0] & 0x10) != 0 ? (this.viFieldNumber == 0 ? 1 : 0) : 0;
        if ((this.currentFrame & 7) == 0) {
            long frametime = System.currentTimeMillis();
            this.frames[(this.currentFrame >> 3) % 7] = frametime - this.lastFrame;
            this.lastFrame = frametime;
            if (this.currentFrame > 56) {
                float total = 0.0f;
                int count = 0;
                while (count < 7) {
                    total += (float)this.frames[count];
                    ++count;
                }
                this.dac.write32bit(5, (int)((float)this.frequency / (total / 56.0f)));
            } else {
                this.dac.write32bit(5, 0);
            }
        }
        ++this.currentFrame;
        if (this.useFrameBuffer) {
            this.dac.write32bit(8, this.regVI[1] & 0xFFFFFF);
            this.dac.write32bit(9, this.fbLenBytes);
        } else {
            this.mi.read32bit(68157492);
        }
        this.currentTime = System.currentTimeMillis();
        if (this.frameLimit) {
            this.next_game_tick += (long)this.SKIP_TICKS;
            this.sleep_time = this.next_game_tick - this.currentTime;
            if (this.sleep_time >= 0L) {
                try {
                    Thread.sleep(this.sleep_time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.next_game_tick = System.currentTimeMillis();
        return this.viIntrTime;
    }
}

