/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.ucode;

import jario.hardware.Bus64bit;
import jario.n64.ucode.F3d;
import jario.n64.ucode.Gbi;
import jario.n64.ucode.Math3D;

public class F3ddkr
extends F3d {
    protected static final int F3DDKR_VTX_APPEND = 65536;
    protected static final int F3DDKR_DMA_MTX = 1;
    protected static final int F3DDKR_DMA_VTX = 4;
    protected static final int F3DDKR_DMA_TRI = 5;
    protected static final int F3DDKR_DMA_DL = 7;
    protected static final int F3DDKR_DMA_OFFSETS = 191;
    protected F3d.OpCode F3DDKR_DMA_Mtx = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            boolean multiply;
            if ((w0 & 0xFFFF) != 64) {
                return;
            }
            int index = w0 >> 16 & 0xF;
            if (index == 0) {
                index = w0 >> 22 & 3;
                multiply = false;
            } else {
                multiply = (w0 >> 23 & 1) != 0;
            }
            F3ddkr.this.gSPDMAMatrix(F3ddkr.segmentToPhysical((int)w1), index, multiply);
        }
    };
    protected F3d.OpCode F3DDKR_DMA_Vtx = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            int n = (w0 >> 19 & 0x1F) + 1;
            F3ddkr.this.gSPDMAVertex(F3ddkr.segmentToPhysical((int)w1), n, w0 >> 9 & 0x1F, (w0 & 0x10000) != 0);
        }
    };
    protected F3d.OpCode F3DDKR_DMA_Tri = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            F3ddkr.this.gSPDMATriangles(F3ddkr.segmentToPhysical((int)w1), w0 >> 4 & 0xFFF);
        }
    };
    protected F3d.OpCode F3DDKR_DMA_DList = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            F3ddkr.this.gSPDMADisplayList(w1, w0 >> 16 & 0xFF);
        }
    };
    protected F3d.OpCode F3DDKR_DMA_Offsets = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            F3ddkr.this.gSPSetDMAOffsets(w0 & 0xFFFFFF, w1 & 0xFFFFFF);
        }
    };
    protected F3d.OpCode F3DDKR_MoveWord = new F3d.OpCode(){

        public void exec(int w0, int w1) {
            switch (w0 & 0xFF) {
                case 2: {
                    F3ddkr.this.gSPMatrixBillboard(w1 & 1);
                    break;
                }
                case 10: {
                    F3ddkr.this.gSPMatrixModelViewi(w1 >> 6 & 3);
                    break;
                }
                default: {
                    F3ddkr.this.F3D_MoveWord.exec(w0, w1);
                }
            }
        }
    };

    public void clock(long ticks) {
        F3ddkr.gbiInitFlags();
        Gbi.G_DMA_TRI = 5;
        Gbi.G_QUAD = 181;
        Gbi.G_TRI4 = 177;
        F3ddkr.sp_writeRegister((int)9, (int)10);
        F3ddkr.dlist[0] = this.F3D_SPNoOp;
        F3ddkr.dlist[1] = this.F3DDKR_DMA_Mtx;
        F3ddkr.dlist[3] = this.F3D_MoveMem;
        F3ddkr.dlist[4] = this.F3DDKR_DMA_Vtx;
        F3ddkr.dlist[6] = this.F3D_DList;
        F3ddkr.dlist[7] = this.F3DDKR_DMA_DList;
        F3ddkr.dlist[5] = this.F3DDKR_DMA_Tri;
        F3ddkr.dlist[191] = this.F3DDKR_DMA_Offsets;
        F3ddkr.dlist[190] = this.F3D_CullDL;
        F3ddkr.dlist[188] = this.F3DDKR_MoveWord;
        F3ddkr.dlist[187] = this.F3D_Texture;
        F3ddkr.dlist[186] = this.F3D_SetOtherMode_H;
        F3ddkr.dlist[185] = this.F3D_SetOtherMode_L;
        F3ddkr.dlist[184] = this.F3D_EndDL;
        F3ddkr.dlist[183] = this.F3D_SetGeometryMode;
        F3ddkr.dlist[182] = this.F3D_ClearGeometryMode;
        F3ddkr.dlist[181] = this.F3D_Quad;
        F3ddkr.dlist[180] = this.F3D_RDPHalf_1;
        F3ddkr.dlist[179] = this.F3D_RDPHalf_2;
        F3ddkr.dlist[178] = this.F3D_RDPHalf_Cont;
        F3ddkr.dlist[177] = this.F3D_Tri4;
        this.gSPSetDMAOffsets(0, 0);
    }

    protected void gSPSetDMAOffsets(int mtxoffset, int vtxoffset) {
        F3ddkr.DMAOffsets.mtx = mtxoffset;
        F3ddkr.DMAOffsets.vtx = vtxoffset;
    }

    protected void gSPDMATriangles(int address, int n) {
        if (address + 16 * n > rdramSize) {
            return;
        }
        int i = 0;
        while (i < n) {
            int v0 = rdram.read8bit(address + 1) & 0xFF;
            F3ddkr.vertices[v0].tex[0] = (float)rdram16bit.read16bit(address + 4) * 0.03125f;
            F3ddkr.vertices[v0].tex[1] = (float)rdram16bit.read16bit(address + 6) * 0.03125f;
            int v1 = rdram.read8bit(address + 2) & 0xFF;
            F3ddkr.vertices[v1].tex[0] = (float)rdram16bit.read16bit(address + 8) * 0.03125f;
            F3ddkr.vertices[v1].tex[1] = (float)rdram16bit.read16bit(address + 10) * 0.03125f;
            int v2 = rdram.read8bit(address + 3) & 0xFF;
            F3ddkr.vertices[v2].tex[0] = (float)rdram16bit.read16bit(address + 12) * 0.03125f;
            F3ddkr.vertices[v2].tex[1] = (float)rdram16bit.read16bit(address + 14) * 0.03125f;
            F3ddkr.gSPTriangle((int)v0, (int)v1, (int)v2, (int)0);
            address += 16;
            ++i;
        }
        F3ddkr.gSPFlushTriangles();
        vertexi = 0;
    }

    protected void gSPDMAVertex(int address, int n, int v0, boolean append) {
        v0 = vertexi + v0;
        if (append) {
            if (F3ddkr.matrix.billboard != 0) {
                vertexi = 1;
            }
        } else {
            vertexi = 0;
        }
        if ((address = F3ddkr.DMAOffsets.vtx + address) + 10 * n > rdramSize) {
            return;
        }
        if (n + v0 < 80) {
            int i = v0;
            while (i < n + v0) {
                F3d.SPVertex vertex = vertices[i];
                vertex.vtx[0] = rdram16bit.read16bit(address ^ 2);
                vertex.vtx[1] = rdram16bit.read16bit(address + 2 ^ 2);
                vertex.vtx[2] = rdram16bit.read16bit(address + 4 ^ 2);
                if ((geometryMode & 0x20000) != 0) {
                    vertex.norm[0] = rdram.read8bit(address + 6 ^ 3);
                    vertex.norm[1] = rdram.read8bit(address + 7 ^ 3);
                    vertex.norm[2] = rdram.read8bit(address + 8 ^ 3);
                    vertex.color[3] = (float)(rdram.read8bit(address + 9 ^ 3) & 0xFF) * 0.003921569f;
                } else {
                    vertex.color[0] = (float)(rdram.read8bit(address + 6 ^ 3) & 0xFF) * 0.003921569f;
                    vertex.color[1] = (float)(rdram.read8bit(address + 7 ^ 3) & 0xFF) * 0.003921569f;
                    vertex.color[2] = (float)(rdram.read8bit(address + 8 ^ 3) & 0xFF) * 0.003921569f;
                    vertex.color[3] = (float)(rdram.read8bit(address + 9 ^ 3) & 0xFF) * 0.003921569f;
                }
                F3ddkr.gSPProcessVertex((F3d.SPVertex)vertex);
                address += 10;
                ++i;
            }
        }
        vertexi += n;
    }

    protected void gSPDMAMatrix(int address, int index, boolean multiply) {
        if ((address = F3ddkr.DMAOffsets.mtx + address) + 64 > rdramSize) {
            return;
        }
        F3ddkr.loadMatrix((float[][])tmpmtx, (int)address);
        F3ddkr.matrix.modelViewi = index;
        if (multiply) {
            Math3D.copyMatrix((float[][])F3ddkr.matrix.modelView[F3ddkr.matrix.modelViewi], (float[][])F3ddkr.matrix.modelView[0]);
            Math3D.multMatrix((float[][])F3ddkr.matrix.modelView[F3ddkr.matrix.modelViewi], (float[][])tmpmtx);
        } else {
            Math3D.copyMatrix((float[][])F3ddkr.matrix.modelView[F3ddkr.matrix.modelViewi], (float[][])tmpmtx);
        }
        Math3D.copyMatrix((float[][])F3ddkr.matrix.projection, (float[][])Math3D.IDENTITY_MATRIX);
        changed |= 2;
    }

    protected void gSPMatrixBillboard(int x) {
        F3ddkr.matrix.billboard = x;
    }

    protected void gSPMatrixModelViewi(int x) {
        F3ddkr.matrix.modelViewi = x;
        changed |= 2;
    }

    protected void gSPDMADisplayList(int dl, int n) {
        if (dl + (n << 3) > rdramSize) {
            return;
        }
        int pc = F3ddkr.sp_readRegister((int)10);
        F3ddkr.sp_writeRegister((int)10, (int)F3ddkr.segmentToPhysical((int)dl));
        ((Bus64bit)sp).write64bit(dl, (long)n & 0xFFFFFFFFL);
        F3ddkr.sp_writeRegister((int)10, (int)pc);
    }
}

