/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.rcp;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Hardware;

public class SerialInterface
implements Hardware,
Clockable,
Bus32bit {
    private static final int MI_INTR_REG = 70254600;
    private static final int MI_INTR_CLR_SI = 4;
    private static final int MI_INTR_SET_SI = 8;
    private static final int SI_DRAM_ADDR_REG = 0;
    private static final int SI_PIF_ADDR_RD64B_REG = 1;
    private static final int SI_PIF_ADDR_WR64B_REG = 2;
    private static final int SI_STATUS_REG = 3;
    private static final int SI_STATUS_INTERRUPT = 4096;
    private static final int RDRAM_CAPACITY_REG = 66060328;
    private static final int PIF_READ_REG = 0;
    private Bus8bit rdram;
    private Bus32bit mi;
    private Bus8bit pif;
    private Bus32bit timer;
    private int[] regSI = new int[4];

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.rdram = (Bus8bit)bus;
                break;
            }
            case 1: {
                this.mi = (Bus32bit)bus;
                break;
            }
            case 2: {
                this.pif = (Bus8bit)bus;
                break;
            }
            case 3: {
                this.timer = (Bus32bit)bus;
            }
        }
    }

    public void reset() {
    }

    public void clock(long ticks) {
        this.regSI[3] = this.regSI[3] | 0x1000;
        this.mi.write32bit(70254600, 8);
        this.timer.write32bit(1, -((int)ticks));
    }

    public int read32bit(int reg) {
        switch (reg - 0x4800000 >> 2) {
            case 6: {
                return this.regSI[3];
            }
        }
        return 0;
    }

    public void write32bit(int reg, int value) {
        switch (reg - 0x4800000 >> 2) {
            case 0: {
                this.regSI[0] = value;
                break;
            }
            case 1: {
                this.regSI[1] = value;
                this.pifRamDmaRead(this.rdram, this.regSI[0]);
                this.regSI[3] = this.regSI[3] | 0x1000;
                this.mi.write32bit(70254600, 8);
                break;
            }
            case 4: {
                this.regSI[2] = value;
                this.pifRamDmaWrite(this.rdram, this.regSI[0]);
                this.regSI[3] = this.regSI[3] | 0x1000;
                this.mi.write32bit(70254600, 8);
                break;
            }
            case 6: {
                this.regSI[3] = this.regSI[3] & 0xFFFFEFFF;
                this.mi.write32bit(70254600, 4);
            }
        }
    }

    private void pifRamDmaRead(Bus8bit rdram, int dramAddr) {
        if (dramAddr > ((Bus32bit)rdram).read32bit(66060328)) {
            System.err.printf("SI DMA READ\nSI_DRAM_ADDR_REG not in RDRam space\n", new Object[0]);
            return;
        }
        ((Bus1bit)this.pif).write1bit(0, true);
        if ((dramAddr &= 0xFFFFFFF8) < 0) {
            int count = 0;
            while (count < 64) {
                if (dramAddr >= 0) {
                    rdram.write8bit(dramAddr, this.pif.read8bit(count + 1984));
                }
                ++count;
                ++dramAddr;
            }
        } else {
            int i = 0;
            while (i < 64) {
                rdram.write8bit(dramAddr, this.pif.read8bit(i + 1984));
                ++i;
                ++dramAddr;
            }
        }
    }

    private void pifRamDmaWrite(Bus8bit rdram, int dramAddr) {
        if (dramAddr > ((Bus32bit)rdram).read32bit(66060328)) {
            System.err.printf("SI DMA WRITE\nSI_DRAM_ADDR_REG not in RDRam space\n", new Object[0]);
            return;
        }
        if ((dramAddr &= 0xFFFFFFF8) < 0) {
            int count = 0;
            while (count < 64) {
                if (dramAddr < 0) {
                    this.pif.write8bit(count + 1984, (byte)0);
                } else {
                    this.pif.write8bit(count + 1984, rdram.read8bit(dramAddr));
                }
                ++count;
                ++dramAddr;
            }
        } else {
            int i = 0;
            while (i < 64) {
                this.pif.write8bit(i + 1984, rdram.read8bit(dramAddr));
                ++i;
                ++dramAddr;
            }
        }
        ((Bus1bit)this.pif).write1bit(0, false);
    }
}

