/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console;

import jario.hardware.Bus16bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus64bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;

public class Rdram
implements Hardware,
Bus8bit,
Bus16bit,
Bus32bit,
Bus64bit,
BusDMA {
    private static final int RDRAM_CONFIG_REG = 0;
    private static final int RDRAM_DEVICE_ID_REG = 1;
    private static final int RDRAM_DELAY_REG = 2;
    private static final int RDRAM_MODE_REG = 3;
    private static final int RDRAM_REF_INTERVAL_REG = 4;
    private static final int RDRAM_REF_ROW_REG = 5;
    private static final int RDRAM_RAS_INTERVAL_REG = 6;
    private static final int RDRAM_MIN_INTERVAL_REG = 7;
    private static final int RDRAM_ADDR_SELECT_REG = 8;
    private static final int RDRAM_DEVICE_MANUF_REG = 9;
    private byte[] rdram;
    private int[] regRDRAM = new int[10];

    public Rdram() {
        this.rdram = new byte[0x800000];
    }

    public void connect(int port, Hardware bus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte read8bit(int pAddr) {
        return this.rdram[pAddr];
    }

    public short read16bit(int pAddr) {
        return (short)((this.rdram[pAddr] & 0xFF) << 8 | this.rdram[pAddr + 1] & 0xFF);
    }

    public int read32bit(int pAddr) {
        if (pAddr < 0x800000) {
            return this.rdram[pAddr] << 24 | (this.rdram[pAddr + 1] & 0xFF) << 16 | (this.rdram[pAddr + 2] & 0xFF) << 8 | this.rdram[pAddr + 3] & 0xFF;
        }
        if ((pAddr & 0xFFF00000) == 0x3F00000) {
            switch (pAddr - 0x3F00000 >> 2) {
                case 0: {
                    return this.regRDRAM[0];
                }
                case 1: {
                    return this.regRDRAM[1];
                }
                case 2: {
                    return this.regRDRAM[2];
                }
                case 3: {
                    return this.regRDRAM[3];
                }
                case 4: {
                    return this.regRDRAM[4];
                }
                case 5: {
                    return this.regRDRAM[5];
                }
                case 6: {
                    return this.regRDRAM[6];
                }
                case 7: {
                    return this.regRDRAM[7];
                }
                case 8: {
                    return this.regRDRAM[8];
                }
                case 9: {
                    return this.regRDRAM[9];
                }
                case 10: {
                    return this.rdram.length;
                }
            }
            return 0;
        }
        System.err.println("Illegal Memory LW access: " + Integer.toHexString(pAddr));
        return 0;
    }

    public long read64bit(int pAddr) {
        return ((long)this.rdram[pAddr] & 0xFFL) << 56 | ((long)this.rdram[pAddr + 1] & 0xFFL) << 48 | ((long)this.rdram[pAddr + 2] & 0xFFL) << 40 | ((long)this.rdram[pAddr + 3] & 0xFFL) << 32 | ((long)this.rdram[pAddr + 4] & 0xFFL) << 24 | ((long)this.rdram[pAddr + 5] & 0xFFL) << 16 | ((long)this.rdram[pAddr + 6] & 0xFFL) << 8 | (long)this.rdram[pAddr + 7] & 0xFFL;
    }

    public void readDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        System.arraycopy(this.rdram, pAddr, dma.array(), offset, length);
    }

    public void write8bit(int pAddr, byte value) {
        this.rdram[pAddr] = value;
    }

    public void write16bit(int pAddr, short value) {
        this.rdram[pAddr] = (byte)(value >> 8);
        this.rdram[pAddr + 1] = (byte)value;
    }

    public void write32bit(int pAddr, int value) {
        if (pAddr < 0x800000) {
            this.rdram[pAddr] = (byte)(value >> 24);
            this.rdram[pAddr + 1] = (byte)(value >> 16);
            this.rdram[pAddr + 2] = (byte)(value >> 8);
            this.rdram[pAddr + 3] = (byte)value;
        } else if ((pAddr & 0xFFF00000) == 0x3F00000) {
            switch (pAddr - 0x3F00000 >> 2) {
                case 0: {
                    this.regRDRAM[0] = value;
                    break;
                }
                case 1: {
                    this.regRDRAM[1] = value;
                    break;
                }
                case 2: {
                    this.regRDRAM[2] = value;
                    break;
                }
                case 3: {
                    this.regRDRAM[3] = value;
                    break;
                }
                case 4: {
                    this.regRDRAM[4] = value;
                    break;
                }
                case 5: {
                    this.regRDRAM[5] = value;
                    break;
                }
                case 6: {
                    this.regRDRAM[6] = value;
                    break;
                }
                case 7: {
                    this.regRDRAM[7] = value;
                    break;
                }
                case 8: {
                    this.regRDRAM[8] = value;
                    break;
                }
                case 9: {
                    this.regRDRAM[9] = value;
                    break;
                }
                case 4097: {
                    break;
                }
                case 8193: {
                    break;
                }
                case 131073: {
                    break;
                }
                case 131074: {
                    break;
                }
                case 131075: {
                    break;
                }
            }
        } else {
            System.err.println("Illegal Memory LW access: " + Integer.toHexString(pAddr));
        }
    }

    public void write64bit(int pAddr, long value) {
        this.rdram[pAddr] = (byte)(value >> 56);
        this.rdram[pAddr + 1] = (byte)(value >> 48);
        this.rdram[pAddr + 2] = (byte)(value >> 40);
        this.rdram[pAddr + 3] = (byte)(value >> 32);
        this.rdram[pAddr + 4] = (byte)(value >> 24);
        this.rdram[pAddr + 5] = (byte)(value >> 16);
        this.rdram[pAddr + 6] = (byte)(value >> 8);
        this.rdram[pAddr + 7] = (byte)value;
    }

    public void writeDMA(int pAddr, ByteBuffer dma, int offset, int length) {
        System.arraycopy(dma.array(), offset, this.rdram, pAddr, length);
    }
}

