/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG;
    public static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    public static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Constructor<?> fosCtor;
    private static File tempRootExec;
    private static File tempRootNoexec;
    private static volatile boolean tempRootSet;

    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[Platform.getMachineDescription().pageSizeInBytes()];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = inputStream.available();
        MachineDescription machineDescription = Platform.getMachineDescription();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(n));
        byte[] byArray = new byte[machineDescription.pageSizeInBytes()];
        int n2 = Math.min(machineDescription.pageSizeInBytes(), n);
        int n3 = 0;
        do {
            if (n > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(byteBuffer.position() + n));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n3 = inputStream.read(byArray, 0, n2)) >= 0) {
                byteBuffer.put(byArray, 0, n3);
            }
            n = inputStream.available();
            n2 = Math.min(machineDescription.pageSizeInBytes(), n);
        } while (n > 0 && n3 >= 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) throws RuntimeException {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        try {
            return IOUtil.cleanPathString(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static URL toURLSimple(File file) throws MalformedURLException {
        return new URL("file", "", IOUtil.slashify(file.getAbsolutePath(), true, file.isDirectory()));
    }

    public static URL toURLSimple(String string, String string2, boolean bl) throws MalformedURLException {
        return new URL(string, "", IOUtil.slashify(string2, true, bl));
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException {
        if (null == fosCtor) {
            throw new IOException("Cannot open file (" + file + ") for writing, feature not available.");
        }
        if (file.exists() && !bl) {
            throw new IOException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            return (FileOutputStream)fosCtor.newInstance(file);
        }
        catch (Exception exception) {
            throw new IOException("error opening " + file + " for write. ", exception);
        }
    }

    public static String getClassFileName(String string) throws IOException {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        return classLoader.getResource(IOUtil.getClassFileName(string));
    }

    public static String getBasename(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                uRLConnection = IOUtil.getResource(string2.substring(0, n + 1) + string, classLoader);
            }
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> within class package: " + (null != uRLConnection));
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    System.err.println("IOUtil: Catched Exception:");
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("IOUtil: Catched Exception:");
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) {
        if (null == string) {
            return null;
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws MalformedURLException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new MalformedURLException("path is empty <" + string + ">");
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new MalformedURLException("path contains no '/' <" + string + ">");
        }
        if (n3 == 0) {
            throw new MalformedURLException("path has no parents <" + string + ">");
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        throw new MalformedURLException("parent of path contains no '/' <" + string + ">");
    }

    public static String cleanPathString(String string) throws MalformedURLException {
        int n;
        while ((n = string.indexOf("../")) >= 0) {
            string = IOUtil.getParentOf(string.substring(0, n)) + string.substring(n + 3);
        }
        while ((n = string.indexOf("./")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        return string;
    }

    public static URL getRelativeOf(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getAuthority();
        String string4 = uRL.getPath();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        if (!string4.endsWith("/")) {
            string4 = IOUtil.getParentOf(string4);
        }
        return IOUtil.compose(string2, string3, string4, string, string5, string6);
    }

    public static URL compose(String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != string) {
            stringBuilder.append(string);
            stringBuilder.append(":");
        }
        if (null != string2) {
            stringBuilder.append("//");
            stringBuilder.append(string2);
        }
        if (null != string3) {
            stringBuilder.append(string3);
        }
        if (null != string4) {
            stringBuilder.append(string4);
        }
        if (null != string5) {
            stringBuilder.append("?");
            stringBuilder.append(string5);
        }
        if (null != string6) {
            stringBuilder.append("#");
            stringBuilder.append(string6);
        }
        return new URL(IOUtil.cleanPathString(stringBuilder.toString()));
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - false - " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace();
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    private static String getShellSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return ".bat";
            }
        }
        return ".sh";
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: does not exist");
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not a directory");
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not writable");
            }
            return false;
        }
        return true;
    }

    public static boolean testDirExec(File file) throws SecurityException {
        int n;
        File file2;
        block10: {
            if (!IOUtil.testFile(file, true, true)) {
                return false;
            }
            if (!IOUtil.getOSHasNoexecFS()) {
                return true;
            }
            try {
                file2 = File.createTempFile("jogamp_exe_tst", IOUtil.getShellSuffix(), file);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
                return false;
            }
            n = -1;
            if (file2.setExecutable(true)) {
                try {
                    Process process = Runtime.getRuntime().exec(file2.getCanonicalPath());
                    process.waitFor();
                    n = process.exitValue();
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Throwable throwable) {
                    n = -2;
                    if (!DEBUG) break block10;
                    System.err.println("IOUtil.testDirExec: <" + file2.getAbsolutePath() + ">: " + throwable.getMessage());
                }
            }
        }
        file2.delete();
        return 0 == n;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2) throws SecurityException {
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2 ? IOUtil.testDirExec(file) : IOUtil.testFile(file, true, true)) {
            return file;
        }
        return null;
    }

    public static File testDir(final File file, final boolean bl, final boolean bl2, AccessControlContext accessControlContext) throws SecurityException {
        if (null != accessControlContext) {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    return IOUtil.testDirImpl(file, bl, bl2);
                }
            }, accessControlContext);
        }
        return IOUtil.testDirImpl(file, bl, bl2);
    }

    private static boolean isStringSet(String string) {
        return null != string && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl) throws SecurityException {
        File file2;
        if (null != IOUtil.testDirImpl(file, true, bl)) {
            file2 = IOUtil.testDirImpl(new File(file, string), true, bl);
            for (int i = 0; null == file2 && i <= 9999; ++i) {
                String string2 = String.format("_%04d", i);
                file2 = IOUtil.testDirImpl(new File(file, string + string2), true, bl);
            }
        } else {
            file2 = null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static File getTempDirImpl(boolean bl) throws SecurityException, RuntimeException {
        Object object;
        if (!tempRootSet) {
            object = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                String string;
                tempRootSet = true;
                Object object2 = AndroidUtils.getTempRoot();
                if (null != object2) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir((File)object2, tmpSubDir, false);
                    // MONITOREXIT : object
                    return tempRootExec;
                }
                object2 = PropertyAccess.getProperty(java_io_tmpdir_propkey, false, null);
                String string2 = PropertyAccess.getProperty(user_home_propkey, false, null);
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    string = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet(string) && IOUtil.isStringSet(string2)) {
                        string = string2 + File.separator + ".cache";
                    }
                } else {
                    string = null;
                }
                String string3 = string;
                if (null == tempRootExec && IOUtil.isStringSet((String)object2)) {
                    tempRootExec = IOUtil.getSubTempDir(new File((String)object2), tmpSubDir, true);
                }
                if (null == tempRootExec && IOUtil.isStringSet(string3)) {
                    tempRootExec = IOUtil.getSubTempDir(new File(string3), tmpSubDir, true);
                }
                if (null == tempRootExec && IOUtil.isStringSet(string2)) {
                    tempRootExec = IOUtil.getSubTempDir(new File(string2), ".jogamp", true);
                }
                if (null != tempRootExec) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (null == tempRootNoexec && IOUtil.isStringSet((String)object2)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File((String)object2), tmpSubDir, false);
                    }
                    if (null == tempRootNoexec && IOUtil.isStringSet(string3)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File(string3), tmpSubDir, false);
                    }
                    if (null == tempRootNoexec && IOUtil.isStringSet(string2)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File(string2), ".jogamp", false);
                    }
                }
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): temp dirs: exec: " + tempRootExec.getAbsolutePath() + ", noexec: " + tempRootNoexec.getAbsolutePath());
                }
            }
            // MONITOREXIT : object
        }
        object = bl ? tempRootExec : tempRootNoexec;
        if (null != object) return object;
        throw new RuntimeException("Could not determine a temporary directory");
    }

    public static File getTempDir(final boolean bl, AccessControlContext accessControlContext) throws SecurityException, RuntimeException {
        if (null != accessControlContext) {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    return IOUtil.getTempDirImpl(bl);
                }
            }, accessControlContext);
        }
        return IOUtil.getTempDirImpl(bl);
    }

    public static File createTempFile(String string, String string2, boolean bl, AccessControlContext accessControlContext) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl, accessControlContext));
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Catched Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    static {
        Constructor<?> constructor;
        DEBUG = Debug.debug("IOUtil");
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, IOUtil.class.getClassLoader());
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                throwable.printStackTrace();
            }
            constructor = null;
        }
        fosCtor = constructor;
        tempRootExec = null;
        tempRootNoexec = null;
        tempRootSet = false;
    }
}

