/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.ucode;

import jario.n64.ucode.ABI1;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class ABI2
extends ABI1 {
    private static boolean isMKABI = false;
    private static boolean isZeldaABI = false;
    private static int t3;
    private static int s5;
    private static int s6;
    private static short[] env;
    protected ABI1.OpCode LOADADPCM2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int v0 = inst2 & 0xFFFFFF;
            int cnt = (inst1 & 0xFFFF) >> 4;
            int x = 0;
            while (x < cnt) {
                ABI2.adpcmtable[0 + (x << 3)] = rdram.read16bit(v0 + 0);
                ABI2.adpcmtable[1 + (x << 3)] = rdram.read16bit(v0 + 2);
                ABI2.adpcmtable[2 + (x << 3)] = rdram.read16bit(v0 + 4);
                ABI2.adpcmtable[3 + (x << 3)] = rdram.read16bit(v0 + 6);
                ABI2.adpcmtable[4 + (x << 3)] = rdram.read16bit(v0 + 8);
                ABI2.adpcmtable[5 + (x << 3)] = rdram.read16bit(v0 + 10);
                ABI2.adpcmtable[6 + (x << 3)] = rdram.read16bit(v0 + 12);
                ABI2.adpcmtable[7 + (x << 3)] = rdram.read16bit(v0 + 14);
                v0 += 16;
                ++x;
            }
        }
    };
    protected ABI1.OpCode SETLOOP2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            loopval = inst2 & 0xFFFFFF;
        }
    };
    protected ABI1.OpCode SETBUFF2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            AudioInBuffer = inst1 & 0xFFFF;
            AudioOutBuffer = inst2 >>> 16;
            AudioCount = inst2 & 0xFFFF;
        }
    };
    protected ABI1.OpCode ADPCM2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int shifter;
            int mask2;
            int mask1;
            int srange;
            int flags = inst1 >>> 16 & 0xFF;
            int Address = inst2 & 0xFFFFFF;
            int inPtr = 0;
            ByteBuffer out = BufferSpace;
            int out_p = AudioOutBuffer;
            short count = (short)AudioCount;
            int[] a = new int[8];
            Arrays.fill(out.array(), out_p, out_p + 32, (byte)0);
            if ((flags & 4) != 0) {
                srange = 14;
                mask1 = 192;
                mask2 = 48;
                shifter = 10;
            } else {
                srange = 12;
                mask1 = 240;
                mask2 = 15;
                shifter = 12;
            }
            if ((flags & 1) == 0) {
                if ((flags & 2) != 0) {
                    rdramDMA.readDMA(loopval, out, out_p, 32);
                } else {
                    rdramDMA.readDMA(Address, out, out_p, 32);
                }
            }
            int l1 = out.getShort(out_p + 28);
            int l2 = out.getShort(out_p + 30);
            int[] inp1 = new int[8];
            int[] inp2 = new int[8];
            out_p += 32;
            while (count > 0) {
                int icode;
                int code = BufferSpace.get(AudioInBuffer + inPtr) & 0xFF;
                int index = code & 0xF;
                int book1_p = index <<= 4;
                int book2_p = book1_p + 8;
                int vscale = 32768 >> srange - (code >>= 4) - 1;
                ++inPtr;
                int j = 0;
                while (j < 8) {
                    icode = BufferSpace.get(AudioInBuffer + inPtr) & 0xFF;
                    ++inPtr;
                    inp1[j] = (short)((icode & mask1) << 8);
                    if (code < srange) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    inp1[++j] = (short)((icode & mask2) << shifter);
                    if (code < srange) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    ++j;
                    if ((flags & 4) == 0) continue;
                    inp1[j] = (short)((icode & 0xC) << 12);
                    if (code < 14) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    inp1[++j] = (short)((icode & 3) << 14);
                    if (code < 14) {
                        inp1[j] = inp1[j] * vscale >> 16;
                    }
                    ++j;
                }
                j = 0;
                while (j < 8) {
                    icode = BufferSpace.get(AudioInBuffer + inPtr) & 0xFF;
                    ++inPtr;
                    inp2[j] = (short)((icode & mask1) << 8);
                    if (code < srange) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    inp2[++j] = (short)((icode & mask2) << shifter);
                    if (code < srange) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    ++j;
                    if ((flags & 4) == 0) continue;
                    inp2[j] = (short)((icode & 0xC) << 12);
                    if (code < 14) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    inp2[++j] = (short)((icode & 3) << 14);
                    if (code < 14) {
                        inp2[j] = inp2[j] * vscale >> 16;
                    }
                    ++j;
                }
                a[0] = adpcmtable[book1_p + 0] * l1;
                a[0] = a[0] + adpcmtable[book2_p + 0] * l2;
                a[0] = a[0] + inp1[0] * 2048;
                a[1] = adpcmtable[book1_p + 1] * l1;
                a[1] = a[1] + adpcmtable[book2_p + 1] * l2;
                a[1] = a[1] + adpcmtable[book2_p + 0] * inp1[0];
                a[1] = a[1] + inp1[1] * 2048;
                a[2] = adpcmtable[book1_p + 2] * l1;
                a[2] = a[2] + adpcmtable[book2_p + 2] * l2;
                a[2] = a[2] + adpcmtable[book2_p + 1] * inp1[0];
                a[2] = a[2] + adpcmtable[book2_p + 0] * inp1[1];
                a[2] = a[2] + inp1[2] * 2048;
                a[3] = adpcmtable[book1_p + 3] * l1;
                a[3] = a[3] + adpcmtable[book2_p + 3] * l2;
                a[3] = a[3] + adpcmtable[book2_p + 2] * inp1[0];
                a[3] = a[3] + adpcmtable[book2_p + 1] * inp1[1];
                a[3] = a[3] + adpcmtable[book2_p + 0] * inp1[2];
                a[3] = a[3] + inp1[3] * 2048;
                a[4] = adpcmtable[book1_p + 4] * l1;
                a[4] = a[4] + adpcmtable[book2_p + 4] * l2;
                a[4] = a[4] + adpcmtable[book2_p + 3] * inp1[0];
                a[4] = a[4] + adpcmtable[book2_p + 2] * inp1[1];
                a[4] = a[4] + adpcmtable[book2_p + 1] * inp1[2];
                a[4] = a[4] + adpcmtable[book2_p + 0] * inp1[3];
                a[4] = a[4] + inp1[4] * 2048;
                a[5] = adpcmtable[book1_p + 5] * l1;
                a[5] = a[5] + adpcmtable[book2_p + 5] * l2;
                a[5] = a[5] + adpcmtable[book2_p + 4] * inp1[0];
                a[5] = a[5] + adpcmtable[book2_p + 3] * inp1[1];
                a[5] = a[5] + adpcmtable[book2_p + 2] * inp1[2];
                a[5] = a[5] + adpcmtable[book2_p + 1] * inp1[3];
                a[5] = a[5] + adpcmtable[book2_p + 0] * inp1[4];
                a[5] = a[5] + inp1[5] * 2048;
                a[6] = adpcmtable[book1_p + 6] * l1;
                a[6] = a[6] + adpcmtable[book2_p + 6] * l2;
                a[6] = a[6] + adpcmtable[book2_p + 5] * inp1[0];
                a[6] = a[6] + adpcmtable[book2_p + 4] * inp1[1];
                a[6] = a[6] + adpcmtable[book2_p + 3] * inp1[2];
                a[6] = a[6] + adpcmtable[book2_p + 2] * inp1[3];
                a[6] = a[6] + adpcmtable[book2_p + 1] * inp1[4];
                a[6] = a[6] + adpcmtable[book2_p + 0] * inp1[5];
                a[6] = a[6] + inp1[6] * 2048;
                a[7] = adpcmtable[book1_p + 7] * l1;
                a[7] = a[7] + adpcmtable[book2_p + 7] * l2;
                a[7] = a[7] + adpcmtable[book2_p + 6] * inp1[0];
                a[7] = a[7] + adpcmtable[book2_p + 5] * inp1[1];
                a[7] = a[7] + adpcmtable[book2_p + 4] * inp1[2];
                a[7] = a[7] + adpcmtable[book2_p + 3] * inp1[3];
                a[7] = a[7] + adpcmtable[book2_p + 2] * inp1[4];
                a[7] = a[7] + adpcmtable[book2_p + 1] * inp1[5];
                a[7] = a[7] + adpcmtable[book2_p + 0] * inp1[6];
                a[7] = a[7] + inp1[7] * 2048;
                j = 0;
                while (j < 8) {
                    int n = j;
                    a[n] = a[n] >> 11;
                    if (a[j] > Short.MAX_VALUE) {
                        a[j] = Short.MAX_VALUE;
                    } else if (a[j] < Short.MIN_VALUE) {
                        a[j] = Short.MIN_VALUE;
                    }
                    out.putShort(out_p, (short)a[j]);
                    out_p += 2;
                    ++j;
                }
                l1 = a[6];
                l2 = a[7];
                a[0] = adpcmtable[book1_p + 0] * l1;
                a[0] = a[0] + adpcmtable[book2_p + 0] * l2;
                a[0] = a[0] + inp2[0] * 2048;
                a[1] = adpcmtable[book1_p + 1] * l1;
                a[1] = a[1] + adpcmtable[book2_p + 1] * l2;
                a[1] = a[1] + adpcmtable[book2_p + 0] * inp2[0];
                a[1] = a[1] + inp2[1] * 2048;
                a[2] = adpcmtable[book1_p + 2] * l1;
                a[2] = a[2] + adpcmtable[book2_p + 2] * l2;
                a[2] = a[2] + adpcmtable[book2_p + 1] * inp2[0];
                a[2] = a[2] + adpcmtable[book2_p + 0] * inp2[1];
                a[2] = a[2] + inp2[2] * 2048;
                a[3] = adpcmtable[book1_p + 3] * l1;
                a[3] = a[3] + adpcmtable[book2_p + 3] * l2;
                a[3] = a[3] + adpcmtable[book2_p + 2] * inp2[0];
                a[3] = a[3] + adpcmtable[book2_p + 1] * inp2[1];
                a[3] = a[3] + adpcmtable[book2_p + 0] * inp2[2];
                a[3] = a[3] + inp2[3] * 2048;
                a[4] = adpcmtable[book1_p + 4] * l1;
                a[4] = a[4] + adpcmtable[book2_p + 4] * l2;
                a[4] = a[4] + adpcmtable[book2_p + 3] * inp2[0];
                a[4] = a[4] + adpcmtable[book2_p + 2] * inp2[1];
                a[4] = a[4] + adpcmtable[book2_p + 1] * inp2[2];
                a[4] = a[4] + adpcmtable[book2_p + 0] * inp2[3];
                a[4] = a[4] + inp2[4] * 2048;
                a[5] = adpcmtable[book1_p + 5] * l1;
                a[5] = a[5] + adpcmtable[book2_p + 5] * l2;
                a[5] = a[5] + adpcmtable[book2_p + 4] * inp2[0];
                a[5] = a[5] + adpcmtable[book2_p + 3] * inp2[1];
                a[5] = a[5] + adpcmtable[book2_p + 2] * inp2[2];
                a[5] = a[5] + adpcmtable[book2_p + 1] * inp2[3];
                a[5] = a[5] + adpcmtable[book2_p + 0] * inp2[4];
                a[5] = a[5] + inp2[5] * 2048;
                a[6] = adpcmtable[book1_p + 6] * l1;
                a[6] = a[6] + adpcmtable[book2_p + 6] * l2;
                a[6] = a[6] + adpcmtable[book2_p + 5] * inp2[0];
                a[6] = a[6] + adpcmtable[book2_p + 4] * inp2[1];
                a[6] = a[6] + adpcmtable[book2_p + 3] * inp2[2];
                a[6] = a[6] + adpcmtable[book2_p + 2] * inp2[3];
                a[6] = a[6] + adpcmtable[book2_p + 1] * inp2[4];
                a[6] = a[6] + adpcmtable[book2_p + 0] * inp2[5];
                a[6] = a[6] + inp2[6] * 2048;
                a[7] = adpcmtable[book1_p + 7] * l1;
                a[7] = a[7] + adpcmtable[book2_p + 7] * l2;
                a[7] = a[7] + adpcmtable[book2_p + 6] * inp2[0];
                a[7] = a[7] + adpcmtable[book2_p + 5] * inp2[1];
                a[7] = a[7] + adpcmtable[book2_p + 4] * inp2[2];
                a[7] = a[7] + adpcmtable[book2_p + 3] * inp2[3];
                a[7] = a[7] + adpcmtable[book2_p + 2] * inp2[4];
                a[7] = a[7] + adpcmtable[book2_p + 1] * inp2[5];
                a[7] = a[7] + adpcmtable[book2_p + 0] * inp2[6];
                a[7] = a[7] + inp2[7] * 2048;
                j = 0;
                while (j < 8) {
                    int n = j;
                    a[n] = a[n] >> 11;
                    if (a[j] > Short.MAX_VALUE) {
                        a[j] = Short.MAX_VALUE;
                    } else if (a[j] < Short.MIN_VALUE) {
                        a[j] = Short.MIN_VALUE;
                    }
                    out.putShort(out_p, (short)a[j]);
                    out_p += 2;
                    ++j;
                }
                l1 = a[6];
                l2 = a[7];
                count = (short)(count - 32);
            }
            rdramDMA.writeDMA(Address, out, out_p -= 32, 32);
        }
    };
    protected ABI1.OpCode CLEARBUFF2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int addr = inst1 & 0xFFFF;
            int count = inst2 & 0xFFFF;
            if (count > 0) {
                Arrays.fill(BufferSpace.array(), addr, addr + count, (byte)0);
            }
        }
    };
    protected ABI1.OpCode LOADBUFF2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int cnt = (inst1 >>> 12) + 3 & 0xFFC;
            int v0 = inst2 & 0xFFFFFC;
            rdramDMA.readDMA(v0, BufferSpace, inst1 & 0xFFFC, cnt + 3 & 0xFFFC);
        }
    };
    protected ABI1.OpCode SAVEBUFF2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int cnt = (inst1 >>> 12) + 3 & 0xFFC;
            int v0 = inst2 & 0xFFFFFC;
            rdramDMA.writeDMA(v0, BufferSpace, inst1 & 0xFFFC, cnt + 3 & 0xFFFC);
        }
    };
    protected ABI1.OpCode MIXER2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int dmemin = inst2 >>> 16;
            int dmemout = inst2 & 0xFFFF;
            int count = inst1 >>> 12 & 0xFF0;
            int gain = (short)(inst1 & 0xFFFF) * 2;
            int x = 0;
            while (x < count) {
                int temp = BufferSpace.getShort(dmemin + x) * gain >> 16;
                if ((temp += BufferSpace.getShort(dmemout + x)) > Short.MAX_VALUE) {
                    temp = Short.MAX_VALUE;
                }
                if (temp < Short.MIN_VALUE) {
                    temp = Short.MIN_VALUE;
                }
                BufferSpace.putShort(dmemout + x, (short)temp);
                x += 2;
            }
        }
    };
    protected ABI1.OpCode RESAMPLE2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int x;
            int flags = inst1 >>> 16 & 0xFF;
            int Pitch = (inst1 & 0xFFFF) << 1;
            int addy = inst2 & 0xFFFFFF;
            int Accum = 0;
            ShortBuffer dst = BufferSpaceShort;
            ShortBuffer src = BufferSpaceShort;
            int srcPtr = AudioInBuffer / 2;
            int dstPtr = AudioOutBuffer / 2;
            srcPtr -= 4;
            if ((flags & 1) == 0) {
                x = 0;
                while (x < 4) {
                    src.put(srcPtr + x ^ 1, rdram.read16bit((addy / 2 + x ^ 1) * 2));
                    ++x;
                }
                Accum = rdram.read16bit(addy + 8) & 0xFFFF;
            } else {
                x = 0;
                while (x < 4) {
                    src.put(srcPtr + x ^ 1, (short)0);
                    ++x;
                }
            }
            int count = (AudioCount + 15 & 0xFFF0) / 2;
            int i = 0;
            while (i < count) {
                int location = (Accum * 64 >>> 16) * 8 / 2;
                int temp = src.get(srcPtr + 0 ^ 1) * ResampleLUT[location + 0];
                int accum = temp >> 15;
                temp = src.get(srcPtr + 1 ^ 1) * ResampleLUT[location + 1];
                accum += temp >> 15;
                temp = src.get(srcPtr + 2 ^ 1) * ResampleLUT[location + 2];
                accum += temp >> 15;
                temp = src.get(srcPtr + 3 ^ 1) * ResampleLUT[location + 3];
                if ((accum += temp >> 15) > Short.MAX_VALUE) {
                    accum = Short.MAX_VALUE;
                }
                if (accum < Short.MIN_VALUE) {
                    accum = Short.MIN_VALUE;
                }
                dst.put(dstPtr ^ 1, (short)accum);
                ++dstPtr;
                srcPtr += (Accum += Pitch) >>> 16;
                Accum &= 0xFFFF;
                ++i;
            }
            int x2 = 0;
            while (x2 < 4) {
                rdram.write16bit((addy / 2 + x2 ^ 1) * 2, src.get(srcPtr + x2 ^ 1));
                ++x2;
            }
            rdram.write16bit(addy + 8, (short)Accum);
        }
    };
    protected ABI1.OpCode DMEMMOVE2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            if ((inst2 & 0xFFFF) == 0) {
                return;
            }
            int v0 = inst1 & 0xFFFF;
            int v1 = inst2 >>> 16;
            int count = inst2 + 3 & 0xFFFC;
            System.arraycopy(BufferSpace.array(), v0, BufferSpace.array(), v1, count);
        }
    };
    protected ABI1.OpCode ENVSETUP1 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            t3 = inst1 & 0xFFFF;
            int tmp = inst1 >>> 8 & 0xFF00;
            env[4] = (short)tmp;
            env[5] = (short)(tmp += t3);
            s5 = inst2 >>> 16;
            s6 = inst2 & 0xFFFF;
        }
    };
    protected ABI1.OpCode ENVSETUP2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int tmp = inst2 >>> 16;
            env[0] = (short)tmp;
            env[1] = (short)(tmp += s5);
            tmp = inst2 & 0xFFFF;
            env[2] = (short)tmp;
            env[3] = (short)(tmp += s6);
        }
    };
    protected ABI1.OpCode ENVMIXER2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int adder;
            short[] v2 = new short[8];
            ShortBuffer buffs3 = BufferSpaceShort;
            int buffs3_p = (inst1 >>> 12 & 0xFF0) / 2;
            ShortBuffer bufft6 = BufferSpaceShort;
            int bufft6_p = (inst2 >>> 20 & 0xFF0) / 2;
            ShortBuffer bufft7 = BufferSpaceShort;
            int bufft7_p = (inst2 >>> 12 & 0xFF0) / 2;
            ShortBuffer buffs0 = BufferSpaceShort;
            int buffs0_p = (inst2 >>> 4 & 0xFF0) / 2;
            ShortBuffer buffs1 = BufferSpaceShort;
            int buffs1_p = (inst2 << 4 & 0xFF0) / 2;
            v2[0] = (short)(0 - (short)((inst1 & 2) >>> 1));
            v2[1] = (short)(0 - (short)(inst1 & 1));
            v2[2] = (short)(0 - (short)((inst1 & 8) >>> 1));
            v2[3] = (short)(0 - (short)((inst1 & 4) >>> 1));
            int count = inst1 >>> 8 & 0xFF;
            if (!isMKABI) {
                s5 = s5 * 2;
                s6 = s6 * 2;
                t3 = t3 * 2;
                adder = 16;
            } else {
                inst1 = 0;
                adder = 8;
                t3 = 0;
            }
            while (count > 0) {
                int temp;
                short vec10;
                short vec9;
                int x = 0;
                while (x < 8) {
                    vec9 = (short)((short)(buffs3.get(buffs3_p + (x ^ 1)) * (env[0] & 0xFFFF) >> 16) ^ v2[0]);
                    vec10 = (short)((short)(buffs3.get(buffs3_p + (x ^ 1)) * (env[2] & 0xFFFF) >> 16) ^ v2[1]);
                    temp = bufft6.get(bufft6_p + (x ^ 1)) + vec9;
                    if (temp > Short.MAX_VALUE) {
                        temp = Short.MAX_VALUE;
                    }
                    if (temp < Short.MIN_VALUE) {
                        temp = Short.MIN_VALUE;
                    }
                    bufft6.put(bufft6_p + (x ^ 1), (short)temp);
                    temp = bufft7.get(bufft7_p + (x ^ 1)) + vec10;
                    if (temp > Short.MAX_VALUE) {
                        temp = Short.MAX_VALUE;
                    }
                    if (temp < Short.MIN_VALUE) {
                        temp = Short.MIN_VALUE;
                    }
                    bufft7.put(bufft7_p + (x ^ 1), (short)temp);
                    vec9 = (short)((short)(vec9 * (env[4] & 0xFFFF) >> 16) ^ v2[2]);
                    vec10 = (short)((short)(vec10 * (env[4] & 0xFFFF) >> 16) ^ v2[3]);
                    if ((inst1 & 0x10) != 0) {
                        temp = buffs0.get(buffs0_p + (x ^ 1)) + vec10;
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        }
                        if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffs0.put(buffs0_p + (x ^ 1), (short)temp);
                        temp = buffs1.get(buffs1_p + (x ^ 1)) + vec9;
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        }
                        if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffs1.put(buffs1_p + (x ^ 1), (short)temp);
                    } else {
                        temp = buffs0.get(buffs0_p + (x ^ 1)) + vec9;
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        }
                        if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffs0.put(buffs0_p + (x ^ 1), (short)temp);
                        temp = buffs1.get(buffs1_p + (x ^ 1)) + vec10;
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        }
                        if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffs1.put(buffs1_p + (x ^ 1), (short)temp);
                    }
                    ++x;
                }
                if (!isMKABI) {
                    x = 8;
                    while (x < 16) {
                        vec9 = (short)((short)(buffs3.get(buffs3_p + (x ^ 1)) * (env[1] & 0xFFFF) >> 16) ^ v2[0]);
                        vec10 = (short)((short)(buffs3.get(buffs3_p + (x ^ 1)) * (env[3] & 0xFFFF) >> 16) ^ v2[1]);
                        temp = bufft6.get(bufft6_p + (x ^ 1)) + vec9;
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        }
                        if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        bufft6.put(bufft6_p + (x ^ 1), (short)temp);
                        temp = bufft7.get(bufft7_p + (x ^ 1)) + vec10;
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        }
                        if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        bufft7.put(bufft7_p + (x ^ 1), (short)temp);
                        vec9 = (short)((short)(vec9 * (env[5] & 0xFFFF) >> 16) ^ v2[2]);
                        vec10 = (short)((short)(vec10 * (env[5] & 0xFFFF) >> 16) ^ v2[3]);
                        if ((inst1 & 0x10) != 0) {
                            temp = buffs0.get(buffs0_p + (x ^ 1)) + vec10;
                            if (temp > Short.MAX_VALUE) {
                                temp = Short.MAX_VALUE;
                            }
                            if (temp < Short.MIN_VALUE) {
                                temp = Short.MIN_VALUE;
                            }
                            buffs0.put(buffs0_p + (x ^ 1), (short)temp);
                            temp = buffs1.get(buffs1_p + (x ^ 1)) + vec9;
                            if (temp > Short.MAX_VALUE) {
                                temp = Short.MAX_VALUE;
                            }
                            if (temp < Short.MIN_VALUE) {
                                temp = Short.MIN_VALUE;
                            }
                            buffs1.put(buffs1_p + (x ^ 1), (short)temp);
                        } else {
                            temp = buffs0.get(buffs0_p + (x ^ 1)) + vec9;
                            if (temp > Short.MAX_VALUE) {
                                temp = Short.MAX_VALUE;
                            }
                            if (temp < Short.MIN_VALUE) {
                                temp = Short.MIN_VALUE;
                            }
                            buffs0.put(buffs0_p + (x ^ 1), (short)temp);
                            temp = buffs1.get(buffs1_p + (x ^ 1)) + vec10;
                            if (temp > Short.MAX_VALUE) {
                                temp = Short.MAX_VALUE;
                            }
                            if (temp < Short.MIN_VALUE) {
                                temp = Short.MIN_VALUE;
                            }
                            buffs1.put(buffs1_p + (x ^ 1), (short)temp);
                        }
                        ++x;
                    }
                }
                bufft6_p += adder;
                bufft7_p += adder;
                buffs0_p += adder;
                buffs1_p += adder;
                buffs3_p += adder;
                count -= adder;
                short[] sArray = env;
                sArray[0] = (short)(sArray[0] + (s5 & 0xFFFF));
                short[] sArray2 = env;
                sArray2[1] = (short)(sArray2[1] + (s5 & 0xFFFF));
                short[] sArray3 = env;
                sArray3[2] = (short)(sArray3[2] + (s6 & 0xFFFF));
                short[] sArray4 = env;
                sArray4[3] = (short)(sArray4[3] + (s6 & 0xFFFF));
                short[] sArray5 = env;
                sArray5[4] = (short)(sArray5[4] + (t3 & 0xFFFF));
                short[] sArray6 = env;
                sArray6[5] = (short)(sArray6[5] + (t3 & 0xFFFF));
            }
        }
    };
    protected ABI1.OpCode DUPLICATE2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int Count = inst1 >>> 16 & 0xFF;
            int In = inst1 & 0xFFFF;
            int Out = inst2 >>> 16;
            byte[] buff = new byte[128];
            System.arraycopy(BufferSpace.array(), In, buff, 0, 128);
            while (Count != 0) {
                System.arraycopy(buff, 0, BufferSpace.array(), Out, 128);
                Out += 128;
                --Count;
            }
        }
    };
    protected ABI1.OpCode INTERL2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int Count = inst1 & 0xFFFF;
            int Out = inst2 & 0xFFFF;
            int In = inst2 >>> 16;
            ByteBuffer src = BufferSpace;
            ByteBuffer dst = BufferSpace;
            while (Count != 0) {
                dst.putShort(Out, src.getShort(In));
                Out += 2;
                In += 4;
                --Count;
            }
        }
    };
    protected ABI1.OpCode INTERLEAVE2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int outbuff_p;
            int count = inst1 >>> 12 & 0xFF0;
            ShortBuffer outbuff = BufferSpaceShort;
            if (count == 0) {
                outbuff_p = AudioOutBuffer / 2;
                count = AudioCount;
            } else {
                outbuff_p = (inst1 & 0xFFFF) / 2;
            }
            ShortBuffer inSrcR = BufferSpaceShort;
            int inSrcR_p = (inst2 & 0xFFFF) / 2;
            ShortBuffer inSrcL = BufferSpaceShort;
            int inSrcL_p = (inst2 >>> 16) / 2;
            int x = 0;
            while (x < count / 4) {
                outbuff.put(outbuff_p++, inSrcL.get(inSrcL_p++));
                outbuff.put(outbuff_p++, inSrcR.get(inSrcR_p++));
                outbuff.put(outbuff_p++, inSrcL.get(inSrcL_p++));
                outbuff.put(outbuff_p++, inSrcR.get(inSrcR_p++));
                ++x;
            }
        }
    };
    protected ABI1.OpCode ADDMIXER = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            int Count = inst1 >>> 12 & 0xFF0;
            int InBuffer = inst2 >>> 16;
            int OutBuffer = inst2 & 0xFFFF;
            ShortBuffer inp = BufferSpaceShort;
            int inp_p = InBuffer / 2;
            ShortBuffer outp = BufferSpaceShort;
            int outp_p = OutBuffer / 2;
            int cntr = 0;
            while (cntr < Count) {
                int temp = outp.get(outp_p) + inp.get(inp_p);
                if (temp > Short.MAX_VALUE) {
                    temp = Short.MAX_VALUE;
                }
                if (temp < Short.MIN_VALUE) {
                    temp = Short.MIN_VALUE;
                }
                ++outp_p;
                ++inp_p;
                cntr += 2;
            }
        }
    };
    protected ABI1.OpCode HILOGAIN = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
        }
    };
    protected ABI1.OpCode SEGMENT2 = new ABI1.OpCode(){

        public void exec(int inst1, int inst2) {
            if (isZeldaABI) {
                return;
            }
            if ((inst1 & 0xFFFFFF) == 0) {
                isMKABI = true;
            } else {
                isMKABI = false;
                isZeldaABI = true;
            }
        }
    };

    static {
        env = new short[8];
    }

    public void clock(long ticks) {
        this.alist[0] = this.SPNOOP;
        this.alist[1] = this.ADPCM2;
        this.alist[2] = this.CLEARBUFF2;
        this.alist[3] = this.UNKNOWN;
        this.alist[4] = this.ADDMIXER;
        this.alist[5] = this.RESAMPLE2;
        this.alist[6] = this.UNKNOWN;
        this.alist[7] = this.SEGMENT2;
        this.alist[8] = this.SETBUFF2;
        this.alist[9] = this.DUPLICATE2;
        this.alist[10] = this.DMEMMOVE2;
        this.alist[11] = this.LOADADPCM2;
        this.alist[12] = this.MIXER2;
        this.alist[13] = this.INTERLEAVE2;
        this.alist[14] = this.HILOGAIN;
        this.alist[15] = this.SETLOOP2;
        this.alist[16] = this.SPNOOP;
        this.alist[17] = this.INTERL2;
        this.alist[18] = this.ENVSETUP1;
        this.alist[19] = this.ENVMIXER2;
        this.alist[20] = this.LOADBUFF2;
        this.alist[21] = this.SAVEBUFF2;
        this.alist[22] = this.ENVSETUP2;
        this.alist[23] = this.SPNOOP;
        this.alist[24] = this.HILOGAIN;
        this.alist[25] = this.SPNOOP;
        this.alist[26] = this.DUPLICATE2;
        this.alist[27] = this.UNKNOWN;
        this.alist[28] = this.SPNOOP;
        this.alist[29] = this.SPNOOP;
        this.alist[30] = this.SPNOOP;
        this.alist[31] = this.SPNOOP;
        loopval = 0;
    }
}

