/*
 * Decompiled with CFR 0.152.
 */
package jario.n64.console.cpu;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.Hardware;

public class Mmu
implements Hardware,
Bus1bit,
Bus32bit {
    private static final boolean DEBUG_TLB = false;
    private static final int INDEX_REGISTER = 0;
    private static final int RANDOM_REGISTER = 1;
    private static final int ENTRYLO0_REGISTER = 2;
    private static final int ENTRYLO1_REGISTER = 3;
    private static final int PAGE_MASK_REGISTER = 5;
    private static final int BAD_VADDR_REGISTER = 8;
    private static final int ENTRYHI_REGISTER = 10;
    private static final int EXC_RMISS = 8;
    private FastTlb[] fastTlb = new FastTlb[64];
    private Tlb[] tlb = new Tlb[32];
    private int[] tlbReadMap;
    private int[] tlbWriteMap;
    private OpCode[] r4300i_Tlb_Function;
    private boolean useTlb = true;
    private boolean showTLBMisses = false;
    private Bus32bit cp0;
    protected OpCode r4300i_COP0_CO_TLBR = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Mmu.this.tlbRead();
        }
    };
    protected OpCode r4300i_COP0_CO_TLBWI = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Mmu.this.writeTlbEntry(Mmu.this.cp0.read32bit(0) & 0x1F);
        }
    };
    protected OpCode r4300i_COP0_CO_TLBWR = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Mmu.this.writeTlbEntry(Mmu.this.cp0.read32bit(1) & 0x1F);
        }
    };
    protected OpCode r4300i_COP0_CO_TLBP = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            Mmu.this.tlbProbe();
        }
    };
    protected OpCode R4300i_UnknownOpcode = new OpCode(){

        @Override
        public void exec(int inst, int unused) {
            System.err.printf("Unhandled r4300i Cop0 OpCode:%X\n", inst);
            System.exit(0);
        }
    };

    public Mmu() {
        this.tlbReadMap = new int[1048575];
        this.tlbWriteMap = new int[1048575];
        int count = 0;
        while (count < 32) {
            this.tlb[count] = new Tlb();
            ++count;
        }
        count = 0;
        while (count < 64) {
            this.fastTlb[count] = new FastTlb();
            ++count;
        }
        this.setupTlb();
        this.buildOps();
    }

    public void connect(int port, Hardware bus) {
        switch (port) {
            case 0: {
                this.cp0 = (Bus32bit)bus;
            }
        }
    }

    public void reset() {
        this.fastTlb = new FastTlb[64];
        this.tlb = new Tlb[32];
        this.tlbReadMap = new int[1048575];
        this.tlbWriteMap = new int[1048575];
        int count = 0;
        while (count < 32) {
            this.tlb[count] = new Tlb();
            ++count;
        }
        count = 0;
        while (count < 64) {
            this.fastTlb[count] = new FastTlb();
            ++count;
        }
        this.setupTlb();
    }

    public boolean read1bit(int pAddr) {
        return this.addressDefined() != 0;
    }

    public final int read32bit(int pAddr) {
        if (!this.useTlb) {
            return pAddr & 0x1FFFFFFF;
        }
        if (this.tlbReadMap[pAddr >>> 12] == 0) {
            this.cp0.write32bit(33, pAddr);
            this.cp0.write32bit(42, 8);
            if (this.showTLBMisses) {
                Thread.dumpStack();
                System.err.printf("Tlb miss address: %X\n", pAddr);
            }
            return pAddr & 0x1FFFFFFF;
        }
        return this.tlbReadMap[pAddr >>> 12] + pAddr;
    }

    public void write1bit(int pAddr, boolean value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write32bit(int pAddr, int value) {
        this.r4300i_Tlb_Function[value & 0x3F].exec(value, 0);
    }

    private void buildOps() {
        this.r4300i_Tlb_Function = new OpCode[16];
        int i = 0;
        while (i < 16) {
            this.r4300i_Tlb_Function[i] = this.R4300i_UnknownOpcode;
            ++i;
        }
        this.r4300i_Tlb_Function[1] = this.r4300i_COP0_CO_TLBR;
        this.r4300i_Tlb_Function[2] = this.r4300i_COP0_CO_TLBWI;
        this.r4300i_Tlb_Function[6] = this.r4300i_COP0_CO_TLBWR;
        this.r4300i_Tlb_Function[8] = this.r4300i_COP0_CO_TLBP;
    }

    private int addressDefined() {
        long address = (long)this.cp0.read32bit(8) & 0xFFFFFFFFL;
        if (address >= 0x80000000L && address <= 0xBFFFFFFFL) {
            return 1;
        }
        int i = 0;
        while (i < 64) {
            if (this.fastTlb[i].validEntry && address >= this.fastTlb[i].vStart && address <= this.fastTlb[i].vEnd) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    private void tlbProbe() {
        this.cp0.write32bit(0, this.cp0.read32bit(0) | Integer.MIN_VALUE);
        int count = 0;
        while (count < 32) {
            int entryHi;
            int tlbValue = this.tlb[count].getEntryHi() & ~this.tlb[count].pageMaskMask << 13;
            if (tlbValue == (entryHi = this.cp0.read32bit(10) & ~this.tlb[count].pageMaskMask << 13)) {
                boolean sameAsid;
                boolean global = (this.tlb[count].getEntryHi() & 0x100) != 0;
                boolean bl = sameAsid = (this.tlb[count].getEntryHi() & 0xFF) == (this.cp0.read32bit(10) & 0xFF);
                if (global || sameAsid) {
                    this.cp0.write32bit(0, count);
                    return;
                }
            }
            ++count;
        }
    }

    private void tlbRead() {
        int index = this.cp0.read32bit(0) & 0x1F;
        this.cp0.write32bit(5, this.tlb[index].getPageMask());
        this.cp0.write32bit(10, this.tlb[index].getEntryHi() & ~this.tlb[index].getPageMask());
        this.cp0.write32bit(2, this.tlb[index].getEntryLo0());
        this.cp0.write32bit(3, this.tlb[index].getEntryLo1());
    }

    private void writeTlbEntry(int index) {
        if (this.tlb[index].entryDefined) {
            int fastIndx = index << 1;
            while (fastIndx <= (index << 1) + 1) {
                if (this.fastTlb[fastIndx].validEntry && this.fastTlb[fastIndx].valid) {
                    long vAddr = this.fastTlb[fastIndx].vStart;
                    while (vAddr < this.fastTlb[fastIndx].vEnd) {
                        this.tlbReadMap[(int)(vAddr >> 12)] = 0;
                        this.tlbWriteMap[(int)(vAddr >> 12)] = 0;
                        vAddr += 4096L;
                    }
                }
                ++fastIndx;
            }
        }
        this.tlb[index].setPageMask(this.cp0.read32bit(5));
        this.tlb[index].setEntryHi(this.cp0.read32bit(10));
        this.tlb[index].setEntryLo0(this.cp0.read32bit(2));
        this.tlb[index].setEntryLo1(this.cp0.read32bit(3));
        this.tlb[index].entryDefined = true;
        this.setupTlbEntry(index);
    }

    private void setupTlb() {
        int i = 0;
        while (i < this.tlbReadMap.length) {
            this.tlbReadMap[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.tlbWriteMap.length) {
            this.tlbWriteMap[i] = 0;
            ++i;
        }
        long vAddr = 0x80000000L;
        while (vAddr < 0xC0000000L) {
            this.tlbReadMap[(int)(vAddr >> 12)] = (int)((vAddr & 0x1FFFFFFFL) - vAddr);
            this.tlbWriteMap[(int)(vAddr >> 12)] = (int)((vAddr & 0x1FFFFFFFL) - vAddr);
            vAddr += 4096L;
        }
        int count = 0;
        while (count < 32) {
            this.setupTlbEntry(count);
            ++count;
        }
    }

    private void setupTlbEntry(int entry) {
        if (!this.tlb[entry].entryDefined) {
            return;
        }
        int fastIndx = entry << 1;
        this.fastTlb[fastIndx].vStart = (long)this.tlb[entry].entryHiVPN2 << 13;
        this.fastTlb[fastIndx].vEnd = this.fastTlb[fastIndx].vStart + (long)(this.tlb[entry].pageMaskMask << 12) + 4095L;
        this.fastTlb[fastIndx].physStart = (long)this.tlb[entry].entryLo0PFN << 12;
        this.fastTlb[fastIndx].valid = this.tlb[entry].entryLo0V;
        this.fastTlb[fastIndx].dirty = this.tlb[entry].entryLo0D;
        this.fastTlb[fastIndx].validEntry = false;
        fastIndx = (entry << 1) + 1;
        this.fastTlb[fastIndx].vStart = ((long)this.tlb[entry].entryHiVPN2 << 13) + (((long)this.tlb[entry].pageMaskMask << 12) + 4095L + 1L);
        this.fastTlb[fastIndx].vEnd = this.fastTlb[fastIndx].vStart + ((long)this.tlb[entry].pageMaskMask << 12) + 4095L;
        this.fastTlb[fastIndx].physStart = (long)this.tlb[entry].entryLo1PFN << 12;
        this.fastTlb[fastIndx].valid = this.tlb[entry].entryLo1V;
        this.fastTlb[fastIndx].dirty = this.tlb[entry].entryLo1D;
        this.fastTlb[fastIndx].validEntry = false;
        fastIndx = entry << 1;
        while (fastIndx <= (entry << 1) + 1) {
            if (!this.fastTlb[fastIndx].valid) {
                this.fastTlb[fastIndx].validEntry = true;
            } else if (this.fastTlb[fastIndx].vEnd <= this.fastTlb[fastIndx].vStart) {
                System.err.printf("Vstart = Vend for tlb mapping\n", new Object[0]);
            } else if ((this.fastTlb[fastIndx].vStart < 0x80000000L || this.fastTlb[fastIndx].vEnd > 0xBFFFFFFFL) && this.fastTlb[fastIndx].physStart <= 0x1FFFFFFFL) {
                this.fastTlb[fastIndx].validEntry = true;
                long vAddr = this.fastTlb[fastIndx].vStart;
                while (vAddr < this.fastTlb[fastIndx].vEnd) {
                    this.tlbReadMap[(int)(vAddr >> 12)] = (int)(vAddr - this.fastTlb[fastIndx].vStart + this.fastTlb[fastIndx].physStart - vAddr);
                    if (this.fastTlb[fastIndx].dirty) {
                        this.tlbWriteMap[(int)(vAddr >> 12)] = (int)(vAddr - this.fastTlb[fastIndx].vStart + this.fastTlb[fastIndx].physStart - vAddr);
                    }
                    vAddr += 4096L;
                }
            }
            ++fastIndx;
        }
    }

    private class FastTlb {
        long vStart;
        long vEnd;
        long physStart;
        boolean valid;
        boolean dirty;
        boolean validEntry = false;

        private FastTlb() {
        }
    }

    public static interface OpCode {
        public void exec(int var1, int var2);
    }

    private class Tlb {
        boolean entryDefined = false;
        int pageMaskZero;
        int pageMaskMask;
        int pageMaskZero2;
        int entryHiASID;
        int entryHiZero;
        int entryHiG;
        int entryHiVPN2;
        boolean entryLo0GLOBAL;
        boolean entryLo0V;
        boolean entryLo0D;
        int entryLo0C;
        int entryLo0PFN;
        int entryLo0ZERO;
        boolean entryLo1GLOBAL;
        boolean entryLo1V;
        boolean entryLo1D;
        int entryLo1C;
        int entryLo1PFN;
        int entryLo1ZERO;

        private Tlb() {
        }

        public void setPageMask(int value) {
            this.pageMaskZero2 = value >> 25 & 0x7F;
            this.pageMaskMask = value >> 13 & 0xFFF;
            this.pageMaskZero = value & 0x1FFF;
        }

        public int getPageMask() {
            return this.pageMaskZero2 << 25 | this.pageMaskMask << 13 | this.pageMaskZero;
        }

        public void setEntryHi(int value) {
            this.entryHiVPN2 = value >> 13 & 0x7FFFF;
            this.entryHiG = value >> 12 & 1;
            this.entryHiZero = value >> 8 & 0xF;
            this.entryHiASID = value & 0xFF;
        }

        public int getEntryHi() {
            return this.entryHiVPN2 << 13 | this.entryHiG << 12 | this.entryHiZero << 8 | this.entryHiASID;
        }

        public void setEntryLo0(int value) {
            this.entryLo0ZERO = value >> 26 & 0x3F;
            this.entryLo0PFN = value >> 6 & 0xFFFFF;
            this.entryLo0C = value >> 3 & 7;
            this.entryLo0D = (value >> 2 & 1) == 1;
            this.entryLo0V = (value >> 1 & 1) == 1;
            this.entryLo0GLOBAL = (value & 1) == 1;
        }

        public int getEntryLo0() {
            return this.entryLo0ZERO << 26 | this.entryLo0PFN << 6 | this.entryLo0C << 3 | (this.entryLo0D ? 1 : 0) << 2 | (this.entryLo0V ? 1 : 0) << 1 | (this.entryLo0GLOBAL ? 1 : 0);
        }

        public void setEntryLo1(int value) {
            this.entryLo1ZERO = value >> 26 & 0x3F;
            this.entryLo1PFN = value >> 6 & 0xFFFFF;
            this.entryLo1C = value >> 3 & 7;
            this.entryLo1D = (value >> 2 & 1) == 1;
            this.entryLo1V = (value >> 1 & 1) == 1;
            this.entryLo1GLOBAL = (value & 1) == 1;
        }

        public int getEntryLo1() {
            return this.entryLo1ZERO << 26 | this.entryLo1PFN << 6 | this.entryLo1C << 3 | (this.entryLo1D ? 1 : 0) << 2 | (this.entryLo1V ? 1 : 0) << 1 | (this.entryLo1GLOBAL ? 1 : 0);
        }
    }
}

