/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class Cp0State
implements IState {
    private static final int STATE_VERSION = 0;
    public static final int STATUS_IE = 1;
    public static final int STATUS_EXL = 2;
    public static final int STATUS_ERL = 4;
    public static final int STATUS_BEV = 0x400000;
    private final int[] data = new int[32];
    private final int[] control = new int[32];

    public Cp0State() {
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.data);
        stream.readInts(this.control);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.data);
        stream.writeInts(this.control);
    }

    public void reset() {
        Arrays.fill(this.data, 0);
        Arrays.fill(this.control, 0);
        int dataCacheSize = 16384;
        int instructionCacheSize = 16384;
        int config = 0;
        config |= Math.min(Integer.numberOfTrailingZeros(16384) - 12, 7) << 6;
        this.setConfig(config |= Math.min(Integer.numberOfTrailingZeros(16384) - 12, 7) << 9);
        this.setStatus(1);
    }

    public int getDataRegister(int n) {
        return this.data[n];
    }

    public void setDataRegister(int n, int value) {
        this.data[n] = value;
    }

    public int getControlRegister(int n) {
        return this.control[n];
    }

    public void setControlRegister(int n, int value) {
        this.control[n] = value;
    }

    public int getEpc() {
        return this.getDataRegister(14);
    }

    public void setEpc(int epc) {
        this.setDataRegister(14, epc);
    }

    public int getErrorEpc() {
        return this.getDataRegister(30);
    }

    public void setErrorEpc(int errorEpc) {
        this.setDataRegister(30, errorEpc);
    }

    public int getStatus() {
        return this.getDataRegister(12);
    }

    public void setStatus(int status) {
        this.setDataRegister(12, status);
    }

    public int getCause() {
        return this.getDataRegister(13);
    }

    public void setCause(int cause) {
        this.setDataRegister(13, cause);
    }

    public int getEbase() {
        return this.getDataRegister(25);
    }

    public void setEbase(int ebase) {
        this.setDataRegister(25, ebase);
    }

    public void setSyscallCode(int syscallCode) {
        this.setDataRegister(21, syscallCode);
    }

    public int getSyscallCode() {
        return this.getDataRegister(21);
    }

    public void setConfig(int config) {
        this.setDataRegister(16, config);
    }

    public void setCpuid(int cpuid) {
        this.setDataRegister(22, cpuid);
    }

    public int getCpuid() {
        return this.getDataRegister(22);
    }

    public int getSyscallTable() {
        return this.getControlRegister(12);
    }

    public boolean isMediaEngineCpu() {
        return this.getCpuid() == 1;
    }

    public boolean isMainCpu() {
        return !this.isMediaEngineCpu();
    }
}

