/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.MemoryBreakpoints;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jpcsp.Debugger.MemoryBreakpoints.MemoryBreakpoint;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.memory.DebuggerMemory;
import jpcsp.util.Constants;

public class MemoryBreakpointsDialog
extends JDialog {
    private List<MemoryBreakpoint> memoryBreakpoints = ((DebuggerMemory)Memory.getInstance()).getMemoryBreakpoints();
    private MemoryBreakpointsModel memoryBreakpointsModel = new MemoryBreakpointsModel();
    private final int COL_STARTADDRESS = 0;
    private final int COL_ENDADDRESS = 1;
    private final int COL_ACCESSTYPE = 2;
    private final int COL_ACTIVE = 3;
    private final int COL_LAST = 4;
    private static final Font tableFont = new Font("Courier new", 0, 12);
    private JButton btnAdd;
    private JButton btnClose;
    private JButton btnExport;
    private JButton btnImport;
    private JButton btnRemove;
    private JCheckBox cbTraceRead;
    private JCheckBox cbTraceRead16;
    private JCheckBox cbTraceRead32;
    private JCheckBox cbTraceRead8;
    private JCheckBox cbTraceWrite;
    private JCheckBox cbTraceWrite16;
    private JCheckBox cbTraceWrite32;
    private JCheckBox cbTraceWrite8;
    private JCheckBox chkPauseOnHit;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTable tblBreakpoints;

    public MemoryBreakpointsDialog(Frame parent) {
        super(parent);
        this.initComponents();
        TableColumn accessType = this.tblBreakpoints.getColumnModel().getColumn(2);
        JComboBox<String> combo = new JComboBox<String>();
        combo.addItem("READ");
        combo.addItem("WRITE");
        combo.addItem("READWRITE");
        accessType.setCellEditor(new DefaultCellEditor(combo));
        this.tblBreakpoints.getColumnModel().getColumn(0).setCellEditor(new AddressCellEditor());
        this.tblBreakpoints.getColumnModel().getColumn(1).setCellEditor(new AddressCellEditor());
        this.tblBreakpoints.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MemoryBreakpointsDialog.this.btnRemove.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
            }
        });
        this.tblBreakpoints.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
                MemoryBreakpointsModel mbpm = (MemoryBreakpointsModel)tme.getSource();
                MemoryBreakpointsDialog.this.btnExport.setEnabled(mbpm.getRowCount() > 0);
                if (tme.getColumn() == 0 || tme.getColumn() == 1) {
                    for (int i = tme.getFirstRow(); i <= tme.getLastRow(); ++i) {
                        int start = Integer.decode(mbpm.getValueAt(i, 0).toString());
                        int end = Integer.decode(mbpm.getValueAt(i, 1).toString());
                        if (tme.getColumn() == 0 && start > end) {
                            mbpm.setValueAt(start, i, 1);
                        }
                        if (tme.getColumn() != 1 || end >= start) continue;
                        mbpm.setValueAt(end, i, 0);
                    }
                }
            }
        });
        this.updateTraceSettings();
    }

    private void updateTraceSettings() {
        DebuggerMemory dbgmem = (DebuggerMemory)Memory.getInstance();
        this.cbTraceRead.setSelected(dbgmem.traceMemoryRead);
        this.cbTraceRead8.setSelected(dbgmem.traceMemoryRead8);
        this.cbTraceRead16.setSelected(dbgmem.traceMemoryRead16);
        this.cbTraceRead32.setSelected(dbgmem.traceMemoryRead32);
        this.cbTraceWrite.setSelected(dbgmem.traceMemoryWrite);
        this.cbTraceWrite8.setSelected(dbgmem.traceMemoryWrite8);
        this.cbTraceWrite16.setSelected(dbgmem.traceMemoryWrite16);
        this.cbTraceWrite32.setSelected(dbgmem.traceMemoryWrite32);
        this.chkPauseOnHit.setSelected(dbgmem.pauseEmulatorOnMemoryBreakpoint);
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.jPanel2 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.cbTraceRead = new JCheckBox();
        this.cbTraceWrite = new JCheckBox();
        this.cbTraceRead8 = new JCheckBox();
        this.cbTraceWrite8 = new JCheckBox();
        this.cbTraceRead16 = new JCheckBox();
        this.cbTraceWrite16 = new JCheckBox();
        this.cbTraceRead32 = new JCheckBox();
        this.cbTraceWrite32 = new JCheckBox();
        this.chkPauseOnHit = new JCheckBox();
        this.btnClose = new JButton();
        this.btnExport = new JButton();
        this.btnImport = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tblBreakpoints = new JTable();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("MemoryBreakpointsDialog.title"));
        this.setLocationByPlatform(true);
        this.setName("dialog");
        this.btnAdd.setText(bundle.getString("MemoryBreakpointsDialog.btnAdd.text"));
        this.btnAdd.setMaximumSize(new Dimension(140, 25));
        this.btnAdd.setMinimumSize(new Dimension(140, 25));
        this.btnAdd.setPreferredSize(new Dimension(140, 25));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBreakpointsDialog.this.btnAddActionPerformed(evt);
            }
        });
        this.btnRemove.setText(bundle.getString("MemoryBreakpointsDialog.btnRemove.text"));
        this.btnRemove.setEnabled(false);
        this.btnRemove.setMaximumSize(new Dimension(140, 25));
        this.btnRemove.setMinimumSize(new Dimension(140, 25));
        this.btnRemove.setPreferredSize(new Dimension(140, 25));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBreakpointsDialog.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new GridLayout(5, 2));
        this.cbTraceRead.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceRead.text"));
        this.cbTraceRead.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceReadItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceRead);
        this.cbTraceWrite.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceWrite.text"));
        this.cbTraceWrite.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceWriteItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceWrite);
        this.cbTraceRead8.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceRead8.text"));
        this.cbTraceRead8.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceRead8ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceRead8);
        this.cbTraceWrite8.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceWrite8.text"));
        this.cbTraceWrite8.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceWrite8ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceWrite8);
        this.cbTraceRead16.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceRead16.text"));
        this.cbTraceRead16.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceRead16ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceRead16);
        this.cbTraceWrite16.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceWrite16.text"));
        this.cbTraceWrite16.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceWrite16ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceWrite16);
        this.cbTraceRead32.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceRead32.text"));
        this.cbTraceRead32.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceRead32ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceRead32);
        this.cbTraceWrite32.setText(bundle.getString("MemoryBreakpointsDialog.cbTraceWrite32.text"));
        this.cbTraceWrite32.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.cbTraceWrite32ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbTraceWrite32);
        this.chkPauseOnHit.setSelected(((DebuggerMemory)Memory.getInstance()).pauseEmulatorOnMemoryBreakpoint);
        this.chkPauseOnHit.setText(bundle.getString("MemoryBreakpointsDialog.chkPauseOnHit.text"));
        this.chkPauseOnHit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MemoryBreakpointsDialog.this.chkPauseOnHitItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.chkPauseOnHit);
        this.btnClose.setText(bundle.getString("CloseButton.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBreakpointsDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnExport.setText(bundle.getString("MemoryBreakpointsDialog.btnExport.text"));
        this.btnExport.setEnabled(false);
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBreakpointsDialog.this.btnExportActionPerformed(evt);
            }
        });
        this.btnImport.setText(bundle.getString("MemoryBreakpointsDialog.btnImport.text"));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryBreakpointsDialog.this.btnImportActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnImport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose)).addComponent(this.jPanel1, -1, 576, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnExport).addComponent(this.btnClose).addComponent(this.btnImport)).addGap(31, 31, 31)));
        this.tblBreakpoints.setFont(new Font("Courier New", 0, 12));
        this.tblBreakpoints.setModel(this.memoryBreakpointsModel);
        this.tblBreakpoints.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.tblBreakpoints);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnAdd, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove, -2, 140, -2)).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 104, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAdd, -2, -1, -2).addComponent(this.btnRemove, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel2, -2, 178, -2).addContainerGap()));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void chkPauseOnHitItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).pauseEmulatorOnMemoryBreakpoint = this.chkPauseOnHit.isSelected();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        MemoryBreakpoint mbp = new MemoryBreakpoint();
        this.memoryBreakpoints.add(mbp);
        this.memoryBreakpointsModel.fireTableRowsInserted(this.memoryBreakpoints.size() - 1, this.memoryBreakpoints.size() - 1);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int row = this.tblBreakpoints.getSelectedRow();
        MemoryBreakpoint mbp = this.memoryBreakpoints.remove(row);
        mbp.setEnabled(false);
        this.memoryBreakpointsModel.fireTableRowsDeleted(row, row);
        this.btnRemove.setEnabled(false);
    }

    private void cbTraceReadItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryRead = this.cbTraceRead.isSelected();
    }

    private void cbTraceRead8ItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryRead8 = this.cbTraceRead8.isSelected();
    }

    private void cbTraceRead16ItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryRead16 = this.cbTraceRead16.isSelected();
    }

    private void cbTraceRead32ItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryRead32 = this.cbTraceRead32.isSelected();
    }

    private void cbTraceWriteItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryWrite = this.cbTraceWrite.isSelected();
    }

    private void cbTraceWrite8ItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryWrite8 = this.cbTraceWrite8.isSelected();
    }

    private void cbTraceWrite16ItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryWrite16 = this.cbTraceWrite16.isSelected();
    }

    private void cbTraceWrite32ItemStateChanged(ItemEvent evt) {
        ((DebuggerMemory)Memory.getInstance()).traceMemoryWrite32 = this.cbTraceWrite32.isSelected();
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(bundle.getString("MemoryBreakpointsDialog.dlgExport.title"));
        fc.setSelectedFile(new File(State.discId + ".mbrk"));
        fc.setCurrentDirectory(new File("."));
        fc.addChoosableFileFilter(Constants.fltMemoryBreakpointFiles);
        fc.setFileFilter(Constants.fltMemoryBreakpointFiles);
        if (fc.showSaveDialog(this) == 0) {
            int rc;
            File f = fc.getSelectedFile();
            if (f.exists() && (rc = JOptionPane.showConfirmDialog(this, bundle.getString("ConsoleWindow.strFileExists.text"), bundle.getString("ConsoleWindow.strFileExistsTitle.text"), 0, 2)) != 0) {
                return;
            }
            ((DebuggerMemory)Memory.getInstance()).exportBreakpoints(fc.getSelectedFile());
        }
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("MemoryBreakpointsDialog.dlgImport.title"));
        fc.setSelectedFile(new File(State.discId + ".mbrk"));
        fc.setCurrentDirectory(new File("."));
        fc.addChoosableFileFilter(Constants.fltMemoryBreakpointFiles);
        fc.setFileFilter(Constants.fltMemoryBreakpointFiles);
        if (fc.showOpenDialog(this) == 0) {
            ((DebuggerMemory)Memory.getInstance()).importBreakpoints(fc.getSelectedFile());
        }
        this.memoryBreakpointsModel.fireTableDataChanged();
        this.updateTraceSettings();
    }

    private class MemoryBreakpointsModel
    extends AbstractTableModel {
        private MemoryBreakpointsModel() {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            MemoryBreakpoint mbp = (MemoryBreakpoint)MemoryBreakpointsDialog.this.memoryBreakpoints.get(rowIndex);
            switch (columnIndex) {
                case 0: 
                case 1: {
                    int address = 0;
                    if (aValue instanceof String) {
                        try {
                            address = Integer.decode((String)aValue);
                        }
                        catch (NumberFormatException nfe) {
                            return;
                        }
                    } else if (aValue instanceof Integer) {
                        address = (Integer)aValue;
                    } else {
                        throw new IllegalArgumentException("only String or Integer values allowed");
                    }
                    if (columnIndex == 0) {
                        mbp.setStartAddress(address);
                        break;
                    }
                    if (columnIndex != 1) break;
                    mbp.setEndAddress(address);
                    break;
                }
                case 2: {
                    String value = ((String)aValue).toUpperCase();
                    if (value.equals("READ")) {
                        mbp.setAccess(MemoryBreakpoint.AccessType.READ);
                        break;
                    }
                    if (value.equals("WRITE")) {
                        mbp.setAccess(MemoryBreakpoint.AccessType.WRITE);
                        break;
                    }
                    if (!value.equals("READWRITE")) break;
                    mbp.setAccess(MemoryBreakpoint.AccessType.READWRITE);
                    break;
                }
                case 3: {
                    mbp.setEnabled((Boolean)aValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("column out of range: " + columnIndex);
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            throw new IllegalArgumentException("column out of range: " + columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            switch (column) {
                case 0: {
                    return bundle.getString("MemoryBreakpointsDialog.strStartAddress.text");
                }
                case 1: {
                    return bundle.getString("MemoryBreakpointsDialog.strEndAddress.text");
                }
                case 2: {
                    return bundle.getString("MemoryBreakpointsDialog.strAccess.text");
                }
                case 3: {
                    return bundle.getString("MemoryBreakpointsDialog.strActive.text");
                }
            }
            throw new IllegalArgumentException("column out of range: " + column);
        }

        @Override
        public int getRowCount() {
            return MemoryBreakpointsDialog.this.memoryBreakpoints.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MemoryBreakpoint mbp = (MemoryBreakpoint)MemoryBreakpointsDialog.this.memoryBreakpoints.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.format("0x%08X", mbp.getStartAddress());
                }
                case 1: {
                    return String.format("0x%08X", mbp.getEndAddress());
                }
                case 2: {
                    switch (mbp.getAccess()) {
                        case READ: {
                            return "READ";
                        }
                        case WRITE: {
                            return "WRITE";
                        }
                        case READWRITE: {
                            return "READWRITE";
                        }
                    }
                    throw new IllegalArgumentException("unknown access type");
                }
                case 3: {
                    return mbp.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            throw new IllegalArgumentException("column out of range: " + columnIndex);
        }
    }

    private class AddressCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public AddressCellEditor() {
            super(new JTextField());
            JTextField tf = (JTextField)this.getComponent();
            tf.setFont(tableFont);
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.getComponent()).getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            final JTextField tf = (JTextField)this.getComponent();
            tf.setText(String.format("0x%X", Integer.decode((String)table.getModel().getValueAt(row, column))));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tf.select(2, tf.getText().length());
                }
            });
            return tf;
        }
    }
}

