/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlan;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.IWlanAdapter;
import org.apache.log4j.Logger;

public class ChatGUI
extends JFrame {
    private static final long serialVersionUID = 5376146560681704272L;
    private Logger log = Emulator.log;
    private JScrollPane scrollPane;
    private JLabel chatMessagesLabel;
    private JTextField chatMessage;
    private JButton sendButton;
    private JLabel adhocIDLabel;
    private JLabel groupNameLabel;
    private JLabel membersLabel;
    private JLabel membersList;
    private List<String> chatMessages = new LinkedList<String>();
    private List<String> members = new LinkedList<String>();
    private static final String chatMessageHeader = "<html>";
    private static final String chatMessageFooter = "</html>";
    private static final String membersHeader = "<html>";
    private static final String membersFooter = "</html>";
    private HashMap<String, Color> nickNameColors = new HashMap();
    private String myNickName;
    private String adhocId;
    private String groupName;
    private int allColorsIndex = 0;
    private static final Color colorForMe = Color.GRAY;
    private static final Color[] allColors = new Color[]{Color.BLUE, Color.RED, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW, Color.BLACK};

    public ChatGUI() {
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.nickNameColors.put(this.getMyNickName(), colorForMe);
        this.updateMembersLabel();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.chatMessagesLabel = new JLabel();
        this.chatMessage = new JTextField();
        this.sendButton = new JButton();
        this.adhocIDLabel = new JLabel();
        this.groupNameLabel = new JLabel();
        this.membersLabel = new JLabel();
        this.membersList = new JLabel();
        this.setTitle("Chat");
        this.setResizable(true);
        this.sendButton.setText("Send");
        this.sendButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChatGUI.this.onSend();
            }
        });
        this.chatMessagesLabel.setVerticalAlignment(3);
        this.chatMessagesLabel.setPreferredSize(new Dimension(500, 300));
        this.scrollPane.setViewportView(this.chatMessagesLabel);
        this.adhocIDLabel.setText(this.getAdhocID());
        this.groupNameLabel.setText(this.getGroupName());
        this.membersLabel.setText("Members:");
        this.membersList.setPreferredSize(new Dimension(100, this.chatMessagesLabel.getPreferredSize().height));
        this.chatMessage.setEditable(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.scrollPane).addGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addComponent(this.adhocIDLabel)).addGroup(layout.createParallelGroup().addComponent(this.groupNameLabel)).addComponent(this.membersLabel).addComponent(this.membersList))).addGroup(layout.createSequentialGroup().addComponent(this.chatMessage).addComponent(this.sendButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.scrollPane).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.adhocIDLabel)).addGroup(layout.createParallelGroup().addComponent(this.groupNameLabel)).addComponent(this.membersLabel).addComponent(this.membersList))).addGroup(layout.createParallelGroup().addComponent(this.chatMessage).addComponent(this.sendButton)));
        this.pack();
    }

    private void onSend() {
        IWlanAdapter wlanAdapter;
        String message = this.chatMessage.getText();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Sending chat message '%s'", message));
        }
        if ((wlanAdapter = Modules.sceWlanModule.getWlanAdapter()) == null) {
            wlanAdapter = MMIOHandlerWlan.getInstance().getWlanAdapter();
        }
        INetworkAdapter networkAdapter = Modules.sceNetModule.getNetworkAdapter();
        if (wlanAdapter != null) {
            wlanAdapter.sendChatMessage(message);
        } else if (networkAdapter != null) {
            networkAdapter.sendChatMessage(message);
        }
        this.chatMessage.setText("");
        this.addChatMessage(this.getMyNickName(), message, true);
    }

    private void addChatLine(String line) {
        this.chatMessages.add(line);
        StringBuilder formattedText = new StringBuilder();
        formattedText.append("<html>");
        for (String chatMessage : this.chatMessages) {
            formattedText.append(String.format("<br>%s</br>\n", chatMessage));
        }
        formattedText.append("</html>");
        this.chatMessagesLabel.setText(formattedText.toString());
    }

    private Color getNewColor() {
        if (this.allColorsIndex >= allColors.length) {
            this.allColorsIndex = 0;
        }
        return allColors[this.allColorsIndex++];
    }

    private Color getNickNameColor(String nickName) {
        Color color = this.nickNameColors.get(nickName);
        if (color == null) {
            color = this.getNewColor();
            this.nickNameColors.put(nickName, color);
        }
        return color;
    }

    public void addChatMessage(String nickName, String message) {
        this.addChatMessage(nickName, message, false);
    }

    private String getFormattedNickName(String nickName, boolean isMe) {
        Color nickNameColor = this.getNickNameColor(nickName);
        String nickNameSuffix = isMe ? " (me)" : "";
        return String.format("<font color='#%06X'>%s%s</font>", nickNameColor.getRGB() & 0xFFFFFF, nickName, nickNameSuffix);
    }

    private void addChatMessage(String nickName, String message, boolean isMe) {
        String line = nickName == null ? message : String.format("%s - %s", this.getFormattedNickName(nickName, isMe), message);
        this.addChatLine(line);
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private void updateMembersLabel() {
        if (this.membersList == null) {
            return;
        }
        StringBuilder label = new StringBuilder();
        label.append("<html>");
        label.append(String.format("<br>%s</br>", this.getFormattedNickName(this.getMyNickName(), true)));
        for (String member : this.members) {
            label.append(String.format("<br>%s</br>", this.getFormattedNickName(member, false)));
        }
        label.append("</html>");
        this.membersList.setText(label.toString());
    }

    public void updateMembers(List<String> members) {
        this.members.clear();
        this.members.addAll(members);
        this.updateMembersLabel();
    }

    public void addMember(String member) {
        if (!this.members.contains(member)) {
            this.members.add(member);
            this.updateMembersLabel();
        }
    }

    public void removeMember(String member) {
        if (this.members.contains(member)) {
            this.members.remove(member);
            this.updateMembersLabel();
        }
    }

    private String getMyNickName() {
        if (this.myNickName == null) {
            return sceUtility.getSystemParamNickname();
        }
        return this.myNickName;
    }

    public void setMyNickName(String myNickName) {
        this.myNickName = myNickName;
        this.updateMembersLabel();
    }

    private String getAdhocID() {
        if (this.adhocId == null) {
            return Modules.sceNetAdhocctlModule.hleNetAdhocctlGetAdhocID();
        }
        return this.adhocId;
    }

    public void setAdhocId(String adhocId) {
        this.adhocId = adhocId;
        this.adhocIDLabel.setText(this.getAdhocID());
    }

    private String getGroupName() {
        if (this.groupName == null) {
            return Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGroupName();
        }
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.groupNameLabel.setText(this.getGroupName());
    }
}

