/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.Memory;

public class TPointerFunction {
    public static final TPointerFunction NULL = new TPointerFunction();
    private TPointer32 pointer;

    public TPointerFunction() {
        this.pointer = TPointer32.NULL;
    }

    public TPointerFunction(Memory mem, int address) {
        this.pointer = address == 0 ? TPointer32.NULL : new TPointer32(mem, address);
    }

    public TPointer getPointer() {
        return this.pointer.getPointer();
    }

    public boolean isNull() {
        return this.pointer.isNull();
    }

    public boolean isNotNull() {
        return this.pointer.isNotNull();
    }

    public int getAddress() {
        if (this.pointer == null) {
            return 0;
        }
        return this.pointer.getAddress();
    }

    public int executeCallback(int arg0) {
        return this.executeCallback(null, arg0);
    }

    public int executeCallback(IAction afterAction, int arg0) {
        CallbackReturnCode callbackReturnCode = new CallbackReturnCode(afterAction);
        Modules.ThreadManForUserModule.executeCallback(Modules.ThreadManForUserModule.getCurrentThread(), this.pointer.getAddress(), (IAction)callbackReturnCode, false, true, arg0);
        return callbackReturnCode.getReturnCode();
    }

    public int executeCallback(int arg0, int arg1) {
        return this.executeCallback(null, arg0, arg1);
    }

    public int executeCallback(IAction afterAction, int arg0, int arg1) {
        CallbackReturnCode callbackReturnCode = new CallbackReturnCode(afterAction);
        Modules.ThreadManForUserModule.executeCallback(Modules.ThreadManForUserModule.getCurrentThread(), this.pointer.getAddress(), (IAction)callbackReturnCode, false, true, arg0, arg1);
        return callbackReturnCode.getReturnCode();
    }

    public int executeCallback(int arg0, int arg1, int arg2) {
        return this.executeCallback(Modules.ThreadManForUserModule.getCurrentThread(), null, arg0, arg1, arg2);
    }

    public int executeCallback(SceKernelThreadInfo thread, int arg0, int arg1, int arg2) {
        return this.executeCallback(thread, null, arg0, arg1, arg2);
    }

    public int executeCallback(IAction afterAction, int arg0, int arg1, int arg2) {
        return this.executeCallback(Modules.ThreadManForUserModule.getCurrentThread(), afterAction, arg0, arg1, arg2);
    }

    public int executeCallback(SceKernelThreadInfo thread, IAction afterAction, int arg0, int arg1, int arg2) {
        CallbackReturnCode callbackReturnCode = new CallbackReturnCode(afterAction);
        Modules.ThreadManForUserModule.executeCallback(thread, this.pointer.getAddress(), (IAction)callbackReturnCode, false, true, arg0, arg1, arg2);
        return callbackReturnCode.getReturnCode();
    }

    public int executeCallback(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return this.executeCallback(null, arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public int executeCallback(IAction afterAction, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        CallbackReturnCode callbackReturnCode = new CallbackReturnCode(afterAction);
        Modules.ThreadManForUserModule.executeCallback(Modules.ThreadManForUserModule.getCurrentThread(), this.pointer.getAddress(), callbackReturnCode, false, true, arg0, arg1, arg2, arg3, arg4, arg5);
        return callbackReturnCode.getReturnCode();
    }

    public int executeCallback(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        return this.executeCallback(null, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public int executeCallback(IAction afterAction, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        CallbackReturnCode callbackReturnCode = new CallbackReturnCode(afterAction);
        Modules.ThreadManForUserModule.executeCallback(Modules.ThreadManForUserModule.getCurrentThread(), this.pointer.getAddress(), callbackReturnCode, false, true, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        return callbackReturnCode.getReturnCode();
    }

    public String toString() {
        return this.pointer.toString();
    }

    private static class CallbackReturnCode
    implements IAction {
        private int returnCode;
        private IAction nextAction;

        public CallbackReturnCode(IAction nextAction) {
            this.nextAction = nextAction;
        }

        @Override
        public void execute() {
            this.returnCode = Emulator.getProcessor().cpu._v0;
            if (this.nextAction != null) {
                this.nextAction.execute();
            }
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

