/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import java.util.Arrays;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.HLE.VFS.fat.FatUtils;
import jpcsp.HLE.VFS.fat.FatVirtualFile;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class FatVirtualFileSystem
extends AbstractVirtualFileSystem
implements IVirtualCache {
    private static Logger log = FatVirtualFile.log;
    private final String deviceName;
    private final IVirtualFile vFile;
    private final byte[] currentSector = new byte[512];
    private int[] fatClusterMap;
    private int sectorsPerCluster;
    private int rootDirectoryClusterNumber;
    private int firstDataClusterSectorNumber;
    private int fatEOC;
    private int clusterMask;

    public FatVirtualFileSystem(String deviceName, IVirtualFile vFile) {
        this.deviceName = deviceName;
        this.vFile = vFile;
        this.init();
    }

    private void init() {
        int i;
        int fatSectors;
        boolean isFat32 = false;
        boolean isFat16 = false;
        boolean isFat12 = false;
        this.readSector(0);
        this.sectorsPerCluster = FatUtils.readSectorInt8(this.currentSector, 13);
        int reservedSectors = FatUtils.readSectorInt16(this.currentSector, 14);
        int numberOfFats = FatUtils.readSectorInt8(this.currentSector, 16);
        int numberOfRootDirectoryEntries = FatUtils.readSectorInt16(this.currentSector, 17);
        int totalSectors = FatUtils.readSectorInt16(this.currentSector, 19);
        if (totalSectors == 0) {
            totalSectors = FatUtils.readSectorInt32(this.currentSector, 32);
        }
        if ((fatSectors = FatUtils.readSectorInt16(this.currentSector, 22)) == 0) {
            isFat32 = true;
            fatSectors = FatUtils.readSectorInt32(this.currentSector, 36);
        }
        int firstDataClusterOffset = (numberOfRootDirectoryEntries << 5) / 512;
        int usedSectors = reservedSectors + fatSectors * numberOfFats + firstDataClusterOffset;
        int maxNumberClusters = (totalSectors - usedSectors) / this.sectorsPerCluster;
        if (!isFat32) {
            isFat16 = maxNumberClusters > 4084;
            isFat12 = !isFat16;
        }
        int fatSectorNumber = 0 + reservedSectors;
        byte[] fatTable = new byte[fatSectors * 512];
        this.readSectors(fatSectorNumber, fatTable, 0, fatTable.length);
        this.fatClusterMap = new int[maxNumberClusters];
        if (isFat32) {
            this.fatEOC = 0xFFFFFFF;
            this.clusterMask = 0xFFFFFFF;
            i = 0;
            int n = 0;
            while (n < this.fatClusterMap.length) {
                int fatEntry = FatUtils.readSectorInt32(fatTable, i);
                this.fatClusterMap[n++] = fatEntry;
                i += 4;
            }
        } else if (isFat16) {
            this.fatEOC = 65528;
            this.clusterMask = 65535;
            i = 0;
            int n = 0;
            while (n < this.fatClusterMap.length) {
                int fatEntry = FatUtils.readSectorInt16(fatTable, i);
                this.fatClusterMap[n++] = fatEntry;
                i += 2;
            }
        } else if (isFat12) {
            this.fatEOC = 4088;
            this.clusterMask = 4095;
            i = 0;
            int n = 0;
            while (n < this.fatClusterMap.length) {
                int fatEntry0 = FatUtils.readSectorInt8(fatTable, i) | (FatUtils.readSectorInt8(fatTable, i + 1) & 0xF) << 8;
                this.fatClusterMap[n++] = fatEntry0;
                int fatEntry1 = FatUtils.readSectorInt8(fatTable, i + 1) >> 4 | FatUtils.readSectorInt8(fatTable, i + 2) << 4;
                if (n < this.fatClusterMap.length) {
                    this.fatClusterMap[n++] = fatEntry1;
                }
                i += 3;
            }
        } else {
            log.error((Object)String.format("Unknown FAT type", new Object[0]));
        }
        int rootDirectorySectorNumber = fatSectorNumber + numberOfFats * fatSectors;
        this.firstDataClusterSectorNumber = rootDirectorySectorNumber + firstDataClusterOffset;
        this.rootDirectoryClusterNumber = isFat32 ? FatUtils.readSectorInt32(this.currentSector, 44) : 1;
    }

    private boolean isEndOfClusterChain(int clusterNumber) {
        return (clusterNumber & this.fatEOC) == this.fatEOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSectors(int sectorNumber, byte[] buffer, int offset, int length) {
        int readLength;
        IVirtualFile iVirtualFile = this.vFile;
        synchronized (iVirtualFile) {
            this.vFile.ioLseek((long)sectorNumber * 512L);
            readLength = this.vFile.ioRead(buffer, offset, length);
        }
        if (readLength != length) {
            log.error((Object)String.format("FatVirtualFileSystem.readSectors cannot read sectors sectorNumber=0x%X, length=0x%X, readLength=0x%X", sectorNumber, length, readLength));
            if (readLength < 0) {
                readLength = 0;
            }
            Arrays.fill(buffer, offset + readLength, offset + length - readLength, (byte)0);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("readSectors sectorNumber=0x%X: %s", sectorNumber, Utilities.getMemoryDump(buffer, offset, readLength)));
        }
    }

    private void readSector(int sectorNumber) {
        this.readSectors(sectorNumber, this.currentSector, 0, 512);
    }

    private int getSectorNumber(int clusterNumber) {
        return (clusterNumber - 2) * this.sectorsPerCluster + this.firstDataClusterSectorNumber;
    }

    private boolean isDataClusterNumber(int clusterNumber) {
        return (clusterNumber &= this.clusterMask) >= 2 && clusterNumber <= (0xFFFFFEF & this.clusterMask);
    }

    private int[] getClusters(int clusterNumber) {
        int nextCluster;
        int[] clusters = new int[]{clusterNumber};
        while (clusterNumber >= 0 && clusterNumber < this.fatClusterMap.length && this.isDataClusterNumber(nextCluster = this.fatClusterMap[clusterNumber])) {
            clusters = Utilities.extendArray(clusters, 1);
            clusters[clusters.length - 1] = clusterNumber = nextCluster & this.clusterMask;
        }
        return clusters;
    }

    public FatFileInfo[] getDirectoryEntries(int clusterNumber) {
        FatFileInfo[] entries = null;
        byte[] lfn = null;
        boolean end = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("getDirectoryEntries clusterNumber=0x%X", clusterNumber));
        }
        while (!end && !this.isEndOfClusterChain(clusterNumber)) {
            int sectorNumber = this.getSectorNumber(clusterNumber);
            block1: for (int i = 0; !end && i < this.sectorsPerCluster; ++i) {
                this.readSector(sectorNumber + i);
                for (int offset = 0; offset < 512; offset += 32) {
                    int firstByte;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("getDirectoryEntries sectorNumber=0x%X, offset=0x%X, %s", sectorNumber, offset, Utilities.getMemoryDump(this.currentSector, offset, 32)));
                    }
                    if ((firstByte = FatUtils.readSectorInt8(this.currentSector, offset + 0)) == 0) {
                        end = true;
                        continue block1;
                    }
                    if (firstByte == 229) continue;
                    if (FatVirtualFile.isLongFileNameDirectoryEntry(this.currentSector, offset)) {
                        lfn = Utilities.extendArray(lfn, this.currentSector, offset, 32);
                        continue;
                    }
                    String entryName = FatVirtualFile.getFileName(this.currentSector, offset, lfn);
                    lfn = null;
                    if (".".equals(entryName) || "..".equals(entryName)) continue;
                    String fileName83 = new String(this.currentSector, offset + 0, 11);
                    int fileAttributes = FatUtils.readSectorInt8(this.currentSector, offset + 11);
                    int entryClusterNumber = FatUtils.readSectorInt16(this.currentSector, offset + 20) << 16;
                    entryClusterNumber |= FatUtils.readSectorInt16(this.currentSector, offset + 26);
                    long fileSize = (long)FatUtils.readSectorInt32(this.currentSector, offset + 28) & 0xFFFFFFFFL;
                    int time = FatUtils.readSectorInt16(this.currentSector, offset + 22);
                    ScePspDateTime lastModified = ScePspDateTime.fromMSDOSTime(time |= FatUtils.readSectorInt16(this.currentSector, offset + 24) << 16);
                    FatFileInfo fatFileInfo = new FatFileInfo();
                    fatFileInfo.setFileName(entryName);
                    fatFileInfo.setReadOnly((fileAttributes & 1) != 0);
                    fatFileInfo.setDirectory((fileAttributes & 0x10) != 0);
                    fatFileInfo.setFileSize(fileSize);
                    fatFileInfo.setLastModified(lastModified);
                    fatFileInfo.setFileName83(fileName83);
                    if (entryClusterNumber != 0) {
                        fatFileInfo.setClusters(this.getClusters(entryClusterNumber));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Found directoryEntry %s", fatFileInfo));
                    }
                    entries = Utilities.add(entries, fatFileInfo);
                }
            }
            clusterNumber = this.fatClusterMap[clusterNumber];
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("getDirectoryEntries next clusterNumber=0x%X", clusterNumber));
        }
        return entries;
    }

    private FatFileInfo getFatFileInfo(int clusterNumber, String fileName) {
        FatFileInfo[] entries = this.getDirectoryEntries(clusterNumber);
        if (entries != null) {
            for (FatFileInfo entry : entries) {
                if (!fileName.equals(entry.getFileName())) continue;
                return entry;
            }
        }
        return null;
    }

    private FatFileInfo getFatFileInfo(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        int clusterNumber = this.rootDirectoryClusterNumber;
        while (true) {
            int directorySeparator;
            if ((directorySeparator = fileName.indexOf(47)) < 0) {
                FatFileInfo fatFileInfo = this.getFatFileInfo(clusterNumber, fileName);
                if (fatFileInfo == null) break;
                return fatFileInfo;
            }
            String directoryName = fileName.substring(0, directorySeparator);
            FatFileInfo fatFileInfo = this.getFatFileInfo(clusterNumber, directoryName);
            if (fatFileInfo == null) break;
            clusterNumber = fatFileInfo.getFirstCluster();
            fileName = fileName.substring(directorySeparator + 1);
        }
        return null;
    }

    private int getFirstClusterNumber(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return this.rootDirectoryClusterNumber;
        }
        FatFileInfo fatFileInfo = this.getFatFileInfo(fileName);
        if (fatFileInfo == null) {
            return -1;
        }
        return fatFileInfo.getFirstCluster();
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        if (flags != 1) {
            log.error((Object)String.format("FatVirtualFileSystem.ioOpen unimplemented fileName='%s', flags=0x%X", fileName, flags));
            return null;
        }
        FatFileInfo fatFileInfo = this.getFatFileInfo(fileName);
        if (fatFileInfo == null) {
            return null;
        }
        FatVirtualFileInstance vFile = new FatVirtualFileInstance(fatFileInfo);
        return vFile;
    }

    @Override
    public String[] ioDopen(String dirName) {
        FatFileInfo[] entries;
        int clusterNumber = this.getFirstClusterNumber(dirName);
        if (clusterNumber < 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ioDopen dirName='%s', clusterNumber=0x%X", dirName, clusterNumber));
        }
        if ((entries = this.getDirectoryEntries(clusterNumber)) == null) {
            return null;
        }
        String[] fileNames = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            fileNames[i] = entries[i].getFileName();
        }
        return fileNames;
    }

    @Override
    public int ioDclose(String dirName) {
        return 0;
    }

    @Override
    public int ioDread(String dirName, SceIoDirent dir) {
        FatFileInfo fatFileInfo;
        int clusterNumber = this.getFirstClusterNumber(dirName);
        if (clusterNumber < 0) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ioDread dirName='%s', fileName='%s', clusterNumber=0x%X", dirName, dir.filename, clusterNumber));
        }
        if ((fatFileInfo = this.getFatFileInfo(clusterNumber, dir.filename)) == null) {
            return -1;
        }
        int attr = fatFileInfo.isDirectory() ? 16 : 32;
        int mode = fatFileInfo.isReadOnly() ? 365 : 511;
        dir.stat.mode = mode |= attr << 8;
        dir.stat.attr = attr;
        dir.stat.size = fatFileInfo.getFileSize();
        dir.stat.ctime = fatFileInfo.getLastModified();
        dir.stat.atime = ScePspDateTime.fromUnixTime(0L);
        dir.stat.mtime = fatFileInfo.getLastModified();
        return 1;
    }

    @Override
    public int ioGetstat(String fileName, SceIoStat stat) {
        log.error((Object)String.format("FatVirtualFileSystem.ioGetstat unimplemented fileName='%s'", fileName));
        return -1;
    }

    @Override
    public void invalidateCachedData() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("invalidateCachedData for %s", this));
        }
        this.init();
        if (this.vFile instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.vFile)).invalidateCachedData();
        }
    }

    @Override
    public void flushCachedData() {
        if (this.vFile instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.vFile)).flushCachedData();
        }
    }

    @Override
    public void closeCachedFiles() {
        if (this.vFile instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.vFile)).closeCachedFiles();
        }
    }

    public int[] getFatClusterMap() {
        return this.fatClusterMap;
    }

    public int getRootDirectoryClusterNumber() {
        return this.rootDirectoryClusterNumber;
    }

    public String toString() {
        return String.format("%s%s", this.deviceName == null ? "" : this.deviceName, this.vFile);
    }

    private class FatVirtualFileInstance
    implements IVirtualFile {
        private final long length;
        private final int[] clusters;
        private long position;

        public FatVirtualFileInstance(FatFileInfo fatFileInfo) {
            this.length = fatFileInfo.getFileSize();
            this.clusters = fatFileInfo.getClusters();
        }

        @Override
        public int ioClose() {
            return 0;
        }

        private int getSectorNumberFromPosition() {
            int clusterIndex = (int)(this.position / (long)(512 * FatVirtualFileSystem.this.sectorsPerCluster));
            int clusterNumber = this.clusters[clusterIndex];
            int sectorNumber = FatVirtualFileSystem.this.getSectorNumber(clusterNumber);
            sectorNumber = (int)((long)sectorNumber + this.position / 512L % (long)FatVirtualFileSystem.this.sectorsPerCluster);
            return sectorNumber;
        }

        private int getSectorOffset() {
            return (int)(this.position % 512L);
        }

        @Override
        public int ioRead(TPointer outputPointer, int outputLength) {
            int readLength = 0;
            int outputOffset = 0;
            while (outputLength > 0) {
                int sectorNumber = this.getSectorNumberFromPosition();
                FatVirtualFileSystem.this.readSector(sectorNumber);
                int sectorOffset = this.getSectorOffset();
                int sectorLength = 512 - sectorOffset;
                int length = Math.min(sectorLength, outputLength);
                outputPointer.setArray(outputOffset, FatVirtualFileSystem.this.currentSector, sectorOffset, length);
                outputLength -= length;
                outputOffset += length;
                this.position += (long)length;
                readLength += length;
            }
            return readLength;
        }

        @Override
        public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
            int readLength = 0;
            while (outputLength > 0) {
                int sectorNumber = this.getSectorNumberFromPosition();
                FatVirtualFileSystem.this.readSector(sectorNumber);
                int sectorOffset = this.getSectorOffset();
                int sectorLength = 512 - sectorOffset;
                int length = Math.min(sectorLength, outputLength);
                System.arraycopy(FatVirtualFileSystem.this.currentSector, sectorOffset, outputBuffer, outputOffset, length);
                outputLength -= length;
                outputOffset += length;
                this.position += (long)length;
                readLength += length;
            }
            return readLength;
        }

        @Override
        public int ioWrite(TPointer inputPointer, int inputLength) {
            return -1;
        }

        @Override
        public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
            return -1;
        }

        @Override
        public long ioLseek(long offset) {
            this.position = offset;
            return this.position;
        }

        @Override
        public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
            return -1;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean isSectorBlockMode() {
            return false;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public IVirtualFile duplicate() {
            return null;
        }

        @Override
        public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
            return null;
        }
    }
}

