/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.synchronize;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.VFS.synchronize.ISynchronize;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.modules.sceRtc;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public abstract class BaseSynchronize
implements ISynchronize {
    public static Logger log = Logger.getLogger((String)"synchronize");
    private static final int STATE_VERSION = 0;
    protected static final int deltaSyncDelayMillis = 1000;
    protected static final int deltaSyncIntervalMillis = 100;
    protected String name;
    protected final Object lock;
    private long lastWrite;
    private long lastSync;
    private SynchronizeThread synchronizeThread;

    protected BaseSynchronize(String name, Object lock) {
        this.name = name;
        this.lock = lock;
        this.synchronizeThread = new SynchronizeThread();
        this.synchronizeThread.setName(String.format("Synchronize Thread - %s", name));
        this.synchronizeThread.setDaemon(true);
        this.synchronizeThread.start();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.lastWrite = stream.readLong();
        this.lastSync = stream.readLong();
        this.invalidateCachedData();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeLong(this.lastWrite);
        stream.writeLong(this.lastSync);
    }

    protected ScePspDateTime nowDate() {
        return ScePspDateTime.fromMicrosLocal(sceRtc.hleGetCurrentMicros());
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkDeltaSynchronize(int syncDelayMillis) {
        int result = 0;
        Object object = this.lock;
        synchronized (object) {
            long now = this.now();
            long millisSinceLastWrite = now - this.lastWrite;
            if (this.lastSync < this.lastWrite && millisSinceLastWrite >= (long)syncDelayMillis) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("checkDeltaSynchronize deltaSynchronize() now", new Object[0]));
                }
                try {
                    result = this.deltaSynchronize();
                }
                catch (Exception e) {
                    log.error((Object)"checkDeltaSynchronize", (Throwable)e);
                    result = -1;
                }
                if (result >= 0) {
                    this.lastSync = now;
                }
            }
        }
        return result;
    }

    @Override
    public int synchronize() {
        return this.checkDeltaSynchronize(0);
    }

    protected abstract int deltaSynchronize();

    protected abstract void invalidateCachedData();

    protected abstract void flushCachedData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWrite() {
        long now = this.now();
        Object object = this.lock;
        synchronized (object) {
            this.lastWrite = now;
        }
    }

    public void exit() {
        this.synchronizeThread.exit();
    }

    private class SynchronizeThread
    extends Thread {
        private volatile boolean exit;
        private volatile boolean done;

        private SynchronizeThread() {
        }

        @Override
        public void run() {
            this.done = false;
            RuntimeContext.setLog4jMDC();
            while (!this.exit) {
                Utilities.sleep(100, 0);
                BaseSynchronize.this.checkDeltaSynchronize(1000);
            }
            BaseSynchronize.this.checkDeltaSynchronize(0);
            this.done = true;
        }

        public void exit() {
            this.exit = true;
            while (!this.done) {
                Utilities.sleep(100);
            }
        }
    }
}

