/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.synchronize;

import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.synchronize.BaseSynchronize;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class SynchronizeMemoryToVirtualFile
extends BaseSynchronize {
    private static final int STATE_VERSION = 0;
    private TPointer input;
    private int inputSize;
    private IVirtualFile output;
    private long outputOffset;

    public SynchronizeMemoryToVirtualFile(String name, TPointer input, int inputSize, IVirtualFile output, Object lock) {
        super(name, lock);
        this.input = input;
        this.inputSize = inputSize;
        this.output = output;
        this.outputOffset = output.getPosition();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        super.write(stream);
    }

    @Override
    protected int deltaSynchronize() {
        int result = 0;
        long seekPosition = this.output.ioLseek(this.outputOffset);
        if (seekPosition != this.outputOffset) {
            log.error((Object)String.format("Error while seeking in %s to 0x%X", this.output, this.outputOffset));
            result = -1;
        } else {
            int writeSize = this.output.ioWrite(this.input, this.inputSize);
            if (writeSize < 0) {
                log.error((Object)String.format("Error while writing to %s: 0x%08X", this.output, writeSize));
                result = writeSize;
            } else if (writeSize != this.inputSize) {
                log.error((Object)String.format("Error while writing to %s: could not write 0x%X bytes, but only 0x%X", this.output, this.inputSize, writeSize));
                result = -1;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("deltaSynchronize successfully written %s", Utilities.getMemoryDump(this.input, 4096)));
            }
        }
        return result;
    }

    @Override
    protected void invalidateCachedData() {
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).invalidateCachedData();
        }
    }

    @Override
    protected void flushCachedData() {
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).flushCachedData();
        }
    }
}

