/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.synchronize;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.synchronize.BaseSynchronize;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class SynchronizeVirtualFileSystems
extends BaseSynchronize {
    private static final int STATE_VERSION = 0;
    private IVirtualFileSystem input;
    private IVirtualFileSystem output;
    private ScePspDateTime lastSyncDate;
    private boolean somethingChanged;
    private final Set<DirectoryEntryData> toBeDeleted = new HashSet<DirectoryEntryData>();

    public SynchronizeVirtualFileSystems(String name, IVirtualFileSystem input, IVirtualFileSystem output, Object lock) {
        super(name, lock);
        this.input = input;
        this.output = output;
        this.lastSyncDate = this.nowDate();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.lastSyncDate.read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.lastSyncDate.write(stream);
        super.write(stream);
    }

    @Override
    protected void invalidateCachedData() {
        if (this.input instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.input)).invalidateCachedData();
        }
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).invalidateCachedData();
        }
    }

    @Override
    protected void flushCachedData() {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("SynchronizeVirtualFileSystems.flushCachedData on input=%s, output=%s", this.input, this.output));
        }
        if (this.input instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.input)).flushCachedData();
        }
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).flushCachedData();
        }
    }

    private void closeCachedFiles() {
        if (this.input instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.input)).closeCachedFiles();
        }
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).closeCachedFiles();
        }
    }

    @Override
    protected int deltaSynchronize() {
        this.somethingChanged = false;
        this.toBeDeleted.clear();
        this.invalidateCachedData();
        this.closeCachedFiles();
        ScePspDateTime newLastSync = this.nowDate();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("deltaSynchronize %s start", this.name));
        }
        int result = this.deltaSynchronize("");
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("deltaSynchronize %s end, somethingChanged=%b", this.name, this.somethingChanged));
        }
        if (this.somethingChanged) {
            this.flushCachedData();
            for (DirectoryEntryData entry : this.toBeDeleted) {
                int deleteResult = this.deleteEntry(entry.dirName, entry.dirent);
                if (deleteResult == 0 || result != 0) continue;
                result = deleteResult;
            }
            this.toBeDeleted.clear();
            this.somethingChanged = false;
        }
        this.lastSyncDate = newLastSync;
        return result;
    }

    private boolean isModifiedSinceLastSync(SceIoDirent dirent) {
        if (dirent.stat.mtime.after(this.lastSyncDate)) {
            return true;
        }
        return dirent.stat.mtime.toMSDOSTime() == 0;
    }

    private boolean isDirectory(SceIoDirent entry) {
        return (entry.stat.attr & 0x10) != 0;
    }

    private boolean sameEntryNameAndAttributes(SceIoDirent dirent1, SceIoDirent dirent2) {
        if (dirent1 == null) {
            return dirent2 == null;
        }
        if (dirent2 == null) {
            return dirent1 == null;
        }
        if (!dirent1.filename.equalsIgnoreCase(dirent2.filename)) {
            return false;
        }
        if (dirent1.stat.attr != dirent2.stat.attr) {
            return false;
        }
        return dirent1.stat.mode == dirent2.stat.mode;
    }

    private SceIoDirent[] getDirectoryEntries(IVirtualFileSystem vfs, String dirName) {
        String[] fileNames = vfs.ioDopen(dirName);
        SceIoDirent[] entries = new SceIoDirent[]{};
        if (fileNames != null) {
            for (String fileName : fileNames) {
                if (".".equals(fileName) || "..".equals(fileName)) continue;
                SceIoDirent entry = new SceIoDirent(new SceIoStat(), fileName);
                int result = vfs.ioDread(dirName, entry);
                if (result != 1) {
                    return null;
                }
                entries = Utilities.add(entries, entry);
            }
        }
        return entries;
    }

    private boolean isToBeUpdated(SceIoDirent inputEntry, SceIoDirent outputEntry) {
        return !this.isDirectory(inputEntry) && (this.isModifiedSinceLastSync(inputEntry) || inputEntry.stat.size != outputEntry.stat.size);
    }

    /*
     * WARNING - void declaration
     */
    private int deltaSynchronize(String dirName) {
        int i;
        int result;
        SceIoDirent[] inputEntries;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("deltaSynchronize '%s'", dirName));
        }
        if ((inputEntries = this.getDirectoryEntries(this.input, dirName)) == null) {
            return -1;
        }
        SceIoDirent[] outputEntries = this.getDirectoryEntries(this.output, dirName);
        if (outputEntries == null) {
            return -1;
        }
        if (log.isTraceEnabled()) {
            for (int i2 = 0; i2 < inputEntries.length; ++i2) {
                log.trace((Object)String.format("deltaSynchronize '%s', inputEntry#%d=%s", dirName, i2, inputEntries[i2]));
            }
            for (int i2 = 0; i2 < outputEntries.length; ++i2) {
                log.trace((Object)String.format("deltaSynchronize '%s', outputEntry#%d=%s", dirName, i2, outputEntries[i2]));
            }
        }
        HashSet<SceIoDirent> toBeUpdated = new HashSet<SceIoDirent>();
        HashSet<SceIoDirent> toBeCreated = new HashSet<SceIoDirent>();
        for (int i3 = 0; i3 < inputEntries.length; ++i3) {
            SceIoDirent sceIoDirent = inputEntries[i3];
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("deltaSynchronize '%s', entry=%s", dirName, sceIoDirent));
            }
            boolean found = false;
            for (int j = 0; j < outputEntries.length; ++j) {
                if (!this.sameEntryNameAndAttributes(sceIoDirent, outputEntries[j])) continue;
                if (this.isToBeUpdated(sceIoDirent, outputEntries[j])) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("deltaSynchronize: entry to be updated entry=%s, lastSyncDate=%s", sceIoDirent, this.lastSyncDate));
                    }
                    toBeUpdated.add(sceIoDirent);
                }
                outputEntries[j] = null;
                found = true;
                break;
            }
            if (found) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("deltaSynchronize: entry to be created entry=%s", sceIoDirent));
            }
            toBeCreated.add(sceIoDirent);
        }
        for (SceIoDirent sceIoDirent : toBeCreated) {
            result = this.createEntry(dirName, sceIoDirent);
            if (result == 0) continue;
            return result;
        }
        for (SceIoDirent sceIoDirent : toBeUpdated) {
            result = this.updateEntry(dirName, sceIoDirent);
            if (result == 0) continue;
            return result;
        }
        for (i = 0; i < outputEntries.length; ++i) {
            if (outputEntries[i] == null) continue;
            DirectoryEntryData directoryEntryData = new DirectoryEntryData(dirName, outputEntries[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("deltaSynchronize: entry to be deleted entry=%s", directoryEntryData));
            }
            this.toBeDeleted.add(directoryEntryData);
            this.somethingChanged = true;
        }
        for (i = 0; i < inputEntries.length; ++i) {
            void var7_20;
            if (!this.isDirectory(inputEntries[i])) continue;
            String string = inputEntries[i].filename;
            if (dirName.length() > 0) {
                String string2 = dirName + '/' + string;
            }
            if ((result = this.deltaSynchronize((String)var7_20)) == 0) continue;
            return result;
        }
        return 0;
    }

    private String getFileName(String dirName, SceIoDirent entry) {
        if (dirName.length() == 0) {
            return entry.filename;
        }
        return String.format("%s/%s", dirName, entry.filename);
    }

    private int updateEntry(String dirName, SceIoDirent entry) {
        IVirtualFile inputFile;
        String fileName = this.getFileName(dirName, entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateEntry %s", fileName));
        }
        if ((inputFile = this.input.ioOpen(fileName, 1, 0)) == null) {
            log.error((Object)String.format("updateEntry cannot read file '%s'", fileName));
            return -1;
        }
        IVirtualFile outputFile = this.output.ioOpen(fileName, 2, 0);
        if (outputFile == null) {
            inputFile.ioClose();
            log.error((Object)String.format("updateEntry cannot write file '%s'", fileName));
            return -1;
        }
        long inputLength = inputFile.length();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("updateEntry %s, length=0x%X", fileName, inputLength));
        }
        byte[] buffer = new byte[32768];
        while (inputLength > 0L) {
            int length = Math.min(buffer.length, (int)inputLength);
            int readLength = inputFile.ioRead(buffer, 0, length);
            if (readLength != length) {
                log.error((Object)String.format("updateEntry error reading file '%s': 0x%X", fileName, readLength));
                return -1;
            }
            int writeLength = outputFile.ioWrite(buffer, 0, readLength);
            if (writeLength != readLength) {
                log.error((Object)String.format("updateEntry error writing file '%s': 0x%X", fileName, writeLength));
                return -1;
            }
            this.somethingChanged = true;
            inputLength -= (long)readLength;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("updateEntry %s, completed successfully", fileName, inputLength));
        }
        inputFile.ioClose();
        outputFile.ioClose();
        return 0;
    }

    private int createEntry(String dirName, SceIoDirent entry) {
        int result;
        if (this.isDirectory(entry)) {
            String fileName = this.getFileName(dirName, entry);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("createEntry %s", fileName));
            }
            if ((result = this.output.ioMkdir(fileName, 511)) != 0) {
                log.error((Object)String.format("createEntry could not create directory '%s'", fileName));
            } else {
                this.somethingChanged = true;
            }
        } else {
            result = this.updateEntry(dirName, entry);
        }
        return result;
    }

    private int deleteEntry(String dirName, SceIoDirent entry) {
        int result;
        String fileName = this.getFileName(dirName, entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("deleteEntry %s", fileName));
        }
        if (this.isDirectory(entry)) {
            result = this.deleteDirectoryEntryRecursive(fileName);
        } else {
            result = this.output.ioRemove(fileName);
            if (result != 0) {
                log.error((Object)String.format("deleteEntry could not delete '%s'", fileName));
            } else {
                this.somethingChanged = true;
            }
        }
        return result;
    }

    private int deleteDirectoryEntryRecursive(String dirName) {
        SceIoDirent[] entries = this.getDirectoryEntries(this.output, dirName);
        if (entries == null) {
            log.error((Object)String.format("deleteDirectoryEntryRecursive could not delete '%s'", dirName));
            return -1;
        }
        int result = 0;
        for (SceIoDirent entry : entries) {
            String fileName = this.getFileName(dirName, entry);
            if (this.isDirectory(entry)) {
                result = this.deleteDirectoryEntryRecursive(fileName);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("deleteDirectoryEntryRecursive: delete file %s", fileName));
                }
                if ((result = this.output.ioRemove(fileName)) != 0) {
                    log.error((Object)String.format("deleteDirectoryEntryRecursive could not delete '%s'", dirName));
                } else {
                    this.somethingChanged = true;
                }
            }
            if (result == 0) continue;
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("deleteDirectoryEntryRecursive: delete directory %s", dirName));
        }
        if ((result = this.output.ioRmdir(dirName)) != 0) {
            log.error((Object)String.format("deleteDirectoryEntryRecursive could not delete '%s'", dirName));
        } else {
            this.somethingChanged = true;
        }
        return result;
    }

    private static class DirectoryEntryData {
        final String dirName;
        final SceIoDirent dirent;

        public DirectoryEntryData(String dirName, SceIoDirent dirent) {
            this.dirName = dirName;
            this.dirent = dirent;
        }

        public String toString() {
            return String.format("%s, %s", this.dirName, this.dirent);
        }
    }
}

