/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.SceUid;
import org.apache.log4j.Logger;

public class SceUidManager {
    public static Logger log = Emulator.log;
    private static HashMap<Integer, SceUid> uidMap = new HashMap();
    private static int uidNext = 1;
    public static final int INVALID_ID = Integer.MIN_VALUE;
    private static HashMap<String, LinkedList<Integer>> freeIdsMap = new HashMap();

    public static void reset() {
        uidMap.clear();
        freeIdsMap.clear();
        uidNext = 1;
    }

    public static int getNewUid(String purpose) {
        SceUid uid = new SceUid(purpose, uidNext++);
        uidMap.put(uid.getUid(), uid);
        return uid.getUid();
    }

    public static boolean hasUidPurpose(int uid, String purpose) {
        SceUid found = uidMap.get(uid);
        if (found == null) {
            return false;
        }
        return purpose.equals(found.getPurpose());
    }

    public static boolean checkUidPurpose(int uid, String purpose, boolean allowUnknown) {
        SceUid found = uidMap.get(uid);
        if (found == null) {
            if (!allowUnknown) {
                if (!Emulator.exitCalled()) {
                    log.warn((Object)String.format("Attempt to use unknown SceUID=0x%X (purpose='%s')", uid, purpose));
                }
                return false;
            }
        } else if (!purpose.equals(found.getPurpose())) {
            if (!Emulator.exitCalled()) {
                log.error((Object)String.format("Attempt to use SceUID=0x%X for different purpose (purpose='%s', original='%s')", uid, purpose, found.getPurpose()));
            }
            return false;
        }
        return true;
    }

    public static boolean releaseUid(int uid, String purpose) {
        SceUid found = uidMap.get(uid);
        if (found == null) {
            if (!Emulator.exitCalled()) {
                log.warn((Object)("Attempt to release unknown SceUID (purpose='" + purpose.toString() + "')"));
            }
            return false;
        }
        if (!purpose.equals(found.getPurpose())) {
            if (!Emulator.exitCalled()) {
                log.error((Object)("Attempt to release SceUID for different purpose (purpose='" + purpose.toString() + "',original='" + found.getPurpose().toString() + "')"));
            }
            return false;
        }
        uidMap.remove(uid);
        return true;
    }

    public static boolean isValidUid(int uid) {
        return uidMap.containsKey(uid);
    }

    public static int getNewId(String purpose, int minimumId, int maximumId) {
        LinkedList<Integer> freeIds = freeIdsMap.get(purpose);
        if (freeIds == null) {
            freeIds = new LinkedList();
            for (int id = minimumId; id <= maximumId; ++id) {
                freeIds.add(id);
            }
            freeIdsMap.put(purpose, freeIds);
        }
        if (freeIds.size() <= 0) {
            return Integer.MIN_VALUE;
        }
        return freeIds.remove();
    }

    public static void resetIds(String purpose) {
        freeIdsMap.remove(purpose);
    }

    public static boolean releaseId(int id, String purpose) {
        LinkedList<Integer> freeIds = freeIdsMap.get(purpose);
        if (freeIds == null) {
            if (!Emulator.exitCalled()) {
                log.warn((Object)String.format("Attempt to release ID=%d with unknown purpose='%s'", id, purpose));
            }
            return false;
        }
        ListIterator<Integer> lit = freeIds.listIterator();
        while (lit.hasNext()) {
            int currentId = (Integer)lit.next();
            if (currentId == id) {
                if (!Emulator.exitCalled()) {
                    log.warn((Object)String.format("Attempt to release free ID=%d with purpose='%s'", id, purpose));
                }
                return false;
            }
            if (currentId <= id) continue;
            lit.set(id);
            lit.add(currentId);
            return true;
        }
        freeIds.add(id);
        return true;
    }
}

