/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.util.Utilities;

public class pspSysEventHandler
extends pspAbstractMemoryMappedStructure {
    public static final int SIZEOF = 64;
    public int size;
    public int nameAddr;
    public String name;
    public int typeMask;
    public TPointerFunction handler;
    public int gp;
    public boolean busy;
    public TPointer next;
    public int[] reserved = new int[9];

    @Override
    public int sizeof() {
        return 64;
    }

    @Override
    protected void read() {
        this.size = this.read32();
        this.nameAddr = this.read32();
        this.typeMask = this.read32();
        this.handler = this.readPointerFunction();
        this.gp = this.read32();
        this.busy = this.readBoolean();
        this.next = this.readPointer();
        for (int i = 0; i < this.reserved.length; ++i) {
            this.reserved[i] = this.read32();
        }
        if (this.nameAddr != 0) {
            this.name = this.readStringZ(this.nameAddr);
        }
    }

    @Override
    protected void write() {
        this.write32(this.size);
        this.write32(this.nameAddr);
        this.write32(this.typeMask);
        this.writePointerFunction(this.handler);
        this.write32(this.gp);
        this.writeBoolean(this.busy);
        this.writePointer(this.next);
        for (int i = 0; i < this.reserved.length; ++i) {
            this.write32(this.reserved[i]);
        }
    }

    public static TPointer getNext(TPointer sysEventHandler) {
        return sysEventHandler.getPointer(24);
    }

    public static void setNext(TPointer sysEventHandler, TPointer next) {
        sysEventHandler.setPointer(24, next);
    }

    public static boolean isMatchingTypeMask(TPointer sysEventHandler, int typeMask) {
        return Utilities.hasFlag(typeMask, sysEventHandler.getValue32(8));
    }

    public static boolean isBusy(TPointer sysEventHandler) {
        return sysEventHandler.getUnsignedValue8(20) != 0;
    }

    public static void setBusy(TPointer sysEventHandler, boolean busy) {
        sysEventHandler.setUnsignedValue8(20, busy ? 1 : 0);
    }

    @Override
    public String toString() {
        return String.format("size=0x%X, name=0x%08X('%s'), typeMask=0x%X, handler=%s, gp=0x%08X, busy=%b, next=%s", this.size, this.nameAddr, this.name, this.typeMask, this.handler, this.gp, this.busy, this.next);
    }
}

