/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.Map;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.dmac.DmacThread;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class DmacManForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("DmacManForKernel");
    private SysMemUserForUser.SysMemInfo sysMemInfo;
    private DmaOp firstOp;
    private Map<Integer, DmaOp> dmaOps = new HashMap<Integer, DmaOp>();

    @Override
    public void start() {
        int countOps = 32;
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(1, "DmacManForKernel", 0, 2048, 0);
        if (this.sysMemInfo != null) {
            TPointer currentOpAddr = new TPointer(this.getMemory(), this.sysMemInfo.addr & 0x1FFFFFFF);
            DmaOp previousOp = null;
            for (int i = 0; i < 32; ++i) {
                DmaOp dmaOp = new DmaOp(currentOpAddr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Creating %s", currentOpAddr));
                }
                this.dmaOps.put(currentOpAddr.getAddress(), dmaOp);
                if (previousOp != null) {
                    previousOp.setNext(dmaOp);
                } else {
                    this.firstOp = dmaOp;
                }
                previousOp = dmaOp;
                currentOpAddr.add(64);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("firstOp %s", this.firstOp));
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.sysMemInfo != null) {
            Modules.SysMemUserForUserModule.free(this.sysMemInfo);
            this.sysMemInfo = null;
            this.firstOp = null;
        }
        super.stop();
    }

    private DmaOp getDmaOp(TPointer dmaOpAddr) {
        return this.dmaOps.get(dmaOpAddr.getAddress());
    }

    @HLEFunction(nid=1499550105, version=150)
    public int sceKernelDmaOpAlloc() {
        if (this.firstOp == null) {
            return 0;
        }
        DmaOp dmaOp = this.firstOp;
        this.firstOp = dmaOp.getNext();
        return dmaOp.getAddr().getAddress();
    }

    @HLEFunction(nid=1952324079, version=150)
    public int sceKernelDmaOpFree(@CanBeNull TPointer dmaOpAddr) {
        DmaOp dmaOp = this.getDmaOp(dmaOpAddr);
        if (dmaOp == null) {
            return -2147351857;
        }
        dmaOp.setNext(this.firstOp);
        this.firstOp = dmaOp;
        return 0;
    }

    @HLEFunction(nid=-162813031, version=150)
    public int sceKernelDmaOpAssign(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr, int unknown1, int unknown2, int unknown3) {
        DmaOp dmaOp = this.getDmaOp(dmaOpAddr);
        if (dmaOp == null) {
            return -2147351857;
        }
        dmaOp.setUnknown48(unknown3);
        int unknown52 = unknown1 & 0xFF | (unknown2 & 0xFF) << 8;
        dmaOp.setUnknown52(unknown52);
        return 0;
    }

    @HLEFunction(nid=1004448108, version=150)
    public int sceKernelDmaOpEnQueue(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr) {
        DmaOp dmaOp = this.getDmaOp(dmaOpAddr);
        if (dmaOp == null) {
            return -2147351857;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1525884803, version=150)
    public int sceKernelDmaOpQuit(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1838150451, version=150)
    public int sceKernelDmaOpDeQueue(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr) {
        return 0;
    }

    @HLEFunction(nid=-834241125, version=150)
    public int sceKernelDmaOpSetupNormal(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr, int status, TPointer dstAddress, TPointer srcAddress, int attributes) {
        DmaOp dmaOp = this.getDmaOp(dmaOpAddr);
        if (dmaOp == null) {
            return -2147351857;
        }
        dmaOp.setStatus(status);
        dmaOp.setDstAddress(dstAddress);
        dmaOp.setSrcAddress(srcAddress);
        dmaOp.setAttributes(attributes);
        return 0;
    }

    @HLEFunction(nid=-801797143, version=150)
    public int sceKernelDmaOpSetCallback(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr, TPointer callbackAddr, int callbackArgument) {
        DmaOp dmaOp = this.getDmaOp(dmaOpAddr);
        if (dmaOp == null) {
            return -2147351857;
        }
        dmaOp.setCallback(callbackAddr, callbackArgument);
        return 0;
    }

    @HLEFunction(nid=-618107547, version=150)
    public int sceKernelDmaOpSync(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr, int waitType, int timeout) {
        DmaOp dmaOp = this.getDmaOp(dmaOpAddr);
        if (dmaOp == null) {
            return -2147351857;
        }
        dmaOp.execute();
        dmaOp.callCallback();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2099356399, version=150)
    public int sceKernelDmaOpSetupLink(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr, int status, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.in) TPointer32 linkStructure) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1068324932, version=150)
    public int sceKernelDmaOpSetupMemcpy(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=54, usage=BufferInfo.Usage.inout) TPointer dmaOpAddr, TPointer dstAddress, TPointer srcAddress, int length) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=846560343, version=150)
    public int DmacManForKernel_32757C57(@CanBeNull TPointer setupLinkCallback) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=474355082, version=150)
    public int sceKernelDmaExit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=532690615, version=150)
    public int DmacManForKernel_1FC036B7() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=775668531, version=150)
    public int sceKernelDmaChReserve() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2073441505, version=150)
    public int sceKernelDmaSoftRequest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1874784004, version=150)
    public int sceKernelDmaOpAssignMultiple() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1471477685, version=150)
    public int sceKernelDmaOpAllCancel() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-738844059, version=150)
    public int sceKernelDmaOnDebugMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-658755296, version=150)
    public int sceKernelDmaChExclude() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-511011931, version=150)
    public int DmacManForKernel_E18A93A5() {
        return 0;
    }

    protected static class DmaOp {
        public static final int SIZEOF = 64;
        private final TPointer addr;
        private DmaOp next;
        private TPointer callbackAddr;
        private int callbackArgument;
        private int status;
        private TPointer dstAddress;
        private TPointer srcAddress;
        private int attributes;
        private int unknown48;
        private int unknown52;

        public DmaOp(TPointer addr) {
            this.addr = new TPointer(addr);
        }

        public TPointer getAddr() {
            return this.addr;
        }

        public DmaOp getNext() {
            return this.next;
        }

        public void setNext(DmaOp next) {
            this.next = next;
        }

        public int getUnknown48() {
            return this.unknown48;
        }

        public void setUnknown48(int unknown48) {
            this.unknown48 = unknown48;
        }

        public int getUnknown52() {
            return this.unknown52;
        }

        public void setUnknown52(int unknown52) {
            this.unknown52 = unknown52;
        }

        public void setCallback(TPointer callbackAddr, int callbackArgument) {
            this.callbackAddr = callbackAddr;
            this.callbackArgument = callbackArgument;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public TPointer getDstAddress() {
            return this.dstAddress;
        }

        public void setDstAddress(TPointer dstAddress) {
            this.dstAddress = dstAddress;
        }

        public TPointer getSrcAddress() {
            return this.srcAddress;
        }

        public void setSrcAddress(TPointer srcAddress) {
            this.srcAddress = srcAddress;
        }

        public int getAttributes() {
            return this.attributes;
        }

        public void setAttributes(int attributes) {
            this.attributes = attributes;
        }

        public void callCallback() {
            if (this.callbackAddr != null && this.callbackAddr.isNotNull()) {
                Modules.ThreadManForUserModule.executeCallback(null, this.callbackAddr.getAddress(), null, false, this.addr.getAddress(), 0, 0, this.callbackArgument);
            }
        }

        public boolean execute() {
            int dstLength;
            int srcLength;
            int nextAddr = 0;
            int srcStep = this.attributes >> 12 & 7;
            int dstStep = this.attributes >> 15 & 7;
            int srcLengthShift = this.attributes >> 18 & 7;
            int dstLengthShift = this.attributes >> 21 & 7;
            boolean srcIncrement = Utilities.hasFlag(this.attributes, 0x4000000);
            boolean dstIncrement = Utilities.hasFlag(this.attributes, 0x8000000);
            int length = this.attributes & 0xFFF;
            int srcStepLength = DmacThread.dmacMemcpyStepLength[srcStep];
            if (srcStepLength == 0) {
                log.error((Object)String.format("dmacMemcpy with unknown srcStep=%d", srcStep));
                return false;
            }
            int dstStepLength = DmacThread.dmacMemcpyStepLength[dstStep];
            if (dstStepLength == 0) {
                log.error((Object)String.format("dmacMemcpy with unknown dstStep=%d", dstStep));
                return false;
            }
            if (Utilities.hasFlag(this.attributes, 0x2000000)) {
                srcIncrement = true;
                dstIncrement = true;
                srcStepLength = 1;
                dstStepLength = 1;
                srcLengthShift = 0;
                dstLengthShift = 0;
            }
            if (Utilities.hasFlag(this.attributes, 0x1000000)) {
                srcIncrement = true;
                dstIncrement = true;
            }
            if ((srcLength = length << srcLengthShift) != (dstLength = length << dstLengthShift)) {
                log.error((Object)String.format("dmacMemcpy with different lengths: srcLength=0x%X, dstLength=0x%X", srcLength, dstLength));
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("dmacMemcpy dstAddress=%s, srcAddress=%s, attr=0x%08X, dstLength=0x%X(shift=%d), srcLength=0x%X(shift=%d), dstStepLength=0x%X(step=%d), srcStepLength=0x%X(step=%d), dstIncrement=%b, srcIncrement=%b, next=0x%08X, status=0x%X", this.dstAddress, this.srcAddress, this.attributes, dstLength, dstLengthShift, srcLength, srcLengthShift, dstStepLength, dstStep, srcStepLength, srcStep, dstIncrement, srcIncrement, nextAddr, this.status));
            }
            int normalizedSrc = MMIO.normalizeAddress(this.srcAddress.getAddress());
            int normalizedDst = MMIO.normalizeAddress(this.dstAddress.getAddress());
            Memory memSrc = this.srcAddress.getMemory();
            Memory memDst = this.dstAddress.getMemory();
            if (srcIncrement && dstIncrement && memSrc == memDst) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("dmacMemcpy dst=0x%08X, src=0x%08X, length=0x%X", normalizedDst, normalizedSrc, srcLength));
                }
                memSrc.memcpy(normalizedDst, normalizedSrc, srcLength);
            } else {
                int srcStep4 = srcIncrement ? 4 : 0;
                int srcStep8 = srcIncrement ? 8 : 0;
                int srcStep12 = srcIncrement ? 12 : 0;
                int dstStep4 = dstIncrement ? 4 : 0;
                int dstStep8 = dstIncrement ? 8 : 0;
                int dstStep12 = dstIncrement ? 12 : 0;
                int stepLength = Math.min(srcStepLength, dstStepLength);
                int dst = normalizedDst;
                int src = normalizedSrc;
                while (dstLength > 0 && srcLength > 0) {
                    switch (stepLength) {
                        case 1: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 1));
                            }
                            memDst.write8(dst, (byte)memSrc.read8(src));
                            break;
                        }
                        case 2: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 2));
                            }
                            memDst.write16(dst, (short)memSrc.read16(src));
                            break;
                        }
                        case 4: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 4));
                            }
                            memDst.write32(dst, memSrc.read32(src));
                            break;
                        }
                        case 8: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 8));
                            }
                            memDst.write32(dst, memSrc.read32(src));
                            memDst.write32(dst + dstStep4, memSrc.read32(src + srcStep4));
                            break;
                        }
                        case 16: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 16));
                            }
                            memDst.write32(dst, memSrc.read32(src));
                            memDst.write32(dst + dstStep4, memSrc.read32(src + srcStep4));
                            memDst.write32(dst + dstStep8, memSrc.read32(src + srcStep8));
                            memDst.write32(dst + dstStep12, memSrc.read32(src + srcStep12));
                        }
                    }
                    dstLength -= stepLength;
                    srcLength -= stepLength;
                    if (dstIncrement) {
                        dst += stepLength;
                    }
                    if (!srcIncrement) continue;
                    src += stepLength;
                }
            }
            return true;
        }

        public String toString() {
            return String.format("DmaOp addr=%s", this.addr);
        }
    }
}

