/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.xmb.XmbIsoVirtualFile;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class LoadExecForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("LoadExecForUser");
    protected int registeredExitCallbackUid;
    protected static final String encryptedBootPath = "disc0:/PSP_GAME/SYSDIR/EBOOT.BIN";
    protected static final String unencryptedBootPath = "disc0:/PSP_GAME/SYSDIR/BOOT.BIN";

    public void triggerExitCallback() {
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(5, 0);
    }

    public int hleKernelLoadExec(ByteBuffer moduleBuffer, int argSize, int argAddr, String moduleFileName, UmdIsoReader iso) {
        byte[] arguments = null;
        if (argSize > 0) {
            arguments = new byte[argSize];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(argAddr, argSize, 1);
            for (int i = 0; i < argSize; ++i) {
                arguments[i] = (byte)memoryReader.readNext();
            }
        }
        Modules.SysMemUserForUserModule.reset();
        try {
            if (moduleBuffer != null) {
                int pathIndex;
                SceModule module = Emulator.getInstance().load(moduleFileName, moduleBuffer, true, Modules.ModuleMgrForUserModule.isSignChecked(moduleFileName), null);
                Emulator.getClock().resume();
                if (moduleFileName != null && (pathIndex = moduleFileName.lastIndexOf("/")) >= 0) {
                    Modules.IoFileMgrForUserModule.setHost0Path(moduleFileName.substring(0, pathIndex + 1));
                }
                if ((module.fileFormat & 1) != 1) {
                    log.warn((Object)"sceKernelLoadExec - failed, target is not an ELF");
                    throw new SceKernelErrorException(-2147352244);
                }
                SceKernelThreadInfo rootThread = Modules.ThreadManForUserModule.getRootThread(module);
                Modules.ThreadManForUserModule.hleKernelSetThreadArguments(rootThread, arguments, argSize);
                RuntimeContext.updateMemory();
                if (iso != null) {
                    Modules.IoFileMgrForUserModule.setIsoReader(iso);
                    Modules.sceUmdUserModule.setIsoReader(iso);
                }
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)"General Error", (Throwable)e);
            Emulator.PauseEmu();
        }
        catch (IOException e) {
            log.error((Object)String.format("sceKernelLoadExec - Error while loading module '%s'", moduleFileName), (Throwable)e);
            return -2147352249;
        }
        return 0;
    }

    public int hleKernelLoadExec(PspString filename, int argSize, int argAddr) {
        String name = filename.getString();
        if (name.equals(unencryptedBootPath)) {
            log.info((Object)String.format("sceKernelLoadExec '%s' replaced by '%s'", name, encryptedBootPath));
            name = encryptedBootPath;
        }
        ByteBuffer moduleBuffer = null;
        IVirtualFile vFile = Modules.IoFileMgrForUserModule.getVirtualFile(name, 1, 0);
        UmdIsoReader iso = null;
        if (vFile instanceof XmbIsoVirtualFile) {
            try {
                IVirtualFile vFileLoadExec = ((XmbIsoVirtualFile)vFile).ioReadForLoadExec();
                if (vFileLoadExec != null) {
                    iso = ((XmbIsoVirtualFile)vFile).getIsoReader();
                    vFile.ioClose();
                    vFile = vFileLoadExec;
                }
            }
            catch (IOException e) {
                log.debug((Object)"hleKernelLoadExec", (Throwable)e);
            }
        }
        if (vFile != null) {
            byte[] moduleBytes = Utilities.readCompleteFile(vFile);
            vFile.ioClose();
            if (moduleBytes != null) {
                moduleBuffer = ByteBuffer.wrap(moduleBytes);
            }
        } else {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, 1);
            if (moduleInput != null) {
                try {
                    byte[] moduleBytes = new byte[(int)moduleInput.length()];
                    moduleInput.readFully(moduleBytes);
                    moduleInput.close();
                    moduleBuffer = ByteBuffer.wrap(moduleBytes);
                }
                catch (IOException e) {
                    log.error((Object)String.format("sceKernelLoadExec - Error while loading module '%s'", name), (Throwable)e);
                    return -2147352249;
                }
            }
        }
        return this.hleKernelLoadExec(moduleBuffer, argSize, argAddr, name, iso);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1120989036, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadExec(PspString filename, @CanBeNull TPointer32 optionAddr) {
        int optSize;
        int argSize = 0;
        int argAddr = 0;
        if (optionAddr.isNotNull() && (optSize = optionAddr.getValue(0)) >= 16) {
            argSize = optionAddr.getValue(4);
            argAddr = optionAddr.getValue(8);
            int keyAddr = optionAddr.getValue(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExec params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=0x%08X: %s", optSize, argSize, argAddr, keyAddr, Utilities.getMemoryDump(argAddr, argSize)));
            }
        }
        return this.hleKernelLoadExec(filename, argSize, argAddr);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=717854027, version=150, checkInsideInterrupt=true)
    public int sceKernelExitGameWithStatus(int status) {
        Emulator.PauseEmuWithStatus(status);
        RuntimeContext.reset();
        Modules.ThreadManForUserModule.stop();
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=89598559, version=150, checkInsideInterrupt=true)
    public int sceKernelExitGame() {
        if (Emulator.getInstance().isPspOfficialUpdater()) {
            return Modules.scePowerModule.scePowerRequestColdReset(0);
        }
        Emulator.PauseEmu();
        RuntimeContext.reset();
        Modules.ThreadManForUserModule.stop();
        return 0;
    }

    @HLEFunction(nid=1254455619, version=150, checkInsideInterrupt=true)
    public int sceKernelRegisterExitCallback(int uid) {
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(5, uid)) {
            this.registeredExitCallbackUid = uid;
        }
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=908760427, version=500)
    public int LoadExecForUser_362A956B() {
        SceKernelCallbackInfo callbackInfo;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("LoadExecForUser_362A956B registeredExitCallbackUid=0x%X", this.registeredExitCallbackUid));
        }
        if ((callbackInfo = Modules.ThreadManForUserModule.getCallbackInfo(this.registeredExitCallbackUid)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LoadExecForUser_362A956B registeredExitCallbackUid=0x%x callback not found", this.registeredExitCallbackUid));
            }
            return -2147352159;
        }
        int callbackArgument = callbackInfo.getCallbackArgument();
        if (!Memory.isAddressGood(callbackArgument)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LoadExecForUser_362A956B invalid address for callbackArgument=0x%08X", callbackArgument));
            }
            return -2147352365;
        }
        Memory mem = Processor.memory;
        int unknown1 = mem.read32(callbackArgument - 8);
        if (unknown1 < 0 || unknown1 >= 4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LoadExecForUser_362A956B invalid value unknown1=0x%08X", unknown1));
            }
            return -2147352366;
        }
        int parameterArea = mem.read32(callbackArgument - 4);
        if (!Memory.isAddressGood(parameterArea)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LoadExecForUser_362A956B invalid address for parameterArea=0x%08X", parameterArea));
            }
            return -2147352365;
        }
        int size = mem.read32(parameterArea);
        if (size < 12) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LoadExecForUser_362A956B invalid parameter area size %d", size));
            }
            return -2147352132;
        }
        mem.write32(parameterArea + 4, 0);
        mem.write32(parameterArea + 8, -1);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1436563365, version=150, checkInsideInterrupt=true), @HLEFunction(nid=-1965410093, version=150, checkInsideInterrupt=true)})
    public int sceKernelLoadExecNpDrm(PspString fileName, @CanBeNull TPointer optionAddr) {
        int result;
        Modules.SysMemUserForUserModule.reset();
        byte[] key = null;
        if (optionAddr.isNotNull()) {
            int optSize = optionAddr.getValue32(0);
            int argSize = optionAddr.getValue32(4);
            int argAddr = optionAddr.getValue32(8);
            TPointer keyAddr = optionAddr.getPointer(12);
            if (keyAddr.isNotNull()) {
                key = keyAddr.getArray8(16);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExecNpDrm (params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=%s)", optSize, argSize, argAddr, keyAddr));
            }
        }
        if (Modules.scePspNpDrm_userModule.isDLCDecryptionEnabled()) {
            log.warn((Object)String.format("sceKernelLoadExecNpDrm detected encrypted DLC module: %s", fileName.getString()));
            return -2141910766;
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(fileName.getString(), 1);
            if (moduleInput != null) {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                SceModule module = Emulator.getInstance().load(fileName.getString(), moduleBuffer, true, Modules.ModuleMgrForUserModule.isSignChecked(fileName.getString()), key);
                Emulator.getClock().resume();
                if ((module.fileFormat & 1) == 1) {
                    result = 0;
                } else {
                    log.warn((Object)"sceKernelLoadExecNpDrm - failed, target is not an ELF");
                    result = -2147352244;
                }
            } else {
                result = -2147352249;
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)"sceKernelLoadExecNpDrm", (Throwable)e);
            result = -2147352249;
        }
        catch (IOException e) {
            log.error((Object)String.format("sceKernelLoadExecNpDrm - Error while loading module '%s'", fileName), (Throwable)e);
            result = -2147352249;
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-772058916, version=500)
    public int LoadExecForUser_D1FB50DC() {
        return 0;
    }
}

