/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceLed
extends HLEModule {
    public static Logger log = Modules.getLogger("sceLed");
    public static final int PSP_LED_TYPE_MS = 0;
    public static final int PSP_LED_TYPE_WLAN = 1;
    public static final int PSP_LED_TYPE_BT = 2;
    public static final int SCE_LED_MODE_OFF = 0;
    public static final int SCE_LED_MODE_ON = 1;
    public static final int SCE_LED_MODE_BLINK = 2;
    public static final int SCE_LED_MODE_SELECTIVE_EXEC = 3;

    public static String getLedName(int led) {
        switch (led) {
            case 0: {
                return "MemoryStick";
            }
            case 1: {
                return "WLAN";
            }
            case 2: {
                return "BlueTooth";
            }
        }
        return String.format("Unknown LED_TYPE_%X", led);
    }

    public static String getLedModeName(int ledMode) {
        switch (ledMode) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Blink";
            }
            case 3: {
                return "Selective Exec";
            }
        }
        return String.format("Unknown LED_MODE_%X", ledMode);
    }

    @HLEFunction(nid=-366690813, version=150)
    public int sceLedSetMode(int led, int mode, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=20, usage=BufferInfo.Usage.in) TPointer config) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceLedSetMode %s %s", sceLed.getLedName(led), sceLed.getLedModeName(mode)));
        }
        if (config.isNotNull()) {
            log.info((Object)String.format("sceLedSetMode %s %s unknown config: %s", sceLed.getLedName(led), sceLed.getLedModeName(mode), Utilities.getMemoryDump(config, 20)));
        }
        return 0;
    }
}

