/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.WriteCacheVirtualFile;
import jpcsp.HLE.VFS.fat.Fat32VirtualFile;
import jpcsp.HLE.VFS.fat.FatVirtualFileSystem;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFileSystem;
import jpcsp.HLE.VFS.synchronize.SynchronizeVirtualFileSystems;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspIoDrv;
import jpcsp.HLE.kernel.types.pspIoDrvArg;
import jpcsp.HLE.kernel.types.pspIoDrvFileArg;
import jpcsp.HLE.kernel.types.pspIoDrvFuncs;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.ByteArrayMemory;
import jpcsp.settings.Settings;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMSstor
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMSstor");
    private static final int STATE_VERSION = 0;
    private byte[] dumpIoIoctl_0x02125803;
    private long position;
    private IVirtualFile vFile;
    private IVirtualFile vFileIpl;
    private Fat32ScanThread scanThread;
    private final Object writeLock = new Object();
    private SynchronizeVirtualFileSystems sync;
    private int FIRST_PAGE_LBA;
    private int NUMBER_OF_PAGES;

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.dumpIoIoctl_0x02125803 = stream.readBytesWithLength();
        this.position = stream.readLong();
        this.FIRST_PAGE_LBA = stream.readInt();
        this.NUMBER_OF_PAGES = stream.readInt();
        boolean vFilePresent = stream.readBoolean();
        if (vFilePresent) {
            this.openFile();
            ((IState)((Object)this.vFile)).read(stream);
            this.sync.read(stream);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeBytesWithLength(this.dumpIoIoctl_0x02125803);
        stream.writeLong(this.position);
        stream.writeInt(this.FIRST_PAGE_LBA);
        stream.writeInt(this.NUMBER_OF_PAGES);
        if (this.vFile != null) {
            this.flush();
            stream.writeBoolean(true);
            ((IState)((Object)this.vFile)).write(stream);
            this.sync.write(stream);
        } else {
            stream.writeBoolean(false);
        }
        super.write(stream);
    }

    private void flush() {
        if (this.sync != null) {
            this.sync.synchronize();
        }
    }

    public void reset() {
        this.flush();
        if (this.sync != null) {
            this.sync.exit();
            this.sync = null;
        }
        if (this.vFile != null) {
            this.vFile.ioClose();
            this.vFile = null;
        }
        if (this.vFileIpl != null) {
            this.vFileIpl.ioClose();
            this.vFileIpl = null;
        }
        this.scanThread = null;
        this.hleInit();
    }

    private void getMasterBootRecord(byte[] buffer, int offset) {
        TPointer pageBufferPointer = new ByteArrayMemory(buffer, offset).getPointer();
        TPointer partitionPointer = new TPointer(pageBufferPointer, 446);
        partitionPointer.setValue8(0, (byte)-128);
        partitionPointer.setValue8(1, (byte)0);
        partitionPointer.setValue8(2, (byte)0);
        partitionPointer.setValue8(3, (byte)0);
        partitionPointer.setValue8(4, (byte)12);
        partitionPointer.setValue8(5, (byte)0);
        partitionPointer.setValue8(6, (byte)0);
        partitionPointer.setValue8(7, (byte)0);
        partitionPointer.setUnalignedValue32(8, this.FIRST_PAGE_LBA);
        partitionPointer.setUnalignedValue32(12, this.NUMBER_OF_PAGES);
        pageBufferPointer.setValue8(510, (byte)85);
        pageBufferPointer.setValue8(511, (byte)-86);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorControllerIoInit(pspIoDrvArg drvArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorControllerIoDevctl(pspIoDrvFileArg drvFileArg, PspString devicename, int cmd, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer indata, int inlen, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer outdata, int outlen) {
        switch (cmd) {
            case 33806338: {
                int eventFlag = indata.getValue32();
                Managers.eventFlags.sceKernelSetEventFlag(eventFlag, 1);
                outdata.setValue32(0);
                break;
            }
            case 33708033: {
                outdata.setValue32(4);
                break;
            }
            case 33642503: {
                outdata.setValue32(1);
                break;
            }
            case 33708042: {
                outdata.clear(outlen);
                break;
            }
            case 33642507: {
                break;
            }
            case 33708038: {
                outdata.setValue32(1);
                break;
            }
            default: {
                log.warn((Object)String.format("hleMSstorControllerIoDevctl 0x%08X unknown command on device '%s'", cmd, devicename));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorStorageIoInit(pspIoDrvArg drvArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorStorageIoDevctl(pspIoDrvFileArg drvFileArg, PspString devicename, int cmd, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer indata, int inlen, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer outdata, int outlen) {
        switch (cmd) {
            case 34756610: {
                outdata.setValue32(0);
                break;
            }
            case 34723860: {
                break;
            }
            case 34658326: {
                log.warn((Object)String.format("A FORMAT of the Memory Stick was requested, ignoring the request", new Object[0]));
                break;
            }
            case 33708038: {
                outdata.setValue32(1);
                break;
            }
            default: {
                log.warn((Object)String.format("hleMSstorStorageIoDevctl 0x%08X unknown command on device '%s'", cmd, devicename));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorStorageIoOpen(pspIoDrvFileArg drvFileArg, PspString fileName, int flags, int mode) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorStorageIoIoctl(pspIoDrvFileArg drvFileArg, int cmd, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer indata, int inlen, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer outdata, int outlen) {
        switch (cmd) {
            case 34754568: {
                outdata.setValue32(MemoryStick.isInserted());
                break;
            }
            case 34754569: {
                outdata.setValue32(MemoryStick.isLocked());
                break;
            }
            default: {
                log.warn((Object)String.format("hleMSstorStorageIoIoctl 0x%08X unknown command", cmd));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorStorageIoClose(pspIoDrvFileArg drvFileArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoInit(pspIoDrvArg drvArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoDevctl(pspIoDrvFileArg drvFileArg, PspString devicename, int cmd, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer indata, int inlen, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer outdata, int outlen) {
        switch (cmd) {
            case 34756610: {
                outdata.setValue32(0);
                break;
            }
            default: {
                log.warn((Object)String.format("hleMSstorPartitionIoDevctl 0x%08X unknown command on device '%s'", cmd, devicename));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoIoctl(pspIoDrvFileArg drvFileArg, int cmd, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer indata, int inlen, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer outdata, int outlen) {
        switch (cmd) {
            case 34754561: {
                outdata.setValue32(1);
                break;
            }
            case 34756611: {
                outdata.clear(outlen);
                if (this.dumpIoIoctl_0x02125803 != null) {
                    Utilities.writeBytes(outdata.getAddress(), outlen, this.dumpIoIoctl_0x02125803, 0);
                    break;
                }
                outdata.setValue8(0, (byte)2);
                outdata.setStringNZ(12, 16, "");
                break;
            }
            case 34754568: {
                outdata.setValue32(MemoryStick.isInserted());
                break;
            }
            case 34754569: {
                outdata.setValue32(MemoryStick.isLocked());
                break;
            }
            default: {
                log.warn((Object)String.format("hleMSstorPartitionIoIoctl 0x%08X unknown command", cmd));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoOpen(pspIoDrvFileArg drvFileArg, PspString fileName, int flags, int mode) {
        this.position = 0L;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoClose(pspIoDrvFileArg drvFileArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public long hleMSstorPartitionIoLseek(pspIoDrvFileArg drvFileArg, long offset, int whence) {
        switch (whence) {
            case 0: {
                this.position = offset;
                break;
            }
            default: {
                log.warn((Object)String.format("hleMSstorPartitionIoLseek unimplemented whence=0x%X", whence));
            }
        }
        if (this.vFile != null) {
            this.position = this.vFile.ioLseek(this.position);
        }
        return this.position;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoRead(pspIoDrvFileArg drvFileArg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.returnValue, usage=BufferInfo.Usage.out) TPointer data, int len) {
        data.clear(len);
        if (this.vFile != null) {
            this.scanThread.waitForCompletion();
            len = this.vFile.ioRead(data, len);
        }
        return len;
    }

    public int hleMSstorRawIoRead(long offset, TPointer data, int len) {
        int result;
        if (offset < (long)(this.FIRST_PAGE_LBA * 512)) {
            this.vFileIpl.ioLseek(offset);
            result = this.vFileIpl.ioRead(data, len);
        } else {
            result = this.hleMSstorPartitionIoRead(offset - (long)(this.FIRST_PAGE_LBA * 512), data, len);
        }
        return result;
    }

    public int hleMSstorRawIoRead(long offset, byte[] buffer, int bufferOffset, int len) {
        int result;
        if (offset < (long)(this.FIRST_PAGE_LBA * 512)) {
            this.vFileIpl.ioLseek(offset);
            result = this.vFileIpl.ioRead(buffer, bufferOffset, len);
        } else {
            result = this.hleMSstorPartitionIoRead(offset - (long)(this.FIRST_PAGE_LBA * 512), buffer, bufferOffset, len);
        }
        return result;
    }

    public int hleMSstorRawIoWrite(long offset, TPointer data, int len) {
        int result;
        if (offset < (long)(this.FIRST_PAGE_LBA * 512)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleMSstorRawIoWrite IPL offset=0x%X, len=0x%X", offset, len));
            }
            this.vFileIpl.ioLseek(offset);
            result = this.vFileIpl.ioWrite(data, len);
        } else {
            result = this.hleMSstorPartitionIoWrite(offset - (long)(this.FIRST_PAGE_LBA * 512), data, len);
        }
        return result;
    }

    public int hleMSstorRawIoWrite(long offset, byte[] buffer, int bufferOffset, int len) {
        int result;
        if (offset < (long)(this.FIRST_PAGE_LBA * 512)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleMSstorRawIoWrite IPL offset=0x%X, len=0x%X", offset, len));
            }
            this.vFileIpl.ioLseek(offset);
            result = this.vFileIpl.ioWrite(buffer, bufferOffset, len);
        } else {
            result = this.hleMSstorPartitionIoWrite(offset - (long)(this.FIRST_PAGE_LBA * 512), buffer, bufferOffset, len);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleMSstorPartitionIoRead(long offset, TPointer data, int len) {
        if (this.vFile != null) {
            this.scanThread.waitForCompletion();
            IVirtualFile iVirtualFile = this.vFile;
            synchronized (iVirtualFile) {
                this.vFile.ioLseek(offset);
                len = this.vFile.ioRead(data, len);
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleMSstorPartitionIoRead(long offset, byte[] buffer, int bufferOffset, int len) {
        if (this.vFile != null) {
            this.scanThread.waitForCompletion();
            IVirtualFile iVirtualFile = this.vFile;
            synchronized (iVirtualFile) {
                this.vFile.ioLseek(offset);
                len = this.vFile.ioRead(buffer, bufferOffset, len);
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int hleMSstorPartitionIoWrite(pspIoDrvFileArg drvFileArg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer data, int len) {
        if (this.vFile != null) {
            this.scanThread.waitForCompletion();
            Object object = this.writeLock;
            synchronized (object) {
                len = this.vFile.ioWrite(data, len);
                this.sync.notifyWrite();
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleMSstorPartitionIoWrite(long offset, TPointer data, int len) {
        if (this.vFile != null) {
            this.scanThread.waitForCompletion();
            Object object = this.writeLock;
            synchronized (object) {
                IVirtualFile iVirtualFile = this.vFile;
                synchronized (iVirtualFile) {
                    this.position = this.vFile.ioLseek(offset);
                    len = this.vFile.ioWrite(data, len);
                }
                this.sync.notifyWrite();
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleMSstorPartitionIoWrite(long offset, byte[] buffer, int bufferOffset, int len) {
        if (this.vFile != null) {
            this.scanThread.waitForCompletion();
            Object object = this.writeLock;
            synchronized (object) {
                IVirtualFile iVirtualFile = this.vFile;
                synchronized (iVirtualFile) {
                    this.position = this.vFile.ioLseek(offset);
                    len = this.vFile.ioWrite(buffer, bufferOffset, len);
                }
                this.sync.notifyWrite();
            }
        }
        return len;
    }

    private static byte[] readBytes(String fileName) {
        byte[] bytes = null;
        try {
            File file = new File(fileName);
            FileInputStream is = new FileInputStream(file);
            bytes = new byte[(int)file.length()];
            ((InputStream)is).read(bytes);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    private void installIoFunctions(pspIoDrvFuncs controllerFuncs, pspIoDrvFuncs storageFuncs, pspIoDrvFuncs partitionFuncs) {
        int sizeIoFunctionStub = 12;
        int numberIoFunctions = 15;
        SysMemUserForUser.SysMemInfo memInfo = Modules.SysMemUserForUserModule.malloc(1, "sceMSstor-IoFunctions", 0, 180, 0);
        int addr = memInfo.addr;
        Memory mem = this.getMemory();
        controllerFuncs.ioInit = new TPointerFunction(mem, addr);
        controllerFuncs.ioDevctl = new TPointerFunction(mem, addr += 12);
        HLEUtilities.getInstance().installHLESyscall(controllerFuncs.ioInit, (HLEModule)this, "hleMSstorControllerIoInit");
        HLEUtilities.getInstance().installHLESyscall(controllerFuncs.ioDevctl, (HLEModule)this, "hleMSstorControllerIoDevctl");
        storageFuncs.ioInit = new TPointerFunction(mem, addr += 12);
        storageFuncs.ioDevctl = new TPointerFunction(mem, addr += 12);
        storageFuncs.ioOpen = new TPointerFunction(mem, addr += 12);
        storageFuncs.ioIoctl = new TPointerFunction(mem, addr += 12);
        storageFuncs.ioClose = new TPointerFunction(mem, addr += 12);
        addr += 12;
        HLEUtilities.getInstance().installHLESyscall(storageFuncs.ioInit, (HLEModule)this, "hleMSstorStorageIoInit");
        HLEUtilities.getInstance().installHLESyscall(storageFuncs.ioDevctl, (HLEModule)this, "hleMSstorStorageIoDevctl");
        HLEUtilities.getInstance().installHLESyscall(storageFuncs.ioOpen, (HLEModule)this, "hleMSstorStorageIoOpen");
        HLEUtilities.getInstance().installHLESyscall(storageFuncs.ioIoctl, (HLEModule)this, "hleMSstorStorageIoIoctl");
        HLEUtilities.getInstance().installHLESyscall(storageFuncs.ioClose, (HLEModule)this, "hleMSstorStorageIoClose");
        partitionFuncs.ioInit = new TPointerFunction(mem, addr);
        partitionFuncs.ioDevctl = new TPointerFunction(mem, addr += 12);
        partitionFuncs.ioOpen = new TPointerFunction(mem, addr += 12);
        partitionFuncs.ioClose = new TPointerFunction(mem, addr += 12);
        partitionFuncs.ioIoctl = new TPointerFunction(mem, addr += 12);
        partitionFuncs.ioLseek = new TPointerFunction(mem, addr += 12);
        partitionFuncs.ioRead = new TPointerFunction(mem, addr += 12);
        partitionFuncs.ioWrite = new TPointerFunction(mem, addr += 12);
        addr += 12;
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioInit, (HLEModule)this, "hleMSstorPartitionIoInit");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioDevctl, (HLEModule)this, "hleMSstorPartitionIoDevctl");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioOpen, (HLEModule)this, "hleMSstorPartitionIoOpen");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioClose, (HLEModule)this, "hleMSstorPartitionIoClose");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioIoctl, (HLEModule)this, "hleMSstorPartitionIoIoctl");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioLseek, (HLEModule)this, "hleMSstorPartitionIoLseek");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioRead, (HLEModule)this, "hleMSstorPartitionIoRead");
        HLEUtilities.getInstance().installHLESyscall(partitionFuncs.ioWrite, (HLEModule)this, "hleMSstorPartitionIoWrite");
    }

    private Fat32VirtualFile openFile() {
        if (this.sync != null) {
            this.sync.exit();
            this.sync = null;
        }
        long totalSize = MemoryStick.getTotalSize();
        long totalNumberOfPages = totalSize / 512L;
        int PAGES_PER_BLOCK = 16;
        int NUMBER_OF_PHYSICAL_BLOCKS = (int)(totalNumberOfPages / (long)PAGES_PER_BLOCK);
        if (totalNumberOfPages > 8192L) {
            for (PAGES_PER_BLOCK = 32; PAGES_PER_BLOCK < 32768 && (NUMBER_OF_PHYSICAL_BLOCKS = (int)(totalNumberOfPages / (long)PAGES_PER_BLOCK)) >= 65536; PAGES_PER_BLOCK <<= 1) {
            }
        }
        int BLOCK_SIZE = PAGES_PER_BLOCK * 512 / 1024;
        this.FIRST_PAGE_LBA = 2 * PAGES_PER_BLOCK;
        this.NUMBER_OF_PAGES = (NUMBER_OF_PHYSICAL_BLOCKS / 512 * 496 - 2) * BLOCK_SIZE * 2;
        this.NUMBER_OF_PAGES -= this.FIRST_PAGE_LBA;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("openFile totalSize=0x%X(%s), pagesPerBlock=0x%X, numberOfPhysicalBlocks=0x%X", totalSize, MemoryStick.getSizeKbString((int)(totalSize / 1024L)), PAGES_PER_BLOCK, NUMBER_OF_PHYSICAL_BLOCKS));
        }
        LocalVirtualFileSystem vfs = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("ms0"), true);
        Fat32VirtualFile fat32VirtualFile = new Fat32VirtualFile("ms0:", vfs);
        this.vFile = new WriteCacheVirtualFile(log, fat32VirtualFile);
        fat32VirtualFile.setBaseVirtualFile(this.vFile);
        FatVirtualFileSystem input = new FatVirtualFileSystem("ms0", this.vFile);
        this.sync = new SynchronizeVirtualFileSystems("ms0", input, vfs, this.writeLock);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("openFile vFile=%s", this.vFile));
        }
        try {
            this.vFileIpl = new LocalVirtualFile(new SeekableRandomFile("ms.ipl.bin", "rw"));
            int iplFileSize = this.FIRST_PAGE_LBA * 512;
            byte[] iplBuffer = new byte[iplFileSize];
            this.getMasterBootRecord(iplBuffer, 0);
            this.vFileIpl.ioLseek(0L);
            this.vFileIpl.ioWrite(iplBuffer, 0, iplFileSize);
            this.vFileIpl.ioLseek(0L);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Error while opening the ms.ipl.bin file", (Throwable)e);
        }
        return fat32VirtualFile;
    }

    public void hleInit() {
        Fat32VirtualFile fat32VirtualFile = this.openFile();
        this.scanThread = new Fat32ScanThread(fat32VirtualFile);
        this.scanThread.setName("Fat32VirtualFile Scan Thread");
        this.scanThread.setDaemon(true);
        this.scanThread.start();
    }

    public void installDrivers() {
        Memory mem = Memory.getInstance();
        this.dumpIoIoctl_0x02125803 = sceMSstor.readBytes("ms.ioctl.0x02125803");
        this.hleInit();
        pspIoDrv controllerDrv = new pspIoDrv();
        pspIoDrvFuncs controllerFuncs = new pspIoDrvFuncs();
        String controllerName = "mscmhc";
        String controllerDescription = "MS host controller";
        pspIoDrv storageDrv = new pspIoDrv();
        pspIoDrvFuncs storageFuncs = new pspIoDrvFuncs();
        String storageName = "msstor";
        String storageDescription = "MSstor whole dev";
        pspIoDrv partitionDrv = new pspIoDrv();
        pspIoDrvFuncs partitionFuncs = new pspIoDrvFuncs();
        String partitionName = "msstor0p";
        String partitionDescription = "MSstor partition #1";
        int length = 0;
        length += controllerDrv.sizeof() + controllerFuncs.sizeof() + controllerName.length() + 1 + controllerDescription.length() + 1;
        length += storageDrv.sizeof() + storageFuncs.sizeof() + storageName.length() + 1 + storageDescription.length() + 1;
        SysMemUserForUser.SysMemInfo memInfo = Modules.SysMemUserForUserModule.malloc(1, "sceMSstor-mscmhc", 0, length += partitionDrv.sizeof() + partitionFuncs.sizeof() + partitionName.length() + 1 + partitionDescription.length() + 1, 0);
        int controllerDrvAddr = memInfo.addr;
        int controllerFuncsAddr = controllerDrvAddr + controllerDrv.sizeof();
        int storageDrvAddr = controllerFuncsAddr + controllerFuncs.sizeof();
        int storageFuncsAddr = storageDrvAddr + storageDrv.sizeof();
        int partitionDrvAddr = storageFuncsAddr + controllerFuncs.sizeof();
        int partitionFuncsAddr = partitionDrvAddr + partitionDrv.sizeof();
        int controllerNameAddr = partitionFuncsAddr + partitionFuncs.sizeof();
        int controllerDescriptionAddr = controllerNameAddr + controllerName.length() + 1;
        int storageNameAddr = controllerDescriptionAddr + controllerDescription.length() + 1;
        int storageDescriptionAddr = storageNameAddr + storageName.length() + 1;
        int partitionNameAddr = storageDescriptionAddr + storageDescription.length() + 1;
        int partitionDescriptionAddr = partitionNameAddr + partitionName.length() + 1;
        this.installIoFunctions(controllerFuncs, storageFuncs, partitionFuncs);
        Utilities.writeStringZ(mem, controllerNameAddr, controllerName);
        Utilities.writeStringZ(mem, controllerDescriptionAddr, controllerDescription);
        controllerDrv.nameAddr = controllerNameAddr;
        controllerDrv.name = controllerName;
        controllerDrv.devType = 1;
        controllerDrv.unknown = 0;
        controllerDrv.descriptionAddr = controllerDescriptionAddr;
        controllerDrv.description = controllerDescription;
        controllerDrv.funcsAddr = controllerFuncsAddr;
        controllerDrv.ioDrvFuncs = controllerFuncs;
        controllerDrv.write(mem, controllerDrvAddr);
        Utilities.writeStringZ(mem, storageNameAddr, storageName);
        Utilities.writeStringZ(mem, storageDescriptionAddr, storageDescription);
        storageDrv.nameAddr = storageNameAddr;
        storageDrv.name = storageName;
        storageDrv.devType = 1;
        storageDrv.unknown = 0;
        storageDrv.descriptionAddr = storageDescriptionAddr;
        storageDrv.description = storageDescription;
        storageDrv.funcsAddr = storageFuncsAddr;
        storageDrv.ioDrvFuncs = storageFuncs;
        storageDrv.write(mem, storageDrvAddr);
        Utilities.writeStringZ(mem, partitionNameAddr, partitionName);
        Utilities.writeStringZ(mem, partitionDescriptionAddr, partitionDescription);
        partitionDrv.nameAddr = partitionNameAddr;
        partitionDrv.name = partitionName;
        partitionDrv.devType = 1;
        partitionDrv.unknown = 0;
        partitionDrv.descriptionAddr = partitionDescriptionAddr;
        partitionDrv.description = partitionDescription;
        partitionDrv.funcsAddr = partitionFuncsAddr;
        partitionDrv.ioDrvFuncs = partitionFuncs;
        partitionDrv.write(mem, partitionDrvAddr);
        int sceIoAddDrv = NIDMapper.getInstance().getAddressByName("sceIoAddDrv");
        if (sceIoAddDrv != 0) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, sceIoAddDrv, (IAction)new AfterAddDrvController(thread, sceIoAddDrv, storageDrvAddr, partitionDrvAddr), false, controllerDrvAddr);
        }
    }

    @HLEUnimplemented
    @HLEFunction(nid=1874978990, version=150)
    public int sceMSstorEntry(int unknown1, int unknown2, int unknown3) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1900511958, version=150)
    public int sceMSstorRegisterCLDMSelf(int unknown) {
        return 0;
    }

    private static class Fat32ScanThread
    extends Thread {
        private Fat32VirtualFile vFile;
        private boolean completed;

        public Fat32ScanThread(Fat32VirtualFile vFile) {
            this.vFile = vFile;
            this.completed = false;
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            this.vFile.scan();
            this.completed = true;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void waitForCompletion() {
            while (!this.isCompleted()) {
                Utilities.sleep(1, 0);
            }
        }
    }

    private static class AfterAddDrvStorage
    implements IAction {
        private SceKernelThreadInfo thread;
        private int sceIoAddDrv;
        private int partitionDrvAddr;

        public AfterAddDrvStorage(SceKernelThreadInfo thread, int sceIoAddDrv, int partitionDrvAddr) {
            this.thread = thread;
            this.sceIoAddDrv = sceIoAddDrv;
            this.partitionDrvAddr = partitionDrvAddr;
        }

        @Override
        public void execute() {
            Modules.ThreadManForUserModule.executeCallback(this.thread, this.sceIoAddDrv, null, false, this.partitionDrvAddr);
        }
    }

    private static class AfterAddDrvController
    implements IAction {
        private SceKernelThreadInfo thread;
        private int sceIoAddDrv;
        private int storageDrvAddr;
        private int partitionDrvAddr;

        public AfterAddDrvController(SceKernelThreadInfo thread, int sceIoAddDrv, int storageDrvAddr, int partitionDrvAddr) {
            this.thread = thread;
            this.sceIoAddDrv = sceIoAddDrv;
            this.storageDrvAddr = storageDrvAddr;
            this.partitionDrvAddr = partitionDrvAddr;
        }

        @Override
        public void execute() {
            Modules.ThreadManForUserModule.executeCallback(this.thread, this.sceIoAddDrv, (IAction)new AfterAddDrvStorage(this.thread, this.sceIoAddDrv, this.partitionDrvAddr), false, this.storageDrvAddr);
        }
    }
}

