/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointerFunction;
import org.apache.log4j.Logger;

public class sceSuspendForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSuspendForKernel");
    private static final int NUMBER_HANDLERS = 32;
    private final Handler[] suspendHandlers = new Handler[32];
    private final Handler[] resumeHandlers = new Handler[32];

    @Override
    public void start() {
        for (int i = 0; i < 32; ++i) {
            this.suspendHandlers[i] = null;
            this.resumeHandlers[i] = null;
        }
        super.start();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1734225823, version=150)
    public int sceKernelPowerRebootStart(int unknown) {
        return 0;
    }

    @HLEFunction(nid=-1851297481, version=150)
    public int sceKernelRegisterSuspendHandler(int reg, TPointerFunction handler, int param) {
        if (reg < 0 || reg >= 32) {
            return -1;
        }
        this.suspendHandlers[reg] = new Handler(handler, param);
        return 0;
    }

    @HLEFunction(nid=-1271063924, version=150)
    public int sceKernelRegisterResumeHandler(int reg, TPointerFunction handler, int param) {
        if (reg < 0 || reg >= 32) {
            return -1;
        }
        this.resumeHandlers[reg] = new Handler(handler, param);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1254416057, version=150)
    public int sceKernelPowerLockForUser() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-943118137, version=150)
    public int sceKernelPowerUnlockForUser() {
        return 0;
    }

    @HLEFunction(nid=-1890012692, version=150)
    public int sceKernelDispatchSuspendHandlers(int unknown) {
        for (int i = 0; i < 32; ++i) {
            if (this.suspendHandlers[i] == null) continue;
            this.suspendHandlers[i].call(unknown);
        }
        return 0;
    }

    @HLEFunction(nid=179357427, version=150)
    public int sceKernelDispatchResumeHandlers(int unknown) {
        for (int i = 0; i < 32; ++i) {
            if (this.resumeHandlers[i] == null) continue;
            this.resumeHandlers[i].call(unknown);
        }
        return 0;
    }

    private static class Handler {
        private TPointerFunction handler;
        private int param;
        private int gp;

        public Handler(TPointerFunction handler, int param) {
            this.handler = handler;
            this.param = param;
            this.gp = Emulator.getProcessor().cpu._gp;
        }

        public void call(int unknown) {
            if (this.handler == null || this.handler.isNull()) {
                return;
            }
            Modules.ThreadManForUserModule.executeCallback(this.handler.getAddress(), this.gp, null, unknown, this.param);
        }
    }
}

