/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.kernel.types.pspUsbDriver;
import jpcsp.hardware.Usb;
import org.apache.log4j.Logger;

public class sceUsb
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUsb");
    public static final String PSP_USBBUS_DRIVERNAME = "USBBusDriver";
    public static final int PSP_USB_CONNECTION_NOT_ESTABLISHED = 1;
    public static final int PSP_USB_CONNECTION_ESTABLISHED = 2;
    public static final int PSP_USB_CABLE_DISCONNECTED = 16;
    public static final int PSP_USB_CABLE_CONNECTED = 32;
    public static final int PSP_USB_DEACTIVATED = 256;
    public static final int PSP_USB_ACTIVATED = 512;
    protected static final int WAIT_MODE_ANDOR_MASK = 1;
    protected static final int WAIT_MODE_AND = 0;
    protected static final int WAIT_MODE_OR = 1;
    protected boolean usbActivated = false;
    protected boolean usbStarted = false;
    protected int callbackId = -1;

    @Override
    public void start() {
        this.usbActivated = false;
        this.usbStarted = false;
        super.start();
    }

    protected int getUsbState() {
        int state = Usb.isCableConnected() ? 32 : 16;
        state |= this.usbActivated ? 512 : 256;
        return state |= this.usbStarted ? 2 : 1;
    }

    protected boolean matchState(int waitState, int waitMode) {
        int state = this.getUsbState();
        if ((waitMode & 1) == 0) {
            return (state & waitState) == waitState;
        }
        return (state & waitState) != 0;
    }

    protected void notifyCallback() {
        if (this.callbackId >= 0) {
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(6, this.getUsbState());
        }
    }

    @HLEFunction(nid=-1369577809, version=150)
    public int sceUsbStart(String driverName, int size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.in) @CanBeNull TPointer args) {
        int result;
        this.usbStarted = true;
        if (PSP_USBBUS_DRIVERNAME.equals(driverName)) {
            result = 0;
        } else {
            pspUsbDriver usbDriver = Modules.sceUsbBusModule.getRegisteredUsbDriver(driverName);
            if (usbDriver == null) {
                log.error((Object)String.format("sceUsbStart unknown driver '%s'", driverName));
                result = -1;
            } else {
                TPointerFunction start_func;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceUsbStart on %s", usbDriver));
                }
                result = (start_func = usbDriver.start_func) != null ? start_func.executeCallback(size, args.getAddress()) : 0;
            }
        }
        this.notifyCallback();
        return result;
    }

    @HLEFunction(nid=-1035579488, version=150)
    public int sceUsbStop(String driverName, int size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.in) @CanBeNull TPointer args) {
        int result;
        this.usbStarted = false;
        if (PSP_USBBUS_DRIVERNAME.equals(driverName)) {
            result = 0;
        } else {
            pspUsbDriver usbDriver = Modules.sceUsbBusModule.getRegisteredUsbDriver(driverName);
            if (usbDriver == null) {
                log.error((Object)String.format("sceUsbStop unknown driver '%s'", driverName));
                result = -1;
            } else {
                TPointerFunction stop_func;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceUsbStop on %s", usbDriver));
                }
                result = (stop_func = usbDriver.stop_func) != null ? stop_func.executeCallback(size, args.getAddress()) : 0;
            }
        }
        this.notifyCallback();
        return result;
    }

    @HLEFunction(nid=-1038727772, version=150)
    public int sceUsbGetState() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUsbGetState returning 0x%X", this.getUsbState()));
        }
        return this.getUsbState();
    }

    @HLEFunction(nid=1314091878, version=150)
    public int sceUsbGetDrvList(int unknown1, int unknown2, int unknown3) {
        log.warn((Object)String.format("Unimplemented sceUsbGetDrvList unknown1=0x%08X, unknown2=0x%08X, unknown3=0x%08X", unknown1, unknown2, unknown3));
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=288147793, version=150)
    public int sceUsbGetDrvState(PspString driverName) {
        return 0;
    }

    @HLEFunction(nid=1483585580, version=150)
    public int sceUsbActivate(int pid) {
        return this.sceUsbActivateWithCharging(pid, false);
    }

    @HLEFunction(nid=-982341176, version=150)
    public int sceUsbDeactivate() {
        this.usbActivated = false;
        this.notifyCallback();
        Modules.sceUsbPspcmModule.onUsbDeactivate();
        return 0;
    }

    @HLEFunction(nid=1541464066, version=150)
    public int sceUsbWaitState(int state, int waitMode, @CanBeNull TPointer32 timeoutAddr) {
        if (!this.matchState(state, waitMode)) {
            log.warn((Object)String.format("Unimplemented sceUsbWaitState state=0x%X, waitMode=0x%X, timeoutAddr=%s - non-matching state not implemented", state, waitMode, timeoutAddr));
            Modules.ThreadManForUserModule.hleBlockCurrentThread(263);
            return 0;
        }
        int usbState = this.getUsbState();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUsbWaitState returning 0x%X", usbState));
        }
        return usbState;
    }

    @HLEFunction(nid=1634675553, version=150)
    public int sceUsbWaitStateCB(int state, int waitMode, @CanBeNull TPointer32 timeoutAddr) {
        if (!this.matchState(state, waitMode)) {
            log.warn((Object)String.format("Unimplemented sceUsbWaitStateCB state=0x%X, waitMode=0x%X, timeoutAddr=%s - non-matching state not implemented", state, waitMode, timeoutAddr));
            Modules.ThreadManForUserModule.hleBlockCurrentThread(263);
            return 0;
        }
        int usbState = this.getUsbState();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUsbWaitStateCB returning 0x%X", usbState));
        }
        return usbState;
    }

    @HLEUnimplemented
    @HLEFunction(nid=473302837, version=150)
    public int sceUsbWaitCancel() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1946403352, version=150)
    public int sceUsb_8BFC3DE8(int callbackId, int unknown1, int unknown2) {
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(6, callbackId)) {
            this.callbackId = callbackId;
            this.notifyCallback();
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1981936187, version=150)
    public int sceUsb_89DE0DC5(int callbackId) {
        if (this.callbackId == callbackId) {
            this.callbackId = -1;
        }
        return 0;
    }

    @HLEFunction(nid=-502586458, version=150)
    public int sceUsbActivateWithCharging(int pid, boolean charging) {
        this.usbActivated = true;
        this.notifyCallback();
        if (pid == 459) {
            Modules.sceUsbPspcmModule.onUsbActivate(pid);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-307716064, version=150)
    public int sceUsbRestart(int delayMilliseconds) {
        return 0;
    }
}

