/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspUsbDriver;
import jpcsp.HLE.kernel.types.pspUsbdDeviceReq;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceUsbBus
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUsbBus");
    private boolean unknownFlag1;
    private boolean unknownFlag2;
    private boolean unknownFlag3;
    private final List<pspUsbDriver> registeredDrivers = new LinkedList<pspUsbDriver>();

    public pspUsbDriver getRegisteredUsbDriver(String name) {
        for (pspUsbDriver usbDriver : this.registeredDrivers) {
            if (!name.equals(usbDriver.name)) continue;
            return usbDriver;
        }
        return null;
    }

    public int hleUsbbdRegister(pspUsbDriver usbDriver) {
        this.registeredDrivers.add(usbDriver);
        return 0;
    }

    public int hleUsbbdUnregister(pspUsbDriver usbDriver) {
        for (pspUsbDriver registeredDriver : this.registeredDrivers) {
            if (registeredDriver != usbDriver && registeredDriver.getBaseAddress() != usbDriver.getBaseAddress()) continue;
            this.registeredDrivers.remove(registeredDriver);
            break;
        }
        return 0;
    }

    private boolean isRegistered(pspUsbdDeviceReq deviceReq) {
        for (pspUsbDriver driver : this.registeredDrivers) {
            TPointer endpoint = new TPointer(driver.endp);
            for (int i = 0; i < driver.endpoints; ++i) {
                if (deviceReq.endp.equals(endpoint)) {
                    return true;
                }
                endpoint.add(12);
            }
        }
        return false;
    }

    public void triggerCompletionFunction(pspUsbdDeviceReq deviceReq) {
        if (deviceReq.func != null && deviceReq.func.isNotNull()) {
            Emulator.getScheduler().addAction(new sceUsbbdReqComplete(deviceReq, Modules.ThreadManForUserModule.getCurrentThread()));
        }
    }

    @HLEUnimplemented
    @HLEFunction(nid=602217871, version=150)
    public int sceUsbbdReqSend(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer req) {
        int result = 0;
        pspUsbDriver usbDriver = this.getRegisteredUsbDriver("USBPSPCommunicationDriver");
        TPointer deviceReqAddress = new TPointer(req);
        boolean first = true;
        while (true) {
            pspUsbdDeviceReq deviceReq = new pspUsbdDeviceReq();
            deviceReq.read(deviceReqAddress);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceUsbbdReqSend size=0x%X, data=%s", deviceReq.size, Utilities.getMemoryDump(deviceReq.data, deviceReq.size)));
            }
            deviceReq.retcode = 0;
            deviceReq.recvsize = deviceReq.size;
            if (usbDriver != null) {
                result = Modules.sceUsbPspcmModule.getUsbCommunicationStub().hleUsbbdReqSend(usbDriver, deviceReq, deviceReqAddress);
            }
            deviceReq.write(deviceReqAddress);
            if (deviceReq.func.isNotNull() && first) {
                Emulator.getScheduler().addAction(Scheduler.getNow() + 5000L, new sceUsbbdReqComplete(deviceReq, Modules.ThreadManForUserModule.getCurrentThread()));
                first = false;
            }
            if (deviceReq.nextRequest == 0) break;
            deviceReqAddress = new TPointer(req.getMemory(), deviceReq.nextRequest);
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1866977451, version=150)
    public void sceUsbBus_driver_90B82F55() {
        this.unknownFlag1 = true;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2072478045, version=150)
    public void sceUsbBus_driver_7B87815D() {
        this.unknownFlag1 = false;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1975601710, version=150)
    public boolean sceUsbBus_driver_8A3EB5D2() {
        return this.unknownFlag2;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-73267413, version=150)
    public void sceUsbBus_driver_FBA2072B() {
        if (this.unknownFlag1) {
            this.unknownFlag2 = true;
        }
    }

    @HLEUnimplemented
    @HLEFunction(nid=1221387201, version=150)
    public boolean sceUsbBus_driver_48CCE3C1() {
        return this.unknownFlag3;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1858158243, version=150)
    public int sceUsbbdReqRecv(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer req) {
        pspUsbdDeviceReq deviceReq = new pspUsbdDeviceReq();
        deviceReq.read(req);
        int result = 0;
        pspUsbDriver usbDriver = this.getRegisteredUsbDriver("USBPSPCommunicationDriver");
        if (usbDriver != null) {
            result = Modules.sceUsbPspcmModule.getUsbCommunicationStub().hleUsbbdReqRecv(usbDriver, deviceReq, req);
        } else if (deviceReq.func.isNotNull()) {
            Emulator.getScheduler().addAction(Scheduler.getNow() + 5000L, new sceUsbbdReqComplete(deviceReq, Modules.ThreadManForUserModule.getCurrentThread()));
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1793448756, version=150)
    public int sceUsbbdClearFIFO(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.inout) TPointer endp) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1318827033, version=150)
    public int sceUsbbdRegister(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer drv) {
        pspUsbDriver usbDriver = new pspUsbDriver();
        usbDriver.read(drv);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUsbbdRegister %s", usbDriver));
        }
        return this.hleUsbbdRegister(usbDriver);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1042111168, version=150)
    public int sceUsbbdUnregister(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer drv) {
        pspUsbDriver usbDriver = new pspUsbDriver();
        usbDriver.read(drv);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUsbbdUnregister %s", usbDriver));
        }
        return this.hleUsbbdUnregister(usbDriver);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-974834043, version=150)
    public int sceUsbbdReqCancelAll(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.inout) TPointer endp) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-866653027, version=150)
    public int sceUsbbdReqCancel(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer req) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-430685759, version=150)
    public int sceUsbbdStall(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.inout) TPointer endp) {
        return 0;
    }

    private class sceUsbbdReqComplete
    implements IAction {
        private final pspUsbdDeviceReq deviceReq;
        private final SceKernelThreadInfo threadInfo;

        public sceUsbbdReqComplete(pspUsbdDeviceReq deviceReq, SceKernelThreadInfo threadInfo) {
            this.deviceReq = deviceReq;
            this.threadInfo = threadInfo;
        }

        @Override
        public void execute() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Executing completion function for %s, endpnum=0x%X, isRegistered=%b: %s", this.deviceReq, this.deviceReq.endp.getValue32(0), sceUsbBus.this.isRegistered(this.deviceReq), Utilities.getMemoryDump(this.deviceReq.data, this.deviceReq.recvsize)));
            }
            if (sceUsbBus.this.isRegistered(this.deviceReq)) {
                sceUsbbdReqComplete nextAction = null;
                if (this.deviceReq.nextRequest != 0) {
                    pspUsbdDeviceReq nextDeviceReq = new pspUsbdDeviceReq();
                    nextDeviceReq.read(sceUsbBus.this.getMemory(), this.deviceReq.nextRequest);
                    nextAction = new sceUsbbdReqComplete(nextDeviceReq, this.threadInfo);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("next deviceReq=%s, endpnum=0x%X", nextDeviceReq, nextDeviceReq.endp.getValue32(0)));
                    }
                }
                Modules.ThreadManForUserModule.executeCallback(this.threadInfo, this.deviceReq.func.getAddress(), nextAction, false, true, this.deviceReq.getBaseAddress());
            }
        }
    }
}

