/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceMpegbase;
import jpcsp.Memory;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.IVideoCodec;
import jpcsp.mediaengine.MEEmulator;
import jpcsp.mediaengine.MEMemory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.scheduler.DelayThreadAction;
import jpcsp.scheduler.UnblockThreadAction;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceVideocodec
extends HLEModule {
    public static Logger log = Modules.getLogger("sceVideocodec");
    public static final int videocodecBufferSize = 96;
    private static final int videocodecDecodeDelay = 4000;
    public static final int videocodecDeleteDelay = 40000;
    protected int memoryAddr;
    protected int edramAddr;
    protected int frameCount;
    protected int bufferY1;
    protected int bufferY2;
    protected int bufferCr1;
    protected int bufferCr2;
    protected int bufferCb1;
    protected int bufferCb2;
    protected final TPointer[][] buffers = new TPointer[4][8];
    protected TPointer defaultBufferUnknown1;
    protected TPointer defaultBufferUnknown2;
    protected IVideoCodec videoCodec;
    private VideocodecDecoderThread videocodecDecoderThread;
    private int[] videocodecExtraData;

    @Override
    public void start() {
        this.videocodecExtraData = null;
        super.start();
    }

    public int[] getVideocodecExtraData() {
        return this.videocodecExtraData;
    }

    public void setVideocodecExtraData(int[] videocodecExtraData) {
        this.videocodecExtraData = videocodecExtraData;
    }

    public void clearVideocodecExtraData() {
        this.videocodecExtraData = null;
    }

    public void videocodecDelete() {
        if (this.videocodecDecoderThread != null) {
            this.videocodecDecoderThread.exit();
            this.videocodecDecoderThread = null;
        }
        this.clearVideocodecExtraData();
        if (this.videoCodec != null) {
            this.videoCodec = null;
        }
        if (this.memoryAddr != 0) {
            MEEmulator.getInstance().free(this.memoryAddr);
            this.memoryAddr = 0;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            for (int j = 0; j < this.buffers[i].length; ++j) {
                this.buffers[i][j] = null;
            }
        }
        if (this.edramAddr != 0) {
            MEEmulator.getInstance().free(this.edramAddr);
            this.edramAddr = 0;
        }
    }

    private int videocodecDecode(Memory mp4Memory, int mp4Data, int mp4Size) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceVideocodecDecode mp4Data:%s", Utilities.getMemoryDump(mp4Memory, mp4Data, mp4Size)));
        }
        if (this.videoCodec == null) {
            this.videoCodec = CodecFactory.getVideoCodec();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("videocodecDecode init Codec with extraData=%s", new Object[]{this.getVideocodecExtraData()}));
            }
            this.videoCodec.init(this.getVideocodecExtraData());
            this.clearVideocodecExtraData();
        }
        int[] mp4Buffer = sceMpegbase.getIntBuffer(mp4Size + 2);
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(mp4Memory, mp4Data, mp4Size, 1);
        for (int i = 0; i < mp4Size; ++i) {
            mp4Buffer[i] = memoryReader.readNext();
        }
        int result = this.videoCodec.decode(mp4Buffer, 0, mp4Size);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceVideocodecDecode videoCodec returned 0x%X from 0x%08X, 0x%X data bytes", result, mp4Data, mp4Size));
        }
        sceMpegbase.releaseIntBuffer(mp4Buffer);
        return result;
    }

    public int videocodecDecodeType0(Memory mp4Memory, int mp4Data, int mp4Size, TPointer buffer2, TPointer mpegAvcYuvStruct, TPointer buffer3, TPointer decodeSEI) {
        int result = this.videocodecDecode(mp4Memory, mp4Data, mp4Size);
        int frameWidth = this.videoCodec.getImageWidth();
        int frameHeight = this.videoCodec.getImageHeight();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceVideocodecDecode codec image size %dx%d, frame size %dx%d", this.videoCodec.getImageWidth(), this.videoCodec.getImageHeight(), frameWidth, frameHeight));
        }
        buffer2.setValue32(8, frameWidth);
        buffer2.setValue32(12, frameHeight);
        buffer2.setValue32(28, 1);
        buffer2.setValue32(32, this.videoCodec.hasImage());
        buffer2.setValue32(36, !this.videoCodec.hasImage());
        if (this.videoCodec.hasImage()) {
            int[] cr;
            int[] cb;
            int height;
            if (this.buffers[0][0] == null) {
                int sizeY1 = Utilities.alignUp((frameWidth + 16 >> 5) * (frameHeight >> 1) * 16, 511);
                int sizeY2 = Utilities.alignUp((frameWidth >> 5) * (frameHeight >> 1) * 16, 511);
                int sizeCr1 = Utilities.alignUp((frameWidth + 16 >> 5) * (frameHeight >> 1) * 8, 511);
                int sizeCr2 = Utilities.alignUp((frameWidth >> 5) * (frameHeight >> 1) * 8, 511);
                int size = 256 + (sizeY1 + sizeY2 + sizeCr1 + sizeCr2) * 2 * this.buffers.length;
                int baseAddr = MEEmulator.getInstance().malloc(size);
                TPointer base = new TPointer(this.getMEMemory(), baseAddr);
                this.defaultBufferUnknown1 = new TPointer(base);
                this.defaultBufferUnknown1.clear(36);
                this.defaultBufferUnknown2 = new TPointer(base, 36);
                this.defaultBufferUnknown2.clear(32);
                TPointer yuvBuffersBase = new TPointer(base, 256);
                TPointer base1 = new TPointer(yuvBuffersBase);
                TPointer base2 = new TPointer(base1, (sizeY1 + sizeY2) * this.buffers.length);
                int step = (sizeY1 + sizeY2 + sizeCr1 + sizeCr2) * this.buffers.length;
                for (int i = 0; i < this.buffers.length; ++i) {
                    this.buffers[i][0] = new TPointer(base1);
                    this.buffers[i][0].memset((byte)0, sizeY1);
                    this.buffers[i][1] = new TPointer(this.buffers[i][0], step);
                    this.buffers[i][1].memset((byte)0, sizeY1);
                    this.buffers[i][2] = new TPointer(base1, sizeY1);
                    this.buffers[i][2].memset((byte)0, sizeY2);
                    this.buffers[i][3] = new TPointer(this.buffers[i][2], step);
                    this.buffers[i][3].memset((byte)0, sizeY2);
                    this.buffers[i][4] = new TPointer(base2);
                    this.buffers[i][4].memset((byte)-128, sizeCr1);
                    this.buffers[i][5] = new TPointer(this.buffers[i][4], step);
                    this.buffers[i][5].memset((byte)-128, sizeCr1);
                    this.buffers[i][6] = new TPointer(base2, sizeCr1);
                    this.buffers[i][6].memset((byte)-128, sizeCr2);
                    this.buffers[i][7] = new TPointer(this.buffers[i][6], step);
                    this.buffers[i][7].memset((byte)-128, sizeCr2);
                    base1.add(sizeY1 + sizeY2);
                    base2.add(sizeCr1 + sizeCr2);
                    if (!log.isDebugEnabled()) continue;
                    for (int j = 0; j < this.buffers[i].length; ++j) {
                        log.debug((Object)String.format("sceVideocodecDecode allocated buffers[%d][%d]=%s", i, j, this.buffers[i][j]));
                    }
                }
            }
            int buffersIndex = this.frameCount % 3;
            int width = this.videoCodec.getImageWidth();
            int[] luma = sceMpegbase.getIntBuffer(width * (height = this.videoCodec.getImageHeight()));
            if (this.videoCodec.getImage(luma, cb = sceMpegbase.getIntBuffer(width * height >> 2), cr = sceMpegbase.getIntBuffer(width * height >> 2)) == 0) {
                int i;
                int xx;
                int i2;
                int y;
                int x;
                int width2 = width / 2;
                int height2 = height / 2;
                int[] buffer = sceMpegbase.getIntBuffer((width + 31 >> 5) * (height + 1 >> 1) * 16);
                int n = 0;
                for (x = 0; x < width; x += 32) {
                    y = 0;
                    i2 = x;
                    while (y < height) {
                        System.arraycopy(luma, i2, buffer, n, 16);
                        y += 2;
                        n += 16;
                        i2 += 2 * width;
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][0], n, buffer, 0);
                n = 0;
                for (x = 16; x < width; x += 32) {
                    y = 0;
                    i2 = x;
                    while (y < height) {
                        System.arraycopy(luma, i2, buffer, n, 16);
                        y += 2;
                        n += 16;
                        i2 += 2 * width;
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][1], n, buffer, 0);
                n = 0;
                for (x = 0; x < width2; x += 16) {
                    for (y = 0; y < height2; y += 2) {
                        xx = 0;
                        i = y * width2 + x;
                        while (xx < 8) {
                            buffer[n++] = cb[i];
                            buffer[n++] = cr[i];
                            ++xx;
                            ++i;
                        }
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][4], n, buffer, 0);
                n = 0;
                for (x = 0; x < width2; x += 16) {
                    for (y = 1; y < height2; y += 2) {
                        xx = 0;
                        i = y * width2 + x;
                        while (xx < 8) {
                            buffer[n++] = cb[i];
                            buffer[n++] = cr[i];
                            ++xx;
                            ++i;
                        }
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][5], n, buffer, 0);
                n = 0;
                for (x = 0; x < width; x += 32) {
                    y = 1;
                    i2 = x + width;
                    while (y < height) {
                        System.arraycopy(luma, i2, buffer, n, 16);
                        y += 2;
                        n += 16;
                        i2 += 2 * width;
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][2], n, buffer, 0);
                n = 0;
                for (x = 16; x < width; x += 32) {
                    y = 1;
                    i2 = x + width;
                    while (y < height) {
                        System.arraycopy(luma, i2, buffer, n, 16);
                        y += 2;
                        n += 16;
                        i2 += 2 * width;
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][3], n, buffer, 0);
                n = 0;
                for (x = 8; x < width2; x += 16) {
                    for (y = 0; y < height2; y += 2) {
                        xx = 0;
                        i = y * width2 + x;
                        while (xx < 8) {
                            buffer[n++] = cb[i];
                            buffer[n++] = cr[i];
                            ++xx;
                            ++i;
                        }
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][6], n, buffer, 0);
                n = 0;
                for (x = 8; x < width2; x += 16) {
                    for (y = 1; y < height2; y += 2) {
                        xx = 0;
                        i = y * width2 + x;
                        while (xx < 8) {
                            buffer[n++] = cb[i];
                            buffer[n++] = cr[i];
                            ++xx;
                            ++i;
                        }
                    }
                }
                sceVideocodec.write(this.buffers[buffersIndex][7], n, buffer, 0);
                sceMpegbase.releaseIntBuffer(buffer);
            }
            sceMpegbase.releaseIntBuffer(luma);
            sceMpegbase.releaseIntBuffer(cb);
            sceMpegbase.releaseIntBuffer(cr);
            for (int i = 0; i < 8; ++i) {
                mpegAvcYuvStruct.setValue32(i * 4, this.buffers[buffersIndex][i].getAddress());
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)String.format("sceVideocodecDecode YUV buffer[%d]=%s", i, this.buffers[buffersIndex][i]));
            }
            mpegAvcYuvStruct.setValue32(32, this.videoCodec.hasImage());
            TPointer bufferUnknown1 = mpegAvcYuvStruct.getPointer(this.getMEMemory(), 36);
            if (bufferUnknown1.isNull()) {
                bufferUnknown1 = this.defaultBufferUnknown1;
                mpegAvcYuvStruct.setPointer(36, bufferUnknown1);
            }
            bufferUnknown1.setUnsignedValue8(0, 2);
            bufferUnknown1.setValue32(8, 90000);
            bufferUnknown1.setValue32(16, 90000);
            bufferUnknown1.setValue32(24, this.frameCount * 2);
            bufferUnknown1.setValue32(28, 2);
            bufferUnknown1.setUnsignedValue8(32, 0);
            bufferUnknown1.setUnsignedValue8(33, 1);
            TPointer bufferUnknown2 = mpegAvcYuvStruct.getPointer(this.getMEMemory(), 40);
            if (bufferUnknown2.isNull()) {
                bufferUnknown2 = this.defaultBufferUnknown2;
                mpegAvcYuvStruct.setPointer(40, bufferUnknown2);
            }
            bufferUnknown2.setUnsignedValue8(0, 0);
            bufferUnknown2.setValue32(24, 0);
            bufferUnknown2.setValue32(28, 0);
            buffer3.setValue8(0, (byte)1);
            buffer3.setValue8(1, (byte)-1);
            buffer3.setValue32(4, 3);
            buffer3.setValue32(8, 4);
            buffer3.setValue32(12, 1);
            buffer3.setValue8(16, (byte)0);
            buffer3.setValue32(20, 65536);
            buffer3.setValue32(32, 4004);
            buffer3.setValue32(36, 240000);
            ++this.frameCount;
            this.videocodecGetSEIType0(decodeSEI);
        }
        return result;
    }

    public void videocodecGetSEIType0(TPointer decodeSEI) {
        if (decodeSEI.isNotNull()) {
            decodeSEI.setValue8(0, (byte)2);
            decodeSEI.setValue32(8, 90000);
            decodeSEI.setValue32(16, 90000);
            decodeSEI.setValue32(24, (this.frameCount - 1) * 2);
            decodeSEI.setValue32(28, 2);
            decodeSEI.setValue8(32, (byte)0);
            decodeSEI.setValue8(33, (byte)1);
        }
    }

    public int videocodecDecodeType1(Memory mp4Memory, int mp4Data, int mp4Size, TPointer buffer2, int value) {
        int bufferCb;
        int result = this.videocodecDecode(mp4Memory, mp4Data, mp4Size);
        int frameWidth = this.videoCodec.getImageWidth();
        int frameHeight = this.videoCodec.getImageHeight();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceVideocodecDecode codec image size %dx%d, frame size %dx%d", this.videoCodec.getImageWidth(), this.videoCodec.getImageHeight(), frameWidth, frameHeight));
        }
        int frameBufferWidthY = this.videoCodec.getImageWidth();
        int frameBufferWidthCr = frameBufferWidthY / 2;
        int frameBufferWidthCb = frameBufferWidthY / 2;
        if (this.videoCodec.hasImage() && this.memoryAddr == 0) {
            int sizeY = frameBufferWidthY * frameHeight;
            int sizeCr = frameBufferWidthCr * (frameHeight / 2);
            int sizeCb = frameBufferWidthCr * (frameHeight / 2);
            int size = (sizeY + sizeCr + sizeCb) * 2;
            this.bufferY1 = this.memoryAddr = MEEmulator.getInstance().malloc(size);
            this.bufferY2 = this.bufferY1 + sizeY;
            this.bufferCr1 = this.bufferY1 + sizeY;
            this.bufferCb1 = this.bufferCr1 + sizeCr;
            this.bufferCr2 = this.bufferY2 + sizeY;
            this.bufferCb2 = this.bufferCr2 + sizeCr;
        }
        boolean buffer1 = (this.frameCount & 1) == 0;
        int bufferY = buffer1 ? this.bufferY1 : this.bufferY2;
        int bufferCr = buffer1 ? this.bufferCr1 : this.bufferCr2;
        int n = bufferCb = buffer1 ? this.bufferCb1 : this.bufferCb2;
        if (this.videoCodec.hasImage()) {
            Memory mem = this.getMEMemory();
            mem.memset(bufferY, (byte)-128, frameBufferWidthY * frameHeight);
            mem.memset(bufferCr, (byte)(buffer1 ? 80 : 128), frameBufferWidthCr * (frameHeight / 2));
            mem.memset(bufferCb, (byte)-128, frameBufferWidthCb * (frameHeight / 2));
            ++this.frameCount;
        }
        buffer2.setValue32(0, mp4Data);
        buffer2.setValue32(4, mp4Size);
        buffer2.setValue32(8, value);
        buffer2.setValue32(12, 64);
        buffer2.setValue32(16, 0);
        buffer2.setValue32(44, mp4Size);
        buffer2.setValue32(48, frameWidth);
        buffer2.setValue32(52, frameHeight);
        buffer2.setValue32(60, this.videoCodec.hasImage() ? 2 : 1);
        buffer2.setValue32(64, 1);
        buffer2.setValue32(72, -1);
        buffer2.setValue32(76, this.frameCount * 100);
        buffer2.setValue32(80, 2997);
        buffer2.setValue32(84, bufferY);
        buffer2.setValue32(88, bufferCr);
        buffer2.setValue32(92, bufferCb);
        buffer2.setValue32(96, frameBufferWidthY);
        buffer2.setValue32(100, frameBufferWidthCr);
        buffer2.setValue32(104, frameBufferWidthCb);
        return result;
    }

    private void videocodecDecoderStep(TPointer buffer, int type, IAction afterDecodeAction, int threadUid, long threadWakeupMicroTime) {
        IAction action;
        long delayMicros;
        if (buffer == null) {
            return;
        }
        MEMemory mp4Memory = MEEmulator.getInstance().getMEMemory();
        int mp4Data = buffer.getValue32(36);
        int mp4Size = buffer.getValue32(40);
        buffer.setValue32(8, 0);
        TPointer buffer2 = buffer.getPointer(16);
        switch (type) {
            case 0: {
                TPointer mpegAvcYuvStruct = buffer.getPointer(44);
                TPointer buffer3 = buffer.getPointer(48);
                TPointer decodeSEI = buffer.getPointer(80);
                this.videocodecDecodeType0(mp4Memory, mp4Data, mp4Size, buffer2, mpegAvcYuvStruct, buffer3, decodeSEI);
                break;
            }
            case 1: {
                this.videocodecDecodeType1(mp4Memory, mp4Data, mp4Size, buffer2, buffer.getValue32(56));
                break;
            }
            default: {
                log.warn((Object)String.format("sceVideocodecDecode unknown type=0x%X", type));
            }
        }
        if (afterDecodeAction != null) {
            afterDecodeAction.execute();
        }
        if ((delayMicros = threadWakeupMicroTime - Emulator.getClock().microTime()) > 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Further delaying thread=0x%X by %d microseconds", threadUid, delayMicros));
            }
            action = new DelayThreadAction(threadUid, (int)delayMicros, false, true);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unblocking thread=0x%X", threadUid));
            }
            action = new UnblockThreadAction(threadUid);
        }
        Emulator.getScheduler().addAction(action);
    }

    public static void write(TPointer addr, int length, int[] buffer, int offset) {
        int address;
        Memory mem;
        length = Math.min(length, buffer.length - offset);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("write addr=%s, length=0x%X", addr, length));
        }
        if ((mem = addr.getMemory()).hasMemoryInt(address = addr.getAddress())) {
            int length4 = length >> 2;
            int addrOffset = mem.getMemoryIntOffset(address);
            int[] memoryInt = mem.getMemoryInt(address);
            int j = offset;
            for (int i = 0; i < length4; ++i) {
                int value = buffer[j++] & 0xFF;
                value += (buffer[j++] & 0xFF) << 8;
                value += (buffer[j++] & 0xFF) << 16;
                memoryInt[addrOffset++] = value += buffer[j++] << 24;
            }
        } else {
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, length, 1);
            int j = offset;
            for (int i = 0; i < length; ++i) {
                memoryWriter.writeNext(buffer[j++] & 0xFF);
            }
            memoryWriter.flush();
        }
    }

    public void hleVideocodecStartDecoderThread() {
        if (this.videocodecDecoderThread == null) {
            this.videocodecDecoderThread = new VideocodecDecoderThread();
            this.videocodecDecoderThread.setDaemon(true);
            this.videocodecDecoderThread.setName("Videocodec Decoder Thread");
            this.videocodecDecoderThread.start();
        }
    }

    @HLEFunction(nid=-1071724503, version=150)
    public int sceVideocodecOpen(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        buffer.setValue32(0, 84936193);
        return Modules.sceMeVideoModule.sceMeVideo_driver_C441994C(type, buffer);
    }

    public int hleVideocodecDecode(TPointer buffer, int type, IAction afterDecodeAction) {
        int threadUid = Modules.ThreadManForUserModule.getCurrentThreadID();
        Modules.ThreadManForUserModule.hleBlockCurrentThread(264);
        this.videocodecDecoderThread.trigger(buffer, type, afterDecodeAction, threadUid, Emulator.getClock().microTime() + 4000L);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1561307570, version=150)
    public int sceVideocodecStop(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        if (this.videoCodec != null) {
            this.videoCodec = null;
        }
        return 0;
    }

    @HLEFunction(nid=386506506, version=150)
    public int sceVideocodecInit(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        buffer.setValue32(12, buffer.getValue32(20) + 8);
        return 0;
    }

    @HLEFunction(nid=758248881, version=150)
    public int sceVideocodecGetEDRAM(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        int size = buffer.getValue32(24) + 63 | 0x3F;
        this.edramAddr = MEEmulator.getInstance().malloc(size);
        if (this.edramAddr == 0) {
            return -1;
        }
        buffer.setValue32(20, Utilities.alignUp(this.edramAddr, 63));
        buffer.setValue32(92, this.edramAddr);
        return 0;
    }

    @HLEFunction(nid=1326844916, version=150)
    public int sceVideocodecReleaseEDRAM(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer) {
        buffer.setValue32(20, 0);
        buffer.setValue32(92, 0);
        if (this.edramAddr != 0) {
            MEEmulator.getInstance().free(this.edramAddr);
            this.edramAddr = 0;
        }
        return 0;
    }

    @HLEFunction(nid=-610110470, version=150)
    public int sceVideocodecDecode(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        if (type != 0 && type != 1) {
            log.warn((Object)String.format("sceVideocodecDecode unknown type=0x%X", type));
            return -1;
        }
        return this.hleVideocodecDecode(buffer, type, null);
    }

    @HLEUnimplemented
    @HLEFunction(nid=399473964, version=150)
    public int sceVideocodecGetFrameCrop() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=647134489, version=150)
    public int sceVideocodecGetVersion(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        buffer.setValue32(4, 120);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=792223359, version=150)
    public int sceVideocodecScanHeader() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=813592092, version=150)
    public int sceVideocodecDelete(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        this.videocodecDelete();
        Modules.ThreadManForUserModule.hleKernelDelayThread(40000, false);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1652260162, version=150)
    public int sceVideocodecGetSEI(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        TPointer decodeSEI = buffer.getPointer(80);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceVideocodecGetSEI storing decodeSEI to %s", decodeSEI));
        }
        decodeSEI.setValue32(28, 0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1952086906, version=150)
    public int sceVideocodecSetMemory(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer buffer, int type) {
        int unknown1 = buffer.getValue32(64);
        int unknown2 = buffer.getValue32(68);
        int unknown3 = buffer.getValue32(72);
        int unknown4 = buffer.getValue32(76);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceVideocodecSetMemory unknown1=0x%08X, unknown2=0x%08X, unknown3=0x%08X, unknown4=0x%08X", unknown1, unknown2, unknown3, unknown4));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1992609103, version=150)
    public int sceVideocodec_893B32B1() {
        return 0;
    }

    @HLEFunction(nid=-648272683, version=150)
    public int sceVideocodec_D95C24D5(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=56, usage=BufferInfo.Usage.in) TPointer buffer) {
        int height;
        int width = buffer.getValue32(0);
        if (((width | (height = buffer.getValue32(4))) & 0xF) != 0 || width == 0 || height == 0 || width > 720 || height > 576) {
            return -2141060610;
        }
        int size1 = (height >> 1) * (width >> 1);
        int size0 = (width & 0x10) == 0 ? size1 : (height >> 1) * (width + 32 >> 1);
        int size2 = size0 >> 1;
        int size3 = size1 >> 1;
        TPointer buffer0 = buffer.getPointer(12);
        TPointer buffer1 = buffer.getPointer(28);
        TPointer buffer2 = buffer.getPointer(16);
        TPointer buffer3 = buffer.getPointer(32);
        TPointer buffer4 = buffer.getPointer(20);
        TPointer buffer5 = buffer.getPointer(36);
        TPointer buffer6 = buffer.getPointer(24);
        TPointer buffer7 = buffer.getPointer(40);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer0=%s, size=0x%X", buffer0, size0));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer1=%s, size=0x%X", buffer1, size0));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer2=%s, size=0x%X", buffer2, size1));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer3=%s, size=0x%X", buffer3, size1));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer4=%s, size=0x%X", buffer4, size2));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer5=%s, size=0x%X", buffer5, size2));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer6=%s, size=0x%X", buffer6, size3));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 input buffer7=%s, size=0x%X", buffer7, size3));
        }
        sceMpegbase.YCbCrImageState imageState = new sceMpegbase.YCbCrImageState();
        sceMpegbase.read(imageState, width, height, buffer0.getMemory(), buffer0.getAddress(), buffer1.getAddress(), buffer2.getAddress(), buffer3.getAddress(), buffer4.getAddress(), buffer5.getAddress(), buffer6.getAddress(), buffer7.getAddress());
        int sizeY = width * height;
        int sizeCbCr = sizeY >> 2;
        if ((width & 0x70) == 112) {
            sizeY += height << 4;
            sizeCbCr += height << 2;
        }
        TPointer bufferY = buffer.getPointer(44);
        TPointer bufferCb = buffer.getPointer(48);
        TPointer bufferCr = buffer.getPointer(52);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceVideocodec_D95C24D5 output bufferY=%s, size=0x%X", bufferY, sizeY));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 output bufferCb=%s, size=0x%X", bufferCb, sizeCbCr));
            log.debug((Object)String.format("sceVideocodec_D95C24D5 output bufferCr=%s, size=0x%X", bufferCr, sizeCbCr));
        }
        sceMpegbase.write(bufferY, sizeY, imageState.luma, 0);
        sceMpegbase.write(bufferCb, sizeCbCr, imageState.cb, 0);
        sceMpegbase.write(bufferCr, sizeCbCr, imageState.cr, 0);
        imageState.releaseIntBuffers();
        return 0;
    }

    private class VideocodecDecoderThread
    extends Thread {
        private volatile boolean exit = false;
        private volatile boolean done = false;
        private Semaphore sema = new Semaphore(1);
        private TPointer buffer;
        private int type;
        private IAction afterDecodeAction;
        private int threadUid;
        private long threadWakeupMicroTime;

        private VideocodecDecoderThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            while (!this.exit) {
                if (!this.waitForTrigger(100) || this.exit) continue;
                sceVideocodec.this.videocodecDecoderStep(this.buffer, this.type, this.afterDecodeAction, this.threadUid, this.threadWakeupMicroTime);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exiting the VideocodecDecoderThread");
            }
            this.done = true;
        }

        public void exit() {
            this.exit = true;
            while (!this.done) {
                Utilities.sleep(1);
            }
        }

        public void trigger(TPointer buffer, int type, IAction afterDecodeAction, int threadUid, long threadWakeupMicroTime) {
            this.buffer = buffer;
            this.type = type;
            this.afterDecodeAction = afterDecodeAction;
            this.threadUid = threadUid;
            this.threadWakeupMicroTime = threadWakeupMicroTime;
            this.trigger();
        }

        private void trigger() {
            if (this.sema != null) {
                this.sema.release();
            }
        }

        private boolean waitForTrigger(int millis) {
            while (true) {
                try {
                    int availablePermits = this.sema.drainPermits();
                    if (availablePermits <= 0 && !this.sema.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return true;
        }
    }
}

