/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceNetIfHandle;
import jpcsp.HLE.kernel.types.SceNetIfMessage;
import jpcsp.HLE.kernel.types.SceNetWlanMessage;
import jpcsp.HLE.kernel.types.SceNetWlanScanInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.hardware.Wlan;
import jpcsp.network.IWlanAdapter;
import jpcsp.network.WlanAdapterFactory;
import jpcsp.network.accesspoint.AccessPoint;
import jpcsp.network.accesspoint.IAccessPointCallback;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceWlan
extends HLEModule
implements IAccessPointCallback {
    public static Logger log = Modules.getLogger("sceWlan");
    public static final int IOCTL_CMD_UNKNOWN_0x2 = 2;
    public static final int IOCTL_CMD_START_SCANNING = 52;
    public static final int IOCTL_CMD_CREATE = 53;
    public static final int IOCTL_CMD_CONNECT = 54;
    public static final int IOCTL_CMD_GET_INFO = 55;
    public static final int IOCTL_CMD_DISCONNECT = 56;
    public static final int IOCTL_CMD_UNKNOWN_0x42 = 66;
    public static final int IOCTL_CMD_ENTER_GAME_MODE = 68;
    public static final int IOCTL_CMD_SET_WEP_KEY = 71;
    public static final int WLAN_MODE_INFRASTRUCTURE = 1;
    public static final int WLAN_MODE_ADHOC = 2;
    private static final int wlanThreadPollingDelayUs = 12000;
    private static final int wlanScanActionDelayUs = 50000;
    private static final int wlanConnectActionDelayUs = 50000;
    private static final int wlanCreateActionDelayUs = 50000;
    private static final int wlanDisconnectActionDelayUs = 50000;
    public static final int[] channels = new int[]{1, 6, 11};
    private int joinedChannel;
    private TPointer wlanHandleAddr;
    private int wlanThreadUid;
    private int unknownValue1;
    private int unknownValue2;
    private int unknownValue3;
    private boolean isGameMode;
    private List<pspNetMacAddress> activeMacAddresses;
    private List<GameModeState> gameModeStates;
    private int gameModeDataLength;
    private String[] channelSSIDs;
    private int[] channelModes;
    private int wlanDropRate;
    private int wlanDropDuration;
    private AccessPoint accessPoint;
    private boolean scanInProgress;
    private int scanCallCount;
    private long scanCallTimestamp;
    private TPointer scanHandleAddr;
    private TPointer scanInputAddr;
    private TPointer scanOutputAddr;
    private String scanSsid;
    private int[] scanChannels;
    private int WLAN_LOOP_ADDRESS;
    private int WLAN_UP_CALLBACK_ADDRESS;
    private int WLAN_DOWN_CALLBACK_ADDRESS;
    private int WLAN_SEND_CALLBACK_ADDRESS;
    private int WLAN_IOCTL_CALLBACK_ADDRESS;
    private IWlanAdapter wlanAdapter;

    @Override
    public void start() {
        this.wlanThreadUid = Integer.MIN_VALUE;
        this.activeMacAddresses = new LinkedList<pspNetMacAddress>();
        this.gameModeStates = new LinkedList<GameModeState>();
        this.gameModeDataLength = 256;
        int maxChannel = -1;
        for (int i = 0; i < channels.length; ++i) {
            maxChannel = Math.max(maxChannel, channels[i]);
        }
        this.channelSSIDs = new String[maxChannel + 1];
        this.channelModes = new int[maxChannel + 1];
        this.joinedChannel = -1;
        this.scanSsid = null;
        this.scanChannels = null;
        this.WLAN_LOOP_ADDRESS = HLEUtilities.getInstance().installLoopHandler(this, "hleWlanThread");
        this.WLAN_UP_CALLBACK_ADDRESS = HLEUtilities.getInstance().installHLESyscall(this, "hleWlanUpCallback");
        this.WLAN_DOWN_CALLBACK_ADDRESS = HLEUtilities.getInstance().installHLESyscall(this, "hleWlanDownCallback");
        this.WLAN_SEND_CALLBACK_ADDRESS = HLEUtilities.getInstance().installHLESyscall(this, "hleWlanSendCallback");
        this.WLAN_IOCTL_CALLBACK_ADDRESS = HLEUtilities.getInstance().installHLESyscall(this, "hleWlanIoctlCallback");
        super.start();
    }

    @HLEFunction(nid=-1, version=150)
    public void hleWlanThread() {
        long now;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleWlanThread isGameMode=%b", this.isGameMode));
        }
        if (this.wlanThreadMustExit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Exiting hleWlanThread %s", Modules.ThreadManForUserModule.getCurrentThread()));
            }
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread(0);
        }
        if (this.isGameMode && !this.wlanThreadMustExit()) {
            this.hleWlanSendGameMode();
        }
        while (!this.wlanThreadMustExit() && this.hleWlanReceive()) {
        }
        if (this.scanInProgress && !this.wlanThreadMustExit() && (now = Scheduler.getNow()) - this.scanCallTimestamp >= 50000L) {
            this.hleWlanScanAction();
        }
        Modules.ThreadManForUserModule.hleKernelDelayThread(12000, true);
    }

    private boolean wlanThreadMustExit() {
        return this.wlanThreadUid != Modules.ThreadManForUserModule.getCurrentThreadID();
    }

    private void hleWlanScanAction() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanScanAction scanCallCount=%d", this.scanCallCount));
        }
        try {
            this.wlanAdapter.wlanScan(this.scanSsid, this.scanChannels);
        }
        catch (IOException e) {
            log.error((Object)"hleWlanScanAction", (Throwable)e);
        }
        if (this.scanCallCount < 20) {
            this.scanCallTimestamp = Scheduler.getNow();
            ++this.scanCallCount;
        } else {
            byte channel;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("End of scan action:", new Object[0]));
                for (int ch : channels) {
                    log.debug((Object)String.format("Scan result channel#%d, ssid='%s', mode=%d", ch, this.channelSSIDs[ch], this.channelModes[ch]));
                }
            }
            TPointer addr = new TPointer(this.scanOutputAddr);
            for (int i = 0; i < 14 && (channel = this.scanInputAddr.getValue8(10 + i)) != 0; ++i) {
                String ssid;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Scan on channel %d", channel));
                }
                if (!this.isValidChannel(channel) || (ssid = this.channelSSIDs[channel]) == null || ssid.length() <= 0) continue;
                SceNetWlanScanInfo scanInfo = new SceNetWlanScanInfo();
                scanInfo.bssid = "Jpcsp";
                scanInfo.channel = channel;
                scanInfo.ssid = ssid;
                scanInfo.mode = this.channelModes[channel];
                scanInfo.beaconInterval = 1000;
                scanInfo.write(addr.getMemory(), addr.getAddress() + 4);
                addr.setValue32(0, addr.getAddress() + 4 + scanInfo.sizeof());
                addr.add(4 + scanInfo.sizeof());
            }
            if (addr.getAddress() > this.scanOutputAddr.getAddress()) {
                addr.setValue32(-96, 0);
            }
            SceNetIfHandle handle = new SceNetIfHandle();
            handle.read(this.scanHandleAddr);
            this.scanHandleAddr = null;
            this.scanInputAddr = null;
            this.scanOutputAddr = null;
            this.scanInProgress = false;
            this.scanSsid = null;
            this.scanChannels = null;
            Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        }
    }

    private void hleWlanConnectAction(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanConnectAction handleAddr=%s", handleAddr));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
    }

    private void hleWlanCreateAction(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanCreateAction handleAddr=%s", handleAddr));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
    }

    private void hleWlanDisconnectAction(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanDisconnectAction handleAddr=%s", handleAddr));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
    }

    private boolean hleWlanReceiveMessage() {
        boolean packetReceived = false;
        try {
            byte[] bytes = new byte[10000];
            int dataLength = this.wlanAdapter.receiveWlanPacket(bytes, 0, bytes.length);
            if (dataLength < 0) {
                return packetReceived;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleWlanReceiveMessage message: %s", Utilities.getMemoryDump(bytes, 0, dataLength)));
            }
            packetReceived = true;
            SceNetIfMessage message = new SceNetIfMessage();
            int size = message.sizeof() + dataLength;
            int allocatedAddr = Modules.sceNetIfhandleModule.hleNetMallocInternal(size);
            if (allocatedAddr > 0) {
                Memory mem = Memory.getInstance();
                mem.memset(allocatedAddr, (byte)0, size);
                RuntimeContext.debugMemory(allocatedAddr, size);
                TPointer messageAddr = new TPointer(mem, allocatedAddr);
                TPointer data = new TPointer(messageAddr, message.sizeof());
                data.setArray(bytes, dataLength);
                SceNetWlanMessage wlanMessage = new SceNetWlanMessage();
                wlanMessage.read(data);
                Modules.sceWlanModule.addActiveMacAddress(wlanMessage.srcMacAddress);
                Modules.sceWlanModule.addActiveMacAddress(wlanMessage.dstMacAddress);
                message.dataAddr = data.getAddress();
                message.dataLength = dataLength;
                message.unknown16 = 1;
                message.type = 2;
                if (wlanMessage.dstMacAddress.isMulticastMacAddress()) {
                    message.type = wlanMessage.dstMacAddress.isAnyMacAddress() ? (message.type |= 0x100) : (message.type |= 0x200);
                }
                message.totalDataLength = dataLength;
                message.write(messageAddr);
                if (dataLength > 0) {
                    int sceNetIfEnqueue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Notifying received message: %s", message));
                        log.debug((Object)String.format("Message WLAN: %s", wlanMessage));
                        log.debug((Object)String.format("Message data: %s", Utilities.getMemoryDump(data, dataLength)));
                    }
                    if ((sceNetIfEnqueue = NIDMapper.getInstance().getAddressByName("sceNetIfEnqueue")) != 0) {
                        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
                        Modules.ThreadManForUserModule.executeCallback(thread, sceNetIfEnqueue, null, true, Modules.sceWlanModule.getHandleAddr().getAddress(), messageAddr.getAddress());
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"hleWlanReceiveMessage", (Throwable)e);
        }
        return packetReceived;
    }

    private boolean hleWlanReceive() {
        if (this.isGameMode) {
            return this.hleWlanReceiveGameMode();
        }
        return this.hleWlanReceiveMessage();
    }

    public boolean hasJoinedChannel() {
        return this.joinedChannel >= 0;
    }

    public int getJoinedChannel() {
        return this.joinedChannel;
    }

    public int getChannelMode(int channel) {
        return this.channelModes[channel];
    }

    public String getChannelSSID(int channel) {
        return this.channelSSIDs[channel];
    }

    public String getJoinedChannelSSID() {
        if (!this.hasJoinedChannel()) {
            return null;
        }
        return this.getChannelSSID(this.getJoinedChannel());
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public TPointer getHandleAddr() {
        return this.wlanHandleAddr;
    }

    public IWlanAdapter getWlanAdapter() {
        return this.wlanAdapter;
    }

    @Override
    public void sendPacketFromAccessPoint(byte[] buffer, int bufferLength, EtherFrame etherFrame) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendAccessPointPacket %s", Utilities.getMemoryDump(buffer, 0, bufferLength)));
        }
        try {
            this.wlanAdapter.sendAccessPointPacket(buffer, 0, bufferLength, etherFrame);
        }
        catch (IOException e) {
            log.error((Object)"sendPacketFromAccessPoint", (Throwable)e);
        }
    }

    private GameModeState getGameModeStat(byte[] macAddress) {
        GameModeState myGameModeState = null;
        for (GameModeState gameModeState : this.gameModeStates) {
            if (!gameModeState.macAddress.equals(macAddress)) continue;
            myGameModeState = gameModeState;
            break;
        }
        return myGameModeState;
    }

    private GameModeState getMyGameModeState() {
        return this.getGameModeStat(Wlan.getMacAddress());
    }

    public void addActiveMacAddress(pspNetMacAddress macAddress) {
        if (!sceNetAdhoc.isAnyMacAddress(macAddress.macAddress) && !this.activeMacAddresses.contains(macAddress)) {
            this.activeMacAddresses.add(macAddress);
            this.gameModeStates.add(new GameModeState(macAddress));
        }
    }

    private boolean isValidChannel(int channel) {
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] != channel) continue;
            return true;
        }
        return false;
    }

    public void setChannelSSID(int channel, String ssid, int mode) {
        if (ssid != null && ssid.length() > 0 && this.isValidChannel(channel)) {
            this.channelSSIDs[channel] = ssid;
            this.channelModes[channel] = mode;
        }
    }

    private void joinChannelSSID(int channel, String ssid, int mode) {
        this.setChannelSSID(channel, ssid, mode);
        this.joinedChannel = channel;
    }

    private void hleWlanSendGameMode() {
        GameModeState myGameModeState = this.getMyGameModeState();
        if (myGameModeState == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanSendGameMode sending packet: %s", Utilities.getMemoryDump(myGameModeState.data, 0, myGameModeState.dataLength)));
        }
        try {
            this.wlanAdapter.sendGameModePacket(myGameModeState.macAddress, myGameModeState.data, 0, myGameModeState.dataLength);
        }
        catch (IOException e) {
            log.error((Object)"hleWlanSendGameMode", (Throwable)e);
        }
        myGameModeState.updated = false;
    }

    private boolean hleWlanReceiveGameMode() {
        boolean packetReceived = false;
        pspNetMacAddress macAddress = new pspNetMacAddress();
        try {
            byte[] bytes = new byte[this.gameModeDataLength];
            int dataLength = this.wlanAdapter.receiveGameModePacket(macAddress, bytes, 0, bytes.length);
            if (dataLength < 0) {
                return packetReceived;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleWlanReceiveGameMode message: %s", Utilities.getMemoryDump(bytes, 0, dataLength)));
            }
            packetReceived = true;
            GameModeState gameModeState = this.getGameModeStat(macAddress.macAddress);
            if (gameModeState != null) {
                int length = Math.min(dataLength, gameModeState.dataLength);
                System.arraycopy(bytes, 0, gameModeState.data, 0, length);
                gameModeState.doUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanReceiveGameMode updated GameModeState %s", gameModeState));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleWlanReceiveGameMode could not find GameModeState for MAC address %s", macAddress));
            }
        }
        catch (SocketTimeoutException bytes) {
        }
        catch (IOException e) {
            log.error((Object)"hleWlanReceiveMessage", (Throwable)e);
        }
        return packetReceived;
    }

    protected void hleWlanSendMessage(TPointer handleAddr, SceNetIfMessage message) {
        Memory mem = handleAddr.getMemory();
        SceNetWlanMessage wlanMessage = new SceNetWlanMessage();
        wlanMessage.read(mem, message.dataAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanSendMessage message: %s: %s", message, Utilities.getMemoryDump(message.getBaseAddress(), message.sizeof())));
            log.debug((Object)String.format("hleWlanSendMessage WLAN message : %s", wlanMessage));
            log.debug((Object)String.format("hleWlanSendMessage message data: %s", Utilities.getMemoryDump(message.dataAddr + wlanMessage.sizeof(), message.dataLength - wlanMessage.sizeof())));
        }
        byte[] messageBytes = null;
        while (true) {
            if (message.dataLength > 0) {
                int messageBytesOffset = messageBytes == null ? 0 : messageBytes.length;
                messageBytes = Utilities.extendArray(messageBytes, message.dataLength);
                Utilities.readBytes(message.dataAddr, message.dataLength, messageBytes, messageBytesOffset);
            }
            if (message.nextDataAddr == 0) break;
            message.read(mem, message.nextDataAddr);
        }
        if (messageBytes != null) {
            try {
                this.wlanAdapter.sendWlanPacket(messageBytes, 0, messageBytes.length);
            }
            catch (IOException e) {
                log.error((Object)"hleWlanSendMessage", (Throwable)e);
            }
        }
    }

    private void afterNetIfDequeue(TPointer handleAddr, int returnValue) {
        if (returnValue <= 0) {
            log.error((Object)String.format("sceNetIfDequeue returned error 0x%08X", returnValue));
            return;
        }
        Memory mem = handleAddr.getMemory();
        TPointer firstMessageAddr = new TPointer(mem, returnValue);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanSendCallback handleAddr=%s, firstMessageAddr=%s", handleAddr, firstMessageAddr));
        }
        SceNetIfMessage message = new SceNetIfMessage();
        message.read(firstMessageAddr);
        RuntimeContext.debugMemory(firstMessageAddr.getAddress(), message.sizeof());
        this.hleWlanSendMessage(handleAddr, message);
        int sceNetMFreem = NIDMapper.getInstance().getAddressByName("sceNetMFreem");
        if (sceNetMFreem != 0) {
            Modules.ThreadManForUserModule.executeCallback(null, sceNetMFreem, null, true, firstMessageAddr.getAddress());
        } else {
            Modules.sceNetIfhandleModule.sceNetMFreem(firstMessageAddr);
        }
    }

    @HLEFunction(nid=-1, version=150)
    public int hleWlanSendCallback(TPointer handleAddr) {
        int sceNetIfDequeue = NIDMapper.getInstance().getAddressByName("sceNetIfDequeue");
        if (sceNetIfDequeue != 0) {
            Modules.ThreadManForUserModule.executeCallback(null, sceNetIfDequeue, (IAction)new AfterNetIfDequeueAction(handleAddr), true, handleAddr.getAddress());
        } else {
            this.afterNetIfDequeue(handleAddr, Modules.sceNetIfhandleModule.sceNetIfDequeue(handleAddr));
        }
        return 0;
    }

    @HLEFunction(nid=-1, version=150)
    public int hleWlanUpCallback(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanUpCallback handleAddr: %s", Utilities.getMemoryDump(handleAddr.getAddress(), 44)));
            int handleInternalAddr = handleAddr.getValue32();
            if (handleInternalAddr != 0) {
                log.debug((Object)String.format("hleWlanUpCallback handleInternalAddr: %s", Utilities.getMemoryDump(handleInternalAddr, 320)));
            }
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanUpCallback handleAddr=%s: %s", handleAddr, handle));
        }
        this.wlanHandleAddr = handleAddr;
        this.wlanAdapter = WlanAdapterFactory.createWlanAdapter();
        try {
            this.wlanAdapter.start();
        }
        catch (IOException e) {
            log.error((Object)"hleWlanUpCallback", (Throwable)e);
        }
        this.addActiveMacAddress(new pspNetMacAddress(Wlan.getMacAddress()));
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.hleKernelCreateThread("SceWlanHal", this.WLAN_LOOP_ADDRESS, 39, 2048, 0, 0, 1);
        if (thread != null) {
            this.wlanThreadUid = thread.uid;
            Modules.ThreadManForUserModule.hleKernelStartThread(thread, 0, TPointer.NULL, 0);
        }
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        return 0;
    }

    @HLEFunction(nid=-1, version=150)
    public int hleWlanDownCallback(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanDownCallback handleAddr: %s", Utilities.getMemoryDump(handleAddr.getAddress(), 44)));
            int handleInternalAddr = handleAddr.getValue32();
            if (handleInternalAddr != 0) {
                log.debug((Object)String.format("hleWlanDownCallback handleInternalAddr: %s", Utilities.getMemoryDump(handleInternalAddr, 320)));
            }
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanDownCallback handleAddr=%s: %s", handleAddr, handle));
        }
        this.wlanThreadUid = Integer.MIN_VALUE;
        try {
            this.wlanAdapter.stop();
        }
        catch (IOException e) {
            log.error((Object)"hleWlanDownCallback", (Throwable)e);
        }
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        return 0;
    }

    @HLEFunction(nid=-1, version=150)
    public int hleWlanIoctlCallback(TPointer handleAddr, int cmd, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.in) TPointer unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.in) TPointer32 buffersAddr) {
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Memory mem = Memory.getInstance();
        int inputAddr = buffersAddr.getValue(0);
        int outputAddr = buffersAddr.getValue(4);
        if (log.isDebugEnabled()) {
            int inputLength = 128;
            int outputLength = 128;
            switch (cmd) {
                case 52: {
                    inputLength = 76;
                    outputLength = 1536;
                    break;
                }
                case 53: {
                    inputLength = 112;
                    break;
                }
                case 54: {
                    inputLength = 112;
                    break;
                }
                case 55: {
                    inputLength = 96;
                    break;
                }
                case 68: {
                    inputLength = 80;
                    outputLength = 6;
                    break;
                }
                case 71: {
                    inputLength = 160;
                    break;
                }
                case 66: {
                    break;
                }
            }
            log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, handleAddr=%s: %s", cmd, handleAddr, handle));
            if (inputAddr != 0 && Memory.isAddressGood(inputAddr) && inputLength > 0) {
                log.debug((Object)String.format("hleWlanIoctlCallback inputAddr: %s", Utilities.getMemoryDump(inputAddr, inputLength)));
                RuntimeContext.debugMemory(inputAddr, inputLength);
            }
            if (outputAddr != 0 && Memory.isAddressGood(outputAddr) && outputLength > 0) {
                log.debug((Object)String.format("hleWlanIoctlCallback outputAddr: %s", Utilities.getMemoryDump(outputAddr, outputLength)));
                RuntimeContext.debugMemory(outputAddr, outputLength);
            }
            RuntimeContext.debugMemory(unknown.getAddress(), 32);
        }
        boolean signalSema = true;
        int errorCode = 0;
        switch (cmd) {
            case 52: {
                int mode = mem.read32(inputAddr + 0);
                int channel = mem.read8(inputAddr + 10);
                if (channel == this.joinedChannel && mem.read8(inputAddr + 11) == 0) {
                    SceNetWlanScanInfo scanInfo = new SceNetWlanScanInfo();
                    scanInfo.bssid = "Jpcsp";
                    scanInfo.channel = channel;
                    scanInfo.ssid = this.channelSSIDs[channel];
                    scanInfo.mode = this.channelModes[channel];
                    scanInfo.beaconInterval = 1000;
                    scanInfo.write(handleAddr.getMemory(), outputAddr + 4);
                    mem.write32(outputAddr, 0);
                    break;
                }
                int ssidLength = mem.read8(inputAddr + 24);
                String ssid = Utilities.readStringNZ(mem, inputAddr + 28, ssidLength);
                if (channel != this.joinedChannel) {
                    this.setChannelSSID(channel, ssid, mode);
                }
                signalSema = false;
                this.scanHandleAddr = handleAddr;
                this.scanInputAddr = new TPointer(handleAddr.getMemory(), inputAddr);
                this.scanOutputAddr = new TPointer(handleAddr.getMemory(), outputAddr);
                this.scanSsid = ssid;
                this.scanChannels = new int[]{channel};
                this.scanCallCount = 0;
                this.scanCallTimestamp = 0L;
                this.scanInProgress = true;
                break;
            }
            case 53: {
                int channel = mem.read8(inputAddr + 6);
                int ssidLength = mem.read8(inputAddr + 7);
                String ssid = Utilities.readStringNZ(mem, inputAddr + 8, ssidLength);
                int mode = mem.read32(inputAddr + 40);
                int unknown44 = mem.read32(inputAddr + 44);
                int unknown62 = mem.read16(inputAddr + 62);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, channel=%d, ssid='%s', mode=0x%X, unknown44=0x%X, unknown62=0x%X", cmd, channel, ssid, mode, unknown44, unknown62));
                }
                this.joinChannelSSID(channel, ssid, mode);
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, new WlanCreateAction(handleAddr));
                break;
            }
            case 54: {
                SceNetWlanScanInfo scanInfo = new SceNetWlanScanInfo();
                scanInfo.read(mem, inputAddr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, channel=%d, ssid='%s', mode=0x%X", cmd, scanInfo.channel, scanInfo.ssid, scanInfo.mode));
                }
                this.joinChannelSSID(scanInfo.channel, scanInfo.ssid, scanInfo.mode);
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, new WlanConnectAction(handleAddr));
                break;
            }
            case 55: {
                mem.memset(inputAddr, (byte)0, 40);
                if (this.joinedChannel < 0) break;
                String bssid = "Jpcsp";
                Utilities.writeStringNZ(mem, inputAddr + 0, 6, bssid);
                mem.write8(inputAddr + 6, (byte)this.joinedChannel);
                mem.write8(inputAddr + 7, (byte)this.channelSSIDs[this.joinedChannel].length());
                Utilities.writeStringNZ(mem, inputAddr + 8, 32, this.channelSSIDs[this.joinedChannel]);
                break;
            }
            case 56: {
                this.isGameMode = false;
                this.joinedChannel = -1;
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, new WlanDisconnectAction(handleAddr));
                break;
            }
            case 68: {
                pspNetMacAddress multicastMacAddress = new pspNetMacAddress();
                multicastMacAddress.read(mem, inputAddr + 6);
                int ssidLength = mem.read8(inputAddr + 12);
                String ssid = Utilities.readStringNZ(mem, inputAddr + 14, ssidLength);
                pspNetMacAddress masterMacAddress = new pspNetMacAddress();
                masterMacAddress.read(mem, outputAddr + 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, ssid='%s', multicastMacAddress=%s, masterMacAddress=%s", cmd, ssid, multicastMacAddress, masterMacAddress));
                }
                this.isGameMode = true;
                break;
            }
            case 71: {
                int unknown1 = mem.read32(inputAddr + 0);
                int unknown2 = mem.read32(inputAddr + 4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback unknown1=0x%X, unknown2=0x%X", unknown1, unknown2));
                }
                int wepKeyAddr = inputAddr + 12;
                for (int i = 0; i < 4; ++i) {
                    int mode = mem.read32(wepKeyAddr + 0);
                    String wepKey = Utilities.readStringNZ(wepKeyAddr + 4, 13);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, wekKey#%d: mode=0x%X, wepKey='%s'", cmd, i, mode, wepKey));
                    }
                    wepKeyAddr += 20;
                }
                break;
            }
            default: {
                log.warn((Object)String.format("hleWlanIoctlCallback unknown cmd=0x%X", cmd));
            }
        }
        handle.handleInternal.errorCode = errorCode;
        handle.write(handleAddr);
        if (signalSema) {
            Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        }
        return 0;
    }

    private void afterNetCreateIfhandleEtherAction(SceKernelThreadInfo thread, TPointer handleAddr) {
        int tempMem = Modules.sceNetIfhandleModule.hleNetMallocInternal(32);
        if (tempMem <= 0) {
            return;
        }
        int macAddressAddr = tempMem;
        int interfaceNameAddr = tempMem + 8;
        pspNetMacAddress macAddress = new pspNetMacAddress(Wlan.getMacAddress());
        macAddress.write(handleAddr.getMemory(), macAddressAddr);
        Utilities.writeStringZ(handleAddr.getMemory(), interfaceNameAddr, "wlan");
        int sceNetAttachIfhandleEther = NIDMapper.getInstance().getAddressByName("sceNetAttachIfhandleEther");
        if (sceNetAttachIfhandleEther == 0) {
            return;
        }
        Modules.ThreadManForUserModule.executeCallback(thread, sceNetAttachIfhandleEther, null, true, handleAddr.getAddress(), macAddressAddr, interfaceNameAddr);
    }

    private int createWlanInterface() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using MAC address %s", sceNet.convertMacAddressToString(Wlan.getMacAddress())));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.callbackArg4 = 0x11040404;
        handle.upCallbackAddr = this.WLAN_UP_CALLBACK_ADDRESS;
        handle.downCallbackAddr = this.WLAN_DOWN_CALLBACK_ADDRESS;
        handle.sendCallbackAddr = this.WLAN_SEND_CALLBACK_ADDRESS;
        handle.ioctlCallbackAddr = this.WLAN_IOCTL_CALLBACK_ADDRESS;
        int handleMem = Modules.sceNetIfhandleModule.hleNetMallocInternal(handle.sizeof());
        TPointer handleAddr = new TPointer(Memory.getInstance(), handleMem);
        handle.write(handleAddr);
        RuntimeContext.debugMemory(handleAddr.getAddress(), handle.sizeof());
        int sceNetCreateIfhandleEther = NIDMapper.getInstance().getAddressByName("sceNetCreateIfhandleEther");
        if (sceNetCreateIfhandleEther == 0) {
            int result = Modules.sceNetIfhandleModule.hleNetCreateIfhandleEther(handleAddr);
            if (result < 0) {
                return result;
            }
            result = Modules.sceNetIfhandleModule.hleNetAttachIfhandleEther(handleAddr, new pspNetMacAddress(Wlan.getMacAddress()), "wlan");
            if (result < 0) {
                return result;
            }
        } else {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, sceNetCreateIfhandleEther, (IAction)new AfterNetCreateIfhandleEtherAction(thread, handleAddr), false, handleAddr.getAddress());
        }
        this.accessPoint = new AccessPoint(this);
        return 0;
    }

    @HLEFunction(nid=207757441, version=150, checkInsideInterrupt=true)
    public int sceWlanGetEtherAddr(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.out) TPointer etherAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(Wlan.getMacAddress());
        macAddress.write(etherAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceWlanGetEtherAddr returning %s", macAddress));
        }
        return 0;
    }

    @HLEFunction(nid=-680118631, version=150)
    public int sceWlanGetSwitchState() {
        return Wlan.getSwitchState();
    }

    @HLEFunction(nid=-1824257263, version=150)
    public int sceWlanDevIsPowerOn() {
        return Wlan.getSwitchState();
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1210887834, version=150), @HLEFunction(nid=471397886, version=660)})
    public int sceWlanDevAttach() {
        int result = this.createWlanInterface();
        if (result < 0) {
            log.error((Object)String.format("Cannot create the WLAN Interface: 0x%08X", result));
            return result;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-911684937, version=150), @HLEFunction(nid=-1913373364, version=660)})
    public int sceWlanDevDetach() {
        if (this.accessPoint != null) {
            this.accessPoint.exit();
            this.accessPoint = null;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1923132133, version=150), @HLEFunction(nid=1444925814, version=660)})
    public int sceWlanDrv_lib_8D5F551B(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1956348218, version=150), @HLEFunction(nid=1491980608, version=660)})
    public int sceWlanSetHostDiscover(int unknown1, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-24507578, version=150), @HLEFunction(nid=212553743, version=660)})
    public int sceWlanSetWakeUp(int unknown1, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer unknown2) {
        return 0;
    }

    @HLEFunction(nid=1585221012, version=150)
    public boolean sceWlanDevIsGameMode() {
        return this.isGameMode;
    }

    @HLEFunctions(value={@HLEFunction(nid=1590953114, version=150), @HLEFunction(nid=-310780716, version=660)})
    public int sceWlanGPPrevEstablishActive(pspNetMacAddress macAddress) {
        int index = 0;
        for (pspNetMacAddress activeMacAddress : this.activeMacAddresses) {
            if (activeMacAddress.equals(macAddress.macAddress)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1538846662, version=150), @HLEFunction(nid=81503251, version=660)})
    public int sceWlanGPRecv(int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer buffer, int bufferLength, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.out) TPointer updateInfoAddr) {
        if (!this.isGameMode) {
            return -2143220460;
        }
        if (id < 0 || id >= this.gameModeStates.size()) {
            return -2143220461;
        }
        if (bufferLength < 0 || bufferLength > this.gameModeDataLength) {
            return -2143220461;
        }
        GameModeState gameModeState = this.gameModeStates.get(id);
        int size = Math.min(gameModeState.dataLength, bufferLength);
        Utilities.writeBytes(buffer.getAddress(), size, gameModeState.data, 0);
        if (updateInfoAddr.isNotNull()) {
            sceNetAdhoc.GameModeUpdateInfo updateInfo = new sceNetAdhoc.GameModeUpdateInfo();
            updateInfo.read(updateInfoAddr);
            updateInfo.updated = gameModeState.updated ? 1 : 0;
            updateInfo.timeStamp = gameModeState.timeStamp;
            updateInfo.write(updateInfoAddr);
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1260926092, version=150), @HLEFunction(nid=-289212245, version=660)})
    public int sceWlanGPSend(int unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer buffer, int bufferLength) {
        if (!this.isGameMode) {
            return -2143220460;
        }
        if (bufferLength < 0 || bufferLength > this.gameModeDataLength) {
            return -2143220461;
        }
        GameModeState myGameModeState = this.getMyGameModeState();
        if (myGameModeState == null) {
            log.error((Object)String.format("sceWlanGPSend not found my GameModeState!", new Object[0]));
            return -1;
        }
        Utilities.readBytes(buffer.getAddress(), bufferLength, myGameModeState.data, 0);
        myGameModeState.doUpdate();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=756002382, version=150)
    public int sceWlanDrv_lib_2D0FAE4E(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.in) TPointer16 unknown) {
        this.unknownValue1 = unknown.getValue(0);
        this.unknownValue2 = unknown.getValue(2);
        this.unknownValue3 = unknown.getValue(4);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1458857930, version=150)
    public int sceWlanDrv_lib_56F467CA(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.out) TPointer16 unknown) {
        unknown.setValue(0, this.unknownValue1);
        unknown.setValue(2, this.unknownValue2);
        unknown.setValue(4, this.unknownValue3);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1537875941, version=150)
    public int sceWlanDrv_lib_5BAA1FE5(int unknown1, int unknown2) {
        return 0;
    }

    @HLEFunction(nid=622455463, version=150)
    public boolean sceWlanIsPacketToBeDropped() {
        return false;
    }

    @HLEFunction(nid=845115762, version=150)
    public int sceWlanSetDropRate(int dropRate, int dropDuration) {
        this.wlanDropRate = dropRate;
        this.wlanDropDuration = dropDuration;
        return 0;
    }

    @HLEFunction(nid=-1230409715, version=150)
    public int sceWlanGetDropRate(@CanBeNull TPointer32 dropRateAddr, @CanBeNull TPointer32 dropDurationAddr) {
        dropRateAddr.setValue(this.wlanDropRate);
        dropDurationAddr.setValue(this.wlanDropDuration);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1864019185, version=150)
    public void sceWlanDrv_driver_90E5530F(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer wlanDriver1, int wlanDriver1Size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer wlanDriver2, int wlanDriver2Size) {
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1772566025, version=150), @HLEFunction(nid=48655416, version=660)})
    public int sceWlanGPRegisterCallback(int callbackUid) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1283416800, version=150), @HLEFunction(nid=1417038360, version=660)})
    public int sceWlanGPUnRegisterCallback(int callbackUid) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=100545036, version=150)
    public int sceWlanDrv_lib_05FE320C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=434446164, version=150)
    public int sceWlanDrv_lib_19E51F54() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=450999145, version=150)
    public int sceWlanDrv_lib_1AE1B369() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1085319754, version=150)
    public int sceWlanDrv_lib_40B0AA4A() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1256104399, version=150)
    public int sceWlanDrv_lib_4ADEA1CF() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1276426954, version=150)
    public int sceWlanDrv_lib_4C14BACA() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1834779550, version=150)
    public int sceWlanDrv_lib_6D5C839E() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2146782162, version=150)
    public int sceWlanDrv_lib_7FF54BD2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2124964554, version=150)
    public int sceWlanDrv_lib_81579D36() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=59200058, version=150)
    public int sceWlanDrv_driver_0387523A() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=68686019, version=150)
    public int sceWlanDrv_driver_041810C3() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1408802126, version=150)
    public int sceWlanDrv_driver_53F89D4E() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1580882643, version=150)
    public int sceWlanDrv_driver_5E3A5AD3() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1621129449, version=150)
    public int sceWlanDrv_driver_60A078E9() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1734630751, version=150)
    public int sceWlanDrv_driver_67645D5F() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2081342121, version=150)
    public int sceWlanDrv_driver_7C0EC2A9() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2111010940, version=150)
    public int sceWlanDrv_driver_7DD3787C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1602034014, version=150)
    public int sceWlanDrv_driver_A082E6A2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1444502163, version=150)
    public int sceWlanDrv_driver_A9E6A56D() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1317764677, version=150)
    public int sceWlanDrv_driver_B17481BB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-994257903, version=150)
    public int sceWlanDrv_driver_C4BCD411() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-305002575, version=150)
    public int sceWlanDrv_driver_EDD207B1() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-294368420, version=150)
    public int sceWlanDrv_driver_EE744B5C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-149744577, version=150)
    public int sceWlanDrv_driver_F713143F() {
        return 0;
    }

    private class AfterNetCreateIfhandleEtherAction
    implements IAction {
        private SceKernelThreadInfo thread;
        private TPointer handleAddr;

        public AfterNetCreateIfhandleEtherAction(SceKernelThreadInfo thread, TPointer handleAddr) {
            this.thread = thread;
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.afterNetCreateIfhandleEtherAction(this.thread, this.handleAddr);
        }
    }

    private class AfterNetIfDequeueAction
    implements IAction {
        private TPointer handleAddr;

        public AfterNetIfDequeueAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.afterNetIfDequeue(this.handleAddr, Emulator.getProcessor().cpu._v0);
        }
    }

    private class WlanDisconnectAction
    implements IAction {
        private TPointer handleAddr;

        public WlanDisconnectAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanDisconnectAction(this.handleAddr);
        }
    }

    private class WlanCreateAction
    implements IAction {
        private TPointer handleAddr;

        public WlanCreateAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanCreateAction(this.handleAddr);
        }
    }

    private class WlanConnectAction
    implements IAction {
        private TPointer handleAddr;

        public WlanConnectAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanConnectAction(this.handleAddr);
        }
    }

    private static class GameModeState {
        public long timeStamp;
        public boolean updated;
        public pspNetMacAddress macAddress;
        public byte[] data;
        public int dataLength;

        public GameModeState(pspNetMacAddress macAddress) {
            this.macAddress = macAddress;
            this.dataLength = Modules.sceWlanModule.gameModeDataLength;
            this.data = new byte[this.dataLength];
        }

        public void doUpdate() {
            this.updated = true;
            this.timeStamp = SystemTimeManager.getSystemTime();
        }

        public String toString() {
            return String.format("macAddress=%s, updated=%b, timeStamp=%d, dataLength=0x%X, data=%s", this.macAddress, this.updated, this.timeStamp, this.dataLength, Utilities.getMemoryDump(this.data, 0, this.dataLength));
        }
    }
}

