/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import jpcsp.Allegrex.Interpreter;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.Processor;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.KeyVault;
import jpcsp.format.KL4E;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class PRX {
    public static Logger log = CryptoEngine.log;
    public static final int SCE_EXEC_FILE_COMPRESSED = 1;
    public static final int SCE_EXEC_FILE_ELF = 2;
    public static final int SCE_EXEC_FILE_GZIP_OVERLAP = 8;
    public static final int SCE_EXEC_FILE_KL4E_COMPRESSED = 512;
    public static final int DECRYPT_MODE_NO_EXEC = 0;
    public static final int DECRYPT_MODE_BOGUS_MODULE = 1;
    public static final int DECRYPT_MODE_KERNEL_MODULE = 2;
    public static final int DECRYPT_MODE_VSH_MODULE = 3;
    public static final int DECRYPT_MODE_USER_MODULE = 4;
    public static final int DECRYPT_MODE_UMD_GAME_EXEC = 9;
    public static final int DECRYPT_MODE_GAMESHARING_EXEC = 10;
    public static final int DECRYPT_MODE_MS_UPDATER = 12;
    public static final int DECRYPT_MODE_DEMO_EXEC = 13;
    public static final int DECRYPT_MODE_APP_MODULE = 14;
    public static final int DECRYPT_MODE_INSTALL_EXEC = 18;
    public static final int DECRYPT_MODE_POPS_EXEC = 20;
    public static final int DECRYPT_MODE_SPRX = 23;
    private TAG_INFO[] g_tagInfo = new TAG_INFO[]{new TAG_INFO(1284807920, KeyVault.keys210_vita_k0, 67), new TAG_INFO(1284805872, KeyVault.keys660_k1, 67), new TAG_INFO(1284806128, KeyVault.keys660_k2, 67), new TAG_INFO(1284804848, KeyVault.keys660_k3, 67), new TAG_INFO(1284805104, KeyVault.keys660_k8, 67), new TAG_INFO(1284805616, KeyVault.keys660_k4, 67), new TAG_INFO(1284806640, KeyVault.keys660_k5, 67), new TAG_INFO(1284805360, KeyVault.keys660_k6, 67), new TAG_INFO(1284806384, KeyVault.keys660_k7, 67), new TAG_INFO(1165725936, KeyVault.keys660_v1, 91), new TAG_INFO(1165726192, KeyVault.keys660_v7, 91), new TAG_INFO(1165726448, KeyVault.keys660_v6, 91), new TAG_INFO(1165726704, KeyVault.keys660_v3, 91), new TAG_INFO(939692272, KeyVault.keys660_v2, 90), new TAG_INFO(939692528, KeyVault.keys660_v8, 90), new TAG_INFO(939692784, KeyVault.keys660_v4, 90), new TAG_INFO(939693040, KeyVault.keys660_v5, 90), new TAG_INFO(1284803824, KeyVault.keys639_k3, 67), new TAG_INFO(1284804080, KeyVault.keys638_k4, 67), new TAG_INFO(1284803568, KeyVault.keys636_k2, 67), new TAG_INFO(1284803312, KeyVault.keys636_k1, 67), new TAG_INFO(1165724400, KeyVault.keys636_1, 91), new TAG_INFO(1284802544, KeyVault.keys630_k8, 67), new TAG_INFO(1165722608, KeyVault.keys630_k7, 91), new TAG_INFO(1284802288, KeyVault.keys630_k6, 67), new TAG_INFO(1165722352, KeyVault.keys630_k5, 91), new TAG_INFO(1165722096, KeyVault.keys630_k4, 91), new TAG_INFO(1284802032, KeyVault.keys630_k3, 67), new TAG_INFO(1165721840, KeyVault.keys630_k2, 91), new TAG_INFO(1284801776, KeyVault.keys630_k1, 67), new TAG_INFO(1284800752, KeyVault.keys630_k0, 67), new TAG_INFO(1165699312, KeyVault.keys620_e, 91), new TAG_INFO(1165692144, KeyVault.keys620_a, 91), new TAG_INFO(939665648, KeyVault.keys620_5v, 90), new TAG_INFO(1284778736, KeyVault.keys620_5k, 67), new TAG_INFO(1284778224, KeyVault.keys620_5, 67), new TAG_INFO(1284775408, KeyVault.keys620_1, 67), new TAG_INFO(1284775152, KeyVault.keys620_0, 67), new TAG_INFO(1284776688, KeyVault.keys600_2, 67), new TAG_INFO(1284775664, KeyVault.keys600_1, 67), new TAG_INFO(1284778480, KeyVault.keys570_5k, 67), new TAG_INFO(1284774896, KeyVault.keys555_k2, 67), new TAG_INFO(1284774640, KeyVault.keys555_k1, 67), new TAG_INFO(1165691888, KeyVault.keys505_a, 91), new TAG_INFO(1284776176, KeyVault.keys505_k2, 67), new TAG_INFO(1284774384, KeyVault.keys505_1, 67), new TAG_INFO(1284774128, KeyVault.keys505_0, 67), new TAG_INFO(1165696752, KeyVault.keys500_c, 91), new TAG_INFO(1284775920, KeyVault.keys500_2, 67), new TAG_INFO(1284773872, KeyVault.keys500_1, 67), new TAG_INFO(1284773616, KeyVault.keys500_0, 67), new TAG_INFO(1284773104, KeyVault.keys390_0, 67), new TAG_INFO(1284773360, KeyVault.keys390_1, 67), new TAG_INFO(1284772592, KeyVault.keys370_0, 67), new TAG_INFO(1284772848, KeyVault.keys370_1, 67), new TAG_INFO(1165693168, KeyVault.keys370_2, 91), new TAG_INFO(1284771312, KeyVault.keys360_0, 67), new TAG_INFO(1284772080, KeyVault.keys360_1, 67), new TAG_INFO(1284770800, KeyVault.keys330_0, 67), new TAG_INFO(1165691632, KeyVault.keys330_1, 91), new TAG_INFO(939657968, KeyVault.keys330_2, 90), new TAG_INFO(1284770544, KeyVault.keys330_3, 67), new TAG_INFO(1284771056, KeyVault.keys330_4, 67), new TAG_INFO(-806417936, KeyVault.keys310_0, 98), new TAG_INFO(1165691120, KeyVault.keys310_1, 91), new TAG_INFO(939657456, KeyVault.keys310_2, 90), new TAG_INFO(-806418192, KeyVault.keys310_3, 98), new TAG_INFO(-806418448, KeyVault.keys303_0, 98), new TAG_INFO(-806418704, KeyVault.keys300_0, 98), new TAG_INFO(1165690608, KeyVault.keys300_1, 91), new TAG_INFO(939656944, KeyVault.keys300_2, 90), new TAG_INFO(-806418960, KeyVault.keys280_0, 98), new TAG_INFO(1165690352, KeyVault.keys280_1, 91), new TAG_INFO(939656688, KeyVault.keys280_2, 90), new TAG_INFO(383098371, KeyVault.keys260_0, 98), new TAG_INFO(1981817859, KeyVault.keys260_1, 91), new TAG_INFO(251884291, KeyVault.keys260_2, 90), new TAG_INFO(1284771824, KeyVault.key_2DA8, 67), new TAG_INFO(1147617629, KeyVault.key_22E0, 89), new TAG_INFO(0x1000000, KeyVault.key_2250, 67), new TAG_INFO(777916656, KeyVault.key_2E5E10F0, 72), new TAG_INFO(777917168, KeyVault.key_2E5E12F0, 72), new TAG_INFO(777917424, KeyVault.key_2E5E13F0, 72), new TAG_INFO(802360304, KeyVault.key_2FD30BF0, 71), new TAG_INFO(802361840, KeyVault.key_2FD311F0, 71), new TAG_INFO(802362096, KeyVault.key_2FD312F0, 71), new TAG_INFO(802362352, KeyVault.key_2FD313F0, 71), new TAG_INFO(-652868112, KeyVault.key_D91605F0, 93), new TAG_INFO(-652867856, KeyVault.key_D91606F0, 93), new TAG_INFO(-652867344, KeyVault.key_D91608F0, 93), new TAG_INFO(-652867088, KeyVault.key_D91609F0, 93), new TAG_INFO(-652866832, KeyVault.key_D9160AF0, 93), new TAG_INFO(-652866576, KeyVault.key_D9160BF0, 93), new TAG_INFO(-652865040, KeyVault.key_D91611F0, 93), new TAG_INFO(-652864784, KeyVault.key_D91612F0, 93), new TAG_INFO(-652864528, KeyVault.key_D91613F0, 93), new TAG_INFO(-652864272, KeyVault.key_D91614F0, 93), new TAG_INFO(-652864016, KeyVault.key_D91615F0, 93), new TAG_INFO(-652863760, KeyVault.key_D91616F0, 93), new TAG_INFO(-652863504, KeyVault.key_D91617F0, 93), new TAG_INFO(-652863248, KeyVault.key_D91618F0, 93), new TAG_INFO(-652862992, KeyVault.key_D91619F0, 93), new TAG_INFO(-652862736, KeyVault.key_D9161AF0, 93), new TAG_INFO(-652861200, KeyVault.key_D91620F0, 93), new TAG_INFO(-652860944, KeyVault.key_D91621F0, 93), new TAG_INFO(-652860688, KeyVault.key_D91622F0, 93), new TAG_INFO(-652860432, KeyVault.key_D91623F0, 93), new TAG_INFO(-652860176, KeyVault.key_D91624F0, 93), new TAG_INFO(-652859152, KeyVault.key_D91628F0, 93), new TAG_INFO(-652836624, KeyVault.key_D91680F0, 93), new TAG_INFO(-652836368, KeyVault.key_D91681F0, 93), new TAG_INFO(-668790544, KeyVault.keys02G_E, 81), new TAG_INFO(-668786960, KeyVault.keys03G_E, 81), new TAG_INFO(-668784400, KeyVault.keys05G_E, 81), new TAG_INFO(664602864, KeyVault.oneseg_310, 97), new TAG_INFO(664602352, KeyVault.oneseg_300, 97), new TAG_INFO(664602096, KeyVault.oneseg_280, 97), new TAG_INFO(-697436413, KeyVault.oneseg_260_271, 97), new TAG_INFO(664604912, KeyVault.oneseg_slim, 97), new TAG_INFO(1009387760, KeyVault.ms_app_main, 103), new TAG_INFO(-1376582160, KeyVault.demokeys_280, 96), new TAG_INFO(-1376581904, KeyVault.demokeys_3XX_1, 96), new TAG_INFO(-1376581392, KeyVault.demokeys_3XX_2, 96), new TAG_INFO(-2147156733, KeyVault.ebootbin_271_new, 93), new TAG_INFO(-652868112, KeyVault.ebootbin_280_new, 93), new TAG_INFO(-652867856, KeyVault.ebootbin_300_new, 93), new TAG_INFO(-652867344, KeyVault.ebootbin_310_new, 93), new TAG_INFO(171305475, KeyVault.gameshare_260_271, 94), new TAG_INFO(2063926768, KeyVault.gameshare_280, 94), new TAG_INFO(2063927024, KeyVault.gameshare_300, 94), new TAG_INFO(2063927536, KeyVault.gameshare_310, 94), new TAG_INFO(939659504, KeyVault.key_380210F0, 90), new TAG_INFO(939688176, KeyVault.key_380280F0, 90), new TAG_INFO(939688944, KeyVault.key_380283F0, 90), new TAG_INFO(1081610480, KeyVault.key_407810F0, 106), new TAG_INFO(-383512336, KeyVault.drmkeys_6XX_1, 64), new TAG_INFO(1764233456, KeyVault.drmkeys_6XX_2, 64), new TAG_INFO(1673180163, KeyVault.key_102DC8AF_1, 81), new TAG_INFO(187404528, KeyVault.key_9DC14891_1, 92), new TAG_INFO(187404784, KeyVault.key_9DC14891_2, 92), new TAG_INFO(187405040, KeyVault.key_9DC14891_3, 92), new TAG_INFO(229246704, KeyVault.key_0DAA06F0, KeyVault.xor_0DAA06F0, 101), new TAG_INFO(-1988875516, KeyVault.key_89742B04, KeyVault.xor_89742B04, 101), new TAG_INFO(-383514384, KeyVault.key_E92408F0, KeyVault.xor_E92408F0, 101), new TAG_INFO(0, KeyVault.g_key00, 66, 0), new TAG_INFO(0x2000000, KeyVault.key_5C3A61FE, 69, 0), new TAG_INFO(0x3000000, KeyVault.g_key03, 70, 0), new TAG_INFO(0x3000000, KeyVault.g_key04, 71, 0), new TAG_INFO(0x3000000, KeyVault.g_key05, 72, 0), new TAG_INFO(0x3000000, KeyVault.g_key06, 73, 0), new TAG_INFO(0x3000000, KeyVault.g_key0A, 77, 0), new TAG_INFO(0x3000000, KeyVault.g_key0D, 80, 0), new TAG_INFO(0x3000000, KeyVault.g_key0E, 81, 0), new TAG_INFO(1147617629, KeyVault.g_key44, 89, 89), new TAG_INFO(544980783, KeyVault.g_key20, 90, 90), new TAG_INFO(986598862, KeyVault.g_key3A, 91, 91), new TAG_INFO(0x7000000, KeyVault.g_key_INDEXDAT1xx, 74, 0), new TAG_INFO(0x8000000, KeyVault.g_keyEBOOT1xx, 75, 0), new TAG_INFO(-1060432260, KeyVault.g_keyEBOOT2xx, 93, 93), new TAG_INFO(0xB000000, KeyVault.g_keyUPDATER, 78, 0), new TAG_INFO(0xC000000, KeyVault.g_keyDEMOS27X, 79, 0), new TAG_INFO(0xF000000, KeyVault.g_keyMEIMG250, 82, 0), new TAG_INFO(-2044311343, KeyVault.key_7A0E484C, 82, 0), new TAG_INFO(544980783, KeyVault.g_keyUNK1, 90, 90), new TAG_INFO(0x9000000, KeyVault.g_key_GAMESHARE1xx, 76, 0), new TAG_INFO(-1150827105, KeyVault.g_keyB8, 92, 92), new TAG_INFO(-1150827105, KeyVault.g_key_GAMESHARE2xx, 94, 94), new TAG_INFO(-1150827105, KeyVault.g_key4C, 95, 95), new TAG_INFO(-1150827105, KeyVault.g_key7F, 96, 96), new TAG_INFO(-1150827105, KeyVault.g_key1B, 97, 97), new TAG_INFO(0xE000000, KeyVault.key_102DC8AF_2, 81, 0), new TAG_INFO(0x6000000, KeyVault.key_06000000, 73, 0), new TAG_INFO(-466869501, KeyVault.key_E42C2303, 73, 0)};

    private TAG_INFO GetTagInfo(int tag) {
        LinkedList<TAG_INFO> tagInfos = new LinkedList<TAG_INFO>();
        for (TAG_INFO tagInfo : this.g_tagInfo) {
            if (tagInfo.tag != tag) continue;
            tagInfos.add(tagInfo);
        }
        if (tagInfos.size() == 0) {
            return null;
        }
        if (tagInfos.size() > 1) {
            log.warn((Object)String.format("GetTagInfo found multiple TAG_INFO for tag=0x%08X, using the last one:", tag));
            for (TAG_INFO tagInfo : tagInfos) {
                log.warn((Object)String.format("%s", tagInfo));
            }
        }
        return (TAG_INFO)tagInfos.get(tagInfos.size() - 1);
    }

    private int ScramblePRX(byte[] buf, int offset, int size, int code) {
        return this.ScramblePRX(buf, offset, size, code, true);
    }

    private int ScramblePRX(byte[] buf, int offset, int size, int code, boolean dumpError) {
        Utilities.writeUnaligned32(buf, offset + 0, 5);
        Utilities.writeUnaligned32(buf, offset + 4, 0);
        Utilities.writeUnaligned32(buf, offset + 8, 0);
        Utilities.writeUnaligned32(buf, offset + 12, code & 0xFF);
        Utilities.writeUnaligned32(buf, offset + 16, size);
        return Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buf, offset, size, buf, offset, size + 20, 7, dumpError);
    }

    private static boolean isNullKey(byte[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void MixXOR(byte[] outbuf, int outOffset, int size, byte[] inbuf, int inOffset, byte[] xor, int xorOffset) {
        for (int i = 0; i < size; ++i) {
            outbuf[outOffset + i] = (byte)(inbuf[inOffset + i] & 0xFF ^ xor[xorOffset + i] & 0xFF);
        }
    }

    private void MixXOR(byte[] outbuf, int size, byte[] inbuf, byte[] xor) {
        this.MixXOR(outbuf, 0, size, inbuf, 0, xor, 0);
    }

    private void RoundXOR(byte[] buf, int offset, int size, byte[] xor1, byte[] xor2) {
        for (int i = 0; i < size; ++i) {
            if (!PRX.isNullKey(xor1)) {
                int n = offset + i;
                buf[n] = (byte)(buf[n] ^ xor1[i & 0xF]);
            }
            if (PRX.isNullKey(xor2)) continue;
            int n = offset + i;
            buf[n] = (byte)(buf[n] ^ xor2[i & 0xF]);
        }
    }

    public byte[] DecryptAndUncompressPRX(byte[] buf, int size, boolean isSignChecked, byte[] key) {
        return this.DecryptAndUncompressPRX(buf, size, isSignChecked, key, null, null, 0);
    }

    public byte[] DecryptAndUncompressPRX(byte[] buf, int size, boolean isSignChecked, byte[] key, TPointer kl4eDecompress, TPointer tempBuffer, int tempBufferSize) {
        int type;
        int compAttribute = Utilities.readUnaligned16(buf, 6);
        int pspSize = Utilities.readUnaligned32(buf, 44);
        int elfSize = Utilities.readUnaligned32(buf, 40);
        int decryptMode = Utilities.read8(buf, 124);
        int tag = Utilities.readUnaligned32(buf, 208);
        byte[] resultBuffer = new byte[Math.max(elfSize, pspSize)];
        System.arraycopy(buf, 0, resultBuffer, 0, Math.min(size, resultBuffer.length));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("DecryptAndUncompressPRX size=0x%X, compAttribute=0x%X, pspSize=0x%X, elfSize=0x%X, decryptMode=0x%X, tag=0x%08X, key=%s", size, compAttribute, pspSize, elfSize, decryptMode, tag, Utilities.getMemoryDump(key)));
        }
        byte[] xor = null;
        switch (decryptMode) {
            case 3: {
                int result;
                if (isSignChecked) {
                    result = Modules.memlmdModule.hleMemlmd_6192F715(resultBuffer, size);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("DecryptPRX: memlmd_6192F715 returning 0x%X: %s", result, Utilities.getMemoryDump(resultBuffer, 0, 336)));
                    }
                }
                if (tag == 0x2000000) {
                    type = 8;
                    break;
                }
                type = 9;
                break;
            }
            case 4: {
                int result;
                if (isSignChecked) {
                    result = Modules.memlmdModule.hleMemlmd_6192F715(resultBuffer, size);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("DecryptPRX: memlmd_6192F715 returning 0x%X: %s", result, Utilities.getMemoryDump(resultBuffer, 0, 336)));
                    }
                }
                if (tag == 1165725936) {
                    type = 9;
                    break;
                }
                if (tag == 1165724400 || tag == 1165721840) {
                    type = 6;
                    break;
                }
                if (tag == 1165692144 || tag == 1165691888 || tag == 1165691632 || tag == 1165691120 || tag == 1165691120 || tag == 1165690352 || tag == 1981817859) {
                    type = 2;
                    break;
                }
                if (tag == 986598862) {
                    type = 1;
                    break;
                }
                if (tag == 0x3000000) {
                    type = 0;
                    break;
                }
                type = 9;
                break;
            }
            case 9: {
                type = 9;
                break;
            }
            case 10: {
                type = 2;
                break;
            }
            case 12: {
                type = 8;
                break;
            }
            case 13: 
            case 14: {
                type = 4;
                break;
            }
            case 20: {
                type = 5;
                break;
            }
            case 1: 
            case 2: {
                int result;
                if (isSignChecked) {
                    result = Modules.memlmdModule.hleMemlmd_6192F715(resultBuffer, size);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("DecryptPRX: memlmd_6192F715 returning 0x%X: %s", result, Utilities.getMemoryDump(resultBuffer, 0, 336)));
                    }
                }
                type = 2;
                break;
            }
            case 18: {
                type = 3;
                break;
            }
            case 23: {
                xor = new byte[16];
                for (int i = 0; i < xor.length; ++i) {
                    xor[i] = (byte)KeyVault.xor_91E0A9AD[i];
                }
                type = 5;
                break;
            }
            default: {
                log.error((Object)String.format("DecryptAndUncompressPRX unknown decryptMode=0x%X", decryptMode));
                log.error((Object)String.format("%s", Utilities.getMemoryDump(buf, 0, size)));
                type = 2;
            }
        }
        int resultSize = this.DecryptPRX(resultBuffer, size, type, xor, key);
        if (resultSize < 0) {
            log.error((Object)String.format("DecryptPRX returning %d", resultSize));
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("DecryptPRX size=0x%X returned %s", pspSize, Utilities.getMemoryDump(resultBuffer, 0, pspSize)));
        }
        if ((compAttribute & 1) != 0) {
            if ((compAttribute & 0xF00) == 0) {
                try {
                    int elfOffset;
                    int length;
                    GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(resultBuffer, 0, pspSize));
                    byte[] elfBuffer = new byte[elfSize];
                    for (elfOffset = 0; elfOffset < elfSize && (length = in.read(elfBuffer, elfOffset, elfSize - elfOffset)) > 0; elfOffset += length) {
                    }
                    in.close();
                    resultSize = elfOffset;
                    resultBuffer = elfBuffer;
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            } else if (kl4eDecompress != null && kl4eDecompress.isNotNull()) {
                try {
                    int offset = 0;
                    tempBuffer.alignUp(15);
                    TPointer inputBufferAddr = new TPointer(tempBuffer, offset);
                    int stackSize = Utilities.alignUp(3000, 15);
                    TPointer stackBufferAddr = new TPointer(tempBuffer, offset += Utilities.alignUp(resultSize, 15));
                    offset += stackSize;
                    offset = Utilities.alignUp(offset, 63);
                    TPointer outputBufferAddr = new TPointer(tempBuffer, offset);
                    inputBufferAddr.setArray(0, resultBuffer, 4, resultSize - 4);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Calling KL4E decompress at %s: input %s(size=0x%X), output %s(size=0x%X)", kl4eDecompress, inputBufferAddr, resultSize, outputBufferAddr, elfSize));
                    }
                    Processor processor = new Processor();
                    processor.cpu.setMemory(kl4eDecompress.getMemory());
                    processor.cpu._a0 = outputBufferAddr.getAddress();
                    processor.cpu._a1 = elfSize;
                    processor.cpu._a2 = inputBufferAddr.getAddress();
                    processor.cpu._a3 = 0;
                    processor.cpu._sp = stackBufferAddr.getAddress() + stackSize | Integer.MIN_VALUE;
                    Interpreter interpreter = new Interpreter(processor);
                    interpreter.run(kl4eDecompress.getAddress());
                    int result = processor.cpu._v0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("KL4E decompress returned 0x%08X", result));
                    }
                    if (result < 0) {
                        return null;
                    }
                    resultSize = result;
                    resultBuffer = outputBufferAddr.getArray8(0, resultSize);
                }
                catch (Exception e) {
                    log.error((Object)"KL4E decompress", (Throwable)e);
                    return null;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("DecryptAndUncompressPRX KL4E: %s", Utilities.getMemoryDump(resultBuffer, 0, resultSize)));
                }
                byte[] elfBuffer = new byte[elfSize];
                int decompressResult = KL4E.decompress_kle(elfBuffer, 0, elfSize, resultBuffer, 4, null, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("DecryptAndUncompressPRX KL4E result 0x%X: %s", decompressResult, Utilities.getMemoryDump(elfBuffer, 0, elfSize)));
                }
                resultSize = decompressResult;
                resultBuffer = elfBuffer;
            }
        }
        if (resultSize >= 0 && resultBuffer.length > resultSize) {
            byte[] newBuffer = new byte[resultSize];
            System.arraycopy(resultBuffer, 0, newBuffer, 0, resultSize);
            resultBuffer = newBuffer;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("DecryptAndUncompressPRX returning size=0x%X: %s", resultSize, Utilities.getMemoryDump(resultBuffer)));
        }
        return resultBuffer;
    }

    private int dumpDecryptHeader(PrintStream out, int addr, int code, int length) {
        out.format("write32 0x%08X 0x%X", addr, 5);
        out.println();
        out.format("write32 0x%08X 0x%X", addr + 4, 0);
        out.println();
        out.format("write32 0x%08X 0x%X", addr + 8, 0);
        out.println();
        out.format("write32 0x%08X 0x%X", addr + 12, code);
        out.println();
        out.format("write32 0x%08X 0x%X", addr + 16, length);
        out.println();
        return addr + 20;
    }

    private int dumpBuffer(PrintStream out, int addr, byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; i += 4) {
            out.format("write32 0x%08X 0x%08X", addr + i, Utilities.readUnaligned32(buffer, offset + i));
            out.println();
        }
        return addr + length;
    }

    private int dumpBuffer(PrintStream out, int addr, int buffer, int length) {
        if (addr != buffer) {
            out.format("memcpy 0x%08X 0x%08X 0x%X", addr, buffer, length);
            out.println();
        }
        return addr + length;
    }

    private void dumpDecrypt(PrintStream out, int addrIn, int addrOut, int length, String fileName) {
        out.format("ExecuteKirkCommand 0x%X %s 0x%X 0x%08X 0x%X", 7, fileName, length, addrIn, length + 20);
        out.println();
        out.format("ExecuteKirkCommand 0x%X 0x%08X 0x%X 0x%08X 0x%X", 7, addrOut, length, addrIn, length + 20);
        out.println();
    }

    private void dumpXor(PrintStream out, int addrOut, int addrIn, byte[] xor, int xorOffset, int xorLength, int addrXor, int length) {
        if (xor == null) {
            if (addrOut != addrIn) {
                out.format("memcpy 0x%08X 0x%08X 0x%X", addrOut, addrIn, length);
                out.println();
            }
        } else {
            this.dumpBuffer(out, addrXor, xor, xorOffset, xorLength);
            while (length > 0) {
                int stepLength = Math.min(length, xorLength);
                out.format("xor 0x%08X 0x%08X 0x%08X 0x%X", addrOut, addrIn, addrXor, stepLength);
                out.println();
                addrOut += stepLength;
                addrIn += stepLength;
                length -= stepLength;
            }
        }
    }

    private void dumpXor(PrintStream out, int addrOut, int addrIn, byte[] xor, int addrXor, int length) {
        this.dumpXor(out, addrOut, addrIn, xor, 0, xor == null ? 0 : xor.length, addrXor, length);
    }

    private void dumpErrorForType5(byte[] xor1, byte[] xor2, int code, byte[] buf1, byte[] buf3) {
        try {
            log.error((Object)String.format("Copy the created file", new Object[0]));
            log.error((Object)String.format("    JpcspTrace.config", new Object[0]));
            log.error((Object)String.format("to your MemoryStick on the PSP under seplugins/JpcspTrace.config", new Object[0]));
            log.error((Object)String.format("Then run the JpcspTrace plugin on your PSP.", new Object[0]));
            log.error((Object)String.format("After the run of JpcspTrace, the file PreDecrypt.xml will be created on your MemoryStick.", new Object[0]));
            log.error((Object)String.format("Add the content of this file to the Jpcsp file", new Object[0]));
            log.error((Object)String.format("  src/jpcsp/crypto/PreDecrypt.xml", new Object[0]));
            log.error((Object)String.format("under the section marked with 'Pre-decrypted data for POPS'", new Object[0]));
            PrintStream out = new PrintStream("JpcspTrace.config");
            out.format("LogBufferLength 0x2000", new Object[0]);
            out.println();
            out.format("BufferLogWrites", new Object[0]);
            out.println();
            int baseAddr1 = -1077934848;
            int length = 80;
            int addr = this.dumpDecryptHeader(out, baseAddr1, code, length);
            addr = this.dumpBuffer(out, addr, buf1, 128, 48);
            addr = this.dumpBuffer(out, addr, buf1, 192, 16);
            addr = this.dumpBuffer(out, addr, buf1, 300, 16);
            int tempAddr = baseAddr1 + 20 + length;
            this.dumpXor(out, baseAddr1 + 20, baseAddr1 + 20, xor1, tempAddr, length);
            this.dumpXor(out, baseAddr1 + 20, baseAddr1 + 20, xor2, tempAddr, length);
            this.dumpDecrypt(out, baseAddr1, baseAddr1, length, "ms0:/PreDecrypt.xml");
            int baseAddr2 = baseAddr1 + length;
            length = 96;
            addr = this.dumpDecryptHeader(out, baseAddr2, code, length);
            addr = this.dumpBuffer(out, addr, buf1, 320, 16);
            addr = this.dumpBuffer(out, addr, baseAddr1 + 64, 16);
            addr = this.dumpBuffer(out, addr, buf1, 316, 4);
            addr = this.dumpBuffer(out, addr, baseAddr1, 60);
            tempAddr = baseAddr2 + 20 + length;
            this.dumpXor(out, baseAddr2 + 20, baseAddr2 + 20, xor1, tempAddr, length);
            this.dumpDecrypt(out, baseAddr2, baseAddr2, length, ">ms0:/PreDecrypt.xml");
            this.dumpBuffer(out, baseAddr2 + length, baseAddr1 + 60, 4);
            int baseAddr3 = baseAddr2 + length + 4;
            length = 64;
            tempAddr = baseAddr3 + length;
            this.dumpXor(out, baseAddr3, baseAddr2 + 36, buf3, 16, 64, tempAddr, length);
            int baseAddr4 = baseAddr3 + length;
            length = 64;
            addr = this.dumpDecryptHeader(out, baseAddr4, code, length);
            addr = this.dumpBuffer(out, addr, baseAddr3, 64);
            this.dumpDecrypt(out, baseAddr4, baseAddr4, length, ">ms0:/PreDecrypt.xml");
            out.format("FlushLogBuffer", new Object[0]);
            out.println();
            out.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public int DecryptPRX(byte[] buf, int size, int type, byte[] xor1, byte[] xor2) {
        return this.DecryptPRX(buf, size, type, xor1, xor2, false);
    }

    public int DecryptPRX(byte[] buf, int size, int type, byte[] xor1, byte[] xor2, boolean forceNewMethod) {
        int tag = Utilities.readUnaligned32(buf, 208);
        TAG_INFO pti = this.GetTagInfo(tag);
        if (pti == null) {
            log.error((Object)String.format("DecryptPRX unknown tag 0x%08X", tag));
            return -1;
        }
        return this.DecryptPRX(buf, size, type, xor1, xor2, forceNewMethod, pti);
    }

    public int DecryptPRX(byte[] buf, int size, int type, byte[] xor1, byte[] xor2, boolean forceNewMethod, TAG_INFO pti) {
        int result = 0;
        if (pti.xor1 != null && xor1 == null) {
            xor1 = Utilities.intArrayToByteArray(pti.xor1);
        }
        int tag = Utilities.readUnaligned32(buf, 208);
        int retsize = Utilities.readUnaligned32(buf, 176);
        int dataOffset = Utilities.readUnaligned16(buf, 180);
        if ((type >= 2 && type <= 7 || type == 9 || type == 10) && pti.key.length > 16 && !forceNewMethod) {
            int iXOR;
            int i;
            byte[] oldbuf = new byte[size];
            byte[] oldbuf1 = new byte[336];
            System.arraycopy(buf, 0, oldbuf, 0, size);
            for (i = 0; i < 336; ++i) {
                oldbuf[i] = 0;
            }
            for (i = 0; i < 64; ++i) {
                oldbuf[i] = 85;
            }
            Utilities.writeUnaligned32(oldbuf, 44, 5);
            Utilities.writeUnaligned32(oldbuf, 48, 0);
            Utilities.writeUnaligned32(oldbuf, 52, 0);
            Utilities.writeUnaligned32(oldbuf, 56, pti.code);
            Utilities.writeUnaligned32(oldbuf, 60, 112);
            System.arraycopy(buf, 208, oldbuf1, 0, 128);
            System.arraycopy(buf, 128, oldbuf1, 128, 80);
            System.arraycopy(buf, 0, oldbuf1, 208, 128);
            if (pti.codeExtra != 0) {
                byte[] tmp = new byte[180];
                System.arraycopy(oldbuf1, 16, tmp, 20, 160);
                this.ScramblePRX(tmp, 0, 160, pti.codeExtra);
                System.arraycopy(tmp, 0, oldbuf1, 16, 160);
            }
            System.arraycopy(oldbuf1, 64, oldbuf, 64, 64);
            for (iXOR = 0; iXOR < 112; ++iXOR) {
                oldbuf[64 + iXOR] = (byte)(oldbuf[64 + iXOR] ^ pti.key[20 + iXOR]);
            }
            result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(oldbuf, 44, 112, oldbuf, 44, 132, 7);
            if (result != 0) {
                log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_DECRYPT returned error %d", result));
            }
            for (iXOR = 111; iXOR >= 0; --iXOR) {
                oldbuf[64 + iXOR] = (byte)(oldbuf[44 + iXOR] ^ pti.key[32 + iXOR]);
            }
            for (int k = 0; k < 48; ++k) {
                oldbuf[k + 128] = 0;
            }
            oldbuf[160] = 0;
            oldbuf[161] = 0;
            oldbuf[162] = 0;
            oldbuf[163] = 1;
            System.arraycopy(buf, 176, oldbuf, 176, 32);
            System.arraycopy(buf, 0, oldbuf, 208, 128);
            result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buf, 0, size, oldbuf, 64, size - 64, 1);
            if (result != 0) {
                log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_DECRYPT_PRIVATE returned error %d", result));
            }
        } else {
            int i;
            int i2;
            byte[] buf1 = new byte[336];
            byte[] buf2 = new byte[336];
            byte[] buf3 = new byte[144];
            byte[] buf4 = new byte[180];
            byte[] buf5 = new byte[32];
            byte[] buf6 = new byte[40];
            byte[] sigbuf = new byte[40];
            byte[] sha1buf = new byte[20];
            int unk_0xD4 = 0;
            System.arraycopy(buf, 0, buf1, 0, 336);
            if (size - 336 < retsize) {
                return -206;
            }
            if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                for (i2 = 0; i2 < 9; ++i2) {
                    for (int j = 0; j < 16; ++j) {
                        buf2[20 + ((i2 << 4) + j)] = (byte)pti.key[j];
                    }
                    buf2[20 + (i2 << 4)] = (byte)i2;
                }
            } else {
                for (i2 = 0; i2 < 144; ++i2) {
                    buf2[20 + i2] = (byte)pti.key[i2];
                }
            }
            this.ScramblePRX(buf2, 0, 144, pti.code);
            if (!(type != 3 && type != 5 && type != 7 && type != 10 || PRX.isNullKey(xor2))) {
                this.RoundXOR(buf2, 0, 144, xor2, null);
            }
            System.arraycopy(buf2, 0, buf3, 0, 144);
            if (type == 9 || type == 10) {
                int[] pubKey;
                System.arraycopy(buf, 260, buf6, 0, buf6.length);
                for (i2 = 0; i2 < buf6.length; ++i2) {
                    buf[260 + i2] = 0;
                }
                System.arraycopy(buf6, 0, sigbuf, 0, sigbuf.length);
                Utilities.writeUnaligned32(buf, 0, size - 4);
                result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buf, 0, size, buf, 0, size, 11);
                if (result != 0) {
                    log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_SHA1_HASH returned error %d", result));
                }
                System.arraycopy(buf, 0, sha1buf, 0, sha1buf.length);
                System.arraycopy(buf1, 0, buf, 0, 32);
                switch (tag >> 16 & 0xFF) {
                    case 22: {
                        pubKey = KeyVault.g_pubkey_28752;
                        break;
                    }
                    case 94: {
                        pubKey = KeyVault.g_pubkey_28712;
                        break;
                    }
                    default: {
                        pubKey = KeyVault.g_pubkey_28672;
                    }
                }
                for (i = 0; i < pubKey.length; ++i) {
                    buf4[i] = (byte)pubKey[i];
                }
                System.arraycopy(sha1buf, 0, buf4, 40, sha1buf.length);
                System.arraycopy(sigbuf, 0, buf4, 40 + sha1buf.length, sigbuf.length);
                result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(null, 0, 0, buf4, 0, 100, 17);
                if (result != 0) {
                    log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_ECDSA_VERIFY returned error %d", result));
                }
            }
            if (type == 3) {
                int i3;
                System.arraycopy(buf1, 236, buf2, 0, 64);
                for (i3 = 0; i3 < 80; ++i3) {
                    buf2[64 + i3] = 0;
                }
                buf2[96] = 3;
                buf2[112] = 80;
                System.arraycopy(buf1, 128, buf2, 144, 48);
                System.arraycopy(buf1, 192, buf2, 192, 16);
                System.arraycopy(buf1, 300, buf2, 208, 16);
                this.RoundXOR(buf2, 144, 80, xor1, xor2);
                result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buf4, 0, 180, buf2, 0, 336, 3);
                if (result != 0) {
                    log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_DECRYPT_SIGN returned error %d", result));
                }
                System.arraycopy(buf1, 208, buf2, 0, 4);
                for (i3 = 0; i3 < 88; ++i3) {
                    buf2[4 + i3] = 0;
                }
                System.arraycopy(buf1, 320, buf2, 92, 16);
                System.arraycopy(buf1, 300, buf2, 108, 20);
                System.arraycopy(buf4, 64, buf2, 108, 16);
                System.arraycopy(buf4, 0, buf2, 128, 48);
                System.arraycopy(buf4, 48, buf2, 176, 16);
                System.arraycopy(buf1, 176, buf2, 192, 16);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            } else if (type == 5 || type == 7 || type == 10) {
                System.arraycopy(buf1, 128, buf2, 20, 48);
                System.arraycopy(buf1, 192, buf2, 68, 16);
                System.arraycopy(buf1, 300, buf2, 84, 16);
                this.RoundXOR(buf2, 20, 80, xor1, xor2);
                boolean dumpError = type != 5;
                result = this.ScramblePRX(buf2, 0, 80, pti.code, dumpError);
                if (result != 0 && !dumpError) {
                    this.dumpErrorForType5(xor1, xor2, pti.code, buf1, buf3);
                    return -1;
                }
                System.arraycopy(buf2, 0, buf4, 0, 80);
                System.arraycopy(buf1, 208, buf2, 0, 4);
                for (i = 0; i < 88; ++i) {
                    buf2[4 + i] = 0;
                }
                System.arraycopy(buf1, 320, buf2, 92, 16);
                System.arraycopy(buf1, 300, buf2, 108, 20);
                System.arraycopy(buf4, 64, buf2, 108, 16);
                System.arraycopy(buf4, 0, buf2, 128, 48);
                System.arraycopy(buf4, 48, buf2, 176, 16);
                System.arraycopy(buf1, 176, buf2, 192, 16);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            } else if (type == 2 || type == 4 || type == 6 || type == 9) {
                System.arraycopy(buf1, 208, buf2, 0, 92);
                System.arraycopy(buf1, 320, buf2, 92, 16);
                System.arraycopy(buf1, 300, buf2, 108, 20);
                System.arraycopy(buf1, 128, buf2, 128, 48);
                System.arraycopy(buf1, 192, buf2, 176, 16);
                System.arraycopy(buf1, 176, buf2, 192, 16);
                System.arraycopy(buf1, 0, buf2, 208, 128);
                if (type == 9) {
                    for (int i4 = 0; i4 < 40; ++i4) {
                        buf2[52 + i4] = 0;
                    }
                }
            } else {
                System.arraycopy(buf1, 208, buf2, 0, 128);
                System.arraycopy(buf1, 128, buf2, 128, 80);
                System.arraycopy(buf1, 0, buf2, 208, 128);
            }
            if (type == 1) {
                System.arraycopy(buf2, 16, buf4, 20, 160);
                this.ScramblePRX(buf4, 0, 160, pti.code);
                System.arraycopy(buf4, 0, buf2, 16, 160);
            } else if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                System.arraycopy(buf2, 92, buf4, 20, 96);
                if (type == 3 || type == 5 || type == 7 || type == 10) {
                    this.RoundXOR(buf4, 20, 96, xor1, null);
                }
                this.ScramblePRX(buf4, 0, 96, pti.code);
                System.arraycopy(buf4, 0, buf2, 92, 96);
            }
            if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                int i5;
                System.arraycopy(buf2, 108, buf4, 0, 20);
                if (type == 4) {
                    System.arraycopy(buf2, 0, buf2, 24, 103);
                    for (i5 = 0; i5 < 24; ++i5) {
                        buf2[i5] = 0;
                    }
                } else {
                    System.arraycopy(buf2, 92, buf2, 112, 16);
                    if (type == 6 || type == 7) {
                        System.arraycopy(buf2, 60, buf5, 0, 32);
                        System.arraycopy(buf5, 0, buf2, 80, 32);
                        for (i5 = 0; i5 < 56; ++i5) {
                            buf2[24 + i5] = 0;
                        }
                    } else {
                        for (i5 = 0; i5 < 88; ++i5) {
                            buf2[24 + i5] = 0;
                        }
                    }
                    if (unk_0xD4 == 128) {
                        buf2[24] = -128;
                    }
                }
                System.arraycopy(buf2, 0, buf2, 4, 4);
                Utilities.writeUnaligned32(buf2, 0, 332);
                System.arraycopy(buf3, 0, buf2, 8, 16);
            } else {
                System.arraycopy(buf2, 4, buf4, 0, 20);
                Utilities.writeUnaligned32(buf2, 0, 332);
                System.arraycopy(buf3, 0, buf2, 4, 20);
            }
            result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buf2, 0, 336, buf2, 0, 336, 11);
            if (result != 0) {
                log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_SHA1_HASH returned error %d", result));
            }
            if (Utilities.memcmp(buf2, 0, buf4, 0, 20) != 0) {
                log.error((Object)String.format("DecryptPRX: SHA1 Hash not matching: %s%s", Utilities.getMemoryDump(buf2, 0, 20), Utilities.getMemoryDump(buf4, 0, 20)));
            }
            if (type >= 2 && type <= 7 || type == 9 || type == 10) {
                int i6;
                byte[] tmp1 = new byte[64];
                byte[] tmp2 = new byte[64];
                byte[] tmp3 = new byte[84];
                byte[] tmp4 = new byte[64];
                byte[] tmp5 = new byte[64];
                byte[] tmp6 = new byte[64];
                for (i6 = 0; i6 < 64; ++i6) {
                    tmp1[i6] = buf2[128 + i6];
                    tmp2[i6] = buf3[16 + i6];
                }
                this.MixXOR(tmp1, 64, tmp1, tmp2);
                System.arraycopy(tmp1, 0, tmp3, 20, 64);
                this.ScramblePRX(tmp3, 0, 64, pti.code);
                System.arraycopy(tmp3, 0, buf2, 128, 64);
                for (i6 = 0; i6 < 64; ++i6) {
                    tmp4[i6] = buf[64 + i6];
                    tmp5[i6] = buf2[128 + i6];
                    tmp6[i6] = buf3[80 + i6];
                }
                this.MixXOR(tmp4, 64, tmp5, tmp6);
                System.arraycopy(tmp4, 0, buf, 64, 64);
                if (type == 6 || type == 7) {
                    System.arraycopy(buf5, 0, buf, 128, 32);
                    for (i6 = 0; i6 < 16; ++i6) {
                        buf[160 + i6] = 0;
                    }
                    buf[164] = 0;
                    buf[165] = 0;
                    buf[166] = 0;
                    buf[167] = 1;
                    Utilities.writeUnaligned32(buf, 160, 1);
                } else {
                    for (i6 = 0; i6 < 48; ++i6) {
                        buf[128 + i6] = 0;
                    }
                    Utilities.writeUnaligned32(buf, 160, 1);
                }
                System.arraycopy(buf2, 192, buf, 176, 16);
                for (i6 = 0; i6 < 16; ++i6) {
                    buf[192 + i6] = 0;
                }
                System.arraycopy(buf2, 208, buf, 208, 128);
            } else {
                this.MixXOR(buf2, 64, 112, buf2, 64, buf3, 20);
                this.ScramblePRX(buf2, 44, 112, pti.code);
                this.MixXOR(buf, 64, 112, buf2, 44, buf3, 32);
                System.arraycopy(buf2, 176, buf, 176, 160);
            }
            int firmwareVersion = Emulator.getInstance().getFirmwareVersion();
            if (type == 8 && firmwareVersion > 620 && firmwareVersion != 999 && buf[164] != 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("error -303, type=%d, firmwareVersion=%d: %s", type, Emulator.getInstance().getFirmwareVersion(), Utilities.getMemoryDump(buf, 0, 336)));
                }
                return -303;
            }
            if (unk_0xD4 == 128) {
                if (buf[1424] != 0) {
                    return -302;
                }
                buf[1424] = (byte)(buf[1424] | 0x80);
            }
            int inSize = 144 + Utilities.alignUp(retsize, 15) + dataOffset;
            int outSize = Utilities.alignUp(retsize, 15);
            result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buf, 0, outSize, buf, 64, inSize, 1);
            if (result != 0) {
                log.error((Object)String.format("DecryptPRX: KIRK command PSP_KIRK_CMD_DECRYPT_PRIVATE returned error %d", result));
            }
            if (retsize < 336) {
                for (int i7 = 0; i7 < 336 - retsize; ++i7) {
                    buf[retsize + i7] = 0;
                }
            }
        }
        return retsize;
    }

    public int encryptPRX(byte[] buffer, int bufferLength, byte[] key) {
        if (bufferLength < 352) {
            return -202;
        }
        for (int i = 0; i < 24; ++i) {
            if (buffer[212 + i] == 0) continue;
            return -302;
        }
        int tag = Utilities.readUnaligned32(buffer, 208);
        TAG_INFO pti = this.GetTagInfo(tag);
        if (pti == null) {
            log.error((Object)String.format("encryptPRX unknown tag 0x%08X", tag));
            return -301;
        }
        byte[] xor2 = key;
        byte[] xor1 = null;
        if (pti.xor1 != null) {
            xor1 = Utilities.intArrayToByteArray(pti.xor1);
        }
        byte[] encryptBuffer = new byte[336];
        System.arraycopy(buffer, 236, encryptBuffer, 0, 64);
        encryptBuffer[96] = 2;
        encryptBuffer[112] = 80;
        System.arraycopy(buffer, 128, encryptBuffer, 144, 48);
        System.arraycopy(buffer, 192, encryptBuffer, 192, 16);
        System.arraycopy(buffer, 300, encryptBuffer, 208, 16);
        this.RoundXOR(encryptBuffer, 144, 80, xor1, xor2);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(encryptBuffer, 0, 336, encryptBuffer, 0, 336, 2);
        if (result != 0) {
            log.error((Object)String.format("encryptPRX: KIRK command PSP_KIRK_CMD_ENCRYPT_SIGN returned error %d", result));
        }
        this.RoundXOR(encryptBuffer, 144, 80, xor1, xor2);
        System.arraycopy(encryptBuffer, 0, buffer, 236, 64);
        System.arraycopy(encryptBuffer, 144, buffer, 128, 48);
        System.arraycopy(encryptBuffer, 192, buffer, 192, 16);
        System.arraycopy(encryptBuffer, 208, buffer, 300, 16);
        return 0;
    }

    public static class TAG_INFO {
        int tag;
        int[] key;
        int[] xor1;
        int code;
        int codeExtra;

        public TAG_INFO(int tag, int[] key, int code, int codeExtra) {
            this.tag = tag;
            this.key = this.intArrayToTagArray(key);
            this.code = code;
            this.codeExtra = codeExtra;
        }

        public TAG_INFO(int tag, int[] key, int code) {
            this.tag = tag;
            this.key = key;
            this.code = code;
        }

        public TAG_INFO(int tag, int[] key, int[] xor1, int code) {
            this.tag = tag;
            this.key = key;
            this.xor1 = xor1;
            this.code = code;
        }

        private int[] intArrayToTagArray(int[] array) {
            int[] tagArray = new int[144];
            for (int i = 0; i < array.length; ++i) {
                tagArray[i * 4 + 3] = array[i] >> 24 & 0xFF;
                tagArray[i * 4 + 2] = array[i] >> 16 & 0xFF;
                tagArray[i * 4 + 1] = array[i] >> 8 & 0xFF;
                tagArray[i * 4 + 0] = array[i] & 0xFF;
            }
            return tagArray;
        }

        public String toString() {
            return String.format("tag=0x%08X, key=%s, code=0x%02X, codeExtra=0x%02X", this.tag, Utilities.getMemoryDump(Utilities.intArrayToByteArray(this.key)), this.code, this.codeExtra);
        }
    }
}

