/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.filesystems.umdiso.AbstractFileSectorDevice;
import jpcsp.util.Utilities;
import libchdr.Chd;
import libchdr.ChdHeader;

public class CHDFileSectorDevice
extends AbstractFileSectorDevice {
    private final Chd chd = new Chd();
    private final Chd.ChdFile chdFile;
    private final ChdHeader header;
    private int numberFrames;
    private int frameSize;
    private final byte[] buffer;
    private int hunkNumberInBuffer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CHDFileSectorDevice(RandomAccessFile fileAccess, String fileName) throws IOException {
        super(fileAccess);
        Chd.ChdFile[] res = new Chd.ChdFile[1];
        ChdHeader.ChdError err = this.openChdFile(fileName, res);
        if (err != ChdHeader.ChdError.CHDERR_NONE) {
            throw new IOException(String.format("Invalid CHD file '%s': %s", new Object[]{fileName, err}));
        }
        this.chdFile = res[0];
        this.header = this.chd.chd_get_header(this.chdFile);
        if (this.header == null) {
            throw new IOException(String.format("Could not access the CHD file header '%s'", fileAccess));
        }
        this.numberFrames = this.header.totalhunks * 8;
        this.frameSize = 2448;
        byte[] metadata = new byte[512];
        int[] resultLength = new int[1];
        err = this.chd.chd_get_metadata(this.chdFile, ChdHeader.CDROM_TRACK_METADATA2_TAG, 0, metadata, metadata.length, resultLength, null, null);
        if (err != ChdHeader.ChdError.CHDERR_NONE) throw new IOException(String.format("Unsupported CHD file format, could not find METADATA2 tag", new Object[0]));
        int metadataLength = resultLength[0];
        String metadataString = new String(metadata, 0, metadataLength);
        Pattern p = Pattern.compile("TRACK:(\\d+) TYPE:(.*) SUBTYPE:(.*) FRAMES:(\\d+) PREGAP:(\\d+)");
        Matcher m = p.matcher(metadataString);
        if (!m.find()) throw new IOException(String.format("Unsupported CHD file format METADATA2='%s'", metadataString));
        int track = Integer.parseInt(m.group(1));
        String type = m.group(2);
        String subtype = m.group(3);
        int frames = Integer.parseInt(m.group(4));
        int pregap = Integer.parseInt(m.group(5));
        log.info((Object)String.format("Track %d, type %s, subtype %s, frames %d, pregap %d", track, type, subtype, frames, pregap));
        this.numberFrames = frames;
        if (!"MODE1".equals(type)) {
            throw new IOException(String.format("Unsupported CHD file format METADATA2='%s'", metadataString));
        }
        this.frameSize = 2048;
        if (this.frameSize != 2048) {
            throw new IOException(String.format("Unsupported CHD file format having frameSize=%d, only %d is currently supported", this.frameSize, 2048));
        }
        this.buffer = new byte[this.header.hunkbytes];
        this.hunkNumberInBuffer = -1;
    }

    private ChdHeader.ChdError openChdFile(String fileName, Chd.ChdFile[] res) {
        String[] parentFileNames;
        ChdHeader.ChdError err = this.chd.chd_open_file(fileName, 1, null, res);
        if (err == ChdHeader.ChdError.CHDERR_REQUIRES_PARENT && (parentFileNames = this.searchParentFileNames(fileName)) != null) {
            for (int i = 0; i < parentFileNames.length; ++i) {
                err = this.openChdFile(parentFileNames[i], res);
                if (err != ChdHeader.ChdError.CHDERR_NONE) continue;
                Chd.ChdFile parent = res[0];
                err = this.chd.chd_open_file(fileName, 1, parent, res);
                if (err == ChdHeader.ChdError.CHDERR_NONE) break;
                this.chd.chd_close(parent);
            }
        }
        return err;
    }

    private boolean isParentFileNameMatching(String childPrefix, String childSuffix, String parentPrefix, String parentSuffix) {
        if (!childSuffix.equalsIgnoreCase(parentSuffix)) {
            return false;
        }
        if (childPrefix.equals(parentPrefix)) {
            return false;
        }
        return childPrefix.startsWith(parentPrefix) || parentPrefix.startsWith(childPrefix);
    }

    private String[] searchParentFileNames(String childFileName) {
        if (childFileName == null) {
            return null;
        }
        int lastDot = childFileName.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        int lastDir = childFileName.lastIndexOf(File.separatorChar);
        if (lastDir < 0 || lastDir > lastDot) {
            return null;
        }
        String dirName = childFileName.substring(0, lastDir);
        File[] dirEntries = new File(dirName).listFiles();
        if (dirEntries == null) {
            return null;
        }
        String childPrefix = childFileName.substring(lastDir + 1, lastDot);
        String childSuffix = childFileName.substring(lastDot);
        String[] parentFileNames = null;
        for (int i = 0; i < dirEntries.length; ++i) {
            String parentSuffix;
            String parentPrefix;
            String parentFileName;
            if (!dirEntries[i].isFile() || (lastDot = (parentFileName = dirEntries[i].getName()).lastIndexOf(46)) < 0 || !this.isParentFileNameMatching(childPrefix, childSuffix, parentPrefix = parentFileName.substring(0, lastDot), parentSuffix = parentFileName.substring(lastDot))) continue;
            parentFileNames = Utilities.add(parentFileNames, dirEntries[i].getPath());
        }
        return parentFileNames;
    }

    @Override
    public int getNumSectors() throws IOException {
        return this.numberFrames;
    }

    @Override
    public void readSector(int sectorNumber, byte[] data, int offset) throws IOException {
        int hunkNumber = sectorNumber / 8;
        if (this.hunkNumberInBuffer != hunkNumber) {
            ChdHeader.ChdError err = this.chd.chd_read(this.chdFile, hunkNumber, this.buffer, 0);
            if (err != ChdHeader.ChdError.CHDERR_NONE) {
                throw new IOException(String.format("Error reading CHD file sectorNumber=%d: %s", new Object[]{sectorNumber, err}));
            }
            this.hunkNumberInBuffer = hunkNumber;
        }
        int frameIndex = sectorNumber % 8;
        System.arraycopy(this.buffer, frameIndex * 2448, data, offset, 2048);
    }
}

