/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jpcsp.filesystems.umdiso.AbstractFileSectorDevice;
import jpcsp.util.FileUtil;

public class CSOFileSectorDevice
extends AbstractFileSectorDevice {
    protected int offsetShift;
    protected int numSectors;
    protected long[] sectorOffsets;
    private static final long sectorOffsetMask = Integer.MAX_VALUE;

    public CSOFileSectorDevice(RandomAccessFile fileAccess, byte[] header) throws IOException {
        super(fileAccess);
        ByteBuffer byteBuffer = ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN);
        long lengthInBytes = byteBuffer.getLong(8);
        int sectorSize = byteBuffer.getInt(16);
        int version = byteBuffer.get(20) & 0xFF;
        if (version > 1) {
            log.warn((Object)String.format("Unsupported CSO version number 0x%02X", version));
        }
        this.offsetShift = byteBuffer.get(21) & 0xFF;
        this.numSectors = this.getNumSectors(lengthInBytes, sectorSize);
        this.sectorOffsets = new long[this.numSectors + 1];
        byte[] offsetData = new byte[(this.numSectors + 1) * 4];
        fileAccess.seek(24L);
        fileAccess.readFully(offsetData);
        ByteBuffer offsetBuffer = ByteBuffer.wrap(offsetData).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i <= this.numSectors; ++i) {
            this.sectorOffsets[i] = (long)offsetBuffer.getInt(i * 4) & 0xFFFFFFFFL;
            if (i <= 0 || (this.sectorOffsets[i] & Integer.MAX_VALUE) >= (this.sectorOffsets[i - 1] & Integer.MAX_VALUE)) continue;
            log.error((Object)String.format("Corrupted CISO - Invalid offset [%d]: 0x%08X < 0x%08X", i, this.sectorOffsets[i], this.sectorOffsets[i - 1]));
        }
    }

    @Override
    public int getNumSectors() {
        return this.numSectors;
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        long sectorOffset = this.sectorOffsets[sectorNumber];
        long sectorEnd = this.sectorOffsets[sectorNumber + 1];
        if ((sectorOffset & Integer.MIN_VALUE) != 0L) {
            long realOffset = (sectorOffset & Integer.MAX_VALUE) << this.offsetShift;
            this.fileAccess.seek(realOffset);
            this.fileAccess.read(buffer, offset, 2048);
        } else {
            int compressedLength = (int)((sectorEnd = (sectorEnd & Integer.MAX_VALUE) << this.offsetShift) - (sectorOffset = (sectorOffset & Integer.MAX_VALUE) << this.offsetShift));
            if (compressedLength < 0) {
                Arrays.fill(buffer, offset, offset + 2048, (byte)0);
            } else {
                byte[] compressedData = new byte[compressedLength];
                this.fileAccess.seek(sectorOffset);
                this.fileAccess.read(compressedData);
                try {
                    Inflater inf = new Inflater(true);
                    try (InflaterInputStream s = new InflaterInputStream(new ByteArrayInputStream(compressedData), inf);){
                        FileUtil.readAll(s, buffer, offset, 2048);
                    }
                }
                catch (IOException e) {
                    throw new IOException(String.format("Exception while uncompressing sector %d", sectorNumber));
                }
            }
        }
    }
}

