/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.Buffer;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngineUtilities;

public class FrameBufferSettings {
    private int topAddr;
    private int bottomAddr;
    private int bufferWidth;
    private int width;
    private int height;
    private int pixelFormat;
    private Buffer pixels;
    private int size;

    public FrameBufferSettings(int topAddr, int bufferWidth, int width, int height, int pixelFormat) {
        this.topAddr = topAddr & 0x1FFFFFFF;
        this.bufferWidth = bufferWidth;
        this.width = width;
        this.height = height;
        this.pixelFormat = pixelFormat;
        this.update();
    }

    public FrameBufferSettings(FrameBufferSettings copy) {
        this.topAddr = copy.topAddr;
        this.bottomAddr = copy.bottomAddr;
        this.bufferWidth = copy.bufferWidth;
        this.width = copy.width;
        this.height = copy.height;
        this.pixelFormat = copy.pixelFormat;
        this.pixels = copy.pixels;
        this.size = copy.size;
    }

    private void update() {
        this.size = this.bufferWidth * this.height * VideoEngineUtilities.getPixelFormatBytes(this.pixelFormat);
        this.bottomAddr = this.topAddr + this.size;
        this.pixels = Memory.getInstance().getBuffer(this.topAddr, this.size);
    }

    public int getTopAddr() {
        return this.topAddr;
    }

    public int getBottomAddr() {
        return this.bottomAddr;
    }

    public int getBufferWidth() {
        return this.bufferWidth;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public Buffer getPixels() {
        return this.pixels;
    }

    public Buffer getPixels(int topAddr) {
        if (this.topAddr == topAddr) {
            return this.pixels;
        }
        return Memory.getInstance().getBuffer(topAddr, this.size);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isRawAddressInside(int address) {
        return address >= this.topAddr && address < this.bottomAddr;
    }

    public boolean isAddressInside(int address) {
        return this.isRawAddressInside(address & 0x1FFFFFFF);
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        this.update();
    }

    public String toString() {
        return String.format("0x%08X-0x%08X, %dx%d, bufferWidth=%d, pixelFormat=%d", this.topAddr, this.bottomAddr, this.width, this.height, this.bufferWidth, this.pixelFormat);
    }
}

