/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VideoEngine;
import org.apache.log4j.Logger;

public class GeContext
extends pspAbstractMemoryMappedStructure {
    private static final Logger log = VideoEngine.log;
    public static final int SIZE_OF = 2048;
    protected boolean dirty;
    public int base;
    public int baseOffset;
    public int fbp = 0x4000000;
    public int fbw;
    public int zbp = 0x4000000;
    public int zbw;
    public int psm;
    public int region_x1;
    public int region_y1;
    public int region_x2;
    public int region_y2;
    public int region_width;
    public int region_height;
    public int scissor_x1;
    public int scissor_y1;
    public int scissor_x2;
    public int scissor_y2;
    public int scissor_width;
    public int scissor_height;
    public int offset_x;
    public int offset_y;
    public int viewport_width;
    public int viewport_height;
    public int viewport_cx;
    public int viewport_cy;
    public float[] proj_uploaded_matrix = new float[16];
    public float[] texture_uploaded_matrix = new float[16];
    public float[] model_uploaded_matrix = new float[16];
    public float[] view_uploaded_matrix = new float[16];
    public float[][] bone_uploaded_matrix = new float[8][12];
    public float[] boneMatrixLinear = new float[128];
    public boolean depthMask;
    public int[] colorMask = new int[]{0, 0, 0, 0};
    public int alphaFunc;
    public int alphaRef;
    public int alphaMask;
    public int stencilFunc;
    public int stencilRef;
    public int stencilMask;
    public int stencilOpFail;
    public int stencilOpZFail;
    public int stencilOpZPass;
    public int textureFunc;
    public boolean textureColorDoubled;
    public boolean textureAlphaUsed;
    public boolean frontFaceCw;
    public int depthFunc;
    public final float[] morph_weight = new float[8];
    public float[] tex_envmap_matrix = new float[16];
    public float[][] light_pos = new float[4][4];
    public float[][] light_dir = new float[4][4];
    public int[] light_type = new int[4];
    public int[] light_kind = new int[4];
    public float[][] lightAmbientColor = new float[4][4];
    public float[][] lightDiffuseColor = new float[4][4];
    public float[][] lightSpecularColor = new float[4][4];
    public float[] spotLightExponent = new float[4];
    public float[] spotLightCutoff = new float[4];
    public float[] spotLightCosCutoff = new float[4];
    public float[] lightConstantAttenuation = new float[4];
    public float[] lightLinearAttenuation = new float[4];
    public float[] lightQuadraticAttenuation = new float[4];
    public int lightMode;
    public float[] fog_color = new float[4];
    public float fog_far = 0.0f;
    public float fog_dist = 0.0f;
    public int nearZ;
    public int farZ;
    public float zscale;
    public float zpos;
    public int mat_flags = 0;
    public float[] mat_ambient = new float[4];
    public float[] mat_diffuse = new float[4];
    public float[] mat_specular = new float[4];
    public float[] mat_emission = new float[4];
    public float[] ambient_light = new float[4];
    public float materialShininess;
    public int texture_storage;
    public int texture_num_mip_maps;
    public boolean texture_swizzle;
    public int[] texture_base_pointer = new int[8];
    public int[] texture_width = new int[8];
    public int[] texture_height = new int[8];
    public int[] texture_buffer_width = new int[8];
    public int tex_min_filter = 0;
    public int tex_mag_filter = 0;
    public int tex_mipmap_mode;
    public float tex_mipmap_bias;
    public int tex_mipmap_bias_int;
    public boolean mipmapShareClut;
    public float tex_translate_x = 0.0f;
    public float tex_translate_y = 0.0f;
    public float tex_scale_x = 1.0f;
    public float tex_scale_y = 1.0f;
    public float[] tex_env_color = new float[4];
    public int tex_clut_addr;
    public int tex_clut_num_blocks;
    public int tex_clut_mode;
    public int tex_clut_shift;
    public int tex_clut_mask;
    public int tex_clut_start;
    public int tex_wrap_s = 0;
    public int tex_wrap_t = 0;
    public int tex_shade_u = 0;
    public int tex_shade_v = 0;
    public int patch_div_s;
    public int patch_div_t;
    public int patch_prim;
    public float tslope_level;
    public int transform_mode;
    public int textureTx_sourceAddress;
    public int textureTx_sourceLineWidth;
    public int textureTx_destinationAddress;
    public int textureTx_destinationLineWidth;
    public int textureTx_width;
    public int textureTx_height;
    public int textureTx_sx;
    public int textureTx_sy;
    public int textureTx_dx;
    public int textureTx_dy;
    public int textureTx_pixelSize;
    public float[] dfix_color = new float[4];
    public float[] sfix_color = new float[4];
    public int sfix;
    public int dfix;
    public int blend_src;
    public int blend_dst;
    public int blendEquation;
    public int[] dither_matrix = new int[16];
    public int tex_map_mode = 0;
    public int tex_proj_map_mode = 0;
    public int colorTestFunc;
    public int[] colorTestRef = new int[]{0, 0, 0};
    public int[] colorTestMsk = new int[]{0, 0, 0};
    public int shadeModel;
    public int logicOp;
    public final List<EnableDisableFlag> flags = new LinkedList<EnableDisableFlag>();
    public final EnableDisableFlag alphaTestFlag = new EnableDisableFlag("GU_ALPHA_TEST", 0);
    public final EnableDisableFlag depthTestFlag = new EnableDisableFlag("GU_DEPTH_TEST", 1);
    public final EnableDisableFlag scissorTestFlag = new EnableDisableFlag("GU_SCISSOR_TEST", 2);
    public final EnableDisableFlag stencilTestFlag = new EnableDisableFlag("GU_STENCIL_TEST", 3);
    public final EnableDisableFlag blendFlag = new EnableDisableFlag("GU_BLEND", 4);
    public final EnableDisableFlag cullFaceFlag = new EnableDisableFlag("GU_CULL_FACE", 5);
    public final EnableDisableFlag ditherFlag = new EnableDisableFlag("GU_DITHER", 6);
    public final EnableDisableFlag fogFlag = new EnableDisableFlag("GU_FOG", 7);
    public final EnableDisableFlag clipPlanesFlag = new EnableDisableFlag("GU_CLIP_PLANES", 8);
    public final EnableDisableFlag textureFlag = new EnableDisableFlag("GU_TEXTURE_2D", 9);
    public final EnableDisableFlag lightingFlag = new EnableDisableFlag("GU_LIGHTING", 10);
    public final EnableDisableFlag[] lightFlags = new EnableDisableFlag[]{new EnableDisableFlag("GU_LIGHT0", 11), new EnableDisableFlag("GU_LIGHT1", 12), new EnableDisableFlag("GU_LIGHT2", 13), new EnableDisableFlag("GU_LIGHT3", 14)};
    public final EnableDisableFlag lineSmoothFlag = new EnableDisableFlag("GU_LINE_SMOOTH", 15);
    public final EnableDisableFlag patchCullFaceFlag = new EnableDisableFlag("GU_PATCH_CULL_FACE", 16);
    public final EnableDisableFlag colorTestFlag = new EnableDisableFlag("GU_COLOR_TEST", 17);
    public final EnableDisableFlag colorLogicOpFlag = new EnableDisableFlag("GU_COLOR_LOGIC_OP", 18);
    public final EnableDisableFlag faceNormalReverseFlag = new EnableDisableFlag("GU_FACE_NORMAL_REVERSE", 19);
    public final EnableDisableFlag patchFaceFlag = new EnableDisableFlag("GU_PATCH_FACE", 20);
    public final EnableDisableFlag fragment2xFlag = new EnableDisableFlag("GU_FRAGMENT_2X", 21);
    public final EnableDisableFlag reColorMaterial = new EnableDisableFlag("RE_COLOR_MATERIAL", 22);
    public final EnableDisableFlag reTextureGenS = new EnableDisableFlag("RE_TEXTURE_GEN_S", 23);
    public final EnableDisableFlag reTextureGenT = new EnableDisableFlag("RE_TEXTURE_GEN_T", 24);
    public float[] vertexColor = new float[4];
    public boolean useVertexColor;
    public boolean clearMode;
    public boolean clearModeColor;
    public boolean clearModeStencil;
    public boolean clearModeDepth;
    public VertexInfo vinfo = new VertexInfo();
    public int currentTextureId;
    private static int contextBitCount = 0;

    public GeContext() {
        this.tex_envmap_matrix[15] = 1.0f;
        this.tex_envmap_matrix[10] = 1.0f;
        this.tex_envmap_matrix[5] = 1.0f;
        this.tex_envmap_matrix[0] = 1.0f;
        this.light_pos[3][3] = 1.0f;
        this.light_pos[2][3] = 1.0f;
        this.light_pos[1][3] = 1.0f;
        this.light_pos[0][3] = 1.0f;
        this.light_dir[3][3] = 1.0f;
        this.light_dir[2][3] = 1.0f;
        this.light_dir[1][3] = 1.0f;
        this.light_dir[0][3] = 1.0f;
        this.morph_weight[0] = 1.0f;
        this.tex_mipmap_mode = 0;
        this.tex_mipmap_bias = 0.0f;
        this.tex_mipmap_bias_int = 0;
        this.mipmapShareClut = true;
        this.base = 0;
        this.baseOffset = 0;
        this.light_type[3] = -1;
        this.light_type[2] = -1;
        this.light_type[1] = -1;
        this.light_type[0] = -1;
        this.light_kind[3] = -1;
        this.light_kind[2] = -1;
        this.light_kind[1] = -1;
        this.light_kind[0] = -1;
        this.lightSpecularColor[3][0] = -1.0f;
        this.lightSpecularColor[2][0] = -1.0f;
        this.lightSpecularColor[1][0] = -1.0f;
        this.lightSpecularColor[0][0] = -1.0f;
        this.dirty = false;
    }

    public void update(IRenderingEngine re) {
        if (!this.dirty) {
            return;
        }
        for (EnableDisableFlag flag : this.flags) {
            flag.update(re);
        }
        if (this.fogFlag.isEnabled()) {
            re.setFogHint();
        }
        if (this.lineSmoothFlag.isEnabled()) {
            re.setLineSmoothHint();
        }
        re.setPatchDiv(this.patch_div_s, this.patch_div_t);
        re.setPatchPrim(this.patch_prim);
        re.setShadeModel(this.shadeModel);
        re.setMaterialEmissionColor(this.mat_emission);
        re.setMaterialShininess(this.materialShininess);
        re.setLightModelAmbientColor(this.ambient_light);
        re.setLightMode(this.lightMode);
        for (int light = 0; light < 4; ++light) {
            re.setLightType(light, this.light_type[light], this.light_kind[light]);
            re.setLightConstantAttenuation(light, this.lightConstantAttenuation[light]);
            re.setLightLinearAttenuation(light, this.lightLinearAttenuation[light]);
            re.setLightQuadraticAttenuation(light, this.lightQuadraticAttenuation[light]);
            re.setLightAmbientColor(light, this.lightAmbientColor[light]);
            re.setLightDiffuseColor(light, this.lightDiffuseColor[light]);
            re.setLightSpecularColor(light, this.lightSpecularColor[light]);
        }
        re.setFrontFace(this.frontFaceCw);
        re.setTextureEnvColor(this.tex_env_color);
        re.setFogColor(this.fog_color);
        re.setColorTestFunc(this.colorTestFunc);
        re.setColorTestReference(this.colorTestRef);
        re.setColorTestMask(this.colorTestMsk);
        re.setAlphaFunc(this.alphaFunc, this.alphaRef, this.alphaMask);
        re.setStencilFunc(this.stencilFunc, this.stencilRef, this.stencilMask);
        re.setStencilOp(this.stencilOpFail, this.stencilOpZFail, this.stencilOpZPass);
        re.setBlendEquation(this.blendEquation);
        re.setLogicOp(this.logicOp);
        re.setDepthMask(this.depthMask);
        re.setColorMask(this.colorMask[0], this.colorMask[1], this.colorMask[2], this.colorMask[3]);
        re.setTextureFunc(this.textureFunc, this.textureAlphaUsed, this.textureColorDoubled);
        this.dirty = false;
    }

    public void setDirty() {
        this.dirty = true;
    }

    @Override
    protected void read() {
        this.base = this.read32();
        this.baseOffset = this.read32();
        this.fbp = this.read32();
        this.fbw = this.read32();
        this.zbp = this.read32();
        this.zbw = this.read32();
        this.psm = this.read32();
        int flagBits = this.read32();
        for (EnableDisableFlag flag : this.flags) {
            flag.restore(flagBits);
        }
        this.region_x1 = this.read32();
        this.region_y1 = this.read32();
        this.region_x2 = this.read32();
        this.region_y2 = this.read32();
        this.region_width = this.read32();
        this.region_height = this.read32();
        this.scissor_x1 = this.read32();
        this.scissor_y1 = this.read32();
        this.scissor_x2 = this.read32();
        this.scissor_y2 = this.read32();
        this.scissor_width = this.read32();
        this.scissor_height = this.read32();
        this.offset_x = this.read32();
        this.offset_y = this.read32();
        this.viewport_width = this.read32();
        this.viewport_height = this.read32();
        this.viewport_cx = this.read32();
        this.viewport_cy = this.read32();
        this.readFloatArray(this.proj_uploaded_matrix);
        this.readFloatArray(this.texture_uploaded_matrix);
        this.readFloatArray(this.model_uploaded_matrix);
        this.readFloatArray(this.view_uploaded_matrix);
        this.readFloatArray(this.bone_uploaded_matrix);
        int j = 0;
        for (int matrix = 0; matrix < this.bone_uploaded_matrix.length; ++matrix) {
            int i = 0;
            while (i < 12) {
                this.boneMatrixLinear[j / 3 * 4 + j % 3] = this.bone_uploaded_matrix[matrix][i];
                ++i;
                ++j;
            }
        }
        this.depthMask = this.readBoolean();
        this.read32Array(this.colorMask);
        this.alphaFunc = this.read32();
        this.alphaRef = this.read32();
        this.alphaMask = this.read32();
        this.stencilFunc = this.read32();
        this.stencilRef = this.read32();
        this.stencilMask = this.read32();
        this.stencilOpFail = this.read32();
        this.stencilOpZFail = this.read32();
        this.stencilOpZPass = this.read32();
        this.textureFunc = this.read32();
        this.textureColorDoubled = this.readBoolean();
        this.textureAlphaUsed = this.readBoolean();
        this.frontFaceCw = this.readBoolean();
        this.depthFunc = this.read32();
        this.readFloatArray(this.morph_weight);
        this.readFloatArray(this.tex_envmap_matrix);
        this.readFloatArray(this.light_pos);
        this.readFloatArray(this.light_dir);
        this.read32Array(this.light_type);
        this.read32Array(this.light_kind);
        this.readFloatArray(this.lightAmbientColor);
        this.readFloatArray(this.lightDiffuseColor);
        this.readFloatArray(this.lightSpecularColor);
        this.readFloatArray(this.spotLightExponent);
        this.readFloatArray(this.spotLightCutoff);
        this.readFloatArray(this.lightConstantAttenuation);
        this.readFloatArray(this.lightLinearAttenuation);
        this.readFloatArray(this.lightQuadraticAttenuation);
        this.lightMode = this.read32();
        this.readFloatArray(this.fog_color);
        this.fog_far = this.readFloat();
        this.fog_dist = this.readFloat();
        this.nearZ = this.read16();
        this.farZ = this.read16();
        this.zscale = this.readFloat();
        this.zpos = this.readFloat();
        this.mat_flags = this.read32();
        this.readFloatArray(this.mat_ambient);
        this.readFloatArray(this.mat_diffuse);
        this.readFloatArray(this.mat_specular);
        this.readFloatArray(this.mat_emission);
        this.readFloatArray(this.ambient_light);
        this.materialShininess = this.readFloat();
        this.texture_storage = this.read32();
        this.texture_num_mip_maps = this.read32();
        this.texture_swizzle = this.readBoolean();
        this.read32Array(this.texture_base_pointer);
        this.read32Array(this.texture_width);
        this.read32Array(this.texture_height);
        this.read32Array(this.texture_buffer_width);
        this.tex_min_filter = this.read32();
        this.tex_mag_filter = this.read32();
        this.tex_mipmap_mode = this.read32();
        this.tex_mipmap_bias = this.readFloat();
        this.tex_mipmap_bias_int = this.read32();
        this.mipmapShareClut = this.readBoolean();
        this.tex_translate_x = this.readFloat();
        this.tex_translate_y = this.readFloat();
        this.tex_scale_x = this.readFloat();
        this.tex_scale_y = this.readFloat();
        this.readFloatArray(this.tex_env_color);
        this.tex_clut_addr = this.read32();
        this.tex_clut_num_blocks = this.read32();
        this.tex_clut_mode = this.read32();
        this.tex_clut_shift = this.read32();
        this.tex_clut_mask = this.read32();
        this.tex_clut_start = this.read32();
        this.tex_wrap_s = this.read32();
        this.tex_wrap_t = this.read32();
        this.tex_shade_u = this.read32();
        this.tex_shade_v = this.read32();
        this.patch_div_s = this.read32();
        this.patch_div_t = this.read32();
        this.patch_prim = this.read32();
        this.tslope_level = this.readFloat();
        this.transform_mode = this.read32();
        this.textureTx_sourceAddress = this.read32();
        this.textureTx_sourceLineWidth = this.read32();
        this.textureTx_destinationAddress = this.read32();
        this.textureTx_destinationLineWidth = this.read32();
        this.textureTx_width = this.read32();
        this.textureTx_height = this.read32();
        this.textureTx_sx = this.read32();
        this.textureTx_sy = this.read32();
        this.textureTx_dx = this.read32();
        this.textureTx_dy = this.read32();
        this.textureTx_pixelSize = this.read32();
        this.readFloatArray(this.dfix_color);
        this.readFloatArray(this.sfix_color);
        this.blend_src = this.read32();
        this.blend_dst = this.read32();
        this.blendEquation = this.read32();
        this.read32Array(this.dither_matrix);
        this.tex_map_mode = this.read32();
        this.tex_proj_map_mode = this.read32();
        this.colorTestFunc = this.read32();
        this.read32Array(this.colorTestRef);
        this.read32Array(this.colorTestMsk);
        this.shadeModel = this.read32();
        this.logicOp = this.read32();
        VideoEngine.getInstance().resetCurrentListCMDValues();
        if (this.getOffset() > this.sizeof()) {
            log.error((Object)String.format("GE context overflow: %d (max allowed=%d)", this.getOffset(), this.sizeof()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("GE context read size: %d (max allowed=%d)", this.getOffset(), this.sizeof()));
        }
    }

    @Override
    protected void write() {
        this.write32(this.base);
        this.write32(this.baseOffset);
        this.write32(this.fbp);
        this.write32(this.fbw);
        this.write32(this.zbp);
        this.write32(this.zbw);
        this.write32(this.psm);
        int flagBits = 0;
        for (EnableDisableFlag flag : this.flags) {
            flagBits = flag.save(flagBits);
        }
        this.write32(flagBits);
        this.write32(this.region_x1);
        this.write32(this.region_y1);
        this.write32(this.region_x2);
        this.write32(this.region_y2);
        this.write32(this.region_width);
        this.write32(this.region_height);
        this.write32(this.scissor_x1);
        this.write32(this.scissor_y1);
        this.write32(this.scissor_x2);
        this.write32(this.scissor_y2);
        this.write32(this.scissor_width);
        this.write32(this.scissor_height);
        this.write32(this.offset_x);
        this.write32(this.offset_y);
        this.write32(this.viewport_width);
        this.write32(this.viewport_height);
        this.write32(this.viewport_cx);
        this.write32(this.viewport_cy);
        this.writeFloatArray(this.proj_uploaded_matrix);
        this.writeFloatArray(this.texture_uploaded_matrix);
        this.writeFloatArray(this.model_uploaded_matrix);
        this.writeFloatArray(this.view_uploaded_matrix);
        this.writeFloatArray(this.bone_uploaded_matrix);
        this.writeBoolean(this.depthMask);
        this.write32Array(this.colorMask);
        this.write32(this.alphaFunc);
        this.write32(this.alphaRef);
        this.write32(this.alphaMask);
        this.write32(this.stencilFunc);
        this.write32(this.stencilRef);
        this.write32(this.stencilMask);
        this.write32(this.stencilOpFail);
        this.write32(this.stencilOpZFail);
        this.write32(this.stencilOpZPass);
        this.write32(this.textureFunc);
        this.writeBoolean(this.textureColorDoubled);
        this.writeBoolean(this.textureAlphaUsed);
        this.writeBoolean(this.frontFaceCw);
        this.write32(this.depthFunc);
        this.writeFloatArray(this.morph_weight);
        this.writeFloatArray(this.tex_envmap_matrix);
        this.writeFloatArray(this.light_pos);
        this.writeFloatArray(this.light_dir);
        this.write32Array(this.light_type);
        this.write32Array(this.light_kind);
        this.writeFloatArray(this.lightAmbientColor);
        this.writeFloatArray(this.lightDiffuseColor);
        this.writeFloatArray(this.lightSpecularColor);
        this.writeFloatArray(this.spotLightExponent);
        this.writeFloatArray(this.spotLightCutoff);
        this.writeFloatArray(this.lightConstantAttenuation);
        this.writeFloatArray(this.lightLinearAttenuation);
        this.writeFloatArray(this.lightQuadraticAttenuation);
        this.write32(this.lightMode);
        this.writeFloatArray(this.fog_color);
        this.writeFloat(this.fog_far);
        this.writeFloat(this.fog_dist);
        this.write16((short)this.nearZ);
        this.write16((short)this.farZ);
        this.writeFloat(this.zscale);
        this.writeFloat(this.zpos);
        this.write32(this.mat_flags);
        this.writeFloatArray(this.mat_ambient);
        this.writeFloatArray(this.mat_diffuse);
        this.writeFloatArray(this.mat_specular);
        this.writeFloatArray(this.mat_emission);
        this.writeFloatArray(this.ambient_light);
        this.writeFloat(this.materialShininess);
        this.write32(this.texture_storage);
        this.write32(this.texture_num_mip_maps);
        this.writeBoolean(this.texture_swizzle);
        this.write32Array(this.texture_base_pointer);
        this.write32Array(this.texture_width);
        this.write32Array(this.texture_height);
        this.write32Array(this.texture_buffer_width);
        this.write32(this.tex_min_filter);
        this.write32(this.tex_mag_filter);
        this.write32(this.tex_mipmap_mode);
        this.writeFloat(this.tex_mipmap_bias);
        this.write32(this.tex_mipmap_bias_int);
        this.writeBoolean(this.mipmapShareClut);
        this.writeFloat(this.tex_translate_x);
        this.writeFloat(this.tex_translate_y);
        this.writeFloat(this.tex_scale_x);
        this.writeFloat(this.tex_scale_y);
        this.writeFloatArray(this.tex_env_color);
        this.write32(this.tex_clut_addr);
        this.write32(this.tex_clut_num_blocks);
        this.write32(this.tex_clut_mode);
        this.write32(this.tex_clut_shift);
        this.write32(this.tex_clut_mask);
        this.write32(this.tex_clut_start);
        this.write32(this.tex_wrap_s);
        this.write32(this.tex_wrap_t);
        this.write32(this.tex_shade_u);
        this.write32(this.tex_shade_v);
        this.write32(this.patch_div_s);
        this.write32(this.patch_div_t);
        this.write32(this.patch_prim);
        this.writeFloat(this.tslope_level);
        this.write32(this.transform_mode);
        this.write32(this.textureTx_sourceAddress);
        this.write32(this.textureTx_sourceLineWidth);
        this.write32(this.textureTx_destinationAddress);
        this.write32(this.textureTx_destinationLineWidth);
        this.write32(this.textureTx_width);
        this.write32(this.textureTx_height);
        this.write32(this.textureTx_sx);
        this.write32(this.textureTx_sy);
        this.write32(this.textureTx_dx);
        this.write32(this.textureTx_dy);
        this.write32(this.textureTx_pixelSize);
        this.writeFloatArray(this.dfix_color);
        this.writeFloatArray(this.sfix_color);
        this.write32(this.blend_src);
        this.write32(this.blend_dst);
        this.write32(this.blendEquation);
        this.write32Array(this.dither_matrix);
        this.write32(this.tex_map_mode);
        this.write32(this.tex_proj_map_mode);
        this.write32(this.colorTestFunc);
        this.write32Array(this.colorTestRef);
        this.write32Array(this.colorTestMsk);
        this.write32(this.shadeModel);
        this.write32(this.logicOp);
        if (this.getOffset() > this.sizeof()) {
            log.error((Object)String.format("GE context overflow: %d (max allowed=%d)", this.getOffset(), this.sizeof()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("GE context write size: %d (max allowed=%d)", this.getOffset(), this.sizeof()));
        }
    }

    @Override
    public int sizeof() {
        return 2048;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (EnableDisableFlag flag : this.flags) {
            if (!flag.isEnabled()) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(flag.toString());
        }
        return result.toString();
    }

    public class EnableDisableFlag {
        private boolean enabled;
        private final int reFlag;
        private final String name;
        private int contextBit;

        public EnableDisableFlag(String name, int reFlag) {
            this.name = name;
            this.reFlag = reFlag;
            this.init();
        }

        private void init() {
            this.enabled = false;
            this.contextBit = contextBitCount++;
            GeContext.this.flags.add(this);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int isEnabledInt() {
            return this.enabled ? 1 : 0;
        }

        public void setEnabled(IRenderingEngine re, int enabledInt) {
            this.setEnabled(re, enabledInt != 0);
        }

        public void setEnabled(IRenderingEngine re, boolean enabled) {
            this.enabled = enabled;
            this.update(re);
            if (log.isDebugEnabled() && this.name != null) {
                log.debug((Object)String.format("sceGu%s(%s)", enabled ? "Enable" : "Disable", this.name));
            }
        }

        public void update(IRenderingEngine re) {
            if (this.enabled) {
                re.enableFlag(this.reFlag);
            } else {
                re.disableFlag(this.reFlag);
            }
        }

        public void updateEnabled(IRenderingEngine re) {
            if (this.enabled) {
                re.enableFlag(this.reFlag);
            }
        }

        public int save(int bits) {
            if (this.enabled) {
                bits |= 1 << this.contextBit;
            }
            return bits;
        }

        public void restore(int bits) {
            this.enabled = (bits & 1 << this.contextBit) != 0;
        }

        public int getReFlag() {
            return this.reFlag;
        }

        public String toString() {
            return this.name;
        }
    }
}

