/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import jpcsp.HLE.Modules;
import jpcsp.graphics.RE.AnisotropicFilter;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.REFixedFunction;
import jpcsp.graphics.RE.REShader;
import jpcsp.graphics.RE.RenderingEngineLwjgl;
import jpcsp.graphics.RE.StateProxy;
import jpcsp.graphics.RE.ViewportFilter;
import jpcsp.graphics.RE.software.RESoftware;

public class RenderingEngineFactory {
    private static final boolean enableDebugProxy = false;
    private static final boolean enableCheckErrorsProxy = false;
    private static final boolean enableStatisticsProxy = false;

    private static IRenderingEngine createRenderingEngine(boolean forDisplay) {
        boolean isUsingSoftwareRenderer = Modules.sceDisplayModule.isUsingSoftwareRenderer();
        IRenderingEngine re = isUsingSoftwareRenderer ? new RESoftware() : RenderingEngineLwjgl.newInstance();
        if (!isUsingSoftwareRenderer) {
            re = REShader.useShaders(re) ? new REShader(re) : new REFixedFunction(re);
        }
        re = new StateProxy(re);
        re = new AnisotropicFilter(re);
        re = new ViewportFilter(re);
        return re;
    }

    public static IRenderingEngine createRenderingEngine() {
        return RenderingEngineFactory.createRenderingEngine(false);
    }

    public static IRenderingEngine createRenderingEngineForDisplay() {
        return RenderingEngineFactory.createRenderingEngine(true);
    }

    public static IRenderingEngine createInitialRenderingEngine() {
        IRenderingEngine re = RenderingEngineLwjgl.newInstance();
        return re;
    }
}

