/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jpcsp.graphics.RE.BaseRenderingEngineProxy;
import jpcsp.graphics.RE.CheckErrorsProxy;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.NullRenderingEngine;
import jpcsp.graphics.RE.RenderingEngineLwjgl12;
import jpcsp.graphics.RE.RenderingEngineLwjgl15;
import jpcsp.graphics.RE.RenderingEngineLwjgl31;
import jpcsp.graphics.VideoEngine;
import jpcsp.plugins.XBRZNativeFilter;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBGeometryShader4;
import org.lwjgl.opengl.ARBSync;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.EXTDirectStateAccess;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.NVTextureBarrier;

public class RenderingEngineLwjgl
extends NullRenderingEngine {
    protected static final int[] flagToGL = new int[]{3008, 2929, 3089, 2960, 3042, 2884, 3024, 2912, 0, 3553, 2896, 16384, 16385, 16386, 16387, 2848, 0, 0, 3058, 0, 0, 0, 2903, 3168, 3169};
    protected static final int[] shadeModelToGL = new int[]{7424, 7425};
    protected static final int[] colorTypeToGL = new int[]{4608, 5632, 4609, 4610};
    protected static final int[] lightModeToGL = new int[]{33273, 33274};
    protected static final int[] blendSrcToGL = new int[]{774, 775, 770, 771, 772, 773, 770, 771, 772, 773, 32769, 32770, 0, 1};
    protected static final int[] blendDstToGL = new int[]{768, 769, 770, 771, 772, 773, 770, 771, 772, 773, 32769, 32770, 0, 1};
    protected static final int[] logicOpToGL = new int[]{5376, 5377, 5378, 5379, 5380, 5381, 5382, 5383, 5384, 5385, 5386, 5387, 5388, 5389, 5390, 5391};
    protected static final int[] wrapModeToGL = new int[]{10497, 33071};
    protected static final int[] colorMaterialToGL = new int[]{4608, 4608, 4609, 5634, 4610, 4608, 4609, 5634};
    protected static final int[] depthFuncToGL = new int[]{512, 519, 514, 517, 513, 515, 516, 518};
    protected static final int[] texEnvNameToGL = new int[]{34161, 34162, 34163, 3356, 34176, 34177, 34178, 34184, 34185, 34186, 34192, 34193, 34194, 34200, 34201, 34202, 8704};
    protected static final int[] texEnvParamToGL = new int[]{8448, 8449, 3042, 7681, 260, 34165, 34023, 5890, 34166, 34168, 768, 770, 34160};
    protected static final int[] shaderTypeToGL = new int[]{35633, 35632, 36313, 36488, 36487, 37305};
    protected static final int[] primitiveToGL = new int[]{0, 1, 3, 4, 5, 6, 7, 7, 10, 12, 13, 14, 5, 3, 0, 5, 3, 0};
    protected static final int[] clientStateToGL = new int[]{32888, 32886, 32885, 32884};
    protected static final int[] pointerTypeToGL = new int[]{5120, 5121, 5122, 5123, 5124, 5125, 5126, 5130};
    protected static final int[] bufferUsageToGL = new int[]{35040, 35041, 35042, 35044, 35045, 35046, 35048, 35049, 35050};
    protected static final int[] mipmapFilterToGL = new int[]{9728, 9729, 9728, 9728, 9984, 9985, 9986, 9987};
    protected static final int[] textureFormatToGL = new int[]{6407, 6408, 6408, 6408, 36244, 36244, 36244, 36244, 33777, 33778, 33779, 6407, 6408, 6408, 6408, 6402, 34041, 34041};
    protected static final int[] textureInternalFormatToGL = new int[]{6407, 6408, 6408, 6408, 33330, 33330, 33332, 33334, 33777, 33778, 33779, 6407, 6408, 6408, 6408, 33189, 34041, 34041};
    protected static final int[] textureTypeToGL = new int[]{33636, 33638, 33637, 5121, 5121, 5121, 5123, 5125, 33777, 33778, 33779, 33636, 33638, 33637, 5121, 5123, 34042, 34042};
    protected static final int[] stencilOpToGL = new int[]{7680, 0, 7681, 5386, 7682, 7683};
    protected static final int[] stencilFuncToGL = new int[]{512, 519, 514, 517, 513, 515, 516, 518};
    protected static final int[] alphaFuncToGL = new int[]{512, 519, 514, 517, 513, 515, 516, 518};
    protected static final int[] blendModeToGL = new int[]{32774, 32778, 32779, 32775, 32776, 32774};
    protected static final int[] programParameterToGL = new int[]{36315, 36316, 36314};
    protected static final int[] bufferTargetToGL = new int[]{34962, 35345, 34963};
    protected static final int[] matrixModeToGL = new int[]{5889, 5888, 5888, 5890, 5888};
    protected static final int[] framebufferTargetToGL = new int[]{36160, 36008, 36009};
    protected static final int[] attachmentToGL = new int[]{36096, 36128, 33306, 36064, 36065, 36066, 36067, 36068, 36069, 36070, 36071};
    protected static final int[] pixelTransferToGL = new int[]{3344, 3345, 3346, 3347, 3348, 3352, 3354, 3356, 3359, 3349, 3353, 3355, 3357, 3359};
    protected static final int[] pixelMapToGL = new int[]{3184, 3185, 3186, 3187, 3188, 3189, 3190, 3191, 3192, 3193};
    protected static final int[] buffersMaskToGL = new int[]{16384, 256, 1024};
    protected static final int[] textureLevelParameterToGL = new int[]{4096, 4097, 32881, 4099, 35856, 35857, 35858, 35859, 35862, 32860, 32861, 32862, 32863, 34890, 34465, 34464, 37277, 37278};
    protected static final int[] patchParameterToGL = new int[]{36466, 36468, 36467};
    protected static final int[] polygonModeToGL = new int[]{6914, 6913, 6912};
    protected static final int[] framebufferBindingTargetToGL = new int[]{36006, 36010, 36006};
    protected boolean vendorIntel;
    protected boolean hasOpenGL30;

    public static String getVersion() {
        GL.createCapabilities();
        return GL11.glGetString((int)7938);
    }

    public static IRenderingEngine newInstance() {
        if (GL.getCapabilities().OpenGL31) {
            log.info((Object)"Using RenderingEngineLwjgl31");
            return new RenderingEngineLwjgl31();
        }
        if (GL.getCapabilities().OpenGL15) {
            log.info((Object)"Using RenderingEngineLwjgl15");
            return new RenderingEngineLwjgl15();
        }
        if (GL.getCapabilities().OpenGL12) {
            log.info((Object)"Using RenderingEngineLwjgl12");
            return new RenderingEngineLwjgl12();
        }
        log.info((Object)"Using RenderingEngineLwjgl");
        return new RenderingEngineLwjgl();
    }

    public RenderingEngineLwjgl() {
        this.init();
    }

    protected void init() {
        String s;
        String openGLVersion = GL11.glGetString((int)7938);
        String openGLVendor = GL11.glGetString((int)7936);
        String openGLRenderer = GL11.glGetString((int)7937);
        log.info((Object)String.format("OpenGL version: %s, vender: %s, renderer: %s", openGLVersion, openGLVendor, openGLRenderer));
        this.vendorIntel = "Intel".equalsIgnoreCase(openGLVendor);
        this.hasOpenGL30 = GL.getCapabilities().OpenGL30;
        if (GL.getCapabilities().OpenGL20) {
            String shadingLanguageVersion = GL11.glGetString((int)35724);
            log.info((Object)("Shading Language version: " + shadingLanguageVersion));
        }
        if (GL.getCapabilities().OpenGL30) {
            int contextFlags = GL11.glGetInteger((int)33310);
            s = String.format("GL_CONTEXT_FLAGS: 0x%X", contextFlags);
            if ((contextFlags & 1) != 0) {
                s = s + " (GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT)";
            }
            log.info((Object)s);
        }
        if (GL.getCapabilities().OpenGL32) {
            int contextProfileMask = GL11.glGetInteger((int)37158);
            s = String.format("GL_CONTEXT_PROFILE_MASK: 0x%X", contextProfileMask);
            if ((contextProfileMask & 1) != 0) {
                s = s + " (GL_CONTEXT_CORE_PROFILE_BIT)";
            }
            if ((contextProfileMask & 2) != 0) {
                s = s + " (GL_CONTEXT_COMPATIBILITY_PROFILE_BIT)";
            }
            log.info((Object)s);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Supported extensions: %s", GL11.glGetString((int)7939)));
        }
    }

    @Override
    public void disableFlag(int flag) {
        int glFlag = flagToGL[flag];
        if (glFlag != 0) {
            GL11.glDisable((int)glFlag);
        }
    }

    @Override
    public void enableFlag(int flag) {
        int glFlag = flagToGL[flag];
        if (glFlag != 0) {
            GL11.glEnable((int)glFlag);
        }
    }

    @Override
    public void setDepthRange(float zpos, float zscale, int near, int far) {
        GL11.glDepthRange((double)((zpos - zscale) / 65535.0f), (double)((zpos + zscale) / 65535.0f));
    }

    @Override
    public void setDepthFunc(int func) {
        GL11.glDepthFunc((int)depthFuncToGL[func]);
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void setShadeModel(int model) {
        GL11.glShadeModel((int)shadeModelToGL[model]);
    }

    @Override
    public void setMaterialEmissionColor(float[] color) {
        GL11.glMaterialfv((int)1028, (int)5632, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setMaterialAmbientColor(float[] color) {
        GL11.glMaterialfv((int)1028, (int)4608, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setMaterialDiffuseColor(float[] color) {
        GL11.glMaterialfv((int)1028, (int)4609, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setMaterialSpecularColor(float[] color) {
        GL11.glMaterialfv((int)1028, (int)4610, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightModelAmbientColor(float[] color) {
        GL11.glLightModelfv((int)2899, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightMode(int mode) {
        GL11.glLightModeli((int)33272, (int)lightModeToGL[mode]);
    }

    @Override
    public void setLightAmbientColor(int light, float[] color) {
        GL11.glLightfv((int)(16384 + light), (int)4608, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightDiffuseColor(int light, float[] color) {
        GL11.glLightfv((int)(16384 + light), (int)4609, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightSpecularColor(int light, float[] color) {
        GL11.glLightfv((int)(16384 + light), (int)4610, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setLightConstantAttenuation(int light, float constant) {
        GL11.glLightf((int)(16384 + light), (int)4615, (float)constant);
    }

    @Override
    public void setLightLinearAttenuation(int light, float linear) {
        GL11.glLightf((int)(16384 + light), (int)4616, (float)linear);
    }

    @Override
    public void setLightQuadraticAttenuation(int light, float quadratic) {
        GL11.glLightf((int)(16384 + light), (int)4617, (float)quadratic);
    }

    @Override
    public void setLightDirection(int light, float[] direction) {
        GL11.glLightfv((int)(16384 + light), (int)4612, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(direction));
    }

    @Override
    public void setLightPosition(int light, float[] position) {
        GL11.glLightfv((int)(16384 + light), (int)4611, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(position));
    }

    @Override
    public void setLightSpotCutoff(int light, float cutoff, float pspCutoff) {
        GL11.glLightf((int)(16384 + light), (int)4614, (float)cutoff);
    }

    @Override
    public void setLightSpotExponent(int light, float exponent) {
        GL11.glLightf((int)(16384 + light), (int)4613, (float)exponent);
    }

    @Override
    public void setBlendColor(float[] color) {
        try {
            GL14.glBlendColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        }
        catch (IllegalStateException e) {
            log.warn((Object)("VideoEngine: " + e.getMessage()));
        }
    }

    @Override
    public void setBlendFunc(int src, int dst) {
        try {
            GL11.glBlendFunc((int)blendSrcToGL[src], (int)blendDstToGL[dst]);
        }
        catch (IllegalStateException e) {
            log.warn((Object)("VideoEngine: " + e.getMessage()));
        }
    }

    @Override
    public void setLogicOp(int logicOp) {
        GL11.glLogicOp((int)logicOpToGL[logicOp]);
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        GL11.glColorMask((boolean)redWriteEnabled, (boolean)greenWriteEnabled, (boolean)blueWriteEnabled, (boolean)alphaWriteEnabled);
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        GL11.glDepthMask((boolean)depthWriteEnabled);
    }

    @Override
    public void setTextureWrapMode(int s, int t) {
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapModeToGL[s]);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapModeToGL[t]);
    }

    @Override
    public void setTextureMipmapMinLevel(int level) {
        GL11.glTexParameteri((int)3553, (int)33084, (int)level);
    }

    @Override
    public void setTextureMipmapMaxLevel(int level) {
        GL11.glTexParameteri((int)3553, (int)33085, (int)level);
    }

    @Override
    public void setTextureMipmapMinFilter(int filter) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)mipmapFilterToGL[filter]);
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
        GL11.glTexParameteri((int)3553, (int)10240, (int)mipmapFilterToGL[filter]);
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
        int index = (ambient ? 1 : 0) | (diffuse ? 2 : 0) | (specular ? 4 : 0);
        GL11.glColorMaterial((int)1032, (int)colorMaterialToGL[index]);
    }

    @Override
    public void setTextureEnvironmentMapping(int u, int v) {
        GL11.glTexGeni((int)8192, (int)9472, (int)9218);
        GL11.glTexGeni((int)8193, (int)9472, (int)9218);
    }

    @Override
    public void setVertexColor(float[] color) {
        GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
    }

    @Override
    public void setUniform(int id, int value) {
        GL20.glUniform1i((int)id, (int)value);
    }

    @Override
    public void setUniform(int id, int value1, int value2) {
        GL20.glUniform2i((int)id, (int)value1, (int)value2);
    }

    @Override
    public void setUniform(int id, float value) {
        GL20.glUniform1f((int)id, (float)value);
    }

    @Override
    public void setUniform1v(int id, float[] values) {
        GL20.glUniform1fv((int)id, (float[])values);
    }

    @Override
    public void setUniform2(int id, int[] values) {
        GL20.glUniform2i((int)id, (int)values[0], (int)values[1]);
    }

    @Override
    public void setUniform3(int id, int[] values) {
        GL20.glUniform3i((int)id, (int)values[0], (int)values[1], (int)values[2]);
    }

    @Override
    public void setUniform3(int id, float[] values) {
        GL20.glUniform3f((int)id, (float)values[0], (float)values[1], (float)values[2]);
    }

    @Override
    public void setUniform3v(int id, float[] values) {
        GL20.glUniform3fv((int)id, (float[])values);
    }

    @Override
    public void setUniform4(int id, int[] values) {
        GL20.glUniform4i((int)id, (int)values[0], (int)values[1], (int)values[2], (int)values[3]);
    }

    @Override
    public void setUniform4(int id, float[] values) {
        GL20.glUniform4f((int)id, (float)values[0], (float)values[1], (float)values[2], (float)values[3]);
    }

    @Override
    public void setUniformMatrix3(int id, int count, float[] values) {
        GL20.glUniformMatrix3fv((int)id, (boolean)false, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(values, count * 9));
    }

    @Override
    public void setUniformMatrix4(int id, int count, float[] values) {
        GL20.glUniformMatrix4fv((int)id, (boolean)false, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(values, count * 16));
    }

    @Override
    public void setTexEnv(int name, int param) {
        GL11.glTexEnvi((int)8960, (int)texEnvNameToGL[name], (int)texEnvParamToGL[param]);
    }

    @Override
    public void setTexEnv(int name, float param) {
        GL11.glTexEnvf((int)8960, (int)texEnvNameToGL[name], (float)param);
    }

    @Override
    public void attachShader(int program, int shader) {
        GL20.glAttachShader((int)program, (int)shader);
    }

    @Override
    public boolean compilerShader(int shader, String source) {
        GL20.glShaderSource((int)shader, (CharSequence)source);
        GL20.glCompileShader((int)shader);
        return GL20.glGetShaderi((int)shader, (int)35713) == 1;
    }

    @Override
    public int createProgram() {
        return GL20.glCreateProgram();
    }

    @Override
    public void useProgram(int program) {
        GL20.glUseProgram((int)program);
    }

    @Override
    public int createShader(int type) {
        return GL20.glCreateShader((int)shaderTypeToGL[type]);
    }

    @Override
    public int getAttribLocation(int program, String name) {
        return GL20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    @Override
    public void bindAttribLocation(int program, int index, String name) {
        GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    @Override
    public int getUniformLocation(int program, String name) {
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    @Override
    public boolean linkProgram(int program) {
        GL20.glLinkProgram((int)program);
        return GL20.glGetProgrami((int)program, (int)35714) == 1;
    }

    @Override
    public boolean validateProgram(int program) {
        GL20.glValidateProgram((int)program);
        return GL20.glGetProgrami((int)program, (int)35715) == 1;
    }

    @Override
    public String getProgramInfoLog(int program) {
        int infoLogLength = GL20.glGetProgrami((int)program, (int)35716);
        if (infoLogLength <= 1) {
            return null;
        }
        String infoLog = GL20.glGetProgramInfoLog((int)program, (int)infoLogLength);
        while (infoLog.length() > 0 && infoLog.charAt(infoLog.length() - 1) == '\u0000') {
            infoLog = infoLog.substring(0, infoLog.length() - 1);
        }
        return infoLog;
    }

    @Override
    public String getShaderInfoLog(int shader) {
        int infoLogLength = GL20.glGetShaderi((int)shader, (int)35716);
        if (infoLogLength <= 1) {
            return null;
        }
        String infoLog = GL20.glGetShaderInfoLog((int)shader, (int)infoLogLength);
        while (infoLog.length() > 0 && infoLog.charAt(infoLog.length() - 1) == '\u0000') {
            infoLog = infoLog.substring(0, infoLog.length() - 1);
        }
        return infoLog;
    }

    @Override
    public boolean isExtensionAvailable(String name) {
        String extensions = GL11.glGetString((int)7939);
        if (extensions == null) {
            return false;
        }
        return (" " + extensions + " ").indexOf(" " + name + " ") >= 0;
    }

    @Override
    public void drawArrays(int primitive, int first, int count) {
        GL11.glDrawArrays((int)primitiveToGL[primitive], (int)first, (int)count);
    }

    @Override
    public void deleteBuffer(int buffer) {
        ARBVertexBufferObject.glDeleteBuffersARB((int)buffer);
    }

    @Override
    public int genBuffer() {
        return ARBVertexBufferObject.glGenBuffersARB();
    }

    @Override
    public void setBufferData(int target, int size, Buffer buffer, int usage) {
        if (buffer instanceof ByteBuffer) {
            ARBVertexBufferObject.glBufferDataARB((int)bufferTargetToGL[target], (ByteBuffer)this.directBufferUtilities.getDirectBuffer(size, (ByteBuffer)buffer), (int)bufferUsageToGL[usage]);
        } else if (buffer instanceof IntBuffer) {
            ARBVertexBufferObject.glBufferDataARB((int)bufferTargetToGL[target], (IntBuffer)this.directBufferUtilities.getDirectBuffer(size, (IntBuffer)buffer), (int)bufferUsageToGL[usage]);
        } else if (buffer instanceof ShortBuffer) {
            ARBVertexBufferObject.glBufferDataARB((int)bufferTargetToGL[target], (ShortBuffer)this.directBufferUtilities.getDirectBuffer(size, (ShortBuffer)buffer), (int)bufferUsageToGL[usage]);
        } else if (buffer instanceof FloatBuffer) {
            ARBVertexBufferObject.glBufferDataARB((int)bufferTargetToGL[target], (FloatBuffer)this.directBufferUtilities.getDirectBuffer(size, (FloatBuffer)buffer), (int)bufferUsageToGL[usage]);
        } else if (buffer == null) {
            ARBVertexBufferObject.glBufferDataARB((int)bufferTargetToGL[target], (long)size, (int)bufferUsageToGL[usage]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setBufferSubData(int target, int offset, int size, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            ARBVertexBufferObject.glBufferSubDataARB((int)bufferTargetToGL[target], (long)offset, (ByteBuffer)this.directBufferUtilities.getDirectBuffer(size, (ByteBuffer)buffer));
        } else if (buffer instanceof IntBuffer) {
            ARBVertexBufferObject.glBufferSubDataARB((int)bufferTargetToGL[target], (long)offset, (IntBuffer)this.directBufferUtilities.getDirectBuffer(size, (IntBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            ARBVertexBufferObject.glBufferSubDataARB((int)bufferTargetToGL[target], (long)offset, (ShortBuffer)this.directBufferUtilities.getDirectBuffer(size, (ShortBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            ARBVertexBufferObject.glBufferSubDataARB((int)bufferTargetToGL[target], (long)offset, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(size, (FloatBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void enableClientState(int type) {
        GL11.glEnableClientState((int)clientStateToGL[type]);
    }

    @Override
    public void enableVertexAttribArray(int id) {
        GL20.glEnableVertexAttribArray((int)id);
    }

    @Override
    public void disableClientState(int type) {
        GL11.glDisableClientState((int)clientStateToGL[type]);
    }

    @Override
    public void disableVertexAttribArray(int id) {
        GL20.glDisableVertexAttribArray((int)id);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, long offset) {
        GL11.glColorPointer((int)size, (int)pointerTypeToGL[type], (int)stride, (long)offset);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        GL11.glColorPointer((int)size, (int)pointerTypeToGL[type], (int)stride, (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(bufferSize, buffer, 0));
    }

    @Override
    public void setNormalPointer(int type, int stride, long offset) {
        GL11.glNormalPointer((int)pointerTypeToGL[type], (int)stride, (long)offset);
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        GL11.glNormalPointer((int)pointerTypeToGL[type], (int)stride, (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(bufferSize, buffer, 0));
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, long offset) {
        GL11.glTexCoordPointer((int)size, (int)pointerTypeToGL[type], (int)stride, (long)offset);
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        GL11.glTexCoordPointer((int)pointerTypeToGL[type], (int)size, (int)stride, (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(bufferSize, buffer, 0));
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, long offset) {
        GL11.glVertexPointer((int)size, (int)pointerTypeToGL[type], (int)stride, (long)offset);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        GL11.glVertexPointer((int)pointerTypeToGL[type], (int)size, (int)stride, (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(bufferSize, buffer, 0));
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, long offset) {
        GL20.glVertexAttribPointer((int)id, (int)size, (int)pointerTypeToGL[type], (boolean)normalized, (int)stride, (long)offset);
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, int bufferSize, Buffer buffer) {
        GL20.glVertexAttribPointer((int)id, (int)size, (int)pointerTypeToGL[type], (boolean)normalized, (int)stride, (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(bufferSize, buffer, 0));
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        if (!VideoEngine.getInstance().isUsexBRZFilter()) {
            GL11.glPixelStorei((int)3314, (int)rowLength);
        }
        GL11.glPixelStorei((int)3317, (int)alignment);
        GL11.glPixelStorei((int)3330, (int)rowLength);
        GL11.glPixelStorei((int)3333, (int)alignment);
    }

    @Override
    public int genTexture() {
        return GL11.glGenTextures();
    }

    @Override
    public void bindTexture(int texture) {
        GL11.glBindTexture((int)3553, (int)texture);
    }

    @Override
    public void deleteTexture(int texture) {
        GL11.glDeleteTextures((int)texture);
    }

    @Override
    public void setCompressedTexImage(int level, int internalFormat, int width, int height, int compressedSize, Buffer buffer) {
        GL13.glCompressedTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(compressedSize, buffer, 0));
    }

    @Override
    public void setTexImagexBRZ(int level, int internalFormat, int width, int height, int bufwidth, int format, int type, int textureSize, Buffer buffer) {
        if (buffer == null) {
            GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ByteBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer));
        } else if (buffer instanceof ByteBuffer) {
            if (bufwidth != -1) {
                ByteBuffer tmpbuf = this.directBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer);
                int length = tmpbuf.remaining();
                byte[] buf = new byte[length];
                tmpbuf.get(buf);
                XBRZNativeFilter.ScaleandSetTexImage(2, buf, level, textureInternalFormatToGL[internalFormat], width, height, bufwidth, textureFormatToGL[format], textureTypeToGL[type]);
            } else {
                GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ByteBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer));
            }
        } else if (buffer instanceof IntBuffer) {
            if (bufwidth != -1) {
                IntBuffer tmpbuf = this.directBufferUtilities.getDirectBuffer(textureSize, (IntBuffer)buffer);
                int length = tmpbuf.remaining();
                int[] buf = new int[length];
                tmpbuf.get(buf);
                XBRZNativeFilter.ScaleandSetTexImage(2, buf, level, textureInternalFormatToGL[internalFormat], width, height, bufwidth, textureFormatToGL[format], textureTypeToGL[type]);
            } else {
                GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (IntBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (IntBuffer)buffer));
            }
        } else if (buffer instanceof ShortBuffer) {
            if (bufwidth != -1) {
                ShortBuffer tmpbuf = this.directBufferUtilities.getDirectBuffer(textureSize, (ShortBuffer)buffer);
                int length = tmpbuf.remaining();
                short[] buf = new short[length];
                tmpbuf.get(buf);
                XBRZNativeFilter.ScaleandSetTexImage(2, buf, level, textureInternalFormatToGL[internalFormat], width, height, bufwidth, textureFormatToGL[format], textureTypeToGL[type]);
            } else {
                GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ShortBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ShortBuffer)buffer));
            }
        } else if (buffer instanceof FloatBuffer) {
            if (bufwidth != -1) {
                FloatBuffer tmpbuf = this.directBufferUtilities.getDirectBuffer(textureSize, (FloatBuffer)buffer);
                int length = tmpbuf.remaining();
                float[] buf = new float[length];
                tmpbuf.get(buf);
                XBRZNativeFilter.ScaleandSetTexImage(2, buf, level, textureInternalFormatToGL[internalFormat], width, height, bufwidth, textureFormatToGL[format], textureTypeToGL[type]);
            } else {
                GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (FloatBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (FloatBuffer)buffer));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        if (buffer instanceof ByteBuffer || buffer == null) {
            GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ByteBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer));
        } else if (buffer instanceof IntBuffer) {
            GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (IntBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (IntBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ShortBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ShortBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glTexImage2D((int)3553, (int)level, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height, (int)0, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (FloatBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (FloatBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setTexSubImage(int level, int xOffset, int yOffset, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        if (buffer instanceof ByteBuffer || buffer == null) {
            GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ByteBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ByteBuffer)buffer));
        } else if (buffer instanceof IntBuffer) {
            GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (IntBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (IntBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ShortBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (ShortBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (FloatBuffer)this.directBufferUtilities.getDirectBuffer(textureSize, (FloatBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp((int)stencilOpToGL[fail], (int)stencilOpToGL[zfail], (int)stencilOpToGL[zpass]);
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc((int)stencilFuncToGL[func], (int)ref, (int)mask);
    }

    @Override
    public void setAlphaFunc(int func, int ref, int mask) {
        GL11.glAlphaFunc((int)alphaFuncToGL[func], (float)((float)ref / 255.0f));
    }

    @Override
    public void setFogColor(float[] color) {
        GL11.glFogfv((int)2918, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setFogDist(float start, float end) {
        GL11.glFogf((int)2915, (float)start);
        GL11.glFogf((int)2916, (float)end);
    }

    @Override
    public void setTextureEnvColor(float[] color) {
        GL11.glTexEnvfv((int)8960, (int)8705, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(color));
    }

    @Override
    public void setFrontFace(boolean cw) {
        GL11.glFrontFace((int)(cw ? 2304 : 2305));
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void setBlendEquation(int mode) {
        try {
            GL14.glBlendEquation((int)blendModeToGL[mode]);
        }
        catch (IllegalStateException e) {
            log.warn((Object)("VideoEngine: " + e.getMessage()));
        }
    }

    @Override
    public void setFogHint() {
        GL11.glFogi((int)2917, (int)9729);
        GL11.glHint((int)3156, (int)4352);
    }

    @Override
    public void setLineSmoothHint() {
        GL11.glHint((int)3154, (int)4354);
    }

    @Override
    public void setMaterialShininess(float shininess) {
        GL11.glMaterialf((int)1028, (int)5633, (float)shininess);
    }

    @Override
    public void beginQuery(int id) {
        GL15.glBeginQuery((int)35092, (int)id);
    }

    @Override
    public void endQuery() {
        GL15.glEndQuery((int)35092);
    }

    @Override
    public int genQuery() {
        return GL15.glGenQueries();
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return true;
    }

    @Override
    public boolean getQueryResultAvailable(int id) {
        return GL15.glGetQueryObjecti((int)id, (int)34919) != 0;
    }

    @Override
    public int getQueryResult(int id) {
        return GL15.glGetQueryObjecti((int)id, (int)34918);
    }

    @Override
    public void copyTexSubImage(int level, int xOffset, int yOffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void getTexImage(int level, int format, int type, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            ByteBuffer directBuffer = this.directBufferUtilities.allocateDirectBuffer((ByteBuffer)buffer);
            GL11.glGetTexImage((int)3553, (int)level, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ByteBuffer)((ByteBuffer)buffer));
            this.directBufferUtilities.copyBuffer((ByteBuffer)buffer, directBuffer);
        } else if (buffer instanceof IntBuffer) {
            IntBuffer directBuffer = this.directBufferUtilities.allocateDirectBuffer((IntBuffer)buffer);
            GL11.glGetTexImage((int)3553, (int)level, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (IntBuffer)directBuffer);
            this.directBufferUtilities.copyBuffer((IntBuffer)buffer, directBuffer);
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer directBuffer = this.directBufferUtilities.allocateDirectBuffer((ShortBuffer)buffer);
            GL11.glGetTexImage((int)3553, (int)level, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (ShortBuffer)((ShortBuffer)buffer));
            this.directBufferUtilities.copyBuffer((ShortBuffer)buffer, directBuffer);
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer directBuffer = this.directBufferUtilities.allocateDirectBuffer((FloatBuffer)buffer);
            GL11.glGetTexImage((int)3553, (int)level, (int)textureFormatToGL[format], (int)textureTypeToGL[type], (FloatBuffer)((FloatBuffer)buffer));
            this.directBufferUtilities.copyBuffer((FloatBuffer)buffer, directBuffer);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void clear(float red, float green, float blue, float alpha) {
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glClear((int)16384);
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        return false;
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        return false;
    }

    @Override
    public boolean canNativeCurvePrimitive() {
        return false;
    }

    @Override
    public void setProgramParameter(int program, int parameter, int value) {
        if (parameter == 0 || parameter == 1) {
            value = primitiveToGL[value];
        }
        ARBGeometryShader4.glProgramParameteriARB((int)program, (int)programParameterToGL[parameter], (int)value);
    }

    @Override
    public boolean isQueryAvailable() {
        return GL.getCapabilities().OpenGL15;
    }

    @Override
    public boolean isShaderAvailable() {
        return GL.getCapabilities().OpenGL20;
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        ARBVertexBufferObject.glBindBufferARB((int)bufferTargetToGL[target], (int)buffer);
    }

    @Override
    public void bindBufferBase(int target, int bindingPoint, int buffer) {
        ARBUniformBufferObject.glBindBufferBase((int)bufferTargetToGL[target], (int)bindingPoint, (int)buffer);
    }

    @Override
    public int getUniformBlockIndex(int program, String name) {
        return ARBUniformBufferObject.glGetUniformBlockIndex((int)program, (CharSequence)name);
    }

    @Override
    public void setUniformBlockBinding(int program, int blockIndex, int bindingPoint) {
        ARBUniformBufferObject.glUniformBlockBinding((int)program, (int)blockIndex, (int)bindingPoint);
    }

    @Override
    public int getUniformIndex(int program, String name) {
        IntBuffer indicesBuffer = this.directBufferUtilities.allocateDirectBuffer(4).asIntBuffer();
        ARBUniformBufferObject.glGetUniformIndices((int)program, (CharSequence[])new String[]{name}, (IntBuffer)indicesBuffer);
        return indicesBuffer.get(0);
    }

    @Override
    public int[] getUniformIndices(int program, String[] names) {
        IntBuffer indicesBuffer = this.directBufferUtilities.allocateDirectBuffer(names.length << 2).asIntBuffer();
        ARBUniformBufferObject.glGetUniformIndices((int)program, (CharSequence[])names, (IntBuffer)indicesBuffer);
        int[] indices = new int[names.length];
        indicesBuffer.get(indices);
        return indices;
    }

    @Override
    public int getActiveUniformOffset(int program, int uniformIndex) {
        return ARBUniformBufferObject.glGetActiveUniformsi((int)program, (int)uniformIndex, (int)35387);
    }

    @Override
    public int getActiveUniformArrayStride(int program, int uniformIndex) {
        return ARBUniformBufferObject.glGetActiveUniformsi((int)program, (int)uniformIndex, (int)35388);
    }

    @Override
    public void setProjectionMatrix(float[] values) {
        this.re.setMatrixMode(0);
        this.re.setMatrix(values);
    }

    @Override
    public void setViewMatrix(float[] values) {
        this.re.setMatrixMode(4);
        this.setMatrix(values);
    }

    @Override
    public void setModelMatrix(float[] values) {
        this.re.setMatrixMode(4);
        this.re.multMatrix(values);
    }

    @Override
    public void setTextureMatrix(float[] values) {
        this.re.setMatrixMode(3);
        this.re.setMatrix(values);
    }

    @Override
    public void setModelViewMatrix(float[] values) {
        this.re.setMatrixMode(4);
        this.setMatrix(values);
    }

    @Override
    public void setMatrix(float[] values) {
        if (values != null) {
            GL11.glLoadMatrixf((FloatBuffer)this.directBufferUtilities.getDirectBuffer(values));
        } else {
            GL11.glLoadIdentity();
        }
    }

    @Override
    public void setMatrixMode(int type) {
        GL11.glMatrixMode((int)matrixModeToGL[type]);
    }

    @Override
    public void multMatrix(float[] values) {
        if (values != null) {
            GL11.glMultMatrixf((FloatBuffer)this.directBufferUtilities.getDirectBuffer(values));
        }
    }

    @Override
    public int genFramebuffer() {
        return ARBFramebufferObject.glGenFramebuffers();
    }

    @Override
    public void bindFramebuffer(int target, int framebuffer) {
        ARBFramebufferObject.glBindFramebuffer((int)framebufferTargetToGL[target], (int)framebuffer);
    }

    @Override
    public void bindRenderbuffer(int renderbuffer) {
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)renderbuffer);
    }

    @Override
    public void deleteFramebuffer(int framebuffer) {
        ARBFramebufferObject.glDeleteFramebuffers((int)framebuffer);
    }

    @Override
    public void deleteRenderbuffer(int renderbuffer) {
        ARBFramebufferObject.glDeleteRenderbuffers((int)renderbuffer);
    }

    @Override
    public int genRenderbuffer() {
        return ARBFramebufferObject.glGenRenderbuffers();
    }

    @Override
    public void setFramebufferRenderbuffer(int target, int attachment, int renderbuffer) {
        ARBFramebufferObject.glFramebufferRenderbuffer((int)framebufferTargetToGL[target], (int)attachmentToGL[attachment], (int)36161, (int)renderbuffer);
    }

    @Override
    public void setRenderbufferStorage(int internalFormat, int width, int height) {
        ARBFramebufferObject.glRenderbufferStorage((int)36161, (int)textureInternalFormatToGL[internalFormat], (int)width, (int)height);
    }

    @Override
    public void setFramebufferTexture(int target, int attachment, int texture, int level) {
        ARBFramebufferObject.glFramebufferTexture2D((int)framebufferTargetToGL[target], (int)attachmentToGL[attachment], (int)3553, (int)texture, (int)level);
    }

    @Override
    public boolean isFramebufferObjectAvailable() {
        return GL.getCapabilities().GL_ARB_framebuffer_object;
    }

    @Override
    public void bindVertexArray(int id) {
        ARBVertexArrayObject.glBindVertexArray((int)id);
    }

    @Override
    public void deleteVertexArray(int id) {
        ARBVertexArrayObject.glDeleteVertexArrays((int)id);
    }

    @Override
    public int genVertexArray() {
        return ARBVertexArrayObject.glGenVertexArrays();
    }

    @Override
    public boolean isVertexArrayAvailable() {
        return GL.getCapabilities().GL_ARB_vertex_array_object;
    }

    @Override
    public void multiDrawArrays(int primitive, IntBuffer first, IntBuffer count) {
        GL14.glMultiDrawArrays((int)primitive, (IntBuffer)first, (IntBuffer)count);
    }

    @Override
    public void drawArraysBurstMode(int primitive, int first, int count) {
        this.drawArrays(primitive, first, count);
    }

    @Override
    public void setPixelTransfer(int parameter, int value) {
        GL11.glPixelTransferi((int)pixelTransferToGL[parameter], (int)value);
    }

    @Override
    public void setPixelTransfer(int parameter, float value) {
        GL11.glPixelTransferf((int)pixelTransferToGL[parameter], (float)value);
    }

    @Override
    public void setPixelTransfer(int parameter, boolean value) {
        GL11.glPixelTransferi((int)pixelTransferToGL[parameter], (int)(value ? 1 : 0));
    }

    @Override
    public void setPixelMap(int map, int mapSize, Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            GL11.glPixelMapuiv((int)pixelMapToGL[map], (IntBuffer)this.directBufferUtilities.getDirectBuffer(mapSize, (IntBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glPixelMapfv((int)pixelMapToGL[map], (FloatBuffer)this.directBufferUtilities.getDirectBuffer(mapSize, (FloatBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glPixelMapusv((int)pixelMapToGL[map], (ShortBuffer)this.directBufferUtilities.getDirectBuffer(mapSize, (ShortBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean canNativeClut(int textureAddress, int pixelFormat, boolean textureSwizzle) {
        if (this.vendorIntel && (pixelFormat == 4 || pixelFormat == 5)) {
            return false;
        }
        return this.hasOpenGL30;
    }

    @Override
    public void setActiveTexture(int index) {
        GL13.glActiveTexture((int)(33984 + index));
    }

    @Override
    public float getMaxTextureAnisotropy() {
        return GL11.glGetFloat((int)34047);
    }

    @Override
    public void setTextureAnisotropy(float value) {
        GL11.glTexParameterf((int)3553, (int)34046, (float)value);
    }

    @Override
    public String getShadingLanguageVersion() {
        if (GL.getCapabilities().OpenGL20) {
            return GL11.glGetString((int)35724);
        }
        return null;
    }

    @Override
    public boolean canReadAllVertexInfo() {
        return false;
    }

    @Override
    public void readStencil(int x, int y, int width, int height, int bufferSize, Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6401, (int)5121, (IntBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (IntBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6401, (int)5121, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (FloatBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6401, (int)5121, (ShortBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (ShortBuffer)buffer));
        } else if (buffer instanceof ByteBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6401, (int)5121, (ByteBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (ByteBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void readDepth(int x, int y, int width, int height, int bufferSize, Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6402, (int)5123, (IntBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (IntBuffer)buffer));
        } else if (buffer instanceof FloatBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6402, (int)5123, (FloatBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (FloatBuffer)buffer));
        } else if (buffer instanceof ShortBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6402, (int)5123, (ShortBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (ShortBuffer)buffer));
        } else if (buffer instanceof ByteBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6402, (int)5123, (ByteBuffer)this.directBufferUtilities.getDirectBuffer(bufferSize, (ByteBuffer)buffer));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        int maskGL = 0;
        int i = 0;
        while (i < buffersMaskToGL.length) {
            if ((mask & 1) != 0) {
                maskGL |= buffersMaskToGL[i];
            }
            ++i;
            mask >>= 1;
        }
        GL30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)maskGL, (int)mipmapFilterToGL[filter]);
    }

    @Override
    public boolean checkAndLogErrors(String logComment) {
        boolean hasError = false;
        while (true) {
            String errorComment;
            int error;
            try {
                error = GL11.glGetError();
            }
            catch (NullPointerException e) {
                error = 0;
            }
            if (error == 0) break;
            hasError = true;
            if (logComment == null) continue;
            switch (error) {
                case 1280: {
                    errorComment = "GL_INVALID_ENUM";
                    break;
                }
                case 1282: {
                    errorComment = "GL_INVALID_OPERATION";
                    break;
                }
                case 1281: {
                    errorComment = "GL_INVALID_VALUE";
                    break;
                }
                case 1286: {
                    errorComment = "GL_INVALID_FRAMEBUFFER_OPERATION";
                    break;
                }
                default: {
                    errorComment = String.format("0x%X", error);
                }
            }
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            StringBuilder stackTraceLog = new StringBuilder();
            int count = 0;
            for (int i = 1; i < stackTrace.length && count < 6; ++i) {
                String className = stackTrace[i].getClassName();
                if (BaseRenderingEngineProxy.class.getName().equals(className) || CheckErrorsProxy.class.getName().equals(className)) continue;
                stackTraceLog.append(stackTrace[i]);
                stackTraceLog.append("\n");
                ++count;
            }
            log.error((Object)String.format("Error %s: %s\n%s", logComment, errorComment, stackTraceLog.toString()));
        }
        return hasError;
    }

    @Override
    public boolean setCopyRedToAlpha(boolean shaderCopyRedToAlpha) {
        return true;
    }

    @Override
    public void drawElements(int primitive, int count, int indexType, Buffer indices, int indicesOffset) {
        switch (indexType) {
            case 1: {
                GL11.glDrawElements((int)primitiveToGL[primitive], (ByteBuffer)this.directBufferUtilities.getDirectByteBuffer(count, indices, indicesOffset));
                break;
            }
            case 3: {
                GL11.glDrawElements((int)primitiveToGL[primitive], (ShortBuffer)this.directBufferUtilities.getDirectShortBuffer(count << 1, indices, indicesOffset));
                break;
            }
            case 5: {
                GL11.glDrawElements((int)primitiveToGL[primitive], (IntBuffer)this.directBufferUtilities.getDirectIntBuffer(count << 2, indices, indicesOffset));
                break;
            }
            default: {
                log.error((Object)String.format("drawElements unknown indexType=%d", indexType));
            }
        }
    }

    @Override
    public void drawElements(int primitive, int count, int indexType, long indicesOffset) {
        GL11.glDrawElements((int)primitiveToGL[primitive], (int)count, (int)pointerTypeToGL[indexType], (long)indicesOffset);
    }

    @Override
    public void drawElementsBurstMode(int primitive, int count, int indexType, long indicesOffset) {
        this.drawElements(primitive, count, indexType, indicesOffset);
    }

    @Override
    public void textureBarrier() {
        NVTextureBarrier.glTextureBarrierNV();
    }

    @Override
    public boolean isTextureBarrierAvailable() {
        return GL.getCapabilities().GL_NV_texture_barrier;
    }

    @Override
    public long fenceSync() {
        if (GL.getCapabilities().OpenGL32) {
            return GL32.glFenceSync((int)37143, (int)0);
        }
        if (GL.getCapabilities().GL_ARB_sync) {
            return ARBSync.glFenceSync((int)37143, (int)0);
        }
        return 0L;
    }

    @Override
    public void clientWaitSync(long sync, long timeout) {
        if (GL.getCapabilities().OpenGL32) {
            GL32.glClientWaitSync((long)sync, (int)1, (long)timeout);
        } else if (GL.getCapabilities().GL_ARB_sync) {
            ARBSync.glClientWaitSync((long)sync, (int)1, (long)timeout);
        }
    }

    @Override
    public void deleteSync(long sync) {
        if (GL.getCapabilities().OpenGL32) {
            GL32.glDeleteSync((long)sync);
        } else if (GL.getCapabilities().GL_ARB_sync) {
            ARBSync.glDeleteSync((long)sync);
        }
    }

    @Override
    public int getTextureLevelParameter(int texture, int level, int parameter) {
        int value = 0;
        if (GL.getCapabilities().OpenGL45) {
            value = GL45.glGetTextureLevelParameteri((int)texture, (int)level, (int)textureLevelParameterToGL[parameter]);
        } else if (GL.getCapabilities().GL_ARB_direct_state_access) {
            value = ARBDirectStateAccess.glGetTextureLevelParameteri((int)texture, (int)level, (int)textureLevelParameterToGL[parameter]);
        } else if (GL.getCapabilities().GL_EXT_direct_state_access) {
            value = EXTDirectStateAccess.glGetTextureLevelParameteriEXT((int)texture, (int)3553, (int)level, (int)textureLevelParameterToGL[parameter]);
        }
        block0 : switch (parameter) {
            case 3: {
                for (int pixelFormat = 0; pixelFormat < textureInternalFormatToGL.length; ++pixelFormat) {
                    if (textureInternalFormatToGL[pixelFormat] != value) continue;
                    value = pixelFormat;
                    break block0;
                }
                break;
            }
        }
        return value;
    }

    @Override
    public void setPatchParameter(int parameter, int value) {
        GL40.glPatchParameteri((int)patchParameterToGL[parameter], (int)value);
    }

    @Override
    public void setPatchParameter(int parameter, float[] values) {
        GL40.glPatchParameterfv((int)patchParameterToGL[parameter], (float[])values);
    }

    @Override
    public void setPolygonMode(int mode) {
        GL20.glPolygonMode((int)1032, (int)polygonModeToGL[mode]);
    }

    @Override
    public int getFramebufferBinding(int target) {
        return GL11.glGetInteger((int)framebufferBindingTargetToGL[target]);
    }
}

