/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import jpcsp.Memory;
import jpcsp.graphics.RE.NullRenderingEngine;
import jpcsp.graphics.RE.software.BoundingBoxRenderer;
import jpcsp.graphics.RE.software.BufferVertexReader;
import jpcsp.graphics.RE.software.CachedTexture;
import jpcsp.graphics.RE.software.CachedTextureResampled;
import jpcsp.graphics.RE.software.IRenderer;
import jpcsp.graphics.RE.software.RendererExecutor;
import jpcsp.graphics.RE.software.SpriteRenderer;
import jpcsp.graphics.RE.software.TriangleRenderer;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;

public class RESoftware
extends NullRenderingEngine {
    private static final boolean useTextureCache = true;
    protected int genTextureId;
    protected int bindTexture;
    protected VertexState v1 = new VertexState();
    protected VertexState v2 = new VertexState();
    protected VertexState v3 = new VertexState();
    protected VertexState v4 = new VertexState();
    protected VertexState v5 = new VertexState();
    protected VertexState v6 = new VertexState();
    protected RendererExecutor rendererExecutor;
    protected HashMap<Integer, CachedTextureResampled> cachedTextures = new HashMap();
    protected int textureBufferWidth;
    protected static DurationStatistics drawArraysStatistics = new DurationStatistics("RESoftware drawArrays");
    public static DurationStatistics triangleRender3DStatistics = new DurationStatistics("RESoftware TriangleRender3D");
    public static DurationStatistics triangleRender2DStatistics = new DurationStatistics("RESoftware TriangleRender2D");
    public static DurationStatistics spriteRenderStatistics = new DurationStatistics("RESoftware SpriteRender");
    protected static DurationStatistics cachedTextureStatistics = new DurationStatistics("RESoftware CachedTexture");
    public static DurationStatistics textureResamplingStatistics = new DurationStatistics("RESftware Texture resampling");
    protected BoundingBoxRenderer boundingBoxRenderer;
    protected boolean boundingBoxVisible;
    protected BufferVertexReader bufferVertexReader;
    protected boolean useVertexTexture;

    public RESoftware() {
        log.info((Object)"Using SoftwareRenderer");
    }

    @Override
    public void exit() {
    }

    @Override
    public void startDisplay() {
        this.context = VideoEngine.getInstance().getContext();
        this.rendererExecutor = RendererExecutor.getInstance();
    }

    @Override
    public int setBones(int count, float[] values) {
        return count;
    }

    protected void render(IRenderer renderer) {
        if (renderer.prepare(this.context)) {
            this.rendererExecutor.render(renderer);
        }
    }

    protected void drawSprite(SpriteRenderer spriteRenderer, VertexState v1, VertexState v2) {
        spriteRenderer.setVertex(v1, v2);
        this.render(spriteRenderer);
    }

    protected CachedTextureResampled getCachedTexture() {
        CachedTextureResampled cachedTexture = this.cachedTextures.get(this.bindTexture);
        if (cachedTexture != null) {
            cachedTexture.setClut();
        }
        return cachedTexture;
    }

    protected void drawArraysSprites(int first, int count) {
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        SpriteRenderer spriteRenderer = new SpriteRenderer(this.context, cachedTexture, this.useVertexTexture);
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        Memory mem = Memory.getInstance();
        for (int i = first; i < count - 1; i += 2) {
            int addr1 = this.context.vinfo.getAddress(mem, i);
            int addr2 = this.context.vinfo.getAddress(mem, i + 1);
            this.context.vinfo.readVertex(mem, addr1, this.v1, readTexture, VideoEngine.getInstance().isDoubleTexture2DCoords());
            this.context.vinfo.readVertex(mem, addr2, this.v2, readTexture, VideoEngine.getInstance().isDoubleTexture2DCoords());
            this.drawSprite(spriteRenderer, this.v1, this.v2);
        }
    }

    protected void drawTriangle(TriangleRenderer triangleRenderer, VertexState v1, VertexState v2, VertexState v3, boolean invertedFrontFace) {
        triangleRenderer.setVertex(v1, v2, v3);
        if (!triangleRenderer.isCulled(invertedFrontFace)) {
            this.render(triangleRenderer);
        }
    }

    protected boolean isSprite(VertexInfo vinfo, VertexState tv1, VertexState tv2, VertexState tv3, VertexState tv4) {
        if (!vinfo.transform2D) {
            return false;
        }
        if (!this.context.clearMode && this.context.cullFaceFlag.isEnabled()) {
            return false;
        }
        if (vinfo.normal != 0) {
            return false;
        }
        if (this.context.textureColorDoubled) {
            return false;
        }
        if (vinfo.color != 0 && !Utilities.sameColor(tv1.c, tv2.c, tv3.c, tv4.c)) {
            return false;
        }
        if (tv1.p[0] == tv2.p[0] && tv1.p[1] == tv3.p[1] && tv4.p[0] == tv3.p[0] && tv4.p[1] == tv2.p[1] && tv1.p[2] == tv2.p[2] && tv1.p[2] == tv3.p[2] && tv1.p[2] == tv3.p[2]) {
            if (vinfo.texture == 0) {
                return true;
            }
            if (tv1.t[0] == tv2.t[0] && tv1.t[1] == tv3.t[1] && tv4.t[0] == tv3.t[0] && tv4.t[1] == tv2.t[1]) {
                return true;
            }
        }
        if (tv1.p[1] == tv2.p[1] && tv1.p[0] == tv3.p[0] && tv4.p[1] == tv3.p[1] && tv4.p[0] == tv2.p[0] && tv1.p[2] == tv2.p[2] && tv1.p[2] == tv3.p[2] && tv1.p[2] == tv3.p[2]) {
            if (vinfo.texture == 0) {
                return true;
            }
            if (tv1.t[1] == tv2.t[1] && tv1.t[0] == tv3.t[0] && tv4.t[1] == tv3.t[1] && tv4.t[0] == tv2.t[0]) {
                return true;
            }
        }
        return false;
    }

    protected void resetBufferVertexReader() {
        this.bufferVertexReader = null;
    }

    protected void readVertex(Memory mem, int index, VertexState v, boolean readTexture) {
        if (this.bufferVertexReader == null) {
            int addr = this.context.vinfo.getAddress(mem, index);
            this.context.vinfo.readVertex(mem, addr, v, readTexture, VideoEngine.getInstance().isDoubleTexture2DCoords());
        } else {
            this.bufferVertexReader.readVertex(index, v);
        }
        if (this.context.vinfo.weight != 0) {
            VideoEngine.doSkinning(this.context.bone_uploaded_matrix, this.context.vinfo, v);
        }
    }

    protected void drawArraysTriangleStrips(int first, int count) {
        Memory mem = Memory.getInstance();
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        TriangleRenderer triangleRenderer = new TriangleRenderer(this.context, cachedTexture, this.useVertexTexture);
        SpriteRenderer spriteRenderer = null;
        VertexState tv1 = null;
        VertexState tv2 = null;
        VertexState tv3 = null;
        VertexState tv4 = this.v1;
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        for (int i = 0; i < count; ++i) {
            this.readVertex(mem, first + i, tv4, readTexture);
            if (tv3 != null) {
                if (this.isSprite(this.context.vinfo, tv1, tv2, tv3, tv4)) {
                    if (spriteRenderer == null) {
                        spriteRenderer = new SpriteRenderer(this.context, cachedTexture, this.useVertexTexture);
                    }
                    this.drawSprite(spriteRenderer, tv1, tv4);
                    this.v5.copy(tv3);
                    this.v6.copy(tv4);
                    this.v1.copy(this.v5);
                    this.v2.copy(this.v6);
                    tv1 = this.v1;
                    tv2 = this.v2;
                    tv3 = null;
                    tv4 = this.v3;
                    continue;
                }
                this.drawTriangle(triangleRenderer, tv1, tv2, tv3, (i - 3 & 1) != 0);
                VertexState v = tv1;
                tv1 = tv2;
                tv2 = tv3;
                tv3 = tv4;
                tv4 = v;
                continue;
            }
            if (tv1 == null) {
                tv1 = tv4;
                tv4 = this.v2;
                continue;
            }
            if (tv2 == null) {
                tv2 = tv4;
                tv4 = this.v3;
                continue;
            }
            tv3 = tv4;
            tv4 = this.v4;
        }
        if (tv3 != null) {
            this.drawTriangle(triangleRenderer, tv1, tv2, tv3, (count & 1) == 0);
        }
    }

    protected void drawArraysTriangles(int first, int count) {
        Memory mem = Memory.getInstance();
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        TriangleRenderer triangleRenderer = new TriangleRenderer(this.context, cachedTexture, this.useVertexTexture);
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        for (int i = 0; i < count; i += 3) {
            this.readVertex(mem, first + i, this.v1, readTexture);
            this.readVertex(mem, first + i + 1, this.v2, readTexture);
            this.readVertex(mem, first + i + 2, this.v3, readTexture);
            this.drawTriangle(triangleRenderer, this.v1, this.v2, this.v3, false);
        }
    }

    protected void drawArraysTriangleFan(int first, int count) {
        Memory mem = Memory.getInstance();
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        TriangleRenderer triangleRenderer = new TriangleRenderer(this.context, cachedTexture, this.useVertexTexture);
        VertexState tv1 = null;
        VertexState tv2 = null;
        VertexState tv3 = this.v1;
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        for (int i = 0; i < count; ++i) {
            this.readVertex(mem, first + i, tv3, readTexture);
            if (tv2 != null) {
                this.drawTriangle(triangleRenderer, tv1, tv2, tv3, false);
                VertexState v = tv2;
                tv2 = tv3;
                tv3 = v;
                continue;
            }
            if (tv1 == null) {
                tv1 = tv3;
                tv3 = this.v2;
                continue;
            }
            tv2 = tv3;
            tv3 = this.v3;
        }
    }

    @Override
    public void drawArrays(int primitive, int first, int count) {
        drawArraysStatistics.start();
        switch (primitive) {
            case 6: {
                this.drawArraysSprites(first, count);
                break;
            }
            case 4: {
                this.drawArraysTriangleStrips(first, count);
                break;
            }
            case 3: {
                this.drawArraysTriangles(first, count);
                break;
            }
            case 5: {
                this.drawArraysTriangleFan(first, count);
            }
        }
        drawArraysStatistics.end();
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setTextureComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setColorComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setVertexComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setNormalComponentInfo(type, stride, bufferSize, buffer);
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setWeightComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        this.textureBufferWidth = rowLength;
    }

    @Override
    public int genTexture() {
        return this.genTextureId++;
    }

    @Override
    public void bindTexture(int texture) {
        this.bindTexture = texture;
    }

    @Override
    public void deleteTexture(int texture) {
        this.cachedTextures.remove(texture);
    }

    @Override
    public void setCompressedTexImage(int level, int internalFormat, int width, int height, int compressedSize, Buffer buffer) {
        cachedTextureStatistics.start();
        if (level == 0) {
            int bufferWidth = this.context.texture_buffer_width[level];
            IMemoryReader imageReader = ImageReader.getImageReader(this.context.texture_base_pointer[level], width, height, bufferWidth, internalFormat, false, 0, 0, 0, 0, 0, 0, null, null);
            CachedTexture cachedTexture = CachedTexture.getCachedTexture(Math.min(width, bufferWidth), height, internalFormat, imageReader);
            CachedTextureResampled cachedTextureResampled = new CachedTextureResampled(cachedTexture);
            this.cachedTextures.put(this.bindTexture, cachedTextureResampled);
        }
        cachedTextureStatistics.end();
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        cachedTextureStatistics.start();
        if (level == 0) {
            CachedTexture cachedTexture = null;
            if (buffer instanceof IntBuffer) {
                cachedTexture = CachedTexture.getCachedTexture(this.textureBufferWidth, height, format, ((IntBuffer)buffer).array(), buffer.arrayOffset(), textureSize >> 2);
            } else if (buffer instanceof ShortBuffer) {
                cachedTexture = CachedTexture.getCachedTexture(this.textureBufferWidth, height, format, ((ShortBuffer)buffer).array(), buffer.arrayOffset(), textureSize >> 1);
            }
            CachedTextureResampled cachedTextureResampled = new CachedTextureResampled(cachedTexture);
            this.cachedTextures.put(this.bindTexture, cachedTextureResampled);
        }
        cachedTextureStatistics.end();
    }

    @Override
    public void beginBoundingBox(int numberOfVertexBoundingBox) {
        this.boundingBoxRenderer = new BoundingBoxRenderer(this.context);
        this.boundingBoxVisible = true;
    }

    @Override
    public void drawBoundingBox(float[][] values) {
        if (this.boundingBoxVisible) {
            this.boundingBoxRenderer.drawBoundingBox(values);
            if (!this.boundingBoxRenderer.prepare(this.context)) {
                this.boundingBoxVisible = false;
            }
        }
    }

    @Override
    public void endBoundingBox(VertexInfo vinfo) {
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return this.boundingBoxVisible;
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        return true;
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        return true;
    }

    @Override
    public void setVertexInfo(VertexInfo vinfo, boolean allNativeVertexInfo, boolean useVertexColor, boolean useTexture, boolean useNormal, int type) {
        this.useVertexTexture = useTexture;
        this.resetBufferVertexReader();
    }

    @Override
    public boolean canNativeClut(int textureAddress, int pixelFormat, boolean textureSwizzle) {
        return Memory.isVRAM(textureAddress) && !textureSwizzle;
    }

    @Override
    public void waitForRenderingCompletion() {
        this.rendererExecutor.waitForRenderingCompletion();
    }

    @Override
    public boolean canReadAllVertexInfo() {
        return true;
    }

    @Override
    public boolean setCopyRedToAlpha(boolean copyRedToAlpha) {
        return true;
    }

    @Override
    public void setVertexColor(float[] color) {
        for (int i = 0; i < this.context.vertexColor.length; ++i) {
            this.context.vertexColor[i] = color[i];
        }
    }
}

