/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.Arrays;
import jpcsp.graphics.RE.IRenderingEngine;

public enum Uniforms {
    lightingEnable("lightingEnable"),
    lightEnabled("pspLightEnabled"),
    lightType("pspLightType"),
    lightKind("pspLightKind"),
    lightPosition("pspLightPosition"),
    lightDirection("pspLightDirection"),
    lightAmbientColor("pspLightAmbientColor"),
    lightDiffuseColor("pspLightDiffuseColor"),
    lightSpecularColor("pspLightSpecularColor"),
    lightSpotLightExponent("pspLightSpotLightExponent"),
    lightSpotLightCutoff("pspLightSpotLightCutoff"),
    lightAttenuation("pspLightAttenuation"),
    lightMode("colorAddition"),
    matFlags("pspMatFlags"),
    tex("tex"),
    texEnable("texEnable"),
    texEnvMode("texEnvMode"),
    texEnvColor("texEnvColor"),
    texMapMode("texMapMode"),
    texMapProj("texMapProj"),
    texShade("texShade"),
    colorDoubling("colorDoubling"),
    ctestEnable("ctestEnable"),
    ctestFunc("ctestFunc"),
    ctestRef("ctestRef"),
    ctestMsk("ctestMsk"),
    boneMatrix("pspBoneMatrix"),
    weights("pspWeights"),
    numberBones("pspNumberBones"),
    vinfoColor("vinfoColor"),
    vinfoPosition("vinfoPosition"),
    vinfoTransform2D("vinfoTransform2D"),
    positionScale("positionScale"),
    normalScale("normalScale"),
    textureScale("textureScale"),
    weightScale("weightScale"),
    clutShift("clutShift"),
    clutMask("clutMask"),
    clutOffset("clutOffset"),
    clut("clut"),
    mipmapShareClut("mipmapShareClut"),
    texPixelFormat("texPixelFormat"),
    utex("utex"),
    endOfUBO("endOfUBO"),
    vertexColor("vertexColor"),
    vinfoTexture("vinfoTexture"),
    vinfoNormal("vinfoNormal"),
    stencilTestEnable("stencilTestEnable"),
    stencilFunc("stencilFunc"),
    stencilRef("stencilRef"),
    stencilMask("stencilMask"),
    stencilOpFail("stencilOpFail"),
    stencilOpZFail("stencilOpZFail"),
    stencilOpZPass("stencilOpZPass"),
    depthTestEnable("depthTestEnable"),
    depthFunc("depthFunc"),
    depthWriteEnabled("depthWriteEnabled"),
    fbTex("fbTex"),
    depthTex("depthTex"),
    colorMaskEnable("colorMaskEnable"),
    colorMask("colorMask"),
    notColorMask("notColorMask"),
    alphaTestEnable("alphaTestEnable"),
    alphaTestFunc("alphaTestFunc"),
    alphaTestRef("alphaTestRef"),
    alphaTestMask("alphaTestMask"),
    blendTestEnable("blendTestEnable"),
    blendEquation("blendEquation"),
    blendSrc("blendSrc"),
    blendDst("blendDst"),
    blendSFix("blendSFix"),
    blendDFix("blendDFix"),
    copyRedToAlpha("copyRedToAlpha"),
    wrapModeS("wrapModeS"),
    wrapModeT("wrapModeT"),
    fogEnable("fogEnable"),
    fogColor("fogColor"),
    fogEnd("fogEnd"),
    fogScale("fogScale"),
    fogDepth("fogDepth"),
    clipPlaneEnable("clipPlaneEnable"),
    viewportPos("viewportPos"),
    viewportScale("viewportScale"),
    shadeModel("shadeModel"),
    ambientLightColor("ambientLightColor"),
    materialShininess("materialShininess"),
    materialAmbientColor("materialAmbientColor"),
    materialDiffuseColor("materialDiffuseColor"),
    materialSpecularColor("materialSpecularColor"),
    materialEmissionColor("materialEmissionColor"),
    pspTextureMatrix("pspTextureMatrix"),
    modelMatrix("modelMatrix"),
    modelViewMatrix("modelViewMatrix"),
    modelViewProjectionMatrix("modelViewProjectionMatrix"),
    curvedSurfaceType("curvedSurfaceType"),
    splineInfo("splineInfo"),
    patchFace("patchFace");

    String uniformString;
    int[] uniformId = new int[5000];

    private Uniforms(String uniformString) {
        Arrays.fill(this.uniformId, -1);
        this.uniformString = uniformString;
    }

    public int getId(int shaderProgram) {
        return this.uniformId[shaderProgram];
    }

    public String getUniformString() {
        return this.uniformString;
    }

    public void allocateId(IRenderingEngine re, int shaderProgram) {
        this.uniformId[shaderProgram] = re.getUniformLocation(shaderProgram, this.uniformString);
    }
}

