/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class VertexBuffer {
    private static Logger log = VideoEngine.log;
    private int bufferId = -1;
    private int bufferAddress;
    private int bufferLength;
    private int stride;
    private int[] cachedMemory;
    private ByteBuffer cachedBuffer;
    private int cachedBufferOffset;
    private HashMap<Integer, Integer> addressAlreadyChecked = new HashMap();
    private AddressRange[] dirtyRanges = new AddressRange[0];
    private int numberDirtyRanges = 0;
    private boolean reloadBufferDataPending = false;
    private static final int bufferUsage = 6;
    private static final int bufferTarget = 0;
    private static final boolean workaroundBufferDataBug = true;

    public VertexBuffer(int address, int stride) {
        this.bufferAddress = Memory.normalizeAddress(address);
        this.bufferLength = 0;
        this.stride = stride;
    }

    public void bind(IRenderingEngine re) {
        if (this.bufferId == -1) {
            this.bufferId = re.genBuffer();
        }
        re.bindBuffer(0, this.bufferId);
    }

    private int getBufferAlignment(int address) {
        return address & 3;
    }

    private int offset4(int offset) {
        return offset + 3 >> 2;
    }

    private int length4(int length) {
        return Utilities.alignUp(length, 3);
    }

    private void loadFromMemory(int address, int length) {
        if (length > 0) {
            this.copyToCachedMemory(address, length);
            Buffer buffer = Memory.getInstance().getBuffer(address, length);
            this.position(Utilities.alignDown(address, 3));
            Utilities.putBuffer(this.cachedBuffer, buffer, ByteOrder.LITTLE_ENDIAN, this.length4(length));
        }
    }

    private boolean extend(Buffer buffer, int address, int length) {
        boolean overflowBottom = address < this.bufferAddress;
        boolean overflowTop = address + length > this.bufferAddress + this.bufferLength;
        boolean extended = false;
        if (overflowBottom || overflowTop) {
            if (this.bufferLength == 0 || overflowBottom && overflowTop) {
                this.cachedBufferOffset = this.getBufferAlignment(address);
                this.cachedBuffer = ByteBuffer.allocateDirect(this.length4(length + this.cachedBufferOffset)).order(ByteOrder.LITTLE_ENDIAN);
                this.bufferAddress = address;
                this.bufferLength = length;
                this.cachedMemory = new int[this.offset4(this.bufferLength)];
                this.reloadBufferDataPending = true;
                extended = true;
            } else if (overflowBottom) {
                int newCachedBufferOffset = this.getBufferAlignment(address);
                int extendLength = this.bufferAddress - address + newCachedBufferOffset;
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.length4(extendLength + this.cachedBuffer.capacity())).order(ByteOrder.LITTLE_ENDIAN);
                newBuffer.position(extendLength);
                this.cachedBuffer.clear();
                this.cachedBuffer.position(this.cachedBufferOffset);
                newBuffer.put(this.cachedBuffer);
                newBuffer.rewind();
                this.cachedBuffer = newBuffer;
                this.cachedBufferOffset = newCachedBufferOffset;
                this.bufferLength += extendLength;
                int[] newCachedMemory = new int[this.offset4(this.bufferLength)];
                System.arraycopy(this.cachedMemory, 0, newCachedMemory, extendLength >> 2, this.cachedMemory.length);
                this.cachedMemory = newCachedMemory;
                this.bufferAddress = address;
                this.loadFromMemory(this.bufferAddress + length, extendLength - length);
                this.reloadBufferDataPending = true;
                extended = true;
            } else if (overflowTop) {
                int extendLength = address + length - (this.bufferAddress + this.bufferLength);
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.length4(extendLength + this.cachedBuffer.capacity())).order(ByteOrder.LITTLE_ENDIAN);
                this.cachedBuffer.clear();
                newBuffer.put(this.cachedBuffer);
                newBuffer.rewind();
                this.cachedBuffer = newBuffer;
                int oldBufferEnd = this.bufferAddress + this.bufferLength;
                this.bufferLength += extendLength;
                int[] newCachedMemory = new int[this.offset4(this.bufferLength)];
                System.arraycopy(this.cachedMemory, 0, newCachedMemory, 0, this.cachedMemory.length);
                this.cachedMemory = newCachedMemory;
                this.loadFromMemory(oldBufferEnd, address - oldBufferEnd);
                this.reloadBufferDataPending = true;
                extended = true;
            }
        }
        return extended;
    }

    public int getBufferOffset(int address) {
        address = Memory.normalizeAddress(address);
        return address - this.bufferAddress;
    }

    private int getBufferOffset4(int address) {
        return this.getBufferOffset(address) >> 2;
    }

    public int getNativeBufferOffset(int address) {
        return this.getBufferOffset(address) + this.cachedBufferOffset;
    }

    private void position(int address) {
        this.cachedBuffer.clear();
        this.cachedBuffer.position(this.getNativeBufferOffset(address));
    }

    private void copyToCachedMemory(int address, int length) {
        int offset = this.getBufferOffset4(address);
        int n = this.offset4(length);
        if (RuntimeContext.hasMemoryInt()) {
            System.arraycopy(RuntimeContext.getMemoryInt(), address >> 2, this.cachedMemory, offset, n);
        } else {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 4);
            for (int i = 0; i < n; ++i) {
                this.cachedMemory[offset + i] = memoryReader.readNext();
            }
        }
    }

    private void checkDirty(IRenderingEngine re) {
        if (this.reloadBufferDataPending) {
            this.bind(re);
            this.cachedBuffer.clear();
            re.setBufferData(0, this.cachedBuffer.remaining(), this.cachedBuffer, 6);
            this.reloadBufferDataPending = false;
            this.numberDirtyRanges = 0;
        } else if (this.numberDirtyRanges > 0) {
            this.bind(re);
            for (int i = 0; i < this.numberDirtyRanges; ++i) {
                this.position(this.dirtyRanges[i].address);
                re.setBufferSubData(0, this.cachedBuffer.position(), this.dirtyRanges[i].length, this.cachedBuffer);
            }
            this.numberDirtyRanges = 0;
        }
    }

    private boolean cachedMemoryEquals(int address, int length) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 4);
        int offset = this.getBufferOffset4(address);
        int n = this.offset4(length);
        for (int i = 0; i < n; ++i) {
            if (this.cachedMemory[offset + i] == memoryReader.readNext()) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("VertexBuffer.cachedMemoryEquals(0x%08X, 0x%X): are not equal", address, length));
            }
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("VertexBuffer.cachedMemoryEquals(0x%08X, 0x%X): are equal", address, length));
        }
        return true;
    }

    private void addDirtyRange(int address, int length) {
        for (int i = 0; i < this.numberDirtyRanges; ++i) {
            if (this.dirtyRanges[i].address != address) continue;
            if (length > this.dirtyRanges[i].length) {
                this.dirtyRanges[i].length = length;
            }
            return;
        }
        if (this.numberDirtyRanges >= this.dirtyRanges.length) {
            AddressRange[] newDirtyRanges = new AddressRange[this.dirtyRanges.length + 10];
            System.arraycopy(this.dirtyRanges, 0, newDirtyRanges, 0, this.dirtyRanges.length);
            for (int i = this.dirtyRanges.length; i < newDirtyRanges.length; ++i) {
                newDirtyRanges[i] = new AddressRange();
            }
            this.dirtyRanges = newDirtyRanges;
        }
        this.dirtyRanges[this.numberDirtyRanges].setRange(address, length);
        ++this.numberDirtyRanges;
    }

    public synchronized void preLoad(Buffer buffer, int address, int length) {
        this.load(null, buffer, address, length);
    }

    public synchronized void load(IRenderingEngine re, Buffer buffer, int address, int length) {
        address = Memory.normalizeAddress(address);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("VertexBuffer.load address=0x%08X, length=0x%X in %s", address, length, this.toString()));
        }
        if (!this.addressAlreadyChecked(address, length)) {
            boolean extended = this.extend(buffer, address, length);
            if (extended || !this.cachedMemoryEquals(address, length)) {
                int startLength = address & 3;
                int startAddress = address - startLength;
                int totalLength = this.length4(length + startLength);
                this.position(startAddress);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("copy buffer from 0x%08X(buffer offset=0x%X) to VertexBuffer at 0x%08X(buffer offset=0x%X), length=0x%X", startAddress, buffer.position(), this.bufferAddress - this.cachedBufferOffset + this.cachedBuffer.position(), this.cachedBuffer.position(), totalLength));
                }
                Utilities.putBuffer(this.cachedBuffer, buffer, ByteOrder.LITTLE_ENDIAN, totalLength);
                buffer.rewind();
                if (re != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("VertexBuffer reload buffer address=0x%08X(0x%08X), length=0x%X(0x%X), extended=%b", address, startAddress, length, totalLength, extended));
                    }
                    boolean updateSubData = !this.reloadBufferDataPending;
                    this.checkDirty(re);
                    if (updateSubData) {
                        this.position(address);
                        this.bind(re);
                        re.setBufferSubData(0, this.cachedBuffer.position(), startLength + length, this.cachedBuffer);
                    }
                } else {
                    this.addDirtyRange(address, length);
                }
                this.copyToCachedMemory(address, length);
            } else if (re != null) {
                this.checkDirty(re);
                this.bind(re);
                this.position(this.bufferAddress);
                re.setBufferSubData(0, this.cachedBuffer.position(), 1, this.cachedBuffer);
            }
            this.setAddressAlreadyChecked(address, length);
        } else if (re != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("VertexBuffer address already checked address=0x%08X, length=0x%X", address, length));
            }
            this.checkDirty(re);
        }
    }

    public synchronized void delete(IRenderingEngine re) {
        if (this.bufferId != -1) {
            re.deleteBuffer(this.bufferId);
            this.bufferId = -1;
        }
        this.bufferLength = 0;
        this.bufferAddress = 0;
        this.cachedBufferOffset = 0;
        this.stride = 0;
        this.cachedBuffer = null;
        this.cachedMemory = null;
    }

    public boolean isAddressInside(int address, int length, int gapSize) {
        address = Memory.normalizeAddress(address);
        int endAddress = address + length;
        int startBuffer = this.bufferAddress - gapSize;
        int endBuffer = this.bufferAddress + this.bufferLength + gapSize;
        if (startBuffer <= address && address < endBuffer) {
            return true;
        }
        if (startBuffer <= endAddress && endAddress < endBuffer) {
            return true;
        }
        return address < startBuffer && endBuffer < endAddress;
    }

    public synchronized void resetAddressAlreadyChecked() {
        this.addressAlreadyChecked.clear();
    }

    private boolean addressAlreadyChecked(int address, int length) {
        Integer checkedLength = this.addressAlreadyChecked.get(address);
        if (checkedLength == null) {
            return false;
        }
        return checkedLength >= length;
    }

    private void setAddressAlreadyChecked(int address, int length) {
        this.addressAlreadyChecked.put(address, length);
    }

    public int getStride() {
        return this.stride;
    }

    public int getLength() {
        return this.bufferLength;
    }

    public int getId() {
        return this.bufferId;
    }

    public String toString() {
        return String.format("VertexBuffer[0x%08X-0x%08X, length 0x%X, stride %d, id %d]", this.bufferAddress, this.bufferAddress + this.bufferLength, this.bufferLength, this.stride, this.bufferId);
    }

    private static class AddressRange {
        public int address;
        public int length;

        public void setRange(int address, int length) {
            this.address = address;
            this.length = length;
        }

        public String toString() {
            return String.format("AddressRange[0x%08X-0x%08X, length 0x%X]", this.address, this.address + this.length, this.length);
        }
    }
}

