/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.BufferedMemoryReader;
import jpcsp.memory.ImageReader;
import org.apache.log4j.Logger;

public class VertexInfoReader {
    private static Logger log = VideoEngine.log;
    private VideoEngine videoEngine;
    private BufferedMemoryReader memoryReader;
    private VertexInfo vertexInfo;
    private IVertexDataBuffer vertexDataBuffer;
    private int weightOffset;
    private int weightType;
    private int weightNumberValues;
    private int textureOffset;
    private int textureType;
    private int textureNumberValues;
    private int colorOffset;
    private int colorType;
    private int colorNumberValues;
    private int normalOffset;
    private int normalType;
    private int normalNumberValues;
    private int positionOffset;
    private int positionType;
    private int positionNumberValues;
    private int stride;
    private boolean weightNative;
    private boolean textureNative;
    private boolean colorNative;
    private boolean normalNative;
    private boolean positionNative;
    private float[] boneWeights = new float[8];
    private float[] normal = new float[3];
    private float[] position = new float[3];
    private boolean canAllNativeVertexInfo;
    private static final int typeNone = 0;
    private final IVertexInfoReader[] paddingReaders = new IVertexInfoReader[]{new NotImplementedReader("Padding 0"), new NopReader(), new AlignShortReader(), new NotImplementedReader("Padding 3"), new AlignIntReader()};
    private final IVertexInfoReader[] skip2Readers = new IVertexInfoReader[]{new NopReader(), new Skip2BytesReader(), new Skip2ShortsReader(), new Skip2FloatsReader()};
    private final IVertexInfoReader[] skip3Readers = new IVertexInfoReader[]{new NopReader(), new Skip3BytesReader(), new Skip3ShortsReader(), new Skip3FloatsReader()};
    private final IVertexInfoReader[] skipColorReaders = new IVertexInfoReader[]{new NopReader(), new NotImplementedReader("Color 1"), new NotImplementedReader("Color 2"), new NotImplementedReader("Color 3"), new Skip1ShortReader(), new Skip1ShortReader(), new Skip1ShortReader(), new Skip1IntReader()};
    private final IVertexInfoReader[] textureReaders = new IVertexInfoReader[]{new NopReader(), new Texture1Reader(), new Texture2Reader(), new Texture3Reader()};
    private final IVertexInfoReader[] colorReaders = new IVertexInfoReader[]{new NopReader(), new NotImplementedReader("Color 1"), new NotImplementedReader("Color 2"), new NotImplementedReader("Color 3"), new Color4Reader(), new Color5Reader(), new Color6Reader(), new Color7Reader()};
    private final IVertexInfoReader[] normalReaders = new IVertexInfoReader[]{new NopReader(), new Normal1Reader(), new Normal2Reader(), new Normal3Reader()};
    private final IVertexInfoReader[] positionReaders = new IVertexInfoReader[]{new NopReader(), new Position1Reader(), new Position2Reader(), new Position3Reader()};
    private final IVertexInfoReader[] weightReaders = new IVertexInfoReader[]{new NopReader(), new Weight1Reader(), new Weight2Reader(), new Weight3Reader()};
    private final IVertexInfoReader[] skipWeightReaders = new IVertexInfoReader[]{new NopReader(), new SkipWeight1Reader(), new SkipWeight2Reader(), new SkipWeight3Reader()};

    private void setAddress(int address) {
        this.memoryReader = new BufferedMemoryReader(address);
    }

    private void update() {
        this.stride = 0;
        IVertexInfoReader weightReader = this.getWeightReader(false);
        this.weightNative = weightReader.isNative();
        this.weightType = weightReader.type();
        this.weightOffset = 0;
        this.weightNumberValues = weightReader.numberValues();
        int weightSize = weightReader.size();
        this.stride += weightSize;
        IVertexInfoReader textureReader = this.getTextureReader(false);
        this.textureNative = textureReader.isNative();
        this.textureType = textureReader.type();
        this.textureOffset = this.textureNative ? this.vertexInfo.textureOffset : this.stride;
        this.textureNumberValues = textureReader.numberValues();
        int textureSize = textureReader.size();
        this.stride += textureSize;
        IVertexInfoReader colorReader = this.getColorReader(false);
        this.colorNative = colorReader.isNative();
        this.colorType = colorReader.type();
        this.colorOffset = this.colorNative ? this.vertexInfo.colorOffset : this.stride;
        this.colorNumberValues = colorReader.numberValues();
        int colorSize = colorReader.size();
        this.stride += colorSize;
        IVertexInfoReader normalReader = this.getNormalReader(false);
        this.normalNative = normalReader.isNative();
        this.normalType = normalReader.type();
        this.normalOffset = this.normalNative ? this.vertexInfo.normalOffset : this.stride;
        this.normalNumberValues = normalReader.numberValues();
        int normalSize = normalReader.size();
        this.stride += normalSize;
        IVertexInfoReader positionReader = this.getPositionReader(false);
        this.positionNative = positionReader.isNative();
        this.positionType = positionReader.type();
        this.positionOffset = this.positionNative ? this.vertexInfo.positionOffset : this.stride;
        this.positionNumberValues = positionReader.numberValues();
        int positionSize = positionReader.size();
        this.stride += positionSize;
    }

    public void addNativeOffset(int offset) {
        if (offset != 0) {
            if (this.weightNative) {
                this.weightOffset += offset;
            }
            if (this.textureNative) {
                this.textureOffset += offset;
            }
            if (this.colorNative) {
                this.colorOffset += offset;
            }
            if (this.normalNative) {
                this.normalOffset += offset;
            }
            if (this.positionNative) {
                this.positionOffset += offset;
            }
        }
    }

    public int getWeightOffset() {
        return this.weightOffset;
    }

    public int getWeightType() {
        return this.weightType;
    }

    public int getWeightNumberValues() {
        return this.weightNumberValues;
    }

    public int getTextureOffset() {
        return this.textureOffset;
    }

    public int getTextureType() {
        return this.textureType;
    }

    public int getTextureNumberValues() {
        return this.textureNumberValues;
    }

    public int getColorOffset() {
        return this.colorOffset;
    }

    public int getColorType() {
        return this.colorType;
    }

    public int getColorNumberValues() {
        return this.colorNumberValues;
    }

    public int getNormalOffset() {
        return this.normalOffset;
    }

    public int getNormalType() {
        return this.normalType;
    }

    public int getNormalNumberValues() {
        return this.normalNumberValues;
    }

    public int getPositionOffset() {
        return this.positionOffset;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public int getPositionNumberValues() {
        return this.positionNumberValues;
    }

    public int getStride() {
        return this.stride;
    }

    public boolean isWeightNative() {
        return this.weightNative;
    }

    public boolean isTextureNative() {
        return this.textureNative;
    }

    public boolean isColorNative() {
        return this.colorNative;
    }

    public boolean isNormalNative() {
        return this.normalNative;
    }

    public boolean isPositionNative() {
        return this.positionNative;
    }

    public boolean hasNative() {
        if (this.textureNative && this.vertexInfo.texture != 0) {
            return true;
        }
        if (this.colorNative && this.vertexInfo.color != 0) {
            return true;
        }
        if (this.normalNative && this.vertexInfo.normal != 0) {
            return true;
        }
        return this.positionNative && this.vertexInfo.position != 0;
    }

    public boolean isAllNative() {
        return this.textureNative && this.colorNative && this.normalNative && this.positionNative;
    }

    public Buffer read(VertexInfo vertexInfo, int address, int firstVertex, int numberOfVertex, boolean canAllNativeVertexInfo) {
        this.videoEngine = VideoEngine.getInstance();
        this.vertexInfo = vertexInfo;
        this.canAllNativeVertexInfo = canAllNativeVertexInfo;
        this.update();
        if (this.isAllNative()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Not reading Vertex, all native at 0x%08X", address));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reading %d Vertex at 0x%08X", numberOfVertex, address + firstVertex * vertexInfo.vertexSize));
            if (!this.textureNative) {
                log.debug((Object)("Texture non-native " + vertexInfo.toString()));
            }
            if (!this.colorNative) {
                log.debug((Object)("Color non-native " + vertexInfo.toString()));
            }
            if (!this.normalNative) {
                log.debug((Object)("Normal non-native " + vertexInfo.toString()));
            }
            if (!this.positionNative) {
                log.debug((Object)("Position non-native " + vertexInfo.toString()));
            }
        }
        this.setAddress(address + firstVertex * vertexInfo.vertexSize);
        this.createVertexDataBuffer(numberOfVertex);
        IVertexInfoReader weightReader = this.getWeightReader(this.weightNative);
        IVertexInfoReader textureReader = this.getTextureReader(this.textureNative);
        IVertexInfoReader colorReader = this.getColorReader(this.colorNative);
        IVertexInfoReader normalReader = this.getNormalReader(this.normalNative);
        IVertexInfoReader positionReader = this.getPositionReader(this.positionNative);
        IVertexInfoReader padReader = this.getPaddingReader(vertexInfo.alignmentSize);
        for (int i = 0; i < numberOfVertex; ++i) {
            weightReader.read();
            textureReader.read();
            colorReader.read();
            normalReader.read();
            positionReader.read();
            padReader.read();
        }
        return this.vertexDataBuffer.getBuffer();
    }

    private IVertexInfoReader getWeightReader(boolean isNative) {
        return isNative ? this.skipWeightReaders[this.vertexInfo.weight] : this.weightReaders[this.vertexInfo.weight];
    }

    private IVertexInfoReader getTextureReader(boolean isNative) {
        return isNative ? this.skip2Readers[this.vertexInfo.texture] : this.textureReaders[this.vertexInfo.texture];
    }

    private IVertexInfoReader getColorReader(boolean isNative) {
        return isNative ? this.skipColorReaders[this.vertexInfo.color] : this.colorReaders[this.vertexInfo.color];
    }

    private IVertexInfoReader getNormalReader(boolean isNative) {
        return isNative ? this.skip3Readers[this.vertexInfo.normal] : this.normalReaders[this.vertexInfo.normal];
    }

    private IVertexInfoReader getPositionReader(boolean isNative) {
        return isNative ? this.skip3Readers[this.vertexInfo.position] : this.positionReaders[this.vertexInfo.position];
    }

    private IVertexInfoReader getPaddingReader(int size) {
        return this.paddingReaders[size];
    }

    private void createVertexDataBuffer(int numberOfVertex) {
        boolean intBufferType = false;
        if (this.vertexInfo.transform2D) {
            intBufferType = true;
        }
        this.vertexDataBuffer = intBufferType ? new IntVertexDataBuffer(this.stride * numberOfVertex) : new FloatVertexDataBuffer(this.stride * numberOfVertex);
    }

    private class SkipWeight3Reader
    extends AbstractSkipReader {
        private SkipWeight3Reader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext32(((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount);
        }
    }

    private class SkipWeight2Reader
    extends AbstractSkipReader {
        private SkipWeight2Reader() {
        }

        @Override
        public void read() {
            for (int i = 0; i < ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount; ++i) {
                VertexInfoReader.this.memoryReader.skipNext16();
            }
        }
    }

    private class SkipWeight1Reader
    extends AbstractSkipReader {
        private SkipWeight1Reader() {
        }

        @Override
        public void read() {
            for (int i = 0; i < ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount; ++i) {
                VertexInfoReader.this.memoryReader.skipNext8();
            }
        }
    }

    public class Weight3Reader
    implements IVertexInfoReader {
        @Override
        public void read() {
            for (int i = 0; i < ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount; ++i) {
                ((VertexInfoReader)VertexInfoReader.this).boneWeights[i] = VertexInfoReader.this.memoryReader.readNextFloat();
            }
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int type() {
            return 6;
        }

        @Override
        public int numberValues() {
            return ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount;
        }
    }

    public class Weight2Reader
    implements IVertexInfoReader {
        @Override
        public void read() {
            for (int i = 0; i < ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount; ++i) {
                ((VertexInfoReader)VertexInfoReader.this).boneWeights[i] = (float)VertexInfoReader.this.memoryReader.readNext16() / 32768.0f;
            }
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int type() {
            return 3;
        }

        @Override
        public int numberValues() {
            return ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount;
        }
    }

    public class Weight1Reader
    implements IVertexInfoReader {
        @Override
        public void read() {
            for (int i = 0; i < ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount; ++i) {
                ((VertexInfoReader)VertexInfoReader.this).boneWeights[i] = (float)VertexInfoReader.this.memoryReader.readNext8() / 128.0f;
            }
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public int numberValues() {
            return ((VertexInfoReader)VertexInfoReader.this).vertexInfo.skinningWeightCount;
        }
    }

    private class Position3Reader
    implements IVertexInfoReader {
        private Position3Reader() {
        }

        @Override
        public void read() {
            ((VertexInfoReader)VertexInfoReader.this).position[0] = VertexInfoReader.this.memoryReader.readNextFloat();
            ((VertexInfoReader)VertexInfoReader.this).position[1] = VertexInfoReader.this.memoryReader.readNextFloat();
            ((VertexInfoReader)VertexInfoReader.this).position[2] = VertexInfoReader.this.memoryReader.readNextFloat();
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.weight != 0) {
                VertexInfoReader.this.videoEngine.doPositionSkinning(VertexInfoReader.this.vertexInfo, VertexInfoReader.this.boneWeights, VertexInfoReader.this.position);
            }
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D) {
                ((VertexInfoReader)VertexInfoReader.this).position[2] = VertexInfoReader.this.position[2] < 0.0f ? 0.0f : (VertexInfoReader.this.position[2] > 65535.0f ? 65535.0f : (float)((int)VertexInfoReader.this.position[2]));
            }
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[0]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[1]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[2]);
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo || !((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 12;
        }

        @Override
        public int type() {
            return 6;
        }

        @Override
        public int numberValues() {
            return 3;
        }
    }

    private class Position2Reader
    implements IVertexInfoReader {
        private Position2Reader() {
        }

        @Override
        public void read() {
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D) {
                VertexInfoReader.this.vertexDataBuffer.put((short)VertexInfoReader.this.memoryReader.readNext16());
                VertexInfoReader.this.vertexDataBuffer.put((short)VertexInfoReader.this.memoryReader.readNext16());
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.memoryReader.readNext16());
            } else {
                ((VertexInfoReader)VertexInfoReader.this).position[0] = (float)((short)VertexInfoReader.this.memoryReader.readNext16()) / 32767.0f;
                ((VertexInfoReader)VertexInfoReader.this).position[1] = (float)((short)VertexInfoReader.this.memoryReader.readNext16()) / 32767.0f;
                ((VertexInfoReader)VertexInfoReader.this).position[2] = (float)((short)VertexInfoReader.this.memoryReader.readNext16()) / 32767.0f;
                if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.weight != 0) {
                    VertexInfoReader.this.videoEngine.doPositionSkinning(VertexInfoReader.this.vertexInfo, VertexInfoReader.this.boneWeights, VertexInfoReader.this.position);
                }
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[0]);
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[1]);
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[2]);
            }
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 12;
        }

        @Override
        public int type() {
            return this.isNative() ? 2 : (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D ? 4 : 6);
        }

        @Override
        public int numberValues() {
            return 3;
        }
    }

    private class Position1Reader
    implements IVertexInfoReader {
        private Position1Reader() {
        }

        @Override
        public void read() {
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D) {
                VertexInfoReader.this.vertexDataBuffer.put((byte)VertexInfoReader.this.memoryReader.readNext8());
                VertexInfoReader.this.vertexDataBuffer.put((byte)VertexInfoReader.this.memoryReader.readNext8());
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.memoryReader.readNext8());
            } else {
                ((VertexInfoReader)VertexInfoReader.this).position[0] = (float)((byte)VertexInfoReader.this.memoryReader.readNext8()) / 127.0f;
                ((VertexInfoReader)VertexInfoReader.this).position[1] = (float)((byte)VertexInfoReader.this.memoryReader.readNext8()) / 127.0f;
                ((VertexInfoReader)VertexInfoReader.this).position[2] = (float)((byte)VertexInfoReader.this.memoryReader.readNext8()) / 127.0f;
                if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.weight != 0) {
                    VertexInfoReader.this.videoEngine.doPositionSkinning(VertexInfoReader.this.vertexInfo, VertexInfoReader.this.boneWeights, VertexInfoReader.this.position);
                }
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[0]);
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[1]);
                VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.position[2]);
            }
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 12;
        }

        @Override
        public int type() {
            return this.isNative() ? 0 : (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D ? 4 : 6);
        }

        @Override
        public int numberValues() {
            return 3;
        }
    }

    private class Normal3Reader
    implements IVertexInfoReader {
        private Normal3Reader() {
        }

        @Override
        public void read() {
            ((VertexInfoReader)VertexInfoReader.this).normal[0] = VertexInfoReader.this.memoryReader.readNextFloat();
            ((VertexInfoReader)VertexInfoReader.this).normal[1] = VertexInfoReader.this.memoryReader.readNextFloat();
            ((VertexInfoReader)VertexInfoReader.this).normal[2] = VertexInfoReader.this.memoryReader.readNextFloat();
            VertexInfoReader.this.videoEngine.doNormalSkinning(VertexInfoReader.this.vertexInfo, VertexInfoReader.this.boneWeights, VertexInfoReader.this.normal);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[0]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[1]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[2]);
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo || ((VertexInfoReader)VertexInfoReader.this).vertexInfo.weight == 0;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 12;
        }

        @Override
        public int type() {
            return 6;
        }

        @Override
        public int numberValues() {
            return 3;
        }
    }

    private class Normal2Reader
    implements IVertexInfoReader {
        private Normal2Reader() {
        }

        @Override
        public void read() {
            ((VertexInfoReader)VertexInfoReader.this).normal[0] = (float)((short)VertexInfoReader.this.memoryReader.readNext16()) / 32767.0f;
            ((VertexInfoReader)VertexInfoReader.this).normal[1] = (float)((short)VertexInfoReader.this.memoryReader.readNext16()) / 32767.0f;
            ((VertexInfoReader)VertexInfoReader.this).normal[2] = (float)((short)VertexInfoReader.this.memoryReader.readNext16()) / 32767.0f;
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.weight != 0) {
                VertexInfoReader.this.videoEngine.doNormalSkinning(VertexInfoReader.this.vertexInfo, VertexInfoReader.this.boneWeights, VertexInfoReader.this.normal);
            }
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[0]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[1]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[2]);
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo || ((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 12;
        }

        @Override
        public int type() {
            return this.isNative() ? 2 : 6;
        }

        @Override
        public int numberValues() {
            return 3;
        }
    }

    private class Normal1Reader
    implements IVertexInfoReader {
        private Normal1Reader() {
        }

        @Override
        public void read() {
            ((VertexInfoReader)VertexInfoReader.this).normal[0] = (float)((byte)VertexInfoReader.this.memoryReader.readNext8()) / 127.0f;
            ((VertexInfoReader)VertexInfoReader.this).normal[1] = (float)((byte)VertexInfoReader.this.memoryReader.readNext8()) / 127.0f;
            ((VertexInfoReader)VertexInfoReader.this).normal[2] = (float)((byte)VertexInfoReader.this.memoryReader.readNext8()) / 127.0f;
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.weight != 0) {
                VertexInfoReader.this.videoEngine.doNormalSkinning(VertexInfoReader.this.vertexInfo, VertexInfoReader.this.boneWeights, VertexInfoReader.this.normal);
            }
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[0]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[1]);
            VertexInfoReader.this.vertexDataBuffer.put(VertexInfoReader.this.normal[2]);
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo || ((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 12;
        }

        @Override
        public int type() {
            return this.isNative() ? 0 : 6;
        }

        @Override
        public int numberValues() {
            return 3;
        }
    }

    private class Color7Reader
    extends AbstractNativeReader {
        private Color7Reader() {
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public int numberValues() {
            return 4;
        }
    }

    private class Color6Reader
    implements IVertexInfoReader {
        private Color6Reader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.vertexDataBuffer.put(ImageReader.color4444to8888(VertexInfoReader.this.memoryReader.readNext16()));
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 4;
        }

        @Override
        public int type() {
            return this.isNative() ? 3 : 1;
        }

        @Override
        public int numberValues() {
            return this.isNative() ? 1 : 4;
        }
    }

    private class Color5Reader
    implements IVertexInfoReader {
        private Color5Reader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.vertexDataBuffer.put(ImageReader.color5551to8888(VertexInfoReader.this.memoryReader.readNext16()));
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 4;
        }

        @Override
        public int type() {
            return this.isNative() ? 3 : 1;
        }

        @Override
        public int numberValues() {
            return this.isNative() ? 1 : 4;
        }
    }

    private class Color4Reader
    implements IVertexInfoReader {
        private Color4Reader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.vertexDataBuffer.put(ImageReader.color565to8888(VertexInfoReader.this.memoryReader.readNext16()));
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 4;
        }

        @Override
        public int type() {
            return this.isNative() ? 3 : 1;
        }

        @Override
        public int numberValues() {
            return this.isNative() ? 1 : 4;
        }
    }

    private class Texture3Reader
    extends AbstractNativeReader {
        private Texture3Reader() {
        }

        @Override
        public int type() {
            return 6;
        }

        @Override
        public int numberValues() {
            return 2;
        }
    }

    private class Texture2Reader
    implements IVertexInfoReader {
        private Texture2Reader() {
        }

        @Override
        public void read() {
            int texture1 = VertexInfoReader.this.memoryReader.readNext16();
            int texture2 = VertexInfoReader.this.memoryReader.readNext16();
            VertexInfoReader.this.vertexDataBuffer.put((float)texture1 / 32768.0f);
            VertexInfoReader.this.vertexDataBuffer.put((float)texture2 / 32768.0f);
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo || ((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : 8;
        }

        @Override
        public int type() {
            return VertexInfoReader.this.canAllNativeVertexInfo ? 3 : (this.isNative() ? 2 : 6);
        }

        @Override
        public int numberValues() {
            return 2;
        }
    }

    private class Texture1Reader
    implements IVertexInfoReader {
        private Texture1Reader() {
        }

        @Override
        public void read() {
            int texture1 = VertexInfoReader.this.memoryReader.readNext8();
            int texture2 = VertexInfoReader.this.memoryReader.readNext8();
            if (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D) {
                VertexInfoReader.this.vertexDataBuffer.put(texture1 | texture2 << 16);
            } else {
                VertexInfoReader.this.vertexDataBuffer.put((float)texture1 / 128.0f);
                VertexInfoReader.this.vertexDataBuffer.put((float)texture2 / 128.0f);
            }
        }

        @Override
        public boolean isNative() {
            return VertexInfoReader.this.canAllNativeVertexInfo;
        }

        @Override
        public int size() {
            return this.isNative() ? 0 : (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D ? 4 : 8);
        }

        @Override
        public int type() {
            return this.isNative() ? 1 : (((VertexInfoReader)VertexInfoReader.this).vertexInfo.transform2D ? 2 : 6);
        }

        @Override
        public int numberValues() {
            return 2;
        }
    }

    private class Skip3FloatsReader
    extends AbstractSkipReader {
        private Skip3FloatsReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext32(3);
        }
    }

    private class Skip2FloatsReader
    extends AbstractSkipReader {
        private Skip2FloatsReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext32(2);
        }
    }

    private class Skip1IntReader
    extends AbstractSkipReader {
        private Skip1IntReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext32();
        }
    }

    private class Skip3ShortsReader
    extends AbstractSkipReader {
        private Skip3ShortsReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext16();
            VertexInfoReader.this.memoryReader.skipNext16();
            VertexInfoReader.this.memoryReader.skipNext16();
        }
    }

    private class Skip2ShortsReader
    extends AbstractSkipReader {
        private Skip2ShortsReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext16();
            VertexInfoReader.this.memoryReader.skipNext16();
        }
    }

    private class Skip1ShortReader
    extends AbstractSkipReader {
        private Skip1ShortReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext16();
        }
    }

    private class Skip3BytesReader
    extends AbstractSkipReader {
        private Skip3BytesReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext8();
            VertexInfoReader.this.memoryReader.skipNext8();
            VertexInfoReader.this.memoryReader.skipNext8();
        }
    }

    private class Skip2BytesReader
    extends AbstractSkipReader {
        private Skip2BytesReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.skipNext8();
            VertexInfoReader.this.memoryReader.skipNext8();
        }
    }

    private class AlignIntReader
    extends AbstractSkipReader {
        private AlignIntReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.align32();
        }
    }

    private class AlignShortReader
    extends AbstractSkipReader {
        private AlignShortReader() {
        }

        @Override
        public void read() {
            VertexInfoReader.this.memoryReader.align16();
        }
    }

    private class NopReader
    extends AbstractSkipReader {
        private NopReader() {
        }

        @Override
        public void read() {
        }
    }

    private class NotImplementedReader
    extends AbstractSkipReader {
        private String comment;

        public NotImplementedReader(String comment) {
            this.comment = comment;
        }

        @Override
        public void read() {
            VideoEngine.getInstance().error(String.format("Unsupported Vertex Information %s for %s", this.comment, VertexInfoReader.this.vertexInfo.toString()));
        }
    }

    private abstract class AbstractSkipReader
    implements IVertexInfoReader {
        private AbstractSkipReader() {
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public int numberValues() {
            return 0;
        }
    }

    private abstract class AbstractNativeReader
    implements IVertexInfoReader {
        private AbstractNativeReader() {
        }

        @Override
        public void read() {
            VideoEngine.getInstance().error("This vertex information is always native! " + VertexInfoReader.this.vertexInfo.toString());
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static interface IVertexInfoReader {
        public void read();

        public int size();

        public int type();

        public int numberValues();

        public boolean isNative();
    }

    private static class FloatVertexDataBuffer
    implements IVertexDataBuffer {
        private float[] buffer;
        private int index;

        public FloatVertexDataBuffer(int sizeInBytes) {
            this.buffer = new float[(sizeInBytes + 3) / 4];
            this.index = 0;
        }

        @Override
        public Buffer getBuffer() {
            return FloatBuffer.wrap(this.buffer);
        }

        @Override
        public void put(int data) {
            this.buffer[this.index] = Float.intBitsToFloat(data);
            ++this.index;
        }

        @Override
        public void put(float data) {
            this.buffer[this.index] = data;
            ++this.index;
        }
    }

    private static class IntVertexDataBuffer
    implements IVertexDataBuffer {
        private int[] buffer;
        private int index;

        public IntVertexDataBuffer(int sizeInBytes) {
            this.buffer = new int[(sizeInBytes + 3) / 4];
            this.index = 0;
        }

        @Override
        public Buffer getBuffer() {
            return IntBuffer.wrap(this.buffer);
        }

        @Override
        public void put(int data) {
            this.buffer[this.index] = data;
            ++this.index;
        }

        @Override
        public void put(float data) {
            this.buffer[this.index] = Float.floatToRawIntBits(data);
            ++this.index;
        }
    }

    private static interface IVertexDataBuffer {
        public Buffer getBuffer();

        public void put(int var1);

        public void put(float var1);
    }
}

