/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.VideoEngineUtilities;
import jpcsp.graphics.textures.FBTexture;
import org.apache.log4j.Logger;
import org.lwjgl.opengl.GL;

public class VideoEngineThread
extends Thread {
    private static Logger log = VideoEngine.log;
    private final Semaphore update = new Semaphore(1);
    private final long context = VideoEngineUtilities.createContext();
    private volatile boolean run = true;
    private volatile boolean doInterpretInstruction;
    private volatile int interpretInstruction;

    public static boolean isActive() {
        return VideoEngineUtilities.canShareContext();
    }

    @Override
    public void run() {
        RuntimeContext.setLog4jMDC();
        VideoEngine videoEngine = VideoEngine.getInstance();
        IRenderingEngine re = videoEngine.getRenderingEngine();
        sceDisplay displayModule = Modules.sceDisplayModule;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Start of Video Engine Thread with context=0x%X", this.context));
        }
        VideoEngineUtilities.setContext(this.context);
        GL.createCapabilities();
        re.startDisplay();
        FBTexture renderTexture = new FBTexture(0x4000000, 512, 480, 272, 3);
        while (this.run) {
            this.waitForUpdate();
            if (this.doInterpretInstruction) {
                videoEngine.executeCommand(this.interpretInstruction);
                this.interpretInstruction = 0;
                this.doInterpretInstruction = false;
                continue;
            }
            displayModule.lockDisplay();
            renderTexture.bind(re, false);
            re.startDisplay();
            videoEngine.update();
            displayModule.unlockDisplay();
        }
    }

    public void update() {
        this.update.release();
    }

    private void waitForUpdate() {
        while (true) {
            try {
                int availablePermits;
                while ((availablePermits = this.update.drainPermits()) <= 0 && !this.update.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void exit() {
        this.run = false;
        this.update();
    }

    public void interpretInstruction(int instruction) {
        this.interpretInstruction = instruction;
        this.doInterpretInstruction = true;
        this.update();
        while (this.doInterpretInstruction) {
        }
    }
}

