/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.graphics.capture.CaptureManager;
import org.apache.log4j.Logger;

public class CaptureGEDetails {
    public static Logger log = CaptureManager.log;
    private int topAddrGe;
    private int bufferWidthGe;
    private int pixelFormatGe;
    private boolean endOfList;

    public CaptureGEDetails(boolean endOfList) {
        sceDisplay display = Modules.sceDisplayModule;
        this.topAddrGe = display.getTopAddrGe();
        this.bufferWidthGe = display.getBufferWidthGe();
        this.pixelFormatGe = display.getPixelFormatGe();
        this.endOfList = endOfList;
    }

    private CaptureGEDetails() {
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeInt(this.topAddrGe);
        out.writeInt(this.bufferWidthGe);
        out.writeInt(this.pixelFormatGe);
        out.writeBoolean(this.endOfList);
    }

    public static CaptureGEDetails read(DataInputStream in) throws IOException {
        CaptureGEDetails geDetails = new CaptureGEDetails();
        geDetails.topAddrGe = in.readInt();
        geDetails.bufferWidthGe = in.readInt();
        geDetails.pixelFormatGe = in.readInt();
        geDetails.endOfList = in.readBoolean();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("CaptureGEDetails topAddrGe=0x%08X, bufferWidthGe=%d, pixelFormatGe=%d, endOfList=%b", geDetails.topAddrGe, geDetails.bufferWidthGe, geDetails.pixelFormatGe, geDetails.endOfList));
        }
        return geDetails;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    public void commit() {
        Modules.sceDisplayModule.hleDisplaySetGeBuf(this.topAddrGe, this.bufferWidthGe, this.pixelFormatGe, false, false);
        if (this.endOfList) {
            Modules.sceDisplayModule.hleDisplaySetFrameBuf(this.topAddrGe, this.bufferWidthGe, this.pixelFormatGe, 0);
            Modules.sceDisplayModule.step(true);
        }
    }
}

