/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureManager;
import org.apache.log4j.Logger;

public class CaptureList {
    public static Logger log = CaptureManager.log;
    private PspGeList list;

    private CaptureList() {
    }

    public CaptureList(Memory mem, PspGeList list) throws IOException {
        this.list = new PspGeList(list.id);
        this.list.init(list.list_addr, list.getStallAddr(), list.cbid, list.optParams);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.list.list_addr);
        out.writeInt(this.list.getStallAddr());
        out.writeInt(this.list.cbid);
    }

    public static CaptureList read(DataInputStream in) throws IOException {
        CaptureList list = new CaptureList();
        int list_addr = in.readInt();
        int stall_addr = in.readInt();
        int cbid = in.readInt();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("CaptureList list_addr=0x%08X, stall_addr=0x%08X, cbid=0x%X", list_addr, stall_addr, cbid));
        }
        list.list = new PspGeList(-1);
        list.list.init(list_addr, 0, 0, null);
        return list;
    }

    public void commit(Memory mem) {
        VideoEngine.getInstance().pushDrawList(this.list);
    }
}

