/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.Memory;
import jpcsp.graphics.capture.CaptureManager;
import org.apache.log4j.Logger;

public class CaptureRAM {
    public static Logger log = CaptureManager.log;
    private final int address;
    private final int length;
    private final byte[] buffer;

    public CaptureRAM(Memory mem, int address, int length) throws IOException {
        this.address = address;
        this.length = length;
        TPointer pointer = new TPointer(mem, address);
        this.buffer = pointer.getArray8(length);
    }

    public CaptureRAM(int address, int length, byte[] buffer) throws IOException {
        this.address = address;
        this.length = length;
        this.buffer = buffer;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(2);
        out.writeInt(this.address);
        out.writeInt(this.length);
        out.write(this.buffer, 0, this.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Saved memory 0x%08X - 0x%08X (len 0x%X)", this.address, this.address + this.length, this.length));
        }
    }

    public static CaptureRAM read(DataInputStream in) throws IOException {
        int address = in.readInt();
        int length = in.readInt();
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded memory 0x%08X - 0x%08X (len 0x%X)", address, address + length, length));
        }
        return new CaptureRAM(address, length, buffer);
    }

    public void commit(Memory mem) {
        TPointer pointer = new TPointer(mem, this.address);
        pointer.setArray(this.buffer, this.length);
    }
}

