/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.textures.GETexture;
import jpcsp.util.Utilities;

public abstract class GEProxyTexture
extends GETexture {
    private int fboId = -1;
    protected GETexture geTexture;

    public GEProxyTexture(GETexture geTexture, int address, int bufferWidth, int width, int height, int pixelFormat, boolean useViewportResize) {
        super(address, Utilities.makePow2(width), width, height, pixelFormat, useViewportResize);
        this.geTexture = geTexture;
    }

    @Override
    public void bind(IRenderingEngine re, boolean forDrawing) {
        super.bind(re, forDrawing);
        if (this.isUpdateRequired(re)) {
            int previousFbo = re.getFramebufferBinding(0);
            if (this.fboId == -1) {
                this.fboId = re.genFramebuffer();
                re.bindFramebuffer(0, this.fboId);
                re.setFramebufferTexture(0, 3, this.textureId, 0);
            } else {
                re.bindFramebuffer(0, this.fboId);
            }
            this.updateTexture(re);
            re.bindFramebuffer(0, previousFbo);
            re.bindTexture(this.textureId);
            if (forDrawing) {
                re.setTextureFormat(this.pixelFormat, false);
            }
            this.geTexture.setChanged(false);
        }
    }

    protected boolean isUpdateRequired(IRenderingEngine re) {
        return this.geTexture.hasChanged();
    }

    @Override
    protected boolean hasChanged() {
        return this.geTexture.hasChanged();
    }

    protected abstract void updateTexture(IRenderingEngine var1);

    @Override
    public String toString() {
        return String.format("GEProxyTexture[0x%08X-0x%08X, %dx%d (texture %dx%d), bufferWidth=%d, pixelFormat=%d(%s), textureId=%d, fboId=%d]", this.address, this.address + this.length, this.width, this.height, this.getTexImageWidth(), this.getTexImageHeight(), this.bufferWidth, this.pixelFormat, VideoEngine.getPsmName(this.pixelFormat), this.textureId, this.fboId);
    }
}

