/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.memlmd;
import jpcsp.HLE.modules.semaphore;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.syscon.SysconEmulator;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.Settings;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import libkirk.KirkEngine;
import org.apache.log4j.Logger;

public class MMIOHandlerKirk
extends MMIOHandlerBase {
    private static Logger log = semaphore.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1109393408;
    public static final int RESULT_SUCCESS = 0;
    public static final int STATUS_PHASE1_IN_PROGRESS = 0;
    public static final int STATUS_PHASE1_COMPLETED = 1;
    public static final int STATUS_PHASE1_ERROR = 16;
    public static final int STATUS_PHASE1_MASK = 17;
    public static final int STATUS_PHASE2_IN_PROGRESS = 0;
    public static final int STATUS_PHASE2_COMPLETED = 2;
    public static final int STATUS_PHASE2_ERROR = 32;
    public static final int STATUS_PHASE2_MASK = 34;
    private final int signature = 1263683915;
    private final int version = 0x30313030;
    private static MMIOHandlerKirk instance;
    private int error;
    private int command;
    private int result;
    private int status;
    private int statusAsync;
    private int statusAsyncEnd;
    private int sourceAddr;
    private int destAddr;
    private final CompletePhase1Action completePhase1Action = new CompletePhase1Action();
    private long completePhase1Schedule;
    final int[] lastPrngOutput = new int[20];
    private int stepPreDecryptKeySeed0x15 = 0;
    private boolean initDone;
    private static final int[] xorkeys;

    public static MMIOHandlerKirk getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerKirk(-1109393408);
        }
        return instance;
    }

    private MMIOHandlerKirk(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.error = stream.readInt();
        this.command = stream.readInt();
        this.result = stream.readInt();
        this.status = stream.readInt();
        this.statusAsync = stream.readInt();
        this.statusAsyncEnd = stream.readInt();
        this.sourceAddr = stream.readInt();
        this.destAddr = stream.readInt();
        stream.readInts(this.lastPrngOutput);
        this.stepPreDecryptKeySeed0x15 = stream.readInt();
        this.initDone = stream.readBoolean();
        super.read(stream);
        if ((this.status & 0x11) == 0) {
            this.completePhase1Schedule = Scheduler.getNow();
            Scheduler.getInstance().addAction(this.completePhase1Schedule, this.completePhase1Action);
        } else {
            this.completePhase1Schedule = 0L;
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.error);
        stream.writeInt(this.command);
        stream.writeInt(this.result);
        stream.writeInt(this.status);
        stream.writeInt(this.statusAsync);
        stream.writeInt(this.statusAsyncEnd);
        stream.writeInt(this.sourceAddr);
        stream.writeInt(this.destAddr);
        stream.writeInts(this.lastPrngOutput);
        stream.writeInt(this.stepPreDecryptKeySeed0x15);
        stream.writeBoolean(this.initDone);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.error = 0;
        this.command = 0;
        this.result = 0;
        this.status = 0;
        this.statusAsync = 0;
        this.statusAsyncEnd = 0;
        this.sourceAddr = 0;
        this.destAddr = 0;
        this.completePhase1Schedule = 0L;
        Arrays.fill(this.lastPrngOutput, 0);
        this.stepPreDecryptKeySeed0x15 = 0;
        this.initDone = false;
        this.initKirk();
    }

    private static boolean isEqual(TPointer addr, int length, int[] values) {
        for (int i = 0; i < length; ++i) {
            if (addr.getUnsignedValue8(i) == values[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(TPointer addr, int length) {
        return MMIOHandlerKirk.isEqual(addr, length, new int[length]);
    }

    private static void descramble03g(TPointer buffer, int xorKeyIndex) {
        int idx = xorKeyIndex >> 5 & 0x3F;
        int rot = xorKeyIndex & 0x1F;
        int x1 = xorkeys[idx + 0];
        int x2 = xorkeys[idx + 1];
        int x3 = xorkeys[idx + 2];
        int x4 = xorkeys[idx + 3];
        x1 = x1 >>> rot | x1 << 32 - rot;
        x2 = Integer.reverse(x2 >>> rot | x2 << 32 - rot);
        x3 = (x3 >>> rot | x3 << 32 - rot) ^ x4;
        x4 = x4 >>> rot | x4 << 32 - rot;
        buffer.setValue32(0, buffer.getValue32(0) ^ x1);
        buffer.setValue32(4, buffer.getValue32(4) ^ x2);
        buffer.setValue32(8, buffer.getValue32(8) ^ x3);
        buffer.setValue32(12, buffer.getValue32(12) ^ x4);
    }

    private static int[] getXorKeyStep1() {
        switch (Model.getGeneration()) {
            case 2: {
                return new int[]{97, 122, 86, 66, 248, 237, 197, 228, 11, 11, 11, 11, 11, 11, 11, 11};
            }
            case 3: {
                return new int[]{97, 122, 86, 66, 248, 237, 197, 228, 37, 37, 37, 37, 37, 37, 37, 37};
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return new int[]{141, 93, 166, 8, 242, 187, 198, 204, 35, 35, 35, 35, 35, 35, 35, 35};
            }
        }
        log.error((Object)String.format("getXorKeyStep1 unimplemented for PSP generation %d", Model.getGeneration()));
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static int[] getKeyStep2() {
        switch (Model.getGeneration()) {
            case 2: 
            case 3: {
                return new int[]{219, 177, 30, 32, 72, 131, 177, 111, 101, 140, 61, 48, 224, 254, 203, 191};
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return new int[]{52, 219, 129, 36, 29, 111, 64, 87, 243, 218, 72, 8, 227, 70, 103, 66};
            }
        }
        log.error((Object)String.format("getKeyStep2 unimplemented for PSP generation %d", Model.getGeneration()));
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static int[] getXorKeyStep2() {
        switch (Model.getGeneration()) {
            case 2: {
                return new int[]{11, 221, 237, 199, 181, 36, 188, 34};
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return new int[]{22, 160, 122, 217, 235, 218, 59, 186};
            }
        }
        log.error((Object)String.format("getXorKeyStep2 unimplemented for PSP generation %d", Model.getGeneration()));
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static int[] getKeyStep3() {
        switch (Model.getGeneration()) {
            case 2: 
            case 3: {
                return new int[]{4, 244, 105, 138, 140, 170, 149, 48, 206, 59, 232, 132, 202, 154, 7, 154};
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return new int[]{224, 220, 65, 175, 194, 205, 28, 45, 149, 142, 166, 120, 77, 22, 122, 133};
            }
        }
        log.error((Object)String.format("getKeyStep3 unimplemented for PSP generation %d", Model.getGeneration()));
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static int[] getXorKeyStep3() {
        switch (Model.getGeneration()) {
            case 2: {
                return new int[]{128, 133, 250, 214, 201, 36, 239, 83};
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                return new int[]{192, 180, 189, 115, 166, 204, 178, 210};
            }
        }
        log.error((Object)String.format("getXorKeyStep3 unimplemented for PSP generation %d", Model.getGeneration()));
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    public boolean preDecrypt(TPointer outAddr, int outSize, TPointer inAddr, int inSize, int command) {
        boolean processed = false;
        if (!this.initDone && command == 1 && Model.getGeneration() >= 3 && inSize > 192) {
            boolean xorKeyIndex = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Calling descramble03g xorKeyIndex=0x%X", 1));
            }
            MMIOHandlerKirk.descramble03g(inAddr, 1);
        }
        if (SysconEmulator.isEnabled()) {
            return processed;
        }
        if (command == 7) {
            int keySeed = inAddr.getValue32(12);
            int dataSize = outSize;
            if (keySeed == 21 && dataSize == 16 && Model.getGeneration() >= 2) {
                switch (this.stepPreDecryptKeySeed0x15) {
                    case 1: {
                        int[] values = MMIOHandlerKirk.getXorKeyStep1();
                        for (int i = 0; i < values.length; ++i) {
                            int n = i;
                            values[n] = values[n] ^ this.lastPrngOutput[i];
                        }
                        if (MMIOHandlerKirk.isEqual(new TPointer(inAddr, 20), dataSize, values)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X step %d", keySeed, this.stepPreDecryptKeySeed0x15));
                            }
                            processed = true;
                            outAddr.clear(outSize);
                            this.result = 0;
                            ++this.stepPreDecryptKeySeed0x15;
                            break;
                        }
                        this.stepPreDecryptKeySeed0x15 = 0;
                        break;
                    }
                    case 2: {
                        if (MMIOHandlerKirk.isEmpty(new TPointer(inAddr, 20), dataSize)) {
                            int i;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X step %d", keySeed, this.stepPreDecryptKeySeed0x15));
                            }
                            int[] key1 = MMIOHandlerKirk.getKeyStep2();
                            byte[] xorKey1_1 = memlmd.getKey(MMIO.getXorKeyBFD00210());
                            int[] keyFromVault1 = MMIO.getKeyBFD00210();
                            int[] xorKey1_2 = MMIOHandlerKirk.getXorKeyStep2();
                            for (i = 0; i < 8; ++i) {
                                int n = i + 8;
                                key1[n] = key1[n] ^ (keyFromVault1[i] ^ Utilities.u8(xorKey1_1[i]) ^ xorKey1_2[i]);
                            }
                            for (i = 0; i < key1.length; ++i) {
                                outAddr.setUnsignedValue8(i, key1[i] ^ this.lastPrngOutput[i] + 1);
                            }
                            processed = true;
                            this.result = 0;
                            ++this.stepPreDecryptKeySeed0x15;
                            break;
                        }
                        this.stepPreDecryptKeySeed0x15 = 0;
                        break;
                    }
                    case 3: {
                        if (MMIOHandlerKirk.isEmpty(new TPointer(inAddr, 20), dataSize)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X step %d", keySeed, this.stepPreDecryptKeySeed0x15));
                            }
                            int[] key2 = MMIOHandlerKirk.getKeyStep3();
                            byte[] xorKey2_1 = memlmd.getKey(MMIO.getXorKeyBFD00210());
                            int[] keyFromVault2 = MMIO.getKeyBFD00210();
                            int[] xorKey2_2 = MMIOHandlerKirk.getXorKeyStep3();
                            for (int i = 0; i < 8; ++i) {
                                int n = i + 8;
                                key2[n] = key2[n] ^ (keyFromVault2[i + 8] ^ Utilities.u8(xorKey2_1[i + 8]) ^ xorKey2_2[i]);
                            }
                            int add16 = 51897;
                            for (int i = 0; i < key2.length; i += 2) {
                                int valueKey16 = key2[i] | key2[i + 1] << 8;
                                int valuePrng16 = this.lastPrngOutput[i] | this.lastPrngOutput[i + 1] << 8;
                                outAddr.setUnsignedValue16(i, valueKey16 ^ valuePrng16 + 51897);
                            }
                            processed = true;
                            this.result = 0;
                            this.stepPreDecryptKeySeed0x15 = 0;
                            break;
                        }
                        this.stepPreDecryptKeySeed0x15 = 0;
                    }
                }
            } else if (keySeed == 105 && dataSize == 16 && Model.getGeneration() >= 2 && MMIOHandlerKirk.isEqual(new TPointer(inAddr, 20), dataSize, this.lastPrngOutput)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X", keySeed));
                }
                this.stepPreDecryptKeySeed0x15 = 1;
                processed = true;
                outAddr.clear(outSize);
                this.result = 0;
            }
        }
        return processed;
    }

    private void postDecrypt(TPointer outAddr, int outSize) {
        if (this.result == 0 && this.command == 14) {
            outAddr.getArrayUnsigned8(this.lastPrngOutput);
        }
    }

    private void initKirk() {
        long fuseId = 5124095577148911L;
        String fuseIdString = Settings.getInstance().readString("sceSysreg.fuseId", null);
        if (fuseIdString != null) {
            fuseId = Settings.parseLong(fuseIdString);
        }
        KirkEngine.kirk_init(fuseId);
    }

    public void setInitDone() {
        this.initDone = true;
    }

    private int hleUtilsBufferCopyWithRange() {
        int outSize;
        int inSize;
        TPointer outAddr = new TPointer(this.getMemory(), MMIO.normalizeAddress(this.destAddr));
        TPointer inAddr = new TPointer(this.getMemory(), MMIO.normalizeAddress(this.sourceAddr));
        switch (this.command) {
            case 4: 
            case 5: {
                int dataSize = inAddr.getValue32(16);
                inSize = dataSize + 20;
                outSize = dataSize + 20;
                break;
            }
            case 7: 
            case 8: {
                int dataSize = inAddr.getValue32(16);
                inSize = Utilities.alignUp(dataSize, 15) + 20;
                outSize = Utilities.alignUp(dataSize, 15);
                break;
            }
            case 1: {
                int dataSize = inAddr.getValue32(112);
                int dataOffset = inAddr.getValue32(116);
                inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                outSize = Utilities.alignUp(dataSize, 15);
                break;
            }
            case 10: {
                int dataSize = inAddr.getValue32(112);
                int dataOffset = inAddr.getValue32(116);
                inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                outSize = 0;
                break;
            }
            case 11: {
                inSize = inAddr.getValue32(0) + 4;
                outSize = 20;
                break;
            }
            case 12: {
                inSize = 0;
                outSize = 60;
                break;
            }
            case 13: {
                inSize = 60;
                outSize = 40;
                break;
            }
            case 14: {
                inSize = 0;
                outSize = 20;
                break;
            }
            case 16: {
                inSize = 52;
                outSize = 40;
                break;
            }
            case 17: {
                inSize = 100;
                outSize = 0;
                break;
            }
            case 15: {
                inSize = 8;
                outSize = 28;
                this.initKirk();
                this.setInitDone();
                break;
            }
            case 18: {
                inSize = 184;
                outSize = 0;
                break;
            }
            case 2: {
                int dataSize = inAddr.getValue32(112);
                int dataOffset = inAddr.getValue32(116);
                outSize = inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                break;
            }
            case 3: {
                int dataSize = inAddr.getValue32(112);
                int dataOffset = inAddr.getValue32(116);
                inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                outSize = Utilities.alignUp(dataSize, 15);
                break;
            }
            default: {
                log.error((Object)String.format("MMIOHandlerKirk.hleUtilsBufferCopyWithRange unimplemented KIRK command 0x%X", this.command));
                this.result = 13;
                return 0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleUtilsBufferCopyWithRange input: %s", Utilities.getMemoryDump(inAddr, inSize)));
        }
        if (!this.preDecrypt(outAddr, outSize, inAddr, inSize, this.command)) {
            this.result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(outAddr, outSize, inAddr, inSize, this.command);
        }
        this.postDecrypt(outAddr, outSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleUtilsBufferCopyWithRange result=0x%X, output: %s", this.result, Utilities.getMemoryDump(outAddr, outSize)));
        }
        return Math.max(inSize, outSize);
    }

    private void completePhase1() {
        if (this.completePhase1Schedule != 0L) {
            Scheduler.getInstance().removeAction(this.completePhase1Schedule, this.completePhase1Action);
            this.completePhase1Schedule = 0L;
        }
        this.setStatus(17, 1);
        RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 24);
    }

    private void startProcessing(int value) {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                this.setStatus(17, 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("KIRK startProcessing 1 on %s", this));
                }
                int size = this.hleUtilsBufferCopyWithRange();
                if (this.result == 0) {
                    int delayUs = Math.max(0, size * 360 / 4096);
                    this.completePhase1Schedule = Scheduler.getNow() + (long)delayUs;
                    Scheduler.getInstance().addAction(this.completePhase1Schedule, this.completePhase1Action);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("KIRK delaying completion of phase 1 by %d us", delayUs));
                    break;
                }
                this.completePhase1();
                break;
            }
            case 2: {
                this.setStatus(34, 0);
                log.error((Object)String.format("Unimplemented Phase 2 KIRK command 0x%X on %s", this.command, this));
                log.error((Object)String.format("source: %s", Utilities.getMemoryDump(this.getMemory(), MMIO.normalizeAddress(this.sourceAddr), 256)));
                break;
            }
            default: {
                log.error((Object)String.format("0x%08X - KIRK unknown startProcessing value 0x%X on %s", this.getPc(), value, this));
            }
        }
    }

    private void endProcessing(int value) {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("KIRK endProcessing 1 on %s", this));
                }
                RuntimeContextLLE.clearInterrupt(this.getProcessor(), 24);
                break;
            }
            case 2: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("KIRK endProcessing 2 on %s", this));
                break;
            }
            default: {
                log.error((Object)String.format("0x%08X - KIRK unknown endProcessing value 0x%X on %s", this.getPc(), value, this));
            }
        }
    }

    private void setStatus(int mask, int value) {
        this.status = this.status & ~mask | value;
    }

    private void updateStatus() {
        if (this.completePhase1Schedule != 0L && this.completePhase1Schedule <= Scheduler.getNow()) {
            this.completePhase1();
        }
    }

    private int getStatus() {
        this.updateStatus();
        return this.status;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = 1263683915;
                break;
            }
            case 4: {
                value = 0x30313030;
                break;
            }
            case 8: {
                value = this.error;
                break;
            }
            case 12: {
                value = 0;
                break;
            }
            case 16: {
                value = this.command;
                break;
            }
            case 20: {
                value = this.result;
                break;
            }
            case 28: {
                value = this.getStatus();
                break;
            }
            case 32: {
                value = this.statusAsync;
                break;
            }
            case 36: {
                value = this.statusAsyncEnd;
                break;
            }
            case 44: {
                value = this.sourceAddr;
                break;
            }
            case 48: {
                value = this.destAddr;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 8: {
                this.error = value;
                break;
            }
            case 12: {
                this.startProcessing(value);
                break;
            }
            case 16: {
                this.command = value;
                break;
            }
            case 20: {
                this.result = value;
                break;
            }
            case 28: {
                this.status = value;
                break;
            }
            case 32: {
                this.statusAsync = value;
                break;
            }
            case 36: {
                this.statusAsyncEnd = value;
                break;
            }
            case 40: {
                this.endProcessing(value);
                break;
            }
            case 44: {
                this.sourceAddr = value;
                break;
            }
            case 48: {
                this.destAddr = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("KIRK error=0x%X, command=0x%X, result=0x%X, status=0x%X, statusAsync=0x%X, statusAsyncEnd=0x%X, sourceAddr=0x%08X, destAddr=0x%08X", this.error, this.command, this.result, this.status, this.statusAsync, this.statusAsyncEnd, this.sourceAddr, this.destAddr);
    }

    static {
        xorkeys = new int[]{1637927192, 1164533378, -1666198674, -95839473, 2122626786, -1858974423, -1286463479, -1464070225, 1220788677, -457004580, 77521, 1473852028, -1346837265, 1917360661, -970945147, 100799049, 1102976731, 735678255, -778780949, -777591191, -1062456469, -1996540604, 1577158208, 875661153, 1500832210, 508909595, 1864906654, -1458690681, 152877187, -1111357302, 2121671068, -1672745445, -583916031, -1152945351, 1719193415, -205447013, 1519838261, -1870096646, 1529714218, 2146187148, -475810898, -1953485421, -790678801, 1686426209, 176464211, 2125555061, -1324461091, 455223123, 1490904016, -1903456952, 1968911042, -1505886217, -1748320388, 868075104, 1683104390, 1077884568, 872859217, -1622437959, -494603147, -1189570029, 315029783, 1575401453, -613986424, 115194222, 723608998, 261229887, 1932211317, 420009491};
    }

    private class CompletePhase1Action
    implements IAction {
        private CompletePhase1Action() {
        }

        @Override
        public void execute() {
            MMIOHandlerKirk.this.completePhase1();
        }
    }
}

