/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.eflash;

import java.io.IOException;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.NullVirtualFile;
import jpcsp.HLE.VFS.WriteCacheVirtualFile;
import jpcsp.HLE.modules.sceEFlash;
import jpcsp.memory.mmio.MMIOHandlerBaseAta;
import jpcsp.memory.mmio.eflash.MMIOHandlerEFlash;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class MMIOHandlerEFlashAta
extends MMIOHandlerBaseAta {
    public static final int BASE_ADDRESS = -1113587712;
    private static MMIOHandlerEFlashAta instance;
    private static final int STATE_VERSION = 0;
    private static final long eflashSize = 0x400000000L;
    private IVirtualFile eflashFile;
    private final byte[] buffer = new byte[512];

    public static MMIOHandlerEFlashAta getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerEFlashAta(-1113587712);
        }
        return instance;
    }

    private MMIOHandlerEFlashAta(int baseAddress) {
        super(baseAddress);
        this.log = sceEFlash.log;
        this.eflashFile = new WriteCacheVirtualFile(this.log, new NullVirtualFile(0x400000000L), true);
        this.eflashFile.ioLseek(0x400000L);
        Utilities.writeUnaligned32(this.buffer, 0, 1095778636);
        Utilities.writeUnaligned32(this.buffer, 4, 0);
        this.eflashFile.ioWrite(this.buffer, 0, 512);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        if (this.eflashFile instanceof IState) {
            ((IState)((Object)this.eflashFile)).read(stream);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        if (this.eflashFile instanceof IState) {
            ((IState)((Object)this.eflashFile)).write(stream);
        }
        super.write(stream);
    }

    @Override
    protected int getInterruptNumber() {
        return -1;
    }

    @Override
    protected boolean supportsCmdPacket() {
        return false;
    }

    @Override
    protected void executePacketCommand(int[] data) {
        int operationCode = data[0];
        this.log.error((Object)String.format("MMIOHandlerEFlashAta.executePacketCommand unimplemented operation code 0x%02X(%s)", operationCode, MMIOHandlerEFlashAta.getOperationCodeName(operationCode)));
    }

    @Override
    protected void setInterruptReason(boolean CoD, boolean io) {
        super.setInterruptReason(CoD, io);
        if (!CoD && io) {
            int flags = 65537;
            if (this.getCommand() == 200) {
                flags |= 0x20002;
            }
            MMIOHandlerEFlash.getInstance().setInterruptFlag(flags);
        }
    }

    private long getFileOffset(int lba) {
        return ((long)lba & 0xFFFFFFFFL) * 512L;
    }

    @Override
    protected void executeCommand(int command, int[] data, int dataLength, int totalDataLength, boolean firstCommand) {
        switch (command) {
            case 236: {
                int i;
                dataLength = 512;
                this.prepareDataInit(dataLength);
                for (i = 0; i < 120; ++i) {
                    this.prepareData8(0);
                }
                this.prepareData32(Utilities.endianSwap32(305419896));
                for (i = 124; i < dataLength; ++i) {
                    this.prepareData8(0);
                }
                this.prepareDataEndWithDelay(dataLength, dataLength, 2000);
                break;
            }
            case 239: {
                int subcommandCode = this.getFeatures();
                int delayUs = 0;
                dataLength = 0;
                block10 : switch (subcommandCode) {
                    case 3: {
                        int transferMode = this.getSectorCount();
                        switch (transferMode) {
                            case 66: {
                                break block10;
                            }
                        }
                        this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommand ATA_CMD_SET_FEATURES, SETFEATURES_XFER unimplemented transferMode=0x%X", transferMode));
                        break;
                    }
                    default: {
                        this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommand ATA_CMD_SET_FEATURES unimplemented subcommandCode=0x%X", subcommandCode));
                    }
                }
                this.prepareDataEndWithDelay(dataLength, dataLength, delayUs);
                break;
            }
            case 200: {
                dataLength = 0;
                boolean delayUs = false;
                if (this.isLBA()) {
                    int lba = firstCommand ? this.getLBA() : this.getLogicalBlockAddress();
                    int sectorCount = this.getSectorCount();
                    this.setLogicalBlockAddress(lba + 1);
                    dataLength = 512;
                    if (firstCommand) {
                        totalDataLength = sectorCount * 512;
                    }
                    this.eflashFile.ioLseek(this.getFileOffset(lba));
                    this.eflashFile.ioRead(this.buffer, 0, 512);
                    this.prepareDataInit(dataLength);
                    for (int i = 0; i < dataLength; ++i) {
                        this.prepareData8(this.buffer[i] & 0xFF);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("MMIOHandlerEFlashAta.executeCommand ATA_CMD_READ LBA=0x%X, sectorCount=0x%X", lba, sectorCount));
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)String.format("data: %s", Utilities.getMemoryDump(this.buffer)));
                        }
                    }
                } else {
                    this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommand ATA_CMD_READ unimplemented non-LBA read", new Object[0]));
                }
                this.prepareDataEnd(dataLength, totalDataLength);
                break;
            }
            case 202: {
                if (this.isLBA()) {
                    int lba = this.getLBA();
                    int sectorCount = this.getSectorCount();
                    this.setLogicalBlockAddress(lba);
                    dataLength = 512;
                    totalDataLength = sectorCount * 512;
                    this.prepareDataReceive(dataLength, totalDataLength);
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerEFlashAta.executeCommand ATA_CMD_WRITE LBA=0x%X, sectorCount=0x%X", lba, sectorCount));
                    break;
                }
                this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommand ATA_CMD_WRITE unimplemented non-LBA read", new Object[0]));
                break;
            }
            case 231: {
                this.prepareDataEnd(0, 0);
                break;
            }
            case 230: {
                this.prepareDataEnd(0, 0);
                break;
            }
            case 8: {
                this.prepareDataEnd(0, 0);
                break;
            }
            case 224: {
                this.prepareDataEnd(0, 0);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommand unimplemented command 0x%X(%s)", command, MMIOHandlerEFlashAta.getCommandName(command)));
            }
        }
    }

    @Override
    protected void executeCommandWithData(int command, int pendingOperationCodeParameters, int[] data, int dataLength, boolean firstCommand, boolean lastCommand) {
        switch (command) {
            case 202: {
                if (this.isLBA()) {
                    int lba = firstCommand ? this.getLBA() : this.getLogicalBlockAddress();
                    this.setLogicalBlockAddress(lba + 1);
                    for (int i = 0; i < 512; ++i) {
                        this.buffer[i] = (byte)data[i];
                    }
                    this.eflashFile.ioLseek(this.getFileOffset(lba));
                    this.eflashFile.ioWrite(this.buffer, 0, 512);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("MMIOHandlerEFlashAta.executeCommandWithData ATA_CMD_WRITE lba=0x%X, lastCommand=%b", lba, lastCommand));
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)String.format("data: %s", Utilities.getMemoryDump(this.buffer)));
                        }
                    }
                } else {
                    this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommandWithData ATA_CMD_WRITE unimplemented non-LBA read", new Object[0]));
                }
                if (!lastCommand) break;
                MMIOHandlerEFlash.getInstance().setInterruptFlag(196611);
                this.commandCompleted();
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerEFlashAta.executeCommandWithData unknown command 0x%X(%s)", command, MMIOHandlerEFlashAta.getCommandName(command)));
            }
        }
    }
}

