/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.memorystick;

import java.io.IOException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.sceMSstor;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.IntArrayMemory;
import jpcsp.memory.mmio.MMIOHandlerBaseMemoryStick;
import jpcsp.memory.mmio.memorystick.MemoryStickBootPage;
import jpcsp.memory.mmio.memorystick.MemoryStickDeviceInfo;
import jpcsp.memory.mmio.memorystick.MemoryStickMbr;
import jpcsp.memory.mmio.memorystick.MemoryStickPbr32;
import jpcsp.memory.mmio.memorystick.MemoryStickProAttribute;
import jpcsp.memory.mmio.memorystick.MemoryStickSysInfo;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class MMIOHandlerMemoryStick
extends MMIOHandlerBaseMemoryStick {
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1121976320;
    private static MMIOHandlerMemoryStick instance;
    private static final boolean simulateMemoryStickPro = true;
    private final MemoryStickBootPage bootPage = new MemoryStickBootPage();
    private final IntArrayMemory bootPageMemory = new IntArrayMemory(new int[this.bootPage.sizeof() >> 2]);
    private final MemoryStickBootPage bootPageBackup = new MemoryStickBootPage();
    private final IntArrayMemory bootPageBackupMemory = new IntArrayMemory(new int[this.bootPageBackup.sizeof() >> 2]);
    private final IntArrayMemory disabledBlocksPageMemory = new IntArrayMemory(new int[128]);
    private final MemoryStickProAttribute msproAttribute = new MemoryStickProAttribute();
    private boolean msproAttributeMemoryInitialized = false;
    private static final int DISABLED_BLOCKS_PAGE = 1;
    private static final int CIS_IDI_PAGE = 2;
    private static final long MAX_MEMORY_STICK_SIZE = 0x8000000L;
    private int BLOCK_SIZE;
    private int NUMBER_OF_PHYSICAL_BLOCKS;
    private int NUMBER_OF_LOGICAL_BLOCKS;
    private int FIRST_PAGE_LBA;
    private int NUMBER_OF_PAGES;

    public static MMIOHandlerMemoryStick getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerMemoryStick(-1121976320);
        }
        return instance;
    }

    private MMIOHandlerMemoryStick(int baseAddress) {
        super(baseAddress);
        this.log = sceMSstor.log;
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.BLOCK_SIZE = stream.readInt();
        this.NUMBER_OF_PHYSICAL_BLOCKS = stream.readInt();
        this.NUMBER_OF_LOGICAL_BLOCKS = stream.readInt();
        this.FIRST_PAGE_LBA = stream.readInt();
        this.NUMBER_OF_PAGES = stream.readInt();
        this.msproAttributeMemoryInitialized = false;
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.BLOCK_SIZE);
        stream.writeInt(this.NUMBER_OF_PHYSICAL_BLOCKS);
        stream.writeInt(this.NUMBER_OF_LOGICAL_BLOCKS);
        stream.writeInt(this.FIRST_PAGE_LBA);
        stream.writeInt(this.NUMBER_OF_PAGES);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Modules.sceMSstorModule.reset();
        long totalSize = MemoryStick.getTotalSize();
        long totalNumberOfPages = totalSize / 512L;
        this.PAGES_PER_BLOCK = 32;
        while (this.PAGES_PER_BLOCK < 32768) {
            this.NUMBER_OF_PHYSICAL_BLOCKS = (int)(totalNumberOfPages / (long)this.PAGES_PER_BLOCK);
            if (this.NUMBER_OF_PHYSICAL_BLOCKS < 65536) break;
            this.PAGES_PER_BLOCK <<= 1;
        }
        this.BLOCK_SIZE = this.PAGES_PER_BLOCK * 512 / 1024;
        this.NUMBER_OF_LOGICAL_BLOCKS = this.NUMBER_OF_PHYSICAL_BLOCKS - this.NUMBER_OF_PHYSICAL_BLOCKS / 512 * 16;
        this.FIRST_PAGE_LBA = 2 * this.PAGES_PER_BLOCK;
        this.NUMBER_OF_PAGES = (this.NUMBER_OF_PHYSICAL_BLOCKS / 512 * 496 - 2) * this.BLOCK_SIZE * 2;
        this.NUMBER_OF_PAGES -= this.FIRST_PAGE_LBA;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerMemoryStick.reset totalSize=0x%X(%s), pagesPerBlock=0x%X, numberOfPhysicalBlocks=0x%X", totalSize, MemoryStick.getSizeKbString((int)(totalSize / 1024L)), this.PAGES_PER_BLOCK, this.NUMBER_OF_PHYSICAL_BLOCKS));
        }
        if (MemoryStick.isInserted()) {
            this.status |= 0x1020;
        }
        if (MemoryStick.isLocked()) {
            this.registers[2] = this.registers[2] | 1;
        }
        this.registers[4] = 1;
        this.registers[16] = 128;
        this.bootPage.header.blockId = 1;
        this.bootPage.header.formatVersion = 256;
        this.bootPage.header.numberOfDataEntry = 2;
        this.bootPage.entry.disabledBlock.startAddr = 512 - this.bootPage.sizeof();
        this.bootPage.entry.disabledBlock.dataSize = 4;
        this.bootPage.entry.disabledBlock.dataTypeId = 1;
        this.bootPage.entry.cisIdi.startAddr = 1024 - this.bootPage.sizeof();
        this.bootPage.entry.cisIdi.dataSize = 512;
        this.bootPage.entry.cisIdi.dataTypeId = 10;
        this.bootPage.attr.memorystickClass = 1;
        this.bootPage.attr.cardType = 2;
        this.bootPage.attr.blockSize = this.BLOCK_SIZE;
        this.bootPage.attr.numberOfBlocks = this.NUMBER_OF_PHYSICAL_BLOCKS;
        this.bootPage.attr.numberOfEffectiveBlocks = this.NUMBER_OF_LOGICAL_BLOCKS;
        this.bootPage.attr.pageSize = 512;
        this.bootPage.attr.extraDataSize = 16;
        this.bootPage.attr.securitySupport = 1;
        this.bootPage.attr.formatUniqueValue4[0] = 1;
        this.bootPage.attr.formatUniqueValue4[1] = 1;
        this.bootPage.attr.transferSupporting = 0;
        this.bootPage.attr.formatType = 1;
        this.bootPage.attr.memorystickApplication = 0;
        this.bootPage.attr.deviceType = 0;
        this.bootPage.write(this.bootPageMemory);
        this.bootPageBackup.header.blockId = 1;
        this.bootPageBackup.write(this.bootPageBackupMemory);
        this.disabledBlocksPageMemory.write16(0, (short)Utilities.endianSwap16(0));
        this.disabledBlocksPageMemory.write16(2, (short)Utilities.endianSwap16(1));
        this.disabledBlocksPageMemory.write16(4, (short)Utilities.endianSwap16(this.NUMBER_OF_PHYSICAL_BLOCKS - 1));
    }

    @Override
    protected void initMsproAttributeMemory() {
        if (!this.msproAttributeMemoryInitialized) {
            this.msproAttribute.signature = 42435;
            this.msproAttribute.count = 0;
            int entryAddress = 416;
            MemoryStickSysInfo memoryStickSysInfo = new MemoryStickSysInfo();
            memoryStickSysInfo.memoryStickClass = 2;
            memoryStickSysInfo.blockSize = this.PAGES_PER_BLOCK;
            memoryStickSysInfo.blockCount = this.NUMBER_OF_PHYSICAL_BLOCKS;
            memoryStickSysInfo.userBlockCount = this.NUMBER_OF_LOGICAL_BLOCKS;
            memoryStickSysInfo.unitSize = 512;
            memoryStickSysInfo.deviceType = 0;
            memoryStickSysInfo.interfaceType = 1;
            memoryStickSysInfo.memoryStickSubClass = 0;
            entryAddress = this.addMsproAttributeEntry(entryAddress, 16, memoryStickSysInfo);
            MemoryStickDeviceInfo memoryStickDeviceInfo = new MemoryStickDeviceInfo();
            entryAddress = this.addMsproAttributeEntry(entryAddress, 48, memoryStickDeviceInfo);
            MemoryStickMbr memoryStickMbr = new MemoryStickMbr();
            entryAddress = this.addMsproAttributeEntry(entryAddress, 32, memoryStickMbr);
            MemoryStickPbr32 memoryStickPbr32 = new MemoryStickPbr32();
            Modules.sceMSstorModule.hleMSstorPartitionIoLseek(null, 0L, 0);
            Modules.sceMSstorModule.hleMSstorPartitionIoRead(0L, memoryStickPbr32.bootSector, 0, memoryStickPbr32.bootSector.length);
            entryAddress = this.addMsproAttributeEntry(entryAddress, 34, memoryStickPbr32);
            this.msproAttribute.write(this.msproAttributeMemory);
            this.msproAttributeMemoryInitialized = true;
        }
    }

    private int addMsproAttributeEntry(int address, int id, pspAbstractMemoryMappedStructure attributeInfo) {
        int size = attributeInfo.sizeof();
        this.msproAttribute.entries[this.msproAttribute.count].address = address;
        this.msproAttribute.entries[this.msproAttribute.count].size = size;
        this.msproAttribute.entries[this.msproAttribute.count].id = id;
        attributeInfo.write(this.msproAttributeMemory, address);
        ++this.msproAttribute.count;
        return address + size;
    }

    @Override
    protected int getInterruptNumber() {
        return 7;
    }

    @Override
    protected int getInterruptBit() {
        return 4;
    }

    @Override
    protected int readData16(int dataAddress, int dataIndex, boolean endOfCommand) {
        int value = 0;
        if (dataAddress == 0) {
            value = this.bootPageMemory.read16(dataIndex);
        } else if (dataAddress == this.PAGES_PER_BLOCK) {
            value = this.bootPageBackupMemory.read16(dataIndex);
        } else if (dataAddress == 1) {
            value = this.disabledBlocksPageMemory.read16(dataIndex);
        } else if (dataAddress == 2) {
            this.log.error((Object)String.format("MMIOHandlerMemoryStick.readData16 unimplemented reading from CIS_IDI_PAGE", new Object[0]));
        } else {
            this.log.error((Object)String.format("MMIOHandlerMemoryStick.readData16 unimplemented reading from dataAddress=0x%X", dataAddress));
        }
        return value;
    }

    public void readSector(int lba, TPointer address) {
        long offset = (long)lba * 512L;
        Modules.sceMSstorModule.hleMSstorRawIoRead(offset, address, 512);
        if (this.log.isDebugEnabled()) {
            byte[] buffer = new byte[512];
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = address.getValue8(i);
            }
            this.log.debug((Object)String.format("MMIOHandlerMemoryStick.readSector startBlock=0x%X, lba=0x%X, offset=0x%X: %s", this.startBlock, lba, offset, Utilities.getMemoryDump(buffer)));
        }
    }

    @Override
    protected void readPageBuffer() {
        if (this.cmd == 170 || this.cmd == 32) {
            int lba = this.pageLba;
            if (this.startBlock != 65535) {
                this.pageLba += this.startBlock * this.PAGES_PER_BLOCK;
            }
            if (this.pageLba == 16384) {
                this.pageBufferPointer.clear(512);
            } else {
                this.readSector(lba, this.pageBufferPointer);
            }
            ++this.pageLba;
        } else {
            this.log.error((Object)String.format("MMIOHandlerMemoryStick.readPageBuffer unimplemented cmd=0x%02X(%s)", this.cmd, MMIOHandlerMemoryStick.getCommandName(this.cmd)));
        }
    }

    @Override
    protected void writePageBuffer() {
        if (this.cmd == 33) {
            int lba = this.pageLba;
            if (this.startBlock != 65535) {
                lba += this.startBlock * this.PAGES_PER_BLOCK;
            }
            long offset = (long)lba * 512L;
            if (this.log.isDebugEnabled()) {
                byte[] buffer = new byte[512];
                for (int i = 0; i < buffer.length; ++i) {
                    buffer[i] = this.pageBufferPointer.getValue8(i);
                }
                this.log.debug((Object)String.format("MMIOHandlerMemoryStick.writePageBuffer startBlock=0x%X, lba=0x%X, offset=0x%X: %s", this.startBlock, lba, offset, Utilities.getMemoryDump(buffer)));
            }
            Modules.sceMSstorModule.hleMSstorRawIoWrite(offset, this.pageBufferPointer, 512);
            ++this.pageLba;
        } else {
            this.log.error((Object)String.format("MMIOHandlerMemoryStick.writePageBuffer unimplemented cmd=0x%02X(%s)", this.cmd, MMIOHandlerMemoryStick.getCommandName(this.cmd)));
        }
    }

    @Override
    protected void writeData16(int dataAddress, int dataIndex, int value, boolean endOfCommand) {
        this.log.error((Object)String.format("MMIOHandlerMemoryStick.writeData16 unimplemented dataAddress=0x%X, dataIndex=0x%X, value=0x%08X", dataAddress, dataIndex, value));
    }

    @Override
    protected void writeData32(int dataAddress, int dataIndex, int value, boolean endOfCommand) {
        this.log.error((Object)String.format("MMIOHandlerMemoryStick.writeData32 unimplemented dataAddress=0x%X, dataIndex=0x%X, value=0x%08X", dataAddress, dataIndex, value));
    }
}

