/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import java.io.IOException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceSyscon;
import jpcsp.hardware.Battery;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterface;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import libkirk.AES;

public class SysconBatteryEmulator
extends Nec78k0SerialInterface {
    private static final int STATE_VERSION = 0;
    private static final int[] key0 = new int[]{92, 82, 217, 28, 243, 130, 172, 164, 137, 216, 129, 120, 236, 22, 41, 123};
    private static final int[] key1 = new int[]{157, 79, 80, 252, 225, 182, 142, 18, 9, 48, 125, 219, 166, 165, 181, 170};
    private static final int[] key2 = new int[]{9, 117, 152, 136, 100, 172, 247, 98, 27, 192, 144, 157, 240, 252, 171, 255};
    private static final int[] key3 = new int[]{201, 17, 92, 226, 6, 74, 38, 134, 216, 214, 217, 208, 140, 222, 48, 89};
    private static final int[] key4 = new int[]{102, 117, 57, 210, 251, 66, 115, 178, 144, 63, 215, 163, 158, 210, 198, 12};
    private static final int[] key5 = new int[]{244, 250, 239, 32, 244, 219, 171, 49, 209, 134, 116, 253, 143, 153, 5, 102};
    private static final int[] key6 = new int[]{234, 12, 129, 19, 99, 215, 233, 48, 249, 97, 19, 90, 79, 53, 45, 220};
    private static final int[] key8 = new int[]{10, 46, 115, 48, 92, 56, 45, 79, 49, 13, 10, 237, 132, 164, 24, 0};
    private static final int[] key10 = new int[]{172, 0, 192, 227, 232, 10, 240, 104, 63, 221, 23, 69, 25, 69, 67, 189};
    private static final int[] key13 = new int[]{223, 243, 252, 214, 8, 176, 85, 151, 207, 9, 162, 59, 209, 125, 63, 210};
    private static final int[] key47 = new int[16];
    private static boolean key47created;
    private static final int[] key151;
    private static boolean key151created;
    private static final int[] key179;
    private static final int[] key217;
    private static final int[] key235;
    private static final int[] challenge1secret0;
    private static final int[] challenge1secret1;
    private static final int[] challenge1secret2;
    private static final int[] challenge1secret3;
    private static final int[] challenge1secret4;
    private static final int[] challenge1secret5;
    private static final int[] challenge1secret6;
    public static final int[] challenge1secret8;
    public static final int[] challenge1secret10;
    public static final int[] challenge1secret13;
    private static final int[] challenge1secret47;
    private static final int[] challenge1secret151;
    private static final int[] challenge1secret179;
    private static final int[] challenge1secret217;
    private static final int[] challenge1secret235;
    private static final int[] challenge2secret0;
    private static final int[] challenge2secret1;
    private static final int[] challenge2secret2;
    private static final int[] challenge2secret3;
    private static final int[] challenge2secret4;
    private static final int[] challenge2secret5;
    private static final int[] challenge2secret6;
    public static final int[] challenge2secret8;
    public static final int[] challenge2secret10;
    public static final int[] challenge2secret13;
    private static final int[] challenge2secret47;
    private static final int[] challenge2secret151;
    private static final int[] challenge2secret179;
    private static final int[] challenge2secret217;
    private static final int[] challenge2secret235;
    private int keyId;
    private final int[] challenge1 = new int[8];

    public SysconBatteryEmulator(MMIOHandlerSysconFirmwareSfr sfr, Nec78k0SerialInterfaceUART6 serialInterface) {
        super(sfr, serialInterface);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.keyId = stream.readInt();
        stream.readInts(this.challenge1);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.keyId);
        stream.writeInts(this.challenge1);
        super.write(stream);
    }

    private static byte[] intsToBytes(int[] a, int offset, int length) {
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = (byte)a[offset + i];
        }
        return b;
    }

    private static byte[] intsToBytes(int[] a) {
        return SysconBatteryEmulator.intsToBytes(a, 0, a.length);
    }

    private static int[] bytesToInts(byte[] a, int[] b, int offset) {
        for (int i = 0; i < a.length; ++i) {
            b[offset + i] = a[i] & 0xFF;
        }
        return b;
    }

    private static int[] bytesToInts(byte[] a) {
        return SysconBatteryEmulator.bytesToInts(a, new int[a.length], 0);
    }

    public static String intsToString(int[] a, int start, int length) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(String.format("0x%02X", a[start + i]));
        }
        return s.toString();
    }

    public static String intsToString(int[] a) {
        return SysconBatteryEmulator.intsToString(a, 0, a.length);
    }

    private void createDynamicKeys() {
        if (!key47created) {
            this.createDynamicKey(new int[]{201, 248, 9, 69, 42, 162, 190, 213, 64, 208, 43, 172, 251, 26, 139, 234}, key47, challenge1secret47, challenge2secret47);
            key47created = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("createDynamicKeys: key47=%s, challenge1secret47=%s, challenge2secret47=%s", SysconBatteryEmulator.intsToString(key47), SysconBatteryEmulator.intsToString(challenge1secret47), SysconBatteryEmulator.intsToString(challenge2secret47)));
            }
        }
        if (!key151created) {
            this.createDynamicKey(new int[]{102, 26, 77, 127, 110, 205, 51, 197, 43, 245, 242, 149, 134, 167, 100, 72}, key151, challenge1secret151, challenge2secret151);
            key151created = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("createDynamicKeys: key151=%s, challenge1secret151=%s, challenge2secret151=%s", SysconBatteryEmulator.intsToString(key151), SysconBatteryEmulator.intsToString(challenge1secret151), SysconBatteryEmulator.intsToString(challenge2secret151)));
            }
        }
    }

    private void read32SecureFlash(int address, int[] array, int offset) {
        int data32 = this.sfr.getSecureFlash().read32(address);
        array[offset + 0] = Utilities.getByte0(data32);
        array[offset + 1] = Utilities.getByte1(data32);
        array[offset + 2] = Utilities.getByte2(data32);
        array[offset + 3] = Utilities.getByte3(data32);
    }

    private void createDynamicKey(int[] secret, int[] key, int[] challenge1secret, int[] challenge2secret) {
        int[] keyF600 = new int[16];
        for (int i = 0; i < 8; i += 4) {
            this.read32SecureFlash(1936 + i, keyF600, i);
        }
        System.arraycopy(new int[]{11, 35, 133, 1, 15, 178, 121, 189}, 0, keyF600, 8, 8);
        int[] keyF610 = new int[16];
        System.arraycopy(new int[]{225, 195, 236, 169, 25, 89, 4, 13}, 0, keyF610, 0, 8);
        for (int i = 0; i < 8; i += 4) {
            this.read32SecureFlash(1944 + i, keyF610, i + 8);
        }
        int[] keyF5E0 = new int[32];
        for (int i = 0; i < 16; i += 4) {
            this.read32SecureFlash(1984 + i, keyF5E0, i);
        }
        System.arraycopy(secret, 0, keyF5E0, 16, 16);
        this.finalKeyEncryptionCBC(keyF610, keyF600, keyF5E0);
        System.arraycopy(keyF5E0, 0, key, 0, 16);
        System.arraycopy(keyF5E0, 16, challenge1secret, 0, 8);
        System.arraycopy(keyF5E0, 24, challenge2secret, 0, 8);
    }

    private void finalKeyEncryptionCBC(int[] key1, int[] key2, int[] key3) {
        int i;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC key1=%s, key2=%s, key3=%s", SysconBatteryEmulator.intsToString(key1), SysconBatteryEmulator.intsToString(key2), SysconBatteryEmulator.intsToString(key3)));
        }
        AES.AES_ctx ctx = new AES.AES_ctx();
        AES.AES_set_key(ctx, SysconBatteryEmulator.intsToBytes(key1), key1.length * 8);
        byte[] resultBytes = new byte[16];
        AES.AES_cbc_encrypt(ctx, SysconBatteryEmulator.intsToBytes(key3, 0, 16), resultBytes, 16);
        SysconBatteryEmulator.bytesToInts(resultBytes, key3, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC after first encrypt: key3=%s", SysconBatteryEmulator.intsToString(key3, 0, 16)));
        }
        int[] xor = new int[16];
        System.arraycopy(key3, 0, xor, 0, 16);
        for (i = 0; i < 16; ++i) {
            int n = i + 16;
            key3[n] = key3[n] ^ xor[i];
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC after first xor: key3=%s", SysconBatteryEmulator.intsToString(key3, 16, 16)));
        }
        AES.AES_cbc_encrypt(ctx, SysconBatteryEmulator.intsToBytes(key3, 16, 16), resultBytes, 16);
        SysconBatteryEmulator.bytesToInts(resultBytes, key3, 16);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC after second encrypt: key3=%s", SysconBatteryEmulator.intsToString(key3, 16, 16)));
        }
        AES.AES_set_key(ctx, SysconBatteryEmulator.intsToBytes(key2), key2.length * 8);
        AES.AES_cbc_encrypt(ctx, SysconBatteryEmulator.intsToBytes(key3, 0, 16), resultBytes, 16);
        SysconBatteryEmulator.bytesToInts(resultBytes, key3, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC after third encrypt: key3=%s", SysconBatteryEmulator.intsToString(key3, 0, 16)));
        }
        AES.AES_cbc_encrypt(ctx, SysconBatteryEmulator.intsToBytes(key3, 16, 16), resultBytes, 16);
        SysconBatteryEmulator.bytesToInts(resultBytes, key3, 16);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC after fourth encrypt: key3=%s", SysconBatteryEmulator.intsToString(key3, 16, 16)));
        }
        for (i = 0; i < 16; ++i) {
            int n = i + 16;
            key3[n] = key3[n] ^ xor[i];
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("finalKeyEncryptionCBC after second xor: key3=%s", SysconBatteryEmulator.intsToString(key3, 16, 16)));
        }
    }

    public int[] getKey(int id) {
        switch (id) {
            case 0: {
                return key0;
            }
            case 1: {
                return key1;
            }
            case 2: {
                return key2;
            }
            case 3: {
                return key3;
            }
            case 4: {
                return key4;
            }
            case 5: {
                return key5;
            }
            case 6: {
                return key6;
            }
            case 8: {
                return key8;
            }
            case 10: {
                return key10;
            }
            case 13: {
                return key13;
            }
            case 47: {
                this.createDynamicKeys();
                return key47;
            }
            case 151: {
                this.createDynamicKeys();
                return key151;
            }
            case 179: {
                return key179;
            }
            case 217: {
                return key217;
            }
            case 235: {
                return key235;
            }
        }
        this.log.error((Object)String.format("Unknown key 0x%02X", id));
        return null;
    }

    public int[] getChallenge1Secret(int id) {
        switch (id) {
            case 0: {
                return challenge1secret0;
            }
            case 1: {
                return challenge1secret1;
            }
            case 2: {
                return challenge1secret2;
            }
            case 3: {
                return challenge1secret3;
            }
            case 4: {
                return challenge1secret4;
            }
            case 5: {
                return challenge1secret5;
            }
            case 6: {
                return challenge1secret6;
            }
            case 8: {
                return challenge1secret8;
            }
            case 10: {
                return challenge1secret10;
            }
            case 13: {
                return challenge1secret13;
            }
            case 47: {
                this.createDynamicKeys();
                return challenge1secret47;
            }
            case 151: {
                this.createDynamicKeys();
                return challenge1secret151;
            }
            case 179: {
                return challenge1secret179;
            }
            case 217: {
                return challenge1secret217;
            }
            case 235: {
                return challenge1secret235;
            }
        }
        this.log.error((Object)String.format("Unknown challenge1 secret 0x%02X", id));
        return null;
    }

    public int[] getChallenge2Secret(int id) {
        switch (id) {
            case 0: {
                return challenge2secret0;
            }
            case 1: {
                return challenge2secret1;
            }
            case 2: {
                return challenge2secret2;
            }
            case 3: {
                return challenge2secret3;
            }
            case 4: {
                return challenge2secret4;
            }
            case 5: {
                return challenge2secret5;
            }
            case 6: {
                return challenge2secret6;
            }
            case 8: {
                return challenge2secret8;
            }
            case 10: {
                return challenge2secret10;
            }
            case 13: {
                return challenge2secret13;
            }
            case 47: {
                this.createDynamicKeys();
                return challenge2secret47;
            }
            case 151: {
                this.createDynamicKeys();
                return challenge2secret151;
            }
            case 179: {
                return challenge2secret179;
            }
            case 217: {
                return challenge2secret217;
            }
            case 235: {
                return challenge2secret235;
            }
        }
        this.log.error((Object)String.format("Unknown challenge2 secret 0x%02X", id));
        return null;
    }

    private int[] mixChallenge1(int keyId, int[] challenge) {
        int[] data = new int[16];
        int[] secret1 = this.getChallenge1Secret(keyId);
        data[0] = secret1[0];
        data[4] = secret1[1];
        data[8] = secret1[2];
        data[12] = secret1[3];
        data[1] = secret1[4];
        data[5] = secret1[5];
        data[9] = secret1[6];
        data[13] = secret1[7];
        data[2] = challenge[0];
        data[6] = challenge[1];
        data[10] = challenge[2];
        data[14] = challenge[3];
        data[3] = challenge[4];
        data[7] = challenge[5];
        data[11] = challenge[6];
        data[15] = challenge[7];
        return data;
    }

    private int[] mixChallenge2(int keyId, int[] challenge) {
        int[] data = new int[16];
        int[] secret2 = this.getChallenge2Secret(keyId);
        data[0] = challenge[0];
        data[4] = challenge[1];
        data[8] = challenge[2];
        data[12] = challenge[3];
        data[1] = challenge[4];
        data[5] = challenge[5];
        data[9] = challenge[6];
        data[13] = challenge[7];
        data[2] = secret2[0];
        data[6] = secret2[1];
        data[10] = secret2[2];
        data[14] = secret2[3];
        data[3] = secret2[4];
        data[7] = secret2[5];
        data[11] = secret2[6];
        data[15] = secret2[7];
        return data;
    }

    private static int[] encryptAES(int[] key, int[] data) {
        AES.AES_ctx ctx = new AES.AES_ctx();
        AES.AES_set_key(ctx, SysconBatteryEmulator.intsToBytes(key), key.length * 8);
        byte[] resultBytes = new byte[data.length];
        AES.AES_cbc_encrypt(ctx, SysconBatteryEmulator.intsToBytes(data), resultBytes, data.length);
        return SysconBatteryEmulator.bytesToInts(resultBytes);
    }

    private static int[] matrixSwap(int[] a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.length];
        b[0] = a[0];
        b[1] = a[4];
        b[2] = a[8];
        b[3] = a[12];
        b[4] = a[1];
        b[5] = a[5];
        b[6] = a[9];
        b[7] = a[13];
        b[8] = a[2];
        b[9] = a[6];
        b[10] = a[10];
        b[11] = a[14];
        b[12] = a[3];
        b[13] = a[7];
        b[14] = a[11];
        b[15] = a[15];
        return b;
    }

    public void executeSysconCmdBattery(int batteryCommand, int sysconCmdBattery, int length, int transmissionLength) {
        switch (sysconCmdBattery) {
            case 97: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(3);
                this.addReceptionBufferData8(0);
                this.addReceptionBufferData16(4660);
                this.endReceptionBuffer();
                break;
            }
            case 99: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(2);
                this.addReceptionBufferData16(Battery.getVoltage());
                this.endReceptionBuffer();
                break;
            }
            case 108: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(4);
                this.addReceptionBufferData32(Battery.readEepromBatterySerialNumber());
                this.endReceptionBuffer();
                break;
            }
            case 109: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(5);
                this.addReceptionBufferData16(0);
                this.addReceptionBufferData8(17);
                this.addReceptionBufferData8(11);
                this.addReceptionBufferData8(34);
                this.endReceptionBuffer();
                break;
            }
            case 104: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(2);
                this.addReceptionBufferData16(1250);
                this.endReceptionBuffer();
                break;
            }
            case 103: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(2);
                this.addReceptionBufferData16(Battery.getFullCapacity());
                this.endReceptionBuffer();
                break;
            }
            case 107: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(2);
                this.addReceptionBufferData16(Modules.sceSysconModule.getBatteryCycle());
                this.endReceptionBuffer();
                break;
            }
            case 105: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(2);
                this.addReceptionBufferData16(Modules.sceSysconModule.getBatteryLimitTime());
                this.endReceptionBuffer();
                break;
            }
            case 98: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(1);
                this.addReceptionBufferData8(Battery.getTemperature());
                this.endReceptionBuffer();
                break;
            }
            case 100: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                this.startReceptionBuffer(2);
                this.addReceptionBufferData16(Modules.sceSysconModule.getBatteryElec());
                this.endReceptionBuffer();
                break;
            }
            case 118: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("UART6 Battery received syscon command %s", sceSyscon.getSysconCmdName(sysconCmdBattery)));
                }
                String s = "SonyEnergyDevices";
                this.startReceptionBuffer("SonyEnergyDevices".length());
                for (int i = 0; i < "SonyEnergyDevices".length(); ++i) {
                    this.addReceptionBufferData8("SonyEnergyDevices".charAt(i) & 0xFF);
                }
                this.endReceptionBuffer();
                break;
            }
            case 224: {
                if (length == 11) {
                    int[] key;
                    this.keyId = this.transmissionBuffer.peek(3);
                    int[] requestData = new int[8];
                    this.transmissionBuffer.peek(4, requestData, 0, requestData.length);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("UART6 Battery received syscon command %s, keyId=0x%02X, challenge=%s", sceSyscon.getSysconCmdName(sysconCmdBattery), this.keyId, SysconBatteryEmulator.intsToString(requestData)));
                    }
                    if ((key = this.getKey(this.keyId)) != null) {
                        int[] data = this.mixChallenge1(this.keyId, requestData);
                        int[] challenge1a = SysconBatteryEmulator.encryptAES(key, SysconBatteryEmulator.matrixSwap(data));
                        int[] challenge1b = SysconBatteryEmulator.matrixSwap(SysconBatteryEmulator.encryptAES(key, challenge1a));
                        System.arraycopy(challenge1b, 0, this.challenge1, 0, this.challenge1.length);
                        this.startReceptionBuffer(16);
                        this.addReceptionBufferData8(challenge1a, 0, 8);
                        this.addReceptionBufferData8(challenge1b, 0, 8);
                        this.endReceptionBuffer();
                        break;
                    }
                    this.startReceptionBuffer(16, 21);
                    this.addReceptionBufferData8(new int[16], 0, 16);
                    this.endReceptionBuffer();
                    break;
                }
                this.log.error((Object)String.format("UART6 Battery invalid length=%d for received syscon command %s", length, sceSyscon.getSysconCmdName(sysconCmdBattery), this.transmissionBuffer.toString(8)));
                break;
            }
            case 225: {
                if (length == 10) {
                    int[] key;
                    if (this.log.isDebugEnabled()) {
                        int[] unusedData = new int[8];
                        this.transmissionBuffer.peek(3, unusedData, 0, unusedData.length);
                        this.log.debug((Object)String.format("UART6 Battery received syscon command %s, unused data=%s", sceSyscon.getSysconCmdName(sysconCmdBattery), SysconBatteryEmulator.intsToString(unusedData)));
                    }
                    if ((key = this.getKey(this.keyId)) != null) {
                        int[] data2 = this.mixChallenge2(this.keyId, this.challenge1);
                        int[] challenge2 = SysconBatteryEmulator.encryptAES(key, SysconBatteryEmulator.matrixSwap(data2));
                        int[] response2 = SysconBatteryEmulator.encryptAES(key, challenge2);
                        this.startReceptionBuffer(8);
                        this.addReceptionBufferData8(response2, 0, 8);
                        this.endReceptionBuffer();
                        break;
                    }
                    this.startReceptionBuffer(8);
                    this.addReceptionBufferData8(new int[8], 0, 8);
                    this.endReceptionBuffer();
                    break;
                }
                this.log.error((Object)String.format("UART6 Battery invalid length=%d for received syscon command %s", length, sceSyscon.getSysconCmdName(sysconCmdBattery), this.transmissionBuffer.toString(8)));
                break;
            }
            default: {
                this.log.error((Object)String.format("UART6 Battery setOperationMode starting reception for unknown battery command 0x%02X(%s): %s", batteryCommand, sceSyscon.getSysconCmdName(sysconCmdBattery), this.transmissionBuffer.toString(8)));
            }
        }
    }

    @Override
    public void startReception() {
        int transmissionLength = this.transmissionBuffer.size();
        if (transmissionLength >= 2) {
            int command = this.transmissionBuffer.peek(0);
            int length = this.transmissionBuffer.peek(1);
            if (command == 90) {
                if (length + 2 == transmissionLength) {
                    int checksum = this.transmissionBuffer.peek(length + 1);
                    if (SysconBatteryEmulator.isValidChecksum(this.transmissionBuffer, checksum, length + 1)) {
                        int batteryCommand = this.transmissionBuffer.peek(2);
                        int sysconCmdBattery = batteryCommand + 96;
                        this.executeSysconCmdBattery(batteryCommand, sysconCmdBattery, length, transmissionLength);
                    } else {
                        this.log.error((Object)String.format("UART6 Battery setOperationMode invalid checksum 0x%02X: %s", checksum, this.transmissionBuffer.toString(8)));
                    }
                } else {
                    this.log.error((Object)String.format("UART6 Battery setOperationMode starting reception for unknown command length 0x%02X: %s", length, this.transmissionBuffer.toString(8)));
                }
            } else {
                this.log.error((Object)String.format("UART6 Battery setOperationMode starting reception for unknown command 0x%02X: %s", command, this.transmissionBuffer.toString(8)));
            }
        } else {
            this.log.error((Object)String.format("UART6 Battery setOperationMode starting reception for unknown command buffer: %s", this.transmissionBuffer.toString(8)));
        }
        this.transmissionBuffer.clear();
    }

    static {
        key151 = new int[16];
        key179 = new int[]{3, 190, 182, 84, 153, 20, 4, 131, 186, 24, 122, 100, 239, 144, 38, 29};
        key217 = new int[]{199, 172, 19, 6, 222, 254, 57, 236, 131, 161, 72, 59, 14, 226, 236, 137};
        key235 = new int[]{65, 132, 153, 190, 157, 53, 163, 185, 252, 106, 208, 214, 240, 65, 187, 38};
        challenge1secret0 = new int[]{210, 7, 34, 83, 164, 242, 116, 104};
        challenge1secret1 = new int[]{245, 215, 212, 181, 117, 240, 142, 78};
        challenge1secret2 = new int[]{179, 122, 22, 239, 85, 123, 208, 137};
        challenge1secret3 = new int[]{204, 105, 149, 129, 253, 137, 18, 108};
        challenge1secret4 = new int[]{160, 78, 50, 187, 167, 19, 158, 70};
        challenge1secret5 = new int[]{73, 94, 3, 71, 148, 147, 29, 123};
        challenge1secret6 = new int[]{176, 184, 9, 131, 57, 137, 250, 226};
        challenge1secret8 = new int[]{173, 64, 67, 178, 86, 235, 69, 139};
        challenge1secret10 = new int[]{194, 55, 126, 138, 116, 9, 108, 95};
        challenge1secret13 = new int[]{88, 28, 127, 25, 68, 249, 98, 98};
        challenge1secret47 = new int[8];
        challenge1secret151 = new int[8];
        challenge1secret179 = new int[]{219, 211, 174, 164, 219, 4, 100, 16};
        challenge1secret217 = new int[]{144, 225, 240, 192, 1, 120, 227, 255};
        challenge1secret235 = new int[]{11, 217, 2, 126, 133, 31, 161, 35};
        challenge2secret0 = new int[]{244, 224, 67, 19, 173, 46, 180, 219};
        challenge2secret1 = new int[]{254, 125, 120, 153, 191, 236, 71, 197};
        challenge2secret2 = new int[]{134, 94, 62, 239, 157, 251, 177, 253};
        challenge2secret3 = new int[]{48, 111, 58, 3, 216, 108, 190, 228};
        challenge2secret4 = new int[]{255, 114, 189, 43, 131, 184, 157, 47};
        challenge2secret5 = new int[]{132, 34, 223, 234, 226, 27, 99, 194};
        challenge2secret6 = new int[]{88, 185, 90, 174, 243, 153, 219, 208};
        challenge2secret8 = new int[]{103, 192, 114, 21, 217, 107, 57, 161};
        challenge2secret10 = new int[]{9, 62, 197, 25, 175, 15, 80, 45};
        challenge2secret13 = new int[]{49, 128, 83, 135, 92, 32, 62, 36};
        challenge2secret47 = new int[8];
        challenge2secret151 = new int[8];
        challenge2secret179 = new int[]{227, 43, 143, 86, 178, 100, 18, 152};
        challenge2secret217 = new int[]{195, 74, 106, 123, 32, 95, 232, 249};
        challenge2secret235 = new int[]{247, 145, 237, 11, 63, 73, 164, 72};
    }
}

