/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import java.io.IOException;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterface;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class SysconBootloaderEmulator
extends Nec78k0SerialInterface {
    private static final int STATE_VERSION = 0;
    public static final int SYSCON_BOOTLOADER_COMMAND_INIT = 0;
    public static final int SYSCON_BOOTLOADER_COMMAND_COMPARE_SECUREFLASH = 19;
    public static final int SYSCON_BOOTLOADER_COMMAND_ERASE_COMPLETE_SECUREFLASH = 32;
    public static final int SYSCON_BOOTLOADER_COMMAND_ERASE_SECUREFLASH = 34;
    public static final int SYSCON_BOOTLOADER_COMMAND_CHECK_BLANK_SECUREFLASH = 50;
    public static final int SYSCON_BOOTLOADER_COMMAND_WRITE_SECUREFLASH = 64;
    public static final int SYSCON_BOOTLOADER_COMMAND_GET_INIT_ERROR = 112;
    public static final int SYSCON_BOOTLOADER_COMMAND_SET_TIMEOUT = 144;
    public static final int SYSCON_BOOTLOADER_COMMAND_SET_CONFIG_FOR_DELAYS = 158;
    public static final int SYSCON_BOOTLOADER_COMMAND_SET_SECURITY = 160;
    public static final int SYSCON_BOOTLOADER_COMMAND_READ_SECUREFLASH_0000_to_03FF = 164;
    public static final int SYSCON_BOOTLOADER_COMMAND_CHECKSUM_SECUREFLASH = 176;
    public static final int SYSCON_BOOTLOADER_COMMAND_GET_INFO = 192;
    public static final int SYSCON_BOOTLOADER_COMMAND_GET_VERSION = 197;
    private final int[] buffer = new int[1056];
    private int index;
    private int length;

    public SysconBootloaderEmulator(Nec78k0Sfr sfr, Nec78k0SerialInterfaceUART6 serialInterface) {
        super(sfr, serialInterface);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.index = stream.readInt();
        this.length = stream.readInt();
        stream.readInts(this.buffer);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.index);
        stream.writeInt(this.length);
        stream.writeInts(this.buffer);
        super.write(stream);
    }

    @Override
    public void reset() {
        this.index = 0;
        this.length = 0;
        super.reset();
    }

    @Override
    public void startTransmission() {
    }

    @Override
    public void startReception() {
    }

    @Override
    public void transmit(int value) {
    }

    @Override
    public int receive() {
        if (this.index >= this.length) {
            return 0;
        }
        return this.buffer[this.index++];
    }

    @Override
    public boolean hasReceived() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.index >= this.length;
    }

    public void setCommand(int command, int[] data) {
        if (this.isEmpty()) {
            this.index = 0;
            this.length = 0;
        }
        this.buffer[this.length++] = 1;
        int startChecksum = this.length;
        this.buffer[this.length++] = data.length + 1;
        this.buffer[this.length++] = command;
        for (int i = 0; i < data.length; ++i) {
            this.buffer[this.length++] = data[i];
        }
        int checksum = 0;
        for (int i = startChecksum; i < this.length; ++i) {
            checksum = checksum - this.buffer[i] & 0xFF;
        }
        this.buffer[this.length++] = checksum;
        this.buffer[this.length++] = 3;
    }

    public void setCommand(int command) {
        this.setCommand(command, new int[0]);
    }

    public void setData(int[] data, boolean lastDataPacket) {
        if (this.isEmpty()) {
            this.index = 0;
            this.length = 0;
        }
        this.buffer[this.length++] = 2;
        int startChecksum = this.length;
        this.buffer[this.length++] = data.length & 0xFF;
        for (int i = 0; i < data.length; ++i) {
            this.buffer[this.length++] = data[i];
        }
        int checksum = 0;
        for (int i = startChecksum; i < this.length; ++i) {
            checksum = checksum - this.buffer[i] & 0xFF;
        }
        this.buffer[this.length++] = checksum;
        this.buffer[this.length++] = lastDataPacket ? 3 : 23;
    }
}

