/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jpcsp.nec78k0.Nec78k0Decoder;
import jpcsp.nec78k0.Nec78k0Instruction;
import jpcsp.nec78k0.Nec78k0Instructions;
import jpcsp.nec78k0.Nec78k0Memory;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Nec78k0Disassembler {
    private final Logger log;
    private final Level level;
    private final Nec78k0Processor processor;
    private final List<Integer> pendingFunctions = new LinkedList<Integer>();
    private final Set<Integer> disassembledFunctions = new HashSet<Integer>();
    private final Map<Integer, Integer> branchingTo = new HashMap<Integer, Integer>();
    private final Set<Integer> branchingTargets = new HashSet<Integer>();
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Set<Integer> dataAddresses = new HashSet<Integer>();
    public final Set<Integer> disassembledAddresses = new HashSet<Integer>();

    public Nec78k0Disassembler(Logger log, Level level, Nec78k0Processor processor) {
        this.log = log;
        this.level = level;
        this.processor = processor;
        this.disassembledFunctions.add(65535);
    }

    private void log(String s) {
        this.log.log((Priority)this.level, (Object)s);
    }

    private boolean isEndOfBlock(int addr, int insn, Nec78k0Instruction instr) {
        if (instr == Nec78k0Instructions.RET || instr == Nec78k0Instructions.RETI) {
            return true;
        }
        return instr == Nec78k0Instructions.BR_AX || instr == Nec78k0Instructions.BR_jdisp || instr == Nec78k0Instructions.BR_word;
    }

    private int getJdisp(int addr, int insn, Nec78k0Instruction instr) {
        return Nec78k0Instructions.getJdisp(addr, insn, instr.getInstructionSize());
    }

    private void addJump(List<Integer> list, int addr, int jumpTo) {
        list.add(jumpTo);
        this.branchingTo.put(addr, jumpTo);
        this.branchingTargets.add(jumpTo);
    }

    private void addJumpToFunction(int addr, int jumpTo) {
        if (!this.pendingFunctions.contains(jumpTo)) {
            this.pendingFunctions.add(jumpTo);
        }
        this.branchingTo.put(addr, jumpTo);
        this.branchingTargets.add(jumpTo);
    }

    private void checkBranch(List<Integer> pendingAddresses, int addr, int insn, Nec78k0Instruction instr) {
        if (instr == Nec78k0Instructions.BR_word) {
            int jumpTo = Nec78k0Instructions.getBranchAddressWord(insn, addr);
            this.addJump(pendingAddresses, addr, jumpTo);
        } else if (instr == Nec78k0Instructions.BR_jdisp || instr == Nec78k0Instructions.BZ || instr == Nec78k0Instructions.BNZ || instr == Nec78k0Instructions.BNC || instr == Nec78k0Instructions.BC || instr == Nec78k0Instructions.BF_A_addr || instr == Nec78k0Instructions.BF_saddr || instr == Nec78k0Instructions.BF_sfr || instr == Nec78k0Instructions.BT_A_addr || instr == Nec78k0Instructions.BT_saddr || instr == Nec78k0Instructions.BT_sfr || instr == Nec78k0Instructions.DBNZ_B || instr == Nec78k0Instructions.DBNZ_C || instr == Nec78k0Instructions.DBNZ_saddr || instr == Nec78k0Instructions.BTCLR_saddr) {
            int jumpTo = this.getJdisp(addr, insn, instr);
            this.addJump(pendingAddresses, addr, jumpTo);
        } else if (instr == Nec78k0Instructions.CALL) {
            int jumpTo = Nec78k0Instructions.getCallAddressWord(insn, addr);
            this.addJumpToFunction(addr, jumpTo);
        }
    }

    private void disasmFunction(int startAddress) {
        if (this.disassembledFunctions.contains(startAddress)) {
            return;
        }
        int check = Utilities.internalReadUnaligned32(this.processor.mem, startAddress);
        if (check == 0 || check == -1) {
            this.log(String.format("Skipping Function 0x%04X", startAddress));
            return;
        }
        this.log(String.format("Disassembling Function %s", Nec78k0Instructions.getFunctionName(startAddress)));
        TreeMap<Integer, String> disassembled = new TreeMap<Integer, String>();
        LinkedList<Integer> pendingAddresses = new LinkedList<Integer>();
        pendingAddresses.add(startAddress);
        block6: while (!pendingAddresses.isEmpty()) {
            int pc = (Integer)pendingAddresses.remove(0);
            boolean endOfBlock = false;
            while (!endOfBlock && !disassembled.containsKey(pc)) {
                String alignment;
                String opcode;
                if (this.dataAddresses.contains(pc)) {
                    disassembled.put(pc, String.format("0x%04X - data", pc));
                    continue block6;
                }
                if (!Nec78k0Memory.isAddressGood(pc)) continue block6;
                int insn = this.processor.startNewInstruction(pc);
                Nec78k0Instruction instr = Nec78k0Decoder.instruction(this.processor, insn);
                insn = this.processor.getCurrentInstructionOpcode();
                int nextPc = this.processor.getNextInstructionPc();
                switch (instr.getInstructionSize()) {
                    case 1: {
                        opcode = String.format("0x%02X", insn);
                        alignment = "      ";
                        break;
                    }
                    case 2: {
                        opcode = String.format("0x%04X", insn);
                        alignment = "    ";
                        break;
                    }
                    case 3: {
                        opcode = String.format("0x%06X", insn);
                        alignment = "  ";
                        break;
                    }
                    case 4: {
                        opcode = String.format("0x%08X", insn);
                        alignment = "";
                        break;
                    }
                    default: {
                        opcode = String.format("0x%X", insn);
                        alignment = "";
                    }
                }
                String disasm = String.format("0x%04X - [%s]%s - %s", pc, opcode, alignment, instr.disasm(pc, insn));
                disassembled.put(pc, disasm);
                int size = instr.getInstructionSize();
                for (int i = 0; i < size; ++i) {
                    this.disassembledAddresses.add(pc + i);
                }
                this.checkBranch(pendingAddresses, pc, insn, instr);
                endOfBlock = this.isEndOfBlock(pc, insn, instr);
                pc = nextPc;
            }
        }
        for (Integer pc : disassembled.keySet()) {
            String label = this.labels.get(pc);
            if (label != null) {
                this.log(label);
            }
            char branchingTarget = this.branchingTargets.contains(pc) ? (char)'>' : ' ';
            Integer branchTo = this.branchingTo.get(pc);
            int branchingFlag = branchTo == null ? 32 : (!disassembled.containsKey(branchTo) ? 60 : (branchTo <= pc ? 94 : 118));
            this.log(String.format("%c%c %s", Character.valueOf((char)branchingFlag), Character.valueOf(branchingTarget), disassembled.get(pc)));
        }
        this.disassembledFunctions.add(startAddress);
    }

    private void disasmAll() {
        int savedPc = this.processor.getPc();
        while (!this.pendingFunctions.isEmpty()) {
            int addr = this.pendingFunctions.remove(0);
            this.disasmFunction(addr);
        }
        this.processor.setPc(savedPc);
    }

    public boolean isAlreadyDisassembled(int addr) {
        return this.disassembledFunctions.contains(addr);
    }

    public void disasm(int addr) {
        this.pendingFunctions.add(addr);
        this.branchingTargets.add(addr);
        this.disasmAll();
    }

    public void setData(int addr, int size) {
        for (int i = 0; i < size; ++i) {
            this.disassembledAddresses.add(addr + i);
        }
    }

    public void setDataRange(int addrStart, int addrEnd) {
        this.setData(addrStart, addrEnd - addrStart + 1);
    }
}

