/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import java.util.HashMap;
import java.util.Map;
import jpcsp.Allegrex.compiler.ICompilerContext;
import jpcsp.Emulator;
import jpcsp.nec78k0.Nec78k0Instruction;
import jpcsp.nec78k0.Nec78k0Instruction1;
import jpcsp.nec78k0.Nec78k0Instruction2;
import jpcsp.nec78k0.Nec78k0Instruction3;
import jpcsp.nec78k0.Nec78k0Instruction4;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.util.Utilities;

public class Nec78k0Instructions {
    private static final String[] registerNames = new String[]{"X", "A", "C", "B", "E", "D", "L", "H"};
    private static final String[] registerPairNames = new String[]{"AX", "BC", "DE", "HL"};
    private static final String[] registerBankNames = new String[]{"RB0", "RB1", "RB2", "RB3"};
    private static final String pswName = "PSW";
    private static final String spName = "SP";
    private static final String cyName = "CY";
    private static final Map<Integer, String> functionNames = new HashMap<Integer, String>();
    public static final Nec78k0Instruction UNK1 = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            log.error((Object)String.format("0x%04X %s", processor.getCurrentInstructionPc(), this.disasm(processor.getCurrentInstructionPc(), insn)));
            Emulator.PauseEmuWithStatus(32);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("Unknown instruction 0x%02X", insn);
        }
    };
    public static final Nec78k0Instruction UNK2 = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            log.error((Object)String.format("0x%04X %s", processor.getCurrentInstructionPc(), this.disasm(processor.getCurrentInstructionPc(), insn)));
            Emulator.PauseEmuWithStatus(32);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("Unknown instruction 0x%04X", insn);
        }
    };
    public static final Nec78k0Instruction UNK3 = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            log.error((Object)String.format("0x%04X %s", processor.getCurrentInstructionPc(), this.disasm(processor.getCurrentInstructionPc(), insn)));
            Emulator.PauseEmuWithStatus(32);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("Unknown instruction 0x%06X", insn);
        }
    };
    public static final Nec78k0Instruction UNK4 = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            log.error((Object)String.format("0x%04X %s", processor.getCurrentInstructionPc(), this.disasm(processor.getCurrentInstructionPc(), insn)));
            Emulator.PauseEmuWithStatus(32);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("Unknown instruction 0x%08X", insn);
        }
    };
    public static final Nec78k0Instruction NOP = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("nop", new Object[0]);
        }
    };
    public static final Nec78k0Instruction MOV_A_r = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.getRegister(insn));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction ADD_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.getRegister(insn);
            int value = value1 + value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction SEL = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rbn = Nec78k0Instructions.getRegisterBank(insn);
            processor.setRegisterBank(rbn);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sel %s", Nec78k0Instructions.getRegisterBankName(Nec78k0Instructions.getRegisterBank(insn)));
        }
    };
    public static final Nec78k0Instruction MOVW_saddrp_word = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            int saddrp = insn >> 16 & 0xFF;
            processor.mem.write16(Nec78k0Processor.getSaddr(saddrp), (short)imm16);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, #0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 16)), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction CALL = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getCallAddressWord(insn, processor.getCurrentInstructionPc());
            if (!this.handleHLECall(processor, imm16, insn)) {
                processor.call(imm16);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("call !%s", Nec78k0Instructions.getFunctionName(Nec78k0Instructions.getCallAddressWord(insn, address)));
        }
    };
    public static final Nec78k0Instruction RET = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.ret();
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ret", new Object[0]);
        }
    };
    public static final Nec78k0Instruction MOVW_rp_word = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            int rp = insn >> 17 & 3;
            processor.setRegisterPair(rp, imm16);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, #0x%04X", Nec78k0Instructions.getRegisterPairName(insn >> 17), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction MOVW_addr_AX = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            processor.mem.write16(imm16, (short)processor.getRegisterPair(0));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw !0x%04X, %s", Nec78k0Instructions.getWord(insn), Nec78k0Instructions.getRegisterPairName(0));
        }
    };
    public static final Nec78k0Instruction MOVW_AX_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            processor.setRegisterPair(0, processor.mem.read16(imm16));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, !0x%04X", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction INC_r = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = 1;
            int value = value1 + value2;
            processor.setRegister(insn, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("inc %s", Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction DEC_r = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = 1;
            int value = value1 - value2;
            processor.setRegister(insn, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("dec %s", Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction MOVW_AX_rp = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            processor.setRegisterPair(0, processor.getRegisterPair(rp));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, %s", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getRegisterPairName(insn >> 1));
        }
    };
    public static final Nec78k0Instruction CMPW_AX_word = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegisterPair(0);
            int value2 = Nec78k0Instructions.getWord(insn);
            int value = value1 - value2;
            processor.setPswResult16(value, Nec78k0Instructions.getSubstraction16CY(value1, value2), false);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmpw %s, #0x%04X", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction CMP_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction ADD_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int saddr = Nec78k0Processor.getSaddr(insn >> 8);
            int value1 = processor.mem.read8(saddr);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 + value2;
            processor.mem.write8(saddr, (byte)value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction SUB_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int saddr = Nec78k0Processor.getSaddr(insn >> 8);
            int value1 = processor.mem.read8(saddr);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 - value2;
            processor.mem.write8(saddr, (byte)value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction BZ = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            if (processor.isZeroFlag()) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bz $0x%04X ; branch if ==", Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BNZ = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            if (!processor.isZeroFlag()) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bnz $0x%04X ; branch if !=", Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BC = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            if (processor.isCarryFlag()) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bc $0x%04X ; branch if <", Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BNC = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            if (!processor.isCarryFlag()) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bnc $0x%04X ; branch if >=", Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction MOV_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(processor.getRegisterPair(3)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };
    public static final Nec78k0Instruction MOV_A_DE = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(processor.getRegisterPair(2)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(2));
        }
    };
    public static final Nec78k0Instruction MOV_DE_A = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(processor.getRegisterPair(2), (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov [%s], %s", Nec78k0Instructions.getRegisterPairName(2), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction MOV_HL_A = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(processor.getRegisterPair(3), (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov [%s], %s", Nec78k0Instructions.getRegisterPairName(3), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction INCW = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            processor.setRegisterPair(rp, processor.getRegisterPair(rp) + 1);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("incw %s", Nec78k0Instructions.getRegisterPairName(insn >> 1));
        }
    };
    public static final Nec78k0Instruction DECW = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            processor.setRegisterPair(rp, processor.getRegisterPair(rp) - 1);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("decw %s", Nec78k0Instructions.getRegisterPairName(insn >> 1));
        }
    };
    public static final Nec78k0Instruction BR_jdisp = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int jdisp = Nec78k0Instructions.getJdisp(insn);
            processor.branch(jdisp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("br $0x%04X", Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BR_word = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getBranchAddressWord(insn, processor.getCurrentInstructionPc());
            processor.jump(imm16, false);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("br !0x%04X", Nec78k0Instructions.getBranchAddressWord(insn, address));
        }
    };
    public static final Nec78k0Instruction BR_AX = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.jump(Nec78k0Instructions.getBranchAddress(processor.getRegisterPair(0), processor.getCurrentInstructionPc()), true);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("br %s", Nec78k0Instructions.getRegisterPairName(0));
        }
    };
    public static final Nec78k0Instruction MOV_r_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(insn >> 8, Nec78k0Instructions.getByte(insn));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, #0x%02X", Nec78k0Instructions.getRegisterName(insn >> 8), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction PUSH_rp = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            processor.push16(processor.getRegisterPair(rp));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("push %s", Nec78k0Instructions.getRegisterPairName(insn >> 1));
        }
    };
    public static final Nec78k0Instruction POP_rp = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            processor.setRegisterPair(rp, processor.pop16());
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("pop %s", Nec78k0Instructions.getRegisterPairName(insn >> 1));
        }
    };
    public static final Nec78k0Instruction MOV_sfr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm8 = Nec78k0Instructions.getByte(insn);
            int sfr = insn >> 8 & 0xFF;
            processor.mem.write8(Nec78k0Processor.getSfr(sfr), (byte)imm8);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction MOV_A_sfr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(Nec78k0Processor.getSfr(insn)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn)));
        }
    };
    public static final Nec78k0Instruction MOV_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(Nec78k0Processor.getSaddr(insn)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction CLR1_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            processor.mem.clear1(Nec78k0Processor.getSaddr(insn), bit);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("clr1 %s.%d", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), insn >> 12 & 7);
        }
    };
    public static final Nec78k0Instruction CLR1_sfr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            processor.mem.clear1(Nec78k0Processor.getSfr(insn), bit);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("clr1 %s.%d", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn)), insn >> 12 & 7);
        }
    };
    public static final Nec78k0Instruction SET1_sfr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            processor.mem.set1(Nec78k0Processor.getSfr(insn), bit);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("set1 %s.%d", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn)), insn >> 12 & 7);
        }
    };
    public static final Nec78k0Instruction MOV_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(Nec78k0Processor.getSaddr(insn >> 8), (byte)Nec78k0Instructions.getByte(insn));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction BT_sfr = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 20 & 7;
            int addr = Nec78k0Processor.getSfr(insn >> 8);
            if (processor.mem.read1(addr, bit)) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bt %s.%d, $0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn >> 8)), insn >> 20 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BF_sfr = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 20 & 7;
            int addr = Nec78k0Processor.getSfr(insn >> 8);
            if (!processor.mem.read1(addr, bit)) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bf %s.%d, $0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn >> 8)), insn >> 20 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BT_saddr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 20 & 7;
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            if (processor.mem.read1(addr, bit)) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bt %s.%d, $0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), insn >> 20 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BF_saddr = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 20 & 7;
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            if (!processor.mem.read1(addr, bit)) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bf %s.%d, $0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), insn >> 20 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction MOVW_AX_saddrp = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegisterPair(0, processor.mem.read16(Nec78k0Processor.getSaddr(insn)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, %s", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction MOVW_saddrp_AX = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write16(Nec78k0Processor.getSaddr(insn), (short)processor.getRegisterPair(0));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), Nec78k0Instructions.getRegisterPairName(0));
        }
    };
    public static final Nec78k0Instruction MOVW_rp_AX = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            processor.setRegisterPair(rp, processor.getRegisterPair(0));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, %s", Nec78k0Instructions.getRegisterPairName(insn >> 1), Nec78k0Instructions.getRegisterPairName(0));
        }
    };
    public static final Nec78k0Instruction MOV_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(processor.getRegisterPair(3) + (byte)insn));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction SET1_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            processor.mem.set1(Nec78k0Processor.getSaddr(insn), bit);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("set1 %s.%d", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), insn >> 12 & 7);
        }
    };
    public static final Nec78k0Instruction MOV_addr_A = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            processor.mem.write8(imm16, (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov !0x%04X, %s", Nec78k0Instructions.getWord(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction MOV_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            processor.setRegister(1, processor.mem.read8(imm16));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction MOV_HLbyte_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(processor.getRegisterPair(3) + (byte)insn, (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction MOV_r_A = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(insn, processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getRegisterName(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction MOV_HL_B_A = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(processor.getRegisterPair(3) + processor.getRegister(3), (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov [%s+%s], %s", Nec78k0Instructions.getRegisterPairName(3), Nec78k0Instructions.getRegisterName(3), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction MOV_HL_C_A = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(processor.getRegisterPair(3) + processor.getRegister(2), (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov [%s+%s], %s", Nec78k0Instructions.getRegisterPairName(3), Nec78k0Instructions.getRegisterName(2), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction MOV_saddr_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(Nec78k0Processor.getSaddr(insn), (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction AND_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) & Nec78k0Instructions.getByte(insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction MOV_sfr_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write8(Nec78k0Processor.getSfr(insn), (byte)processor.getRegister(1));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn)), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction AND_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            int value = processor.mem.read8(addr) & Nec78k0Instructions.getByte(insn);
            processor.mem.write8(addr, (byte)value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction MOVW_sfrp_word = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int imm16 = Nec78k0Instructions.getWord(insn);
            int sfrp = insn >> 16 & 0xFF;
            processor.mem.write16(Nec78k0Processor.getSfr(sfrp), (short)imm16);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, #0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn >> 16)), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction OR_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) | Nec78k0Instructions.getByte(insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("or %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction OR_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) | processor.mem.read8(processor.getRegisterPair(3) + (byte)insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("or %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction CMP_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.mem.read8(Nec78k0Processor.getSaddr(insn >> 8));
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction SUB_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 - value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction SUBC_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 - value2;
            if (processor.isCarryFlag()) {
                --value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2, processor.isCarryFlag()), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subc %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction MULU = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegisterPair(0, processor.getRegister(1) * processor.getRegister(0));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mulu %s", Nec78k0Instructions.getRegisterName(0));
        }
    };
    public static final Nec78k0Instruction ADDW_AX_word = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegisterPair(0);
            int value2 = Nec78k0Instructions.getWord(insn);
            int value = value1 + value2;
            processor.setRegisterPair(0, value);
            processor.setPswResult16(value, Nec78k0Instructions.getAddition16CY(value1, value2, value), false);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addw %s, #0x%04X", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction SUBW_AX_word = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegisterPair(0);
            int value2 = Nec78k0Instructions.getWord(insn);
            int value = value1 - value2;
            processor.setRegisterPair(0, value);
            processor.setPswResult16(value, Nec78k0Instructions.getSubstraction16CY(value1, value2), false);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subw %s, #0x%04X", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction XCH_A_r = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int tmp = processor.getRegister(1);
            processor.setRegister(1, processor.getRegister(insn));
            processor.setRegister(insn, tmp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xch %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction OR_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) | processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("or %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction AND_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) & processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction ROR = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1);
            if (Utilities.hasFlag(value, 1)) {
                value = value >> 1 | 0x80;
                processor.setCarryFlag(true);
            } else {
                value >>= 1;
                processor.setCarryFlag(false);
            }
            processor.setRegister(1, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ror %s, %d", Nec78k0Instructions.getRegisterName(1), 1);
        }
    };
    public static final Nec78k0Instruction HALT = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.halt();
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("halt", new Object[0]);
        }
    };
    public static final Nec78k0Instruction STOP = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            log.info((Object)String.format("stop at 0x%04X", processor.getCurrentInstructionPc()));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("stop", new Object[0]);
        }
    };
    public static final Nec78k0Instruction DBNZ_B = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(3) - 1;
            processor.setRegister(3, value);
            if (value != 0) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("dbnz %s, $0x%04X", Nec78k0Instructions.getRegisterName(3), Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction DBNZ_C = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(2) - 1;
            processor.setRegister(2, value);
            if (value != 0) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("dbnz %s, $0x%04X", Nec78k0Instructions.getRegisterName(2), Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction DBNZ_saddr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            int value = processor.mem.read8(addr) - 1;
            processor.mem.write8(addr, (byte)value);
            if (value != 0) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("dbnz %s, $0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction ADD_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3));
            int value = value1 + value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };
    public static final Nec78k0Instruction SUB_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3));
            int value = value1 - value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };
    public static final Nec78k0Instruction ADDC_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3) + (byte)insn);
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction SUBC_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3) + (byte)insn);
            int value = value1 - value2;
            if (processor.isCarryFlag()) {
                --value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subc %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction ADD_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3) + (byte)insn);
            int value = value1 + value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction SUB_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3) + (byte)insn);
            int value = value1 - value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction ADD_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 + value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction ADD_r_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = processor.getRegister(1);
            int value = value1 + value2;
            processor.setRegister(insn, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s", Nec78k0Instructions.getRegisterName(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction ADDC_r_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = processor.getRegister(1);
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.setRegister(insn, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, %s", Nec78k0Instructions.getRegisterName(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction XCHW_AX_rp = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int rp = insn >> 1 & 3;
            int tmp = processor.getRegisterPair(0);
            processor.setRegisterPair(0, processor.getRegisterPair(rp));
            processor.setRegisterPair(rp, tmp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xchw %s, %s", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getRegisterPairName(insn >> 1));
        }
    };
    public static final Nec78k0Instruction MOV_A_HL_C = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(processor.getRegisterPair(3) + processor.getRegister(2)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, [%s+%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3), Nec78k0Instructions.getRegisterName(2));
        }
    };
    public static final Nec78k0Instruction MOV_A_HL_B = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegister(1, processor.mem.read8(processor.getRegisterPair(3) + processor.getRegister(3)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, [%s+%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3), Nec78k0Instructions.getRegisterName(3));
        }
    };
    public static final Nec78k0Instruction XOR_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) ^ processor.getRegister(insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction OR_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) | processor.getRegister(insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("or %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction XCH_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn);
            int tmp = processor.getRegister(1);
            processor.setRegister(1, processor.mem.read8(addr));
            processor.mem.write8(addr, (byte)tmp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xch %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction XOR_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) ^ processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction ADDC_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.getRegister(insn);
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction PUSH_PSW = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.push8(processor.getPsw());
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("push %s", Nec78k0Instructions.pswName);
        }
    };
    public static final Nec78k0Instruction POP_PSW = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setPsw(processor.pop8());
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("pop %s", Nec78k0Instructions.pswName);
        }
    };
    public static final Nec78k0Instruction CALLT = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = processor.mem.read16(insn & 0x3E | 0x40);
            processor.call(addr);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("callt %s", Nec78k0Instructions.getCalltFunctionName(insn & 0x3E | 0x40));
        }
    };
    public static final Nec78k0Instruction ROLC = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1);
            int cy = processor.isCarryFlag() ? 1 : 0;
            value = value << 1 | cy;
            processor.setCarryFlag(Utilities.hasFlag(value, 256));
            processor.setRegister(1, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("rolc %s, %d", Nec78k0Instructions.getRegisterName(1), 1);
        }
    };
    public static final Nec78k0Instruction RORC = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1);
            int cy = processor.isCarryFlag() ? 128 : 0;
            boolean newCy = Utilities.hasFlag(value, 1);
            value = value >> 1 | cy;
            processor.setCarryFlag(newCy);
            processor.setRegister(1, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("rorc %s, %d", Nec78k0Instructions.getRegisterName(1), 1);
        }
    };
    public static final Nec78k0Instruction ROL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1);
            if (Utilities.hasFlag(value <<= 1, 256)) {
                value |= 1;
                processor.setCarryFlag(true);
            } else {
                processor.setCarryFlag(false);
            }
            processor.setRegister(1, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("rol %s, %d", Nec78k0Instructions.getRegisterName(1), 1);
        }
    };
    public static final Nec78k0Instruction CMP_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Instructions.getWord(insn));
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction CMP_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.getRegister(insn);
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction CMP_r_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = processor.getRegister(1);
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, %s", Nec78k0Instructions.getRegisterName(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction XOR_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) ^ Nec78k0Instructions.getByte(insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction BT_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            if (Utilities.hasBit(processor.getRegister(1), bit)) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bt %s.%d, $0x%04X", Nec78k0Instructions.getRegisterName(1), insn >> 12 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction BF_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            if (Utilities.notHasBit(processor.getRegister(1), bit)) {
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bf %s.%d, $0x%04X", Nec78k0Instructions.getRegisterName(1), insn >> 12 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction CMP_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction SUB_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.getRegister(insn);
            int value = value1 - value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction SUBC_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.getRegister(insn);
            int value = value1 - value2;
            if (processor.isCarryFlag()) {
                --value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2, processor.isCarryFlag()), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subc %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction SUBC_r_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = processor.getRegister(1);
            int value = value1 - value2;
            if (processor.isCarryFlag()) {
                --value;
            }
            processor.setRegister(insn, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2, processor.isCarryFlag()), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subc %s, %s", Nec78k0Instructions.getRegisterName(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction SUB_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Instructions.getWord(insn));
            int value = value1 - value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction SUBC_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Instructions.getWord(insn));
            int value = value1 - value2;
            if (processor.isCarryFlag()) {
                --value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2, processor.isCarryFlag()), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subc %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction SUB_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            int value = value1 - value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction SUBC_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            int value = value1 - value2;
            if (processor.isCarryFlag()) {
                --value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2, processor.isCarryFlag()), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("subc %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction DIVUW = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegisterPair(0);
            int value2 = processor.getRegister(2);
            if (value2 == 0) {
                processor.setRegister(2, processor.getRegister(0));
                processor.setRegisterPair(0, 65535);
            } else {
                processor.setRegister(2, value1 % value2);
                processor.setRegisterPair(0, value1 / value2);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("divuw %s", Nec78k0Instructions.getRegisterName(2));
        }
    };
    public static final Nec78k0Instruction OR1_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 4 & 7;
            if (Utilities.hasBit(processor.getRegister(1), bit)) {
                processor.setCarryFlag(true);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("or1 %s, %s.%d", Nec78k0Instructions.cyName, Nec78k0Instructions.getRegisterName(1), insn >> 4 & 7);
        }
    };
    public static final Nec78k0Instruction ADD_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Instructions.getWord(insn));
            int value = value1 + value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction ADDC_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Instructions.getWord(insn));
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction MOV1_CY_saddr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            processor.setCarryFlag(processor.mem.read1(Nec78k0Processor.getSaddr(insn), bit));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov1 %s, %s.%d", Nec78k0Instructions.cyName, Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), insn >> 12 & 7);
        }
    };
    public static final Nec78k0Instruction MOV1_saddr_CY = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            processor.mem.write1(Nec78k0Processor.getSaddr(insn), bit, processor.isCarryFlag());
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov1 %s.%d, %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), insn >> 12 & 7, Nec78k0Instructions.cyName);
        }
    };
    public static final Nec78k0Instruction XOR1_CY_saddr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 12 & 7;
            if (processor.mem.read1(Nec78k0Processor.getSaddr(insn), bit)) {
                processor.setCarryFlag(!processor.isCarryFlag());
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor1 %s, %s.%d", Nec78k0Instructions.cyName, Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)), insn >> 12 & 7);
        }
    };
    public static final Nec78k0Instruction XOR_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) ^ processor.mem.read8(processor.getRegisterPair(3));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };
    public static final Nec78k0Instruction SUB_r_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(insn);
            int value2 = processor.getRegister(1);
            int value = value1 - value2;
            processor.setRegister(insn, value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, %s", Nec78k0Instructions.getRegisterName(insn), Nec78k0Instructions.getRegisterName(1));
        }
    };
    public static final Nec78k0Instruction CLR1_CY = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setCarryFlag(false);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("clr1 %s", Nec78k0Instructions.cyName);
        }
    };
    public static final Nec78k0Instruction SET1_CY = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setCarryFlag(true);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("set1 %s", Nec78k0Instructions.cyName);
        }
    };
    public static final Nec78k0Instruction NOT1_CY = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setCarryFlag(!processor.isCarryFlag());
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("not1 %s", Nec78k0Instructions.cyName);
        }
    };
    public static final Nec78k0Instruction XOR_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            int value = processor.mem.read8(addr) ^ Nec78k0Instructions.getByte(insn);
            processor.mem.write8(addr, (byte)value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction MOVW_AX_sfrp = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.setRegisterPair(0, processor.mem.read16(Nec78k0Processor.getSfr(insn)));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, %s", Nec78k0Instructions.getRegisterPairName(0), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn)));
        }
    };
    public static final Nec78k0Instruction MOVW_sfrp_AX = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.mem.write16(Nec78k0Processor.getSfr(insn), (short)processor.getRegisterPair(0));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("movw %s, %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSfr(insn)), Nec78k0Instructions.getRegisterPairName(0));
        }
    };
    public static final Nec78k0Instruction XCH_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Instructions.getWord(insn);
            int tmp = processor.getRegister(1);
            processor.setRegister(1, processor.mem.read8(addr));
            processor.mem.write8(addr, (byte)tmp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xch %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction XOR_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) ^ processor.mem.read8(Nec78k0Instructions.getWord(insn));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xor %s, !0x%04X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction CMP_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3));
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };
    public static final Nec78k0Instruction RETI = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            processor.reti();
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("reti", new Object[0]);
        }
    };
    public static final Nec78k0Instruction INC_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn);
            int value1 = processor.mem.read8(addr);
            int value2 = 1;
            int value = value1 + value2;
            processor.mem.write8(addr, (byte)value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("inc %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction DEC_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn);
            int value1 = processor.mem.read8(addr);
            int value2 = 1;
            int value = value1 - value2;
            processor.mem.write8(addr, (byte)value);
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("dec %s", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction ADD_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            int value = value1 + value2;
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction OR_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            int value = processor.mem.read8(addr) | Nec78k0Instructions.getByte(insn);
            processor.mem.write8(addr, (byte)value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("or %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction CMP_A_HLbyte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(processor.getRegisterPair(3) + (byte)insn);
            int value = value1 - value2;
            processor.setPswResult(value, Nec78k0Instructions.getSubstractionCY(value1, value2), Nec78k0Instructions.getSubstractionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getBasedAddressing(Nec78k0Instructions.getRegisterPairName(3), insn));
        }
    };
    public static final Nec78k0Instruction AND_A_addr = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) & processor.mem.read8(Nec78k0Instructions.getWord(insn));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getWord(insn));
        }
    };
    public static final Nec78k0Instruction MOV1_CY_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 4 & 7;
            processor.setCarryFlag(Utilities.hasBit(processor.getRegister(1), bit));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov1 %s, %s.%d", Nec78k0Instructions.cyName, Nec78k0Instructions.getRegisterName(1), insn >> 4 & 7);
        }
    };
    public static final Nec78k0Instruction AND_A_r = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) & processor.getRegister(insn);
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterName(insn));
        }
    };
    public static final Nec78k0Instruction XCH_A_DE = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int tmp = processor.getRegister(1);
            int addr = processor.getRegisterPair(2);
            processor.setRegister(1, processor.mem.read8(addr));
            processor.mem.write8(addr, (byte)tmp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xch %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(2));
        }
    };
    public static final Nec78k0Instruction XCH_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int tmp = processor.getRegister(1);
            int addr = processor.getRegisterPair(3);
            processor.setRegister(1, processor.mem.read8(addr));
            processor.mem.write8(addr, (byte)tmp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("xch %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };
    public static final Nec78k0Instruction ADDC_A_saddr = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = processor.mem.read8(Nec78k0Processor.getSaddr(insn));
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, %s", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn)));
        }
    };
    public static final Nec78k0Instruction ADDC_saddr_byte = new Nec78k0Instruction3(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int saddr = Nec78k0Processor.getSaddr(insn >> 8);
            int value1 = processor.mem.read8(saddr);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.mem.write8(saddr, (byte)value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, #0x%02X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction CLR1_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 4 & 7;
            processor.setRegister(1, Utilities.clearBit(processor.getRegister(1), bit));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("clr1 %s.%d", Nec78k0Instructions.getRegisterName(1), insn >> 4 & 7);
        }
    };
    public static final Nec78k0Instruction SET1_A = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 4 & 7;
            processor.setRegister(1, Utilities.setBit(processor.getRegister(1), bit));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("set1 %s.%d", Nec78k0Instructions.getRegisterName(1), insn >> 4 & 7);
        }
    };
    public static final Nec78k0Instruction ADDC_A_byte = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value1 = processor.getRegister(1);
            int value2 = Nec78k0Instructions.getByte(insn);
            int value = value1 + value2;
            if (processor.isCarryFlag()) {
                ++value;
            }
            processor.setRegister(1, value);
            processor.setPswResult(value, Nec78k0Instructions.getAdditionCY(value1, value2, value), Nec78k0Instructions.getAdditionAC(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("addc %s, #0x%02X", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getByte(insn));
        }
    };
    public static final Nec78k0Instruction CLR1_HL = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 4 & 7;
            int addr = processor.getRegisterPair(3);
            processor.mem.write8(addr, (byte)Utilities.clearBit(processor.mem.read8(addr), bit));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("clr1 [%s].%d", Nec78k0Instructions.getRegisterPairName(3), insn >> 4 & 7);
        }
    };
    public static final Nec78k0Instruction SET1_HL = new Nec78k0Instruction2(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 4 & 7;
            int addr = processor.getRegisterPair(3);
            processor.mem.write8(addr, (byte)Utilities.setBit(processor.mem.read8(addr), bit));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("set1 [%s].%d", Nec78k0Instructions.getRegisterPairName(3), insn >> 4 & 7);
        }
    };
    public static final Nec78k0Instruction BTCLR_saddr = new Nec78k0Instruction4(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int bit = insn >> 20 & 7;
            int addr = Nec78k0Processor.getSaddr(insn >> 8);
            if (processor.mem.read1(addr, bit)) {
                processor.mem.clear1(addr, bit);
                int jdisp = Nec78k0Instructions.getJdisp(insn);
                processor.branch(jdisp);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("btclr %s.%d, $0x%04X", Nec78k0Instructions.getAddressName(Nec78k0Processor.getSaddr(insn >> 8)), insn >> 20 & 7, Nec78k0Instructions.getJdisp(address, insn, this.getInstructionSize()));
        }
    };
    public static final Nec78k0Instruction AND_A_HL = new Nec78k0Instruction1(){

        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            int value = processor.getRegister(1) & processor.mem.read8(processor.getRegisterPair(3));
            processor.setRegister(1, value);
            processor.setPswResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, [%s]", Nec78k0Instructions.getRegisterName(1), Nec78k0Instructions.getRegisterPairName(3));
        }
    };

    public static String getRegisterName(int r) {
        return registerNames[r & 7];
    }

    public static String getRegisterPairName(int rp) {
        return registerPairNames[rp & 3];
    }

    public static String getRegisterBankName(int rbn) {
        return registerBankNames[rbn & 7];
    }

    public static String getFunctionName(int addr) {
        String functionName = functionNames.get(addr);
        if (functionName == null) {
            return String.format("0x%04X", addr);
        }
        return String.format("0x%04X (%s)", addr, functionName);
    }

    public static String getCalltFunctionName(int addr) {
        String functionName = functionNames.get(addr);
        if (functionName == null) {
            return String.format("[0x%04X]", addr);
        }
        return String.format("[0x%04X] (%s)", addr, functionName);
    }

    public static void registerFunctionName(int addr, String functionName) {
        functionNames.put(addr, functionName);
    }

    public static String getAddressName(int addr) {
        if (addr == 65308) {
            return spName;
        }
        if (addr == 65310) {
            return pswName;
        }
        return String.format("0x%04X", addr);
    }

    private static final boolean getAdditionCY(int value1, int value2, int value) {
        return Utilities.hasFlag(value, 256);
    }

    private static final boolean getAddition16CY(int value1, int value2, int value) {
        return Utilities.hasFlag(value, 65536);
    }

    private static final boolean getAdditionAC(int value1, int value2, int value) {
        return Utilities.hasFlag(value, 16);
    }

    private static final boolean getSubstractionCY(int value1, int value2, boolean carry) {
        if (carry) {
            ++value2;
        }
        return value1 < value2;
    }

    private static final boolean getSubstractionCY(int value1, int value2) {
        return Nec78k0Instructions.getSubstractionCY(value1, value2, false);
    }

    private static final boolean getSubstraction16CY(int value1, int value2, boolean carry) {
        if (carry) {
            ++value2;
        }
        return value1 < value2;
    }

    private static final boolean getSubstraction16CY(int value1, int value2) {
        return Nec78k0Instructions.getSubstraction16CY(value1, value2, false);
    }

    private static final boolean getSubstractionAC(int value1, int value2, int value) {
        return Utilities.hasFlag(value, 16);
    }

    private static final int getRegisterBank(int insn) {
        return insn >> 3 & 1 | insn >> 4 & 2;
    }

    public static final int getWord(int insn) {
        return insn >> 8 & 0xFF | insn << 8 & 0xFF00;
    }

    private static final int getByte(int insn) {
        return insn & 0xFF;
    }

    private static final int getJdisp(int insn) {
        return (byte)insn;
    }

    public static final int getJdisp(int address, int insn, int size) {
        return address + size + Nec78k0Instructions.getJdisp(insn);
    }

    public static final int getCallAddressWord(int insn, int addr) {
        return Nec78k0Instructions.getWord(insn) | addr & 0x8000;
    }

    public static final int getBranchAddressWord(int insn, int addr) {
        return Nec78k0Instructions.getBranchAddress(Nec78k0Instructions.getWord(insn), addr);
    }

    public static final int getBranchAddress(int branch, int addr) {
        return branch & Short.MAX_VALUE | addr & 0x8000;
    }

    private static final String getBasedAddressing(String base, int value) {
        char sign;
        byte s8 = (byte)value;
        if (s8 < 0) {
            sign = '-';
            s8 = -s8;
        } else {
            sign = '+';
        }
        return String.format("[%s%c0x%02X]", base, Character.valueOf(sign), s8);
    }

    public static abstract class STUB2
    extends Nec78k0Instruction2 {
        @Override
        public void interpret(Nec78k0Processor processor, int insn) {
            this.instance(processor, insn).interpret(processor, insn);
        }

        public Nec78k0Instruction instance(Nec78k0Instruction instruction, Nec78k0Processor processor) {
            int size = instruction.getInstructionSize();
            for (int i = this.getInstructionSize(); i < size; ++i) {
                processor.getNextInstructionOpcode();
            }
            return instruction;
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            log.error((Object)String.format("Unimplemented compile 0x%04X", insn));
        }

        @Override
        public String disasm(int address, int insn) {
            log.error((Object)String.format("Unimplemented disasm 0x%04X", insn));
            return null;
        }
    }
}

