/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Emulator;
import jpcsp.nec78k0.INec78k0HLECall;
import jpcsp.nec78k0.Nec78k0Instructions;
import jpcsp.nec78k0.Nec78k0Processor;
import org.apache.log4j.Logger;

public class Nec78k0Interpreter {
    private final Nec78k0Processor processor;
    private final Logger log;
    private final Map<Integer, INec78k0HLECall> hleCalls = new HashMap<Integer, INec78k0HLECall>();
    public static final int PC_END_RUN = 65535;
    private boolean exitInterpreter;
    private boolean inInterpreter;
    private final Semaphore update = new Semaphore(0);
    private boolean halted;

    public Nec78k0Interpreter(Nec78k0Processor processor) {
        this.processor = processor;
        this.log = processor.log;
        processor.setInterpreter(this);
    }

    public void run() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Interpreting 0x%04X, halted=%b", this.processor.getNextInstructionPc(), this.isHalted()));
        }
        while (this.isHalted()) {
            try {
                this.update.tryAcquire(1, 10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.inInterpreter = true;
        this.processor.checkPendingInterrupt();
        while (!(Emulator.pause || this.exitInterpreter || this.processor.isNextInstructionPc(65535))) {
            this.processor.interpret();
        }
        this.inInterpreter = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Exiting Nec78k0Interpreter loop at 0x%04X", this.processor.getNextInstructionPc()));
        }
        this.exitInterpreter = false;
    }

    public void exitInterpreter() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Request to exit Nec78k0Interpreter inInterpreter=%b", this.inInterpreter));
        }
        if (this.inInterpreter) {
            this.exitInterpreter = true;
        }
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void setHalted(boolean halted) {
        this.halted = halted;
        this.update.release();
    }

    public INec78k0HLECall getHLECall(int addr) {
        return this.hleCalls.get(addr);
    }

    public void registerHLECall(int addr, INec78k0HLECall hleCall) {
        this.hleCalls.put(addr, hleCall);
        Nec78k0Instructions.registerFunctionName(addr, hleCall.getClass().getSimpleName());
    }
}

